/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.refactoringsview;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.export.ExportData;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.GeneratedNamedElementRefactoringIssue;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.ui.swt.base.l;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.PotentiallyDoneElementsBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.x;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ai;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.MatchingElementsBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.RefactoringBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.a;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class RefactoringsView
extends WorkbenchSlaveView
implements ISelectionChangedListener {
    private final a m_configuration = new a();
    private PropertyTableViewer<RefactoringDefinition> m_refactorings;
    private PropertyTableViewer<IIssue> m_matchingElements;
    private PropertyTableViewer<NamedElement> m_potentiallyDoneElements;
    private ai m_refactoringsTextSearchHandler;
    private ai m_matchingElementsTextSearchHandler;
    private ai m_potentiallyDoneElementsTextSearchHandler;
    private ViewComponent m_selectedViewComponent = ViewComponent.REFACTORINGS;

    @Override
    public IViewId getViewId() {
        return ViewId.REFACTORINGS_VIEW;
    }

    @Override
    protected final EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    @Override
    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_refactorings.n(), this.m_matchingElements.n(), this.m_potentiallyDoneElements.n());
    }

    @Override
    public List<Control> getViewComponents() {
        return Arrays.asList(this.m_refactorings.n(), this.m_matchingElements.n(), this.m_potentiallyDoneElements.n());
    }

    @Override
    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        SashForm sashForm = new SashForm(viewContentArea, 512);
        l.a(sashForm);
        this.m_refactorings = new PropertyTableViewer<RefactoringDefinition>((Composite)sashForm, new RefactoringBeanAdapter(), "priorityForSort", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_refactorings.a("Model", "virtualModel", "virtualModel", "virtualModelImage", 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.a("Refactoring Definition", "refactoringType", "refactoringType", "refactoringImage", 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.a("Provider", "provider", "provider", null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.a("Status", "status", null, null, 10, StatusInfo.Status.class);
        this.m_refactorings.a("Description", "description", null, null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.a("Information", "information", null, null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.a("Priority", "priority", "priorityForSort", "priorityImage", 10, Priority.class);
        this.m_refactorings.a("Assignee", "assignee", "assignee", null, 10, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactorings.a("Created", "date", "dateForSort", null, 10, PropertyTableViewer.ColumnType.DATE);
        this.m_matchingElements = new PropertyTableViewer<IIssue>((Composite)sashForm, new MatchingElementsBeanAdapter(), "element", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_matchingElements.a("Matching Element Type", "elementType", "elementType", "elementTypeImage", 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingElements.a("Element", "element", "element", "elementImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingElements.a("Element To", "elementTo", "elementTo", "elementToImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingElements.a("Description", "description", "description", null, 45, PropertyTableViewer.ColumnType.TEXT);
        this.m_potentiallyDoneElements = new PropertyTableViewer<NamedElement>((Composite)sashForm, new PotentiallyDoneElementsBeanAdapter(), "element", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_potentiallyDoneElements.a("Potentially Done Element", "element", "element", "elementImage", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_refactoringsTextSearchHandler = new ai(this.m_refactorings, "Refactorings");
        this.m_matchingElementsTextSearchHandler = new ai(this.m_matchingElements, "Matching Elements");
        this.m_potentiallyDoneElementsTextSearchHandler = new ai(this.m_potentiallyDoneElements, "Potentially Done");
        sashForm.setWeights(new int[]{50, 25, 25});
        this.refilter();
    }

    @Override
    public final void viewOptionsChanged() {
        this.refilter();
    }

    @Override
    protected void destroyViewContent() {
        this.m_selectedViewComponent = null;
    }

    @Override
    public boolean doubleClicked(Element element) {
        return element instanceof RefactoringDefinition || element instanceof GeneratedNamedElementRefactoringIssue;
    }

    @Override
    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        this.removeListeners();
        ArrayList<RefactoringDefinition> refactoringDefinitions = new ArrayList<RefactoringDefinition>(elements.size());
        for (Element next : elements) {
            assert (next instanceof RefactoringDefinition) : "Unexpected class in method 'finishShowInView': " + next;
            refactoringDefinitions.add((RefactoringDefinition)next);
        }
        this.m_refactorings.m().setSelection((ISelection)new StructuredSelection(refactoringDefinitions.toArray()));
        this.syncMatchingElements((RefactoringDefinition)refactoringDefinitions.get(0));
        this.addListeners();
        NavigationState state = ViewNavigationManager.a().a(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.createNavigationState(state);
        ViewNavigationManager.a().b(state);
        super.finishShowInView(sourceViewId, elements, options);
    }

    @Override
    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (component == this.m_refactorings.n()) {
            this.m_selectedViewComponent = ViewComponent.REFACTORINGS;
        } else if (component == this.m_matchingElements.n()) {
            this.m_selectedViewComponent = ViewComponent.MATCHING_ELEMENTS;
        } else if (component == this.m_potentiallyDoneElements.n()) {
            this.m_selectedViewComponent = ViewComponent.POTENTIALLY_DONE_ELEMENTS;
        } else assert (false) : "Unhandled component: " + component;
    }

    @Override
    public final Control getSelectedViewComponent() {
        switch (this.m_selectedViewComponent) {
            case REFACTORINGS: {
                return this.m_refactorings.n();
            }
            case MATCHING_ELEMENTS: {
                return this.m_matchingElements.n();
            }
            case POTENTIALLY_DONE_ELEMENTS: {
                return this.m_potentiallyDoneElements.n();
            }
        }
        assert (false) : "Unhandled section: " + (Object)((Object)this.m_selectedViewComponent);
        return null;
    }

    public ViewComponent getSelectedViewComponentId() {
        assert (this.m_selectedViewComponent != null) : "'m_selectedViewComponent' of method 'getSelectedViewComponentId' must not be null";
        return this.m_selectedViewComponent;
    }

    @Override
    public List<Element> getSelectedElements() {
        switch (this.m_selectedViewComponent) {
            case REFACTORINGS: {
                return x.a(this.m_refactorings.o());
            }
            case MATCHING_ELEMENTS: {
                return x.a(this.m_matchingElements.o());
            }
            case POTENTIALLY_DONE_ELEMENTS: {
                return x.a(this.m_potentiallyDoneElements.o());
            }
        }
        assert (false) : "Unhandled section: " + (Object)((Object)this.m_selectedViewComponent);
        return null;
    }

    @Override
    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        if (element instanceof DependencyIssue) {
            Dependency dependency = ((DependencyIssue)element).getAffectedElement();
            if (dependency != null) {
                return dependency.getUnderlyingFrom();
            }
        } else {
            if (element instanceof IIssue) {
                Element affectedElement = ((IIssue)element).getAffectedElement();
                if (affectedElement != null) {
                    return super.getLinkNamedElement(affectedElement);
                }
                return null;
            }
            if (element instanceof Dependency) {
                return ((Dependency)element).getUnderlyingFrom();
            }
        }
        return super.getLinkNamedElement(element);
    }

    private void createNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationState' must not be null";
        assert (this.m_selectedViewComponent != null) : "'m_selectedViewComponent' of method 'createNavigationState' must not be null";
        state.a((IStateData)ViewData.SELECTED_VIEW_COMPONENT, this.m_selectedViewComponent);
        state.a(Selection.REFACTORINGS, NavigationState.a(this.m_refactorings.p(), this.getElementResolver()));
        state.a(Selection.MATCHING_ELEMENTS, NavigationState.a(this.m_matchingElements.p().stream().map(s2 -> s2.getAffectedElement()).collect(Collectors.toList()), this.getElementResolver()));
        state.a(Selection.POTENTIALLY_DONE_ELEMENTS, NavigationState.a(this.m_potentiallyDoneElements.p(), this.getElementResolver()));
    }

    @Override
    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'performRestoreNavigationState' must not be null";
        this.m_selectedViewComponent = (ViewComponent)((Object)state.getConstant(ViewData.SELECTED_VIEW_COMPONENT));
        assert (this.m_selectedViewComponent != null) : "'m_selectedViewComponent' of method 'performRestoreNavigationState' must not be null";
        List<Element> selectedRefactorings = state.getElements(Selection.REFACTORINGS, Element.class, this.getElementResolver());
        assert (selectedRefactorings != null) : "'selectedRefactorings' of method 'performRestoreNavigationState' must not be null";
        HashSet<Element> selectedMatchingElements = new HashSet<Element>(state.getElements(Selection.MATCHING_ELEMENTS, Element.class, this.getElementResolver()));
        assert (selectedMatchingElements != null) : "'selectedMatchingElements' of method 'performRestoreNavigationState' must not be null";
        List<Element> selectedPotentiallyDoneElements = state.getElements(Selection.POTENTIALLY_DONE_ELEMENTS, Element.class, this.getElementResolver());
        assert (selectedPotentiallyDoneElements != null) : "'selectedPotentiallyDoneElements' of method 'performRestoreNavigationState' must not be null";
        this.removeListeners();
        this.m_refactorings.setRedraw(false);
        this.m_matchingElements.setRedraw(false);
        this.m_potentiallyDoneElements.setRedraw(false);
        StructuredSelection refactoringsSelection = new StructuredSelection(selectedRefactorings.toArray());
        this.m_refactorings.m().setSelection((ISelection)refactoringsSelection, true);
        Object first = refactoringsSelection.getFirstElement();
        this.syncMatchingElements(first instanceof RefactoringDefinition ? (RefactoringDefinition)first : null);
        ArrayList<IIssue> selectedIssueAccessors = new ArrayList<IIssue>(selectedMatchingElements.size());
        for (IIssue next : this.m_matchingElements.f()) {
            if (!selectedMatchingElements.contains(next.getAffectedElement())) continue;
            selectedIssueAccessors.add(next);
        }
        this.m_matchingElements.m().setSelection((ISelection)new StructuredSelection(selectedIssueAccessors.toArray()), true);
        this.m_potentiallyDoneElements.m().setSelection((ISelection)new StructuredSelection(selectedPotentiallyDoneElements.toArray()), true);
        if (this.m_selectedViewComponent == ViewComponent.REFACTORINGS) {
            this.m_refactorings.setFocus();
        } else if (this.m_selectedViewComponent == ViewComponent.MATCHING_ELEMENTS) {
            this.m_matchingElements.setFocus();
        } else if (this.m_selectedViewComponent == ViewComponent.POTENTIALLY_DONE_ELEMENTS) {
            this.m_potentiallyDoneElements.setFocus();
        } else assert (false) : "Unhandled view section: " + (Object)((Object)this.m_selectedViewComponent);
        this.m_refactorings.setRedraw(true);
        this.m_matchingElements.setRedraw(true);
        this.m_potentiallyDoneElements.setRedraw(true);
        this.addListeners();
    }

    @Override
    public void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeViewNavigationState' must not be null";
        this.createNavigationState(state);
    }

    private void addListeners() {
        this.m_refactorings.m().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_matchingElements.m().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_potentiallyDoneElements.m().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void removeListeners() {
        this.m_refactorings.m().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_matchingElements.m().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_potentiallyDoneElements.m().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.removeListeners();
        this.show(this.getSoftwareSystem().getCurrentModel().getResolutions(RefactoringDefinition.class), mode == WorkbenchView.ShowMode.AWAKE);
        this.addListeners();
        super.softwareSystemShow(mode);
    }

    @Override
    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.WORKSPACE_CLEARED) || modification.contains(Modification.VIRTUAL_MODEL_CHANGED) || modification.contains(Modification.VIRTUAL_MODEL_MODIFIED)) {
            this.removeListeners();
            this.show(this.getSoftwareSystem().getCurrentModel().getResolutions(RefactoringDefinition.class), true);
            this.addListeners();
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    @Override
    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            this.removeListeners();
            this.m_refactorings.setRedraw(false);
            this.m_matchingElements.setRedraw(false);
            this.m_potentiallyDoneElements.setRedraw(false);
            this.m_refactorings.s();
            this.m_matchingElements.s();
            this.m_potentiallyDoneElements.s();
            this.m_refactorings.setRedraw(true);
            this.m_matchingElements.setRedraw(true);
            this.m_potentiallyDoneElements.setRedraw(true);
            this.addListeners();
        }
        super.analyzerModification(modification, analyzerId);
    }

    @Override
    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.removeListeners();
        this.show(null, false);
        this.addListeners();
    }

    private void show(List<RefactoringDefinition> resolutions, boolean restoreNavigationState) {
        NavigationState state;
        assert (this.m_refactorings != null) : "'m_refactoringsTable' of method 'show' must not be null";
        this.m_refactorings.setRedraw(false);
        this.m_matchingElements.setRedraw(false);
        this.m_potentiallyDoneElements.setRedraw(false);
        this.m_refactorings.c((Collection<RefactoringDefinition>)null);
        this.m_matchingElements.c((Collection<IIssue>)null);
        this.m_potentiallyDoneElements.c((Collection<NamedElement>)null);
        this.m_refactorings.c(resolutions);
        if (restoreNavigationState && (state = ViewNavigationManager.a().b(this.getViewId(), this.getSecondaryId())) != null) {
            this.performRestoreNavigationState(state, false);
        }
        this.m_refactorings.setRedraw(true);
        this.m_matchingElements.setRedraw(true);
        this.m_potentiallyDoneElements.setRedraw(true);
        this.refilter();
    }

    @Override
    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        if (control == this.m_refactorings.n()) {
            this.m_refactorings.m().setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_matchingElements.n()) {
            this.m_matchingElements.m().setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_potentiallyDoneElements.n()) {
            this.m_potentiallyDoneElements.m().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public void clearFilter() {
        this.m_configuration.h();
        this.refilter();
    }

    private void refilter() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        if (!this.m_configuration.b().isEmpty()) {
            filters.add(this.m_refactorings.a("assignee", this.m_configuration.b()));
        }
        if (!this.m_configuration.c().isEmpty()) {
            filters.add(this.m_refactorings.a("description", this.m_configuration.c()));
        }
        if (!EnumSet.allOf(Priority.class).equals(this.m_configuration.d())) {
            filters.add(this.m_refactorings.a("priority", this.m_configuration.d()));
        }
        if (!EnumSet.allOf(StatusInfo.Status.class).equals(this.m_configuration.e())) {
            filters.add(this.m_refactorings.a("status", this.m_configuration.e()));
        }
        this.m_refactorings.a(filters.toArray(new ViewerFilter[filters.size()]));
    }

    @Override
    public boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && this.m_refactorings != null && !this.m_refactorings.isDisposed() && !this.m_refactorings.g().isEmpty();
    }

    @Override
    public String getExcelExportContentName() {
        return "Refactoring Definitions";
    }

    @Override
    public List<ExportData> getExportData(IWorkerContext workerContext) {
        return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getRefactoringDefintions(this.m_refactorings.g());
    }

    @Override
    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    @Override
    public ITextSearchHandler getTextSearchHandler() {
        if (this.m_selectedViewComponent == ViewComponent.REFACTORINGS) {
            return this.m_refactoringsTextSearchHandler;
        }
        if (this.m_selectedViewComponent == ViewComponent.MATCHING_ELEMENTS) {
            return this.m_matchingElementsTextSearchHandler;
        }
        if (this.m_selectedViewComponent == ViewComponent.POTENTIALLY_DONE_ELEMENTS) {
            return this.m_potentiallyDoneElementsTextSearchHandler;
        }
        assert (false) : "Unexpected value for 'm_selectedViewComponent': " + (Object)((Object)this.m_selectedViewComponent);
        return null;
    }

    public void setSelectedIssue(String issueKey) {
        assert (issueKey != null && issueKey.length() > 0) : "Parameter 'issueKey' of method 'setSelectedIssue' must not be empty";
        List refactorings = (List)this.m_refactorings.m().getInput();
        for (RefactoringDefinition nextRefactoringDefinition : refactorings) {
            for (IIssue nextIssue : nextRefactoringDefinition.getAssociatedIssues()) {
                Issue issue = (Issue)nextIssue;
                if (!issueKey.startsWith(issue.getKey()) || !issueKey.endsWith(issue.getDescription())) continue;
                this.removeListeners();
                this.m_selectedViewComponent = ViewComponent.REFACTORINGS;
                this.m_refactorings.a(Arrays.asList(nextRefactoringDefinition));
                this.syncMatchingElements(nextRefactoringDefinition);
                this.m_selectedViewComponent = ViewComponent.MATCHING_ELEMENTS;
                this.m_matchingElements.a(Arrays.asList(nextIssue));
                this.m_matchingElements.n().setFocus();
                this.addListeners();
                return;
            }
        }
    }

    private void syncMatchingElements(RefactoringDefinition refactoringDefinition) {
        this.m_matchingElements.setRedraw(false);
        this.m_potentiallyDoneElements.setRedraw(false);
        if (refactoringDefinition == null) {
            this.m_matchingElements.c((Collection<IIssue>)null);
            this.m_potentiallyDoneElements.c((Collection<NamedElement>)null);
        } else {
            this.m_matchingElements.c(refactoringDefinition.getAssociatedIssues());
            this.m_potentiallyDoneElements.c(refactoringDefinition.getPotentiallyDoneElements());
        }
        this.m_matchingElements.setRedraw(true);
        this.m_potentiallyDoneElements.setRedraw(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ArrayList<Object> selectElements;
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.removeListeners();
        if (event.getSource() == this.m_refactorings.m()) {
            this.m_selectedViewComponent = ViewComponent.REFACTORINGS;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object first = selection.getFirstElement();
            this.syncMatchingElements(first instanceof RefactoringDefinition ? (RefactoringDefinition)first : null);
        } else if (event.getSource() == this.m_matchingElements.m()) {
            this.m_selectedViewComponent = ViewComponent.MATCHING_ELEMENTS;
            selectElements = new ArrayList<Object>();
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            for (Object next : selection.toList()) {
                assert (next instanceof IIssue) : "Unexpected class: " + next;
                IIssue nextIIssueAccessor = (IIssue)next;
                selectElements.add(nextIIssueAccessor.getAffectedElement());
            }
        } else if (event.getSource() == this.m_potentiallyDoneElements.m()) {
            this.m_selectedViewComponent = ViewComponent.POTENTIALLY_DONE_ELEMENTS;
            selectElements = new ArrayList();
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            for (Object next : selection.toList()) {
                assert (next instanceof NamedElement) : "Unexpected class: " + next;
                selectElements.add((NamedElement)next);
            }
        } else assert (false) : "Unexpected source: " + event.getSource();
        this.initializeTextSearchData();
        this.addListeners();
        NavigationState state = ViewNavigationManager.a().a(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.createNavigationState(state);
        ViewNavigationManager.a().b(state);
        this.getSelectionProviderAdapter().a(this.getSelectedElements());
    }

    private static enum Selection implements IElementGroup
    {
        REFACTORINGS,
        MATCHING_ELEMENTS,
        POTENTIALLY_DONE_ELEMENTS;

    }

    public static enum ViewComponent implements IStandardEnumeration
    {
        REFACTORINGS,
        MATCHING_ELEMENTS,
        POTENTIALLY_DONE_ELEMENTS;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static enum ViewData implements IStateData
    {
        SELECTED_VIEW_COMPONENT;

    }
}

