/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.license;

import com.hello2morrow.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.ProxySettings;
import com.hello2morrow.httpclient.model.ServerInfo;
import com.hello2morrow.sonargraph.ui.swt.base.g;
import com.hello2morrow.sonargraph.ui.swt.base.l;
import com.hello2morrow.sonargraph.ui.swt.dialog.b;
import com.hello2morrow.sonargraph.ui.swt.dialog.f;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class ConnectionDialog
extends f {
    private final boolean c;
    private Response d;
    private Button e;
    private Button f;
    private Button g;
    private Button h;
    private final g i;

    ConnectionDialog(Shell shell, g proxySettingsProvider, ConnectionMode connectionMode, boolean offerExit) {
        super(shell, "Internet Connection Settings", 34912);
        assert (connectionMode != null) : "Parameter 'connectionMode' of method 'ConnectionDialog' must not be null";
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'ConnectionDialog' must not be null";
        switch (connectionMode) {
            case OFFLINE: {
                this.d = Response.OFFLINE;
                break;
            }
            case ONLINE: {
                this.d = Response.ONLINE;
                break;
            }
            default: {
                assert (false) : "Unhandled connection mode: " + (Object)((Object)connectionMode);
                break;
            }
        }
        this.i = proxySettingsProvider;
        this.c = offerExit;
    }

    @Override
    protected boolean j() {
        return true;
    }

    protected Point getInitialLocation(Point initialSize) {
        Shell shell;
        if (initialSize != null && (shell = this.getShell()) != null && !shell.isDisposed()) {
            l.a(shell);
            Point location = l.a(shell, initialSize);
            if (location != null) {
                return location;
            }
        }
        return super.getInitialLocation(initialSize);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
    }

    @Override
    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        return control;
    }

    @Override
    protected void a(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        Label text = new Label(composite, 64);
        StringBuilder info = new StringBuilder();
        if (this.d == Response.ONLINE) {
            info.append("The servers at hello2morrow are reachable.");
        } else {
            info.append("The servers at hello2morrow are not reachable. Either you are not connected to the Internet, you are behind a proxy\n or the servers at hello2morrow are down.");
        }
        info.append("\n\n");
        info.append("What do you want to do?");
        text.setText(info.toString());
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new RowLayout(512));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.d == Response.ONLINE) {
            this.e = new Button((Composite)group, 16);
            this.e.setText("Stay 'online'.");
            this.e.setSelection(true);
            this.e.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ConnectionDialog.this.d = Response.ONLINE;
                }
            });
        }
        this.f = new Button((Composite)group, 16);
        this.f.setText("Use in \"offline\" mode (activation code install, automatic ticket renewal, update check and feedback unavailable).");
        this.f.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionDialog.this.d = Response.OFFLINE;
            }
        });
        this.f.setSelection(this.d == Response.OFFLINE);
        this.g = new Button((Composite)group, 16);
        this.g.setText(this.i.a(false) == null ? "Configure a proxy." : "Reconfigure proxy.");
        this.g.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionDialog.this.d = Response.CONFIGURE_PROXY;
            }
        });
        if (this.c) {
            this.h = new Button((Composite)group, 16);
            this.h.setText("Exit Sonargraph.");
            this.h.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ConnectionDialog.this.d = Response.EXIT;
                }
            });
        }
    }

    private Response n() {
        return this.d;
    }

    public static ConnectionMode a(g proxySettingsProvider) {
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'getConnectionMode' must not be null";
        ProxySettings proxySettings = proxySettingsProvider.a(false);
        Pair hostAndProxySettings = HttpConnectionCheck.getReachableHostWithProxySettings((List)ServerInfo.HTTPS_AND_HTTP_HOSTS, (String)"/license_contracts/test_connection", (String)"OK\n", (ProxySettings)proxySettings);
        return hostAndProxySettings.getFirst() != null ? ConnectionMode.ONLINE : ConnectionMode.OFFLINE;
    }

    public static Pair<ConnectionMode, ProxySettings> b(g proxySettingsProvider) {
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'getOrConfigureConnectionMode' must not be null";
        ProxySettings proxySettings = proxySettingsProvider.a(false);
        Pair hostAndProxySettings = HttpConnectionCheck.getReachableHostWithProxySettings((List)ServerInfo.HTTPS_AND_HTTP_HOSTS, (String)"/license_contracts/test_connection", (String)"OK\n", (ProxySettings)proxySettings);
        ConnectionMode connectionMode = hostAndProxySettings.getFirst() != null ? ConnectionMode.ONLINE : ConnectionMode.OFFLINE;
        ProxySettings usedProxySettings = (ProxySettings)hostAndProxySettings.getSecond();
        if (connectionMode == ConnectionMode.OFFLINE) {
            ConnectionDialog dialog = new ConnectionDialog(null, proxySettingsProvider, connectionMode, true);
            dialog.open();
            Response response = dialog.n();
            switch (response) {
                case EXIT: {
                    return null;
                }
                case ONLINE: {
                    return new Pair((Object)ConnectionMode.ONLINE, (Object)usedProxySettings);
                }
                case OFFLINE: {
                    return new Pair((Object)ConnectionMode.OFFLINE, (Object)usedProxySettings);
                }
                case CONFIGURE_PROXY: {
                    int returnCode = proxySettingsProvider.a(null);
                    if (returnCode == 1) {
                        return ConnectionDialog.b(proxySettingsProvider);
                    }
                    if (!HttpConnectionCheck.canConnect((List)ServerInfo.CONNECTION_CHECK_URLS, null, (ProxySettings)proxySettingsProvider.a(false))) {
                        new b(null, "The servers at hello2morrow are not reachable with the specified proxy settings.", 4, null).open();
                        return ConnectionDialog.b(proxySettingsProvider);
                    }
                    return new Pair((Object)ConnectionMode.ONLINE, (Object)usedProxySettings);
                }
            }
            assert (false) : "Unhandled response: " + (Object)((Object)response);
            return new Pair((Object)ConnectionMode.OFFLINE, (Object)usedProxySettings);
        }
        return new Pair((Object)ConnectionMode.ONLINE, (Object)usedProxySettings);
    }

    public static ConnectionMode a(Shell shell, boolean offerExit, boolean forceDialog, g proxySettingsProvider) {
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'getOrConfigureConnectionMode' must not be null";
        ConnectionMode connectionMode = ConnectionDialog.a(proxySettingsProvider);
        if (connectionMode == ConnectionMode.OFFLINE || forceDialog) {
            ConnectionDialog dialog = new ConnectionDialog(shell, proxySettingsProvider, connectionMode, offerExit);
            dialog.open();
            Response response = dialog.n();
            switch (response) {
                case EXIT: {
                    return null;
                }
                case ONLINE: {
                    return ConnectionMode.ONLINE;
                }
                case OFFLINE: {
                    return ConnectionMode.OFFLINE;
                }
                case CONFIGURE_PROXY: {
                    int returnCode = proxySettingsProvider.a(shell);
                    if (returnCode == 1) {
                        return ConnectionDialog.a(shell, offerExit, false, proxySettingsProvider);
                    }
                    if (!HttpConnectionCheck.canConnect((List)ServerInfo.CONNECTION_CHECK_URLS, null, (ProxySettings)proxySettingsProvider.a(false))) {
                        new b(shell, "The servers at hello2morrow are not reachable with the specified proxy settings.", 4, null).open();
                        return ConnectionDialog.a(shell, offerExit, false, proxySettingsProvider);
                    }
                    return ConnectionMode.ONLINE;
                }
            }
            assert (false) : "Unhandled response: " + (Object)((Object)response);
            return ConnectionMode.OFFLINE;
        }
        return ConnectionMode.ONLINE;
    }

    static enum Response {
        ONLINE,
        OFFLINE,
        CONFIGURE_PROXY,
        EXIT;

    }
}

