/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.cyclesview;

import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventHandler;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.programming.ConditionFilter;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.w;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.TreeViewerBasedView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.aA;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleGroupBasedViewerComparator;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.g;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CycleGroupsView
extends TreeViewerBasedView<AnalyzerCycleGroup> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CycleGroupsView.class);
    private static final String FIRST_COLUMN = "Cycle";
    private static final String FILTER_HANDLED_ITEM_ID = "com.hello2morrow.sonargraph.ui.swt.handledmenuitem.hideignoredfilter";
    private static final Predicate<AnalyzerCycleGroup> IGNORED_FILTER = cycleGroup -> {
        Issue associatedIssue = cycleGroup.getAssociatedIssue();
        return associatedIssue != null && associatedIssue.getResolution() instanceof IgnoreDefinition;
    };
    private static final Predicate<AnalyzerCycleGroup> NOT_IGNORED_FILTER = cycleGroup -> {
        Issue associatedIssue = cycleGroup.getAssociatedIssue();
        return associatedIssue == null || !(associatedIssue.getResolution() instanceof IgnoreDefinition);
    };
    private final Map<IAnalyzerId, AnalyzerResult> m_analyzerResults = new HashMap<IAnalyzerId, AnalyzerResult>();
    private TreeViewerColumn m_treeViewerFirstColumn;
    private CycleGroupBasedViewerComparator m_comparator;

    @Override
    public IViewId getViewId() {
        return ViewId.CYCLE_GROUPS_VIEW;
    }

    @Override
    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    @Override
    protected void createViewContent(Composite viewContentArea) {
        this.m_treeViewer = new TreeViewer(viewContentArea, 66306);
        ConditionFilter filter = new ConditionFilter();
        filter.add(IGNORED_FILTER);
        filter.add(NOT_IGNORED_FILTER);
        this.m_contentProvider = new g((ConditionFilter<AnalyzerCycleGroup>)filter);
        this.m_treeViewer.setContentProvider((IContentProvider)this.m_contentProvider);
        this.m_comparator = new CycleGroupBasedViewerComparator();
        this.m_treeViewer.setComparator((ViewerComparator)this.m_comparator);
        this.m_textSearchHandler = new aA(this.m_treeViewer, this.getViewId().getPresentationName());
        this.m_treeViewer.getTree().setHeaderVisible(true);
        this.m_treeViewerFirstColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        this.m_treeViewerFirstColumn.getColumn().setWidth(300);
        this.m_treeViewerFirstColumn.getColumn().setText(FIRST_COLUMN);
        this.m_treeViewerFirstColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof NamedElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + element));
                }
                return ((NamedElement)element).getPresentationName(false);
            }

            public Image getImage(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof NamedElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + element));
                }
                return UiResourceManager.b().a((Element)((NamedElement)element));
            }
        });
        this.m_treeViewerFirstColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                CycleGroupsView.this.m_comparator.a(CycleGroupBasedViewerComparator.Sort.NAME);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        TreeViewerColumn sizeColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        sizeColumn.getColumn().setWidth(140);
        sizeColumn.getColumn().setText("Count");
        sizeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof AnalyzerResult) {
                    ConditionFilter filter = new ConditionFilter(CycleGroupsView.this.m_contentProvider.a());
                    List allCycleGroups = ((AnalyzerResult)obj).getChildren(AnalyzerCycleGroup.class);
                    if (filter.hasFiltered()) {
                        ArrayList<AnalyzerCycleGroup> visibleCycleGroups = new ArrayList<AnalyzerCycleGroup>();
                        for (AnalyzerCycleGroup analyzerCycleGroup : allCycleGroups) {
                            if (!filter.accept((Element)analyzerCycleGroup)) continue;
                            visibleCycleGroups.add(analyzerCycleGroup);
                        }
                        text = String.valueOf(visibleCycleGroups.size()) + " Cycle Groups";
                    } else {
                        text = String.valueOf(allCycleGroups.size()) + " Cycle Groups";
                    }
                } else if (obj instanceof AnalyzerCycleGroup) {
                    text = String.valueOf(((AnalyzerCycleGroup)obj).getNumberOfCyclicElements()) + " Cyclic Elements";
                }
                return text;
            }
        });
        sizeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                CycleGroupsView.this.m_comparator.a(CycleGroupBasedViewerComparator.Sort.SIZE);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        TreeViewerColumn scopeColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        scopeColumn.getColumn().setWidth(200);
        scopeColumn.getColumn().setText("Scope");
        scopeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                NamedElement scope;
                String text = null;
                if (obj instanceof AnalyzerCycleGroup && (scope = ((AnalyzerCycleGroup)obj).getScope()) != null) {
                    text = scope.getPresentationName(true);
                }
                return text;
            }

            public Image getImage(Object obj) {
                NamedElement scope;
                Image image = null;
                if (obj instanceof AnalyzerCycleGroup && (scope = ((AnalyzerCycleGroup)obj).getScope()) != null) {
                    image = UiResourceManager.b().a((Element)scope);
                }
                return image;
            }
        });
        scopeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                CycleGroupsView.this.m_comparator.a(CycleGroupBasedViewerComparator.Sort.SCOPE);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        TreeViewerColumn resolutionColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        resolutionColumn.getColumn().setWidth(200);
        resolutionColumn.getColumn().setText("Resolution");
        resolutionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                String text = null;
                if (obj instanceof AnalyzerCycleGroup) {
                    AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)obj;
                    Issue associatedIssue = cycleGroup.getAssociatedIssue();
                    if (associatedIssue != null) {
                        StringBuilder resolutionText = new StringBuilder();
                        if (associatedIssue.getResolution() != null) {
                            Resolution resolution = (Resolution)associatedIssue.getResolution();
                            if (resolution.ignores()) {
                                resolutionText.append("Ignored");
                            } else {
                                resolutionText.append("Task");
                                resolutionText.append(" ");
                                resolutionText.append("[");
                                resolutionText.append(resolution.getPriority().getPresentationName());
                                resolutionText.append("]");
                            }
                            text = resolutionText.toString();
                        }
                    }
                    if (text == null) {
                        text = "None";
                    }
                }
                return text;
            }

            public Image getImage(Object obj) {
                Image image = null;
                if (obj instanceof AnalyzerCycleGroup) {
                    Resolution resolution;
                    AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)obj;
                    Issue associatedIssue = cycleGroup.getAssociatedIssue();
                    if (associatedIssue != null && (resolution = (Resolution)associatedIssue.getResolution()) != null) {
                        image = resolution.ignores() ? UiResourceManager.b().a("Ignore") : UiResourceManager.b().a("Fix");
                    }
                    if (image == null) {
                        image = UiResourceManager.b().a("None");
                    }
                }
                return image;
            }
        });
        resolutionColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                CycleGroupsView.this.m_comparator.a(CycleGroupBasedViewerComparator.Sort.RESOLUTION_PRIORITY);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        TreeViewerColumn locColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        locColumn.getColumn().setWidth(140);
        locColumn.getColumn().setText("Involved Lines of Code");
        locColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object obj) {
                if (obj instanceof AnalyzerCycleGroup) {
                    int loc = ((AnalyzerCycleGroup)obj).getLinesOfCodeOfInvolvedSourceFiles();
                    if (loc < 0) {
                        return "n/a";
                    }
                    return Integer.toString(loc);
                }
                return null;
            }
        });
        locColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e2) {
                CycleGroupsView.this.m_comparator.a(CycleGroupBasedViewerComparator.Sort.LOC);
                CycleGroupsView.this.m_treeViewer.refresh();
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_treeViewer);
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void a(AnalyzerResultAvailableEvent event) {
                AnalyzerResult result;
                if (CycleGroupsView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == null && (result = event.getResult()).hasChildren(false, new Class[]{AnalyzerCycleGroup.class})) {
                    CycleGroupsView.this.m_analyzerResults.put(result.getId(), result);
                    LOGGER.debug("Added analyzer result");
                    CycleGroupsView.this.show(false, true);
                }
            }

            public /* synthetic */ void handleEvent(Event event) {
                this.a((AnalyzerResultAvailableEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void a(AnalyzerResultClearedEvent event) {
                if (CycleGroupsView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    for (Analyzer next : event.getAnalyzers()) {
                        CycleGroupsView.this.m_analyzerResults.remove(next.getId());
                    }
                    LOGGER.debug("Removed analyzer results {}", (Object)event.getAnalyzers());
                    CycleGroupsView.this.show(false, false);
                }
            }

            public /* synthetic */ void handleEvent(Event event) {
                this.a((AnalyzerResultClearedEvent)event);
            }
        });
        this.updateViewOptions();
    }

    @Override
    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        if (element instanceof NamedElement) {
            return (NamedElement)element.getElement();
        }
        return null;
    }

    @Override
    protected Object getTreeInput() {
        return this.m_analyzerResults.values();
    }

    @Override
    protected void updateViewOptions() {
        MHandledMenuItem filterMenuItem = w.a(this.getEclipseContext(), (MUIElement)this.getPart().getMenus().get(0), FILTER_HANDLED_ITEM_ID, MHandledMenuItem.class);
        ConditionFilter oldFilter = this.m_contentProvider.a();
        ConditionFilter newFilter = new ConditionFilter(oldFilter);
        if (filterMenuItem == null || filterMenuItem.isSelected()) {
            newFilter.remove(IGNORED_FILTER);
        } else {
            newFilter.add(IGNORED_FILTER);
        }
        this.m_contentProvider.a(newFilter);
    }

    @Override
    protected void updateFirstColumnText() {
        if (this.m_treeViewer.getTree().isDisposed()) {
            return;
        }
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null && softwareSystem.getState() == SoftwareSystemState.MODEL_LOADED && !this.m_analyzerResults.isEmpty()) {
            Object[] expanded = this.m_treeViewer.getExpandedElements();
            this.m_treeViewer.expandToLevel(2);
            int cycles = 0;
            TreeItem[] treeItemArray = this.m_treeViewer.getTree().getItems();
            int n2 = treeItemArray.length;
            int n3 = 0;
            while (n3 < n2) {
                TreeItem nextItem = treeItemArray[n3];
                cycles += nextItem.getItemCount();
                ++n3;
            }
            this.m_treeViewerFirstColumn.getColumn().setText("Cycle [" + cycles + " " + StringUtility.pluralize((String)"element", (int)cycles) + "]");
            this.m_treeViewer.setExpandedElements(expanded);
        } else {
            this.m_treeViewerFirstColumn.getColumn().setText(FIRST_COLUMN);
        }
    }

    @Override
    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        boolean ignores = false;
        for (Element element : elements) {
            assert (element instanceof AnalyzerCycleGroup) : "Unexpected class in method 'finishShowInView': " + element;
            AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)element;
            Resolution resolution = (Resolution)cycleGroup.getAssociatedIssue().getResolution();
            if (resolution == null || !resolution.ignores()) continue;
            ignores = true;
            break;
        }
        ConditionFilter oldFilter = this.m_contentProvider.a();
        if (ignores && oldFilter.hasFiltered()) {
            ConditionFilter newFilter = new ConditionFilter(oldFilter);
            newFilter.add(IGNORED_FILTER);
            newFilter.add(NOT_IGNORED_FILTER);
            assert (newFilter != null) : "Parameter 'newFilter' of method 'setFilter' must not be null";
            this.m_contentProvider.a(newFilter);
            this.show(true, true);
            MHandledMenuItem filterMenuItem = w.a(this.getEclipseContext(), (MUIElement)this.getPart().getMenus().get(0), FILTER_HANDLED_ITEM_ID, MHandledMenuItem.class);
            assert (filterMenuItem != null) : "'useAntialiasingItem' of method 'updateViewOptions' must not be null";
            filterMenuItem.setSelected(false);
        }
        this.removeListeners();
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection(elements));
        this.addListeners();
        super.finishShowInView(sourceViewId, elements, options);
    }

    @Override
    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        for (Analyzer analyzer : ((Files)this.getSoftwareSystem().getUniqueExistingChild(Files.class)).getAnalyzers().getChildren(Analyzer.class)) {
            if (analyzer.getId().getGroup() != AnalyzerGroup.CYCLES || analyzer.getState() != AnalyzerState.FINISHED) continue;
            AnalyzerResult result = analyzer.getResult();
            this.m_analyzerResults.put(result.getId(), result);
        }
        this.show(false, mode == WorkbenchView.ShowMode.AWAKE);
        super.softwareSystemShow(mode);
    }

    @Override
    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        boolean tryRefresh = true;
        if (modification.contains(Modification.VIRTUAL_MODEL_CHANGED)) {
            this.m_analyzerResults.clear();
            tryRefresh = false;
        } else {
            Iterator<Map.Entry<IAnalyzerId, AnalyzerResult>> iterator = this.m_analyzerResults.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<IAnalyzerId, AnalyzerResult> next = iterator.next();
                if (next.getValue().isValid()) continue;
                tryRefresh = false;
                iterator.remove();
            }
        }
        LOGGER.debug("softwareSystemModified. Modifications={}, tryRefresh={}", modification, (Object)tryRefresh);
        this.show(tryRefresh, true);
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    @Override
    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        super.analyzerModification(modification, analyzerId);
    }

    private void reset() {
        this.removeListeners();
        this.m_treeViewer.getTree().setRedraw(false);
        this.m_analyzerResults.clear();
        this.m_treeViewerFirstColumn.getColumn().setText(FIRST_COLUMN);
        this.m_treeViewer.setInput(null);
        this.m_contentProvider.c();
        this.m_treeViewer.getTree().setBackground(UiResourceManager.b().g());
        this.m_treeViewer.getTree().setRedraw(true);
        this.addListeners();
    }

    @Override
    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.reset();
    }

    @Override
    public List<Element> getSelectedElements() {
        assert (this.m_treeViewer != null) : "'m_propertyTableViewer' of method 'getSelected' must not be null";
        IStructuredSelection selection = (IStructuredSelection)this.m_treeViewer.getSelection();
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> selected = new ArrayList<Element>();
        for (Object next : selection.toList()) {
            if (!(next instanceof Element)) continue;
            selected.add((Element)next);
        }
        return selected;
    }

    public void setSelectedCycleGroups(List<String> groupNames) {
        assert (groupNames != null && !groupNames.isEmpty()) : "Parameter 'groupNames' of method 'setSelectedCycleGroups' must not be empty";
        ArrayList<AnalyzerCycleGroup> cycleGroups = new ArrayList<AnalyzerCycleGroup>();
        for (Map.Entry<IAnalyzerId, AnalyzerResult> entry : this.m_analyzerResults.entrySet()) {
            for (AnalyzerCycleGroup group : entry.getValue().getChildren(AnalyzerCycleGroup.class)) {
                if (!group.isValid() || !groupNames.contains(group.getName())) continue;
                cycleGroups.add(group);
            }
        }
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection(cycleGroups), true);
        for (AnalyzerCycleGroup group : cycleGroups) {
            if (!group.isValid() || this.m_treeViewer.getExpandedState((Object)group)) continue;
            this.m_treeViewer.setExpandedState((Object)group, true);
        }
    }
}

