/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.cyclesview;

import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventHandler;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.command.common.c;
import com.hello2morrow.sonargraph.core.command.system.m;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetInfo;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultStateChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.GraphViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.graphview.CycleBreakUpSet;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewCycleGroupNode;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.l;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.x;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ai;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.t;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleBreakUpViewComponent;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleBreakUpViewDependencies;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleBreakUpViewViewerData;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.CycleView;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.GraphViewDependencyBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.b;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.d;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.e;
import com.hello2morrow.sonargraph.ui.swt.cyclesview.f;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class CycleBreakUpView
extends WorkbenchAuxiliaryView
implements PropertyTableViewer.b<GraphViewNode.GraphViewDependency>,
e.b,
ISelectionChangedListener {
    private static final String FROM_PROPERTY = "from";
    private static final String TO_PROPERTY = "to";
    private static final String REMOVE = "[Remove]";
    private static final String KEEP_IF_POSSIBLE = "[Keep If Possible]";
    private final GraphViewDependencyBeanAdapter m_breakUpEdgeBeanAdapter = new GraphViewDependencyBeanAdapter();
    private final GraphViewDependencyBeanAdapter m_removeEdgeBeanAdapter = new GraphViewDependencyBeanAdapter();
    private final GraphViewDependencyBeanAdapter m_keepEdgeBeanAdapter = new GraphViewDependencyBeanAdapter();
    private final Set<GraphViewNode.GraphViewDependency> m_currentViolations = new LinkedHashSet<GraphViewNode.GraphViewDependency>();
    private PropertyTableViewer<GraphViewNode.GraphViewDependency> m_breakUpViewer;
    private PropertyTableViewer<GraphViewNode.GraphViewDependency> m_removeViewer;
    private PropertyTableViewer<GraphViewNode.GraphViewDependency> m_keepViewer;
    private ai m_breakUpTextSearchHandler;
    private ai m_removeTextSearchHandler;
    private ai m_keepTextSearchHandler;
    private Set<GraphViewNode> m_currentNodes;
    private d m_currentComputeInfo;
    private CycleBreakUpViewComponent m_selectedComponent = CycleBreakUpViewComponent.BREAK_UP_VIEWER;
    private e m_dragAndDropAdapter;
    private Button m_reset;
    private Button m_compute;
    private Button m_removeViolations;
    private b m_breakupInfoComposite;
    private boolean m_viewEnabled;

    @Override
    public IViewId getViewId() {
        return ViewId.CYCLE_BREAK_UP_VIEW;
    }

    @Override
    protected boolean supportsSleep() {
        return false;
    }

    @Override
    public StructureMode getStructureMode() {
        return StructureMode.NON_RECURSIVE;
    }

    @Override
    protected boolean canConnect(WorkbenchView view, boolean force) {
        assert (view != null) : "Parameter 'view' of method 'canConnect' must not be null";
        return view.getViewId().equals(ViewId.CYCLE_VIEW) && view.isReady();
    }

    @Override
    protected void createViewContent(Composite viewContentArea) {
        Composite rootComposite = new Composite(viewContentArea, 0);
        rootComposite.setLayout((Layout)f.a(2, true));
        this.m_breakupInfoComposite = new b(rootComposite);
        this.m_breakupInfoComposite.setLayoutData(new GridData(4, 1, true, false));
        Composite buttonComposite = new Composite(rootComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(3, true));
        this.m_removeViolations = new Button(buttonComposite, 0x800008);
        this.m_removeViolations.setText("Remove Violations");
        this.m_removeViolations.setEnabled(false);
        this.m_removeViolations.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_compute = new Button(buttonComposite, 0x800008);
        this.m_compute.setText("Compute");
        this.m_compute.setEnabled(false);
        this.m_compute.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_reset = new Button(buttonComposite, 0x800008);
        this.m_reset.setText("Reset");
        this.m_reset.setEnabled(false);
        this.m_reset.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData buttonCompositeGridData = new GridData(0x1000008, 1, false, false);
        buttonCompositeGridData.widthHint = buttonComposite.computeSize((int)-1, (int)-1).x;
        buttonComposite.setLayoutData((Object)buttonCompositeGridData);
        if (com.hello2morrow.sonargraph.core.command.common.e.b().a(SonargraphFeature.CYCLE_BREAK_UP)) {
            this.m_removeViolations.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e2) {
                    if (CycleBreakUpView.this.m_viewEnabled) {
                        CycleBreakUpView.this.performRemoveViolations();
                    }
                }
            });
            this.m_reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (CycleBreakUpView.this.m_viewEnabled) {
                        CycleBreakUpView.this.performReset();
                    }
                }
            });
            this.m_compute.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (CycleBreakUpView.this.m_viewEnabled) {
                        CycleBreakUpView.this.performCompute();
                    }
                }
            });
        }
        SashForm sashForm = new SashForm(rootComposite, 512);
        l.a(sashForm);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_breakUpViewer = new PropertyTableViewer<GraphViewNode.GraphViewDependency>((Composite)sashForm, this.m_breakUpEdgeBeanAdapter, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_breakUpViewer.a("[Breakup] From", FROM_PROPERTY, null, "fromImage", 26, PropertyTableViewer.ColumnType.TEXT);
        this.m_breakUpViewer.a("Dependency", "dependencyInfo", null, "dependencyImage", 8, PropertyTableViewer.ColumnType.TEXT);
        this.m_breakUpViewer.a("To", TO_PROPERTY, null, "toImage", 26, PropertyTableViewer.ColumnType.TEXT);
        this.m_breakUpViewer.a("Cyclicity", "cyclicity", null, null, 5, PropertyTableViewer.ColumnType.NUMBER);
        this.m_breakUpViewer.a("Cyclic Nodes", "numberOfCyclicNodes", null, null, 8, PropertyTableViewer.ColumnType.NUMBER);
        this.m_breakUpViewer.a("Parser Dependencies", "weight", null, null, 10, PropertyTableViewer.ColumnType.NUMBER);
        this.m_breakUpViewer.a("Sum Of Parser Dependencies", "sumOfWeightInfo", null, null, 12, PropertyTableViewer.ColumnType.NUMBER);
        this.m_breakUpViewer.a(this);
        this.m_removeViewer = new PropertyTableViewer<GraphViewNode.GraphViewDependency>((Composite)sashForm, this.m_removeEdgeBeanAdapter, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_removeViewer.a("[Remove] From", FROM_PROPERTY, FROM_PROPERTY, "fromImage", 36, PropertyTableViewer.ColumnType.TEXT);
        this.m_removeViewer.a("Dependency", "dependencyInfo", null, "dependencyImage", 11, PropertyTableViewer.ColumnType.TEXT);
        this.m_removeViewer.a("To", TO_PROPERTY, null, "toImage", 36, PropertyTableViewer.ColumnType.TEXT);
        this.m_removeViewer.a("Parser Dependencies", "weight", null, null, 11, PropertyTableViewer.ColumnType.NUMBER);
        this.m_removeViewer.a(this);
        this.m_keepViewer = new PropertyTableViewer<GraphViewNode.GraphViewDependency>((Composite)sashForm, this.m_keepEdgeBeanAdapter, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_keepViewer.a("[Keep If Possible] From", FROM_PROPERTY, FROM_PROPERTY, "fromImage", 36, PropertyTableViewer.ColumnType.TEXT);
        this.m_keepViewer.a("Dependency", "dependencyInfo", null, "dependencyImage", 11, PropertyTableViewer.ColumnType.TEXT);
        this.m_keepViewer.a("To", TO_PROPERTY, null, "toImage", 36, PropertyTableViewer.ColumnType.TEXT);
        this.m_keepViewer.a("Parser Dependencies", "weight", null, null, 11, PropertyTableViewer.ColumnType.NUMBER);
        this.m_keepViewer.a(this);
        this.m_breakUpTextSearchHandler = new ai(this.m_breakUpViewer, this.getViewId().getPresentationName());
        this.m_keepTextSearchHandler = new ai(this.m_keepViewer, this.getViewId().getPresentationName());
        this.m_removeTextSearchHandler = new ai(this.m_removeViewer, this.getViewId().getPresentationName());
        sashForm.setWeights(new int[]{50, 25, 25});
        ArrayList<PropertyTableViewer<GraphViewNode.GraphViewDependency>> viewers = new ArrayList<PropertyTableViewer<GraphViewNode.GraphViewDependency>>(3);
        viewers.add(this.m_breakUpViewer);
        viewers.add(this.m_removeViewer);
        viewers.add(this.m_keepViewer);
        this.m_dragAndDropAdapter = new e(viewers, this);
        this.initialize();
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultStateChangedEvent>(AnalyzerResultStateChangedEvent.class, (Object)this){

            public void a(AnalyzerResultStateChangedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (CycleBreakUpView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && CycleBreakUpView.this.m_currentComputeInfo != null && event.getResult().getId() == CoreAnalyzerId.ARCHITECTURE_CHECK) {
                    AnalyzerState state = event.getState();
                    if (state == AnalyzerState.FINISHED) {
                        CycleBreakUpView.this.m_currentViolations.clear();
                        if (CycleBreakUpView.this.m_currentNodes != null && !CycleBreakUpView.this.m_currentNodes.isEmpty()) {
                            CycleBreakUpView.this.m_currentViolations.addAll(GraphViewNode.getViolations(CycleBreakUpView.this.m_currentNodes));
                        }
                        CycleBreakUpView.this.performReset();
                        CycleBreakUpView.this.m_removeViolations.setEnabled(CycleBreakUpView.this.enableRemoveViolations());
                    } else if (state == AnalyzerState.CANCELLED || state == AnalyzerState.HAS_NOT_BEEN_RUN) {
                        CycleBreakUpView.this.m_currentViolations.clear();
                        CycleBreakUpView.this.performReset();
                    }
                }
            }

            public /* synthetic */ void handleEvent(Event event) {
                this.a((AnalyzerResultStateChangedEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<GraphViewModifiedEvent>(GraphViewModifiedEvent.class, (Object)this){

            public void a(GraphViewModifiedEvent event) {
                WorkbenchView connectedView;
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (CycleBreakUpView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && CycleBreakUpView.this.m_currentComputeInfo != null && (connectedView = CycleBreakUpView.this.getConnectedView()) != null) {
                    if (!($assertionsDisabled || connectedView != null && connectedView instanceof CycleView)) {
                        throw new AssertionError((Object)("Unexpected class in method 'handleEvent': " + connectedView));
                    }
                    if (((CycleView)connectedView).isShowingCycle(event.getOwner())) {
                        CycleBreakUpView.this.handleSelection(connectedView, connectedView.getSelectedElements());
                    }
                }
            }

            public /* synthetic */ void handleEvent(Event event) {
                this.a((GraphViewModifiedEvent)event);
            }
        });
    }

    @Override
    protected void destroyViewContent() {
        EventManager.getInstance().detach(AnalyzerResultStateChangedEvent.class, (Object)this);
        EventManager.getInstance().detach(GraphViewModifiedEvent.class, (Object)this);
        if (this.m_dragAndDropAdapter != null) {
            this.m_dragAndDropAdapter.a();
        }
        super.destroyViewContent();
    }

    private void reset(boolean enableCompute, boolean clearRemoveAndKeep, boolean persistEnableCompute) {
        this.m_compute.setEnabled(com.hello2morrow.sonargraph.core.command.common.e.b().a(SonargraphFeature.CYCLE_BREAK_UP) && enableCompute);
        this.m_removeViolations.setEnabled(this.enableRemoveViolations());
        if (persistEnableCompute && this.m_currentComputeInfo != null) {
            this.m_currentComputeInfo.a(enableCompute);
        }
        if (clearRemoveAndKeep) {
            this.m_keepViewer.c((Collection<GraphViewNode.GraphViewDependency>)null);
            this.m_removeViewer.c((Collection<GraphViewNode.GraphViewDependency>)null);
            this.m_removeEdgeBeanAdapter.setFeedbackArcSetInfo(null);
            this.m_keepEdgeBeanAdapter.setFeedbackArcSetInfo(null);
        }
        this.m_breakupInfoComposite.a();
        this.m_breakUpViewer.c((Collection<GraphViewNode.GraphViewDependency>)null);
        this.m_breakUpEdgeBeanAdapter.setFeedbackArcSetInfo(null);
    }

    private boolean enableRemoveViolations() {
        return this.m_currentViolations.isEmpty() || this.m_currentComputeInfo == null ? false : !new THashSet(this.m_currentComputeInfo.a()).containsAll(this.m_currentViolations);
    }

    private void performReset() {
        if (this.m_currentComputeInfo != null) {
            this.m_currentComputeInfo.a(UiResourceManager.b().g());
            this.reset(true, true, true);
            this.m_reset.setEnabled(false);
        }
    }

    private void performRemoveViolations() {
        boolean changedRemoved;
        WorkbenchView connectedView = this.getConnectedView();
        assert (connectedView != null && connectedView instanceof CycleView) : "Unexpected class in method 'compute': " + connectedView;
        assert (this.m_currentComputeInfo != null) : "'m_currentComputeInformation' of method 'compute' must not be null";
        if (this.m_currentViolations.isEmpty()) {
            return;
        }
        this.m_keepViewer.n().setRedraw(false);
        this.m_removeViewer.n().setRedraw(false);
        boolean enableCompute = false;
        boolean changedKeep = this.m_currentComputeInfo.b().removeAll(this.m_currentViolations);
        if (changedKeep) {
            this.m_currentComputeInfo.h().clear();
            this.m_currentComputeInfo.h().addAll(this.m_currentComputeInfo.b());
            this.m_currentComputeInfo.f().clear();
            this.m_currentComputeInfo.f().addAll(this.m_currentComputeInfo.b());
            enableCompute = !this.m_currentComputeInfo.e().equals(this.m_currentComputeInfo.f());
        }
        boolean bl2 = changedRemoved = this.m_currentComputeInfo.a().size() < this.m_currentViolations.size();
        if (!changedRemoved) {
            ArrayList<GraphViewNode.GraphViewDependency> removedFirstN = new ArrayList<GraphViewNode.GraphViewDependency>(this.m_currentComputeInfo.a().subList(0, this.m_currentViolations.size()));
            boolean bl3 = changedRemoved = !removedFirstN.containsAll(this.m_currentViolations);
        }
        if (changedRemoved) {
            this.m_currentComputeInfo.a().removeAll(this.m_currentViolations);
            this.m_currentComputeInfo.a().addAll(0, this.m_currentViolations);
            this.m_currentComputeInfo.i().clear();
            this.m_currentComputeInfo.i().addAll(this.m_currentComputeInfo.a());
            this.m_currentComputeInfo.d().clear();
            this.m_currentComputeInfo.d().addAll(this.m_currentComputeInfo.a());
            boolean bl4 = enableCompute = enableCompute || !this.m_currentComputeInfo.c().equals(this.m_currentComputeInfo.d());
        }
        if (!this.m_compute.isEnabled() && enableCompute) {
            this.m_compute.setEnabled(com.hello2morrow.sonargraph.core.command.common.e.b().a(SonargraphFeature.CYCLE_BREAK_UP));
            this.m_currentComputeInfo.a(true);
        }
        this.m_currentComputeInfo.b(!this.m_compute.isEnabled());
        this.m_breakUpViewer.c(this.m_currentComputeInfo.g());
        this.m_removeViewer.c(this.m_currentComputeInfo.a());
        this.m_keepViewer.c(this.m_currentComputeInfo.b());
        this.m_reset.setEnabled(!this.m_currentComputeInfo.g().isEmpty() || !this.m_currentComputeInfo.a().isEmpty() || !this.m_currentComputeInfo.b().isEmpty());
        this.m_removeViolations.setEnabled(false);
        this.m_breakUpViewer.n().setRedraw(true);
        this.m_keepViewer.n().setRedraw(true);
        this.m_removeViewer.n().setRedraw(true);
    }

    private void performCompute() {
        WorkbenchView connected = this.getConnectedView();
        assert (connected instanceof CycleView) : "Unexpected class in method 'compute': " + connected;
        assert (this.m_currentComputeInfo != null) : "'m_currentComputeInformation' of method 'compute' must not be null";
        assert (this.m_currentNodes != null && !this.m_currentNodes.isEmpty()) : "'m_currentNodes' of method 'compute' must not be empty";
        final m command = new m(this.getSoftwareSystemProvider(), new m.a(){

            public Set<GraphViewNode> e() {
                return CycleBreakUpView.this.m_currentNodes;
            }

            public Collection<GraphViewNode.GraphViewDependency> d() {
                return CycleBreakUpView.this.m_currentComputeInfo.b();
            }

            public Collection<GraphViewNode.GraphViewDependency> c() {
                return CycleBreakUpView.this.m_currentComputeInfo.a();
            }

            public /* synthetic */ Collection b() {
                return this.e();
            }
        });
        if (command.g().isSuccess()) {
            UserInterfaceAdapter.b().a((c)command, new com.hello2morrow.sonargraph.core.command.common.f(){

                public void a(com.hello2morrow.sonargraph.core.command.common.d exception) {
                    CycleBreakUpSet cycleBreakUpSet;
                    super.a(exception);
                    if (exception == null && CycleBreakUpView.this.isActive() && (cycleBreakUpSet = command.o()) != null) {
                        CycleBreakUpView.this.reset(false, false, true);
                        CycleBreakUpView.this.m_currentComputeInfo.c().clear();
                        CycleBreakUpView.this.m_currentComputeInfo.d().clear();
                        CycleBreakUpView.this.m_currentComputeInfo.e().clear();
                        CycleBreakUpView.this.m_currentComputeInfo.f().clear();
                        CycleBreakUpView.this.m_currentComputeInfo.h().clear();
                        CycleBreakUpView.this.m_currentComputeInfo.g().clear();
                        CycleBreakUpView.this.m_currentComputeInfo.t().clear();
                        CycleBreakUpView.this.m_currentComputeInfo.a(false);
                        Set cycleBreakUpSetEdges = cycleBreakUpSet.getEdges();
                        LinkedHashSet<GraphViewNode.GraphViewDependency> edges = new LinkedHashSet<GraphViewNode.GraphViewDependency>(cycleBreakUpSetEdges.size());
                        for (INode.IEdge nextEdge : cycleBreakUpSetEdges) {
                            edges.add((GraphViewNode.GraphViewDependency)nextEdge);
                        }
                        Set cycleBreakUpSetNotKeptEdges = cycleBreakUpSet.getNotKeptEdges();
                        LinkedHashSet<GraphViewNode.GraphViewDependency> notKeptEdges = new LinkedHashSet<GraphViewNode.GraphViewDependency>(cycleBreakUpSetNotKeptEdges.size());
                        for (INode.IEdge nextEdge : cycleBreakUpSetNotKeptEdges) {
                            notKeptEdges.add((GraphViewNode.GraphViewDependency)nextEdge);
                        }
                        FeedbackArcSetInfo info = cycleBreakUpSet.getInfo();
                        CycleBreakUpView.this.m_breakUpEdgeBeanAdapter.setFeedbackArcSetInfo(info);
                        CycleBreakUpView.this.m_removeEdgeBeanAdapter.setFeedbackArcSetInfo(info);
                        CycleBreakUpView.this.m_keepEdgeBeanAdapter.setFeedbackArcSetInfo(info);
                        CycleBreakUpView.this.m_breakUpViewer.c(edges);
                        CycleBreakUpView.this.m_removeViewer.c(CycleBreakUpView.this.m_currentComputeInfo.a());
                        CycleBreakUpView.this.m_keepViewer.c(CycleBreakUpView.this.m_currentComputeInfo.b());
                        CycleBreakUpView.this.m_currentComputeInfo.a(NumberUtility.format((Number)info.getNumberOfCyclicNodes()));
                        CycleBreakUpView.this.m_currentComputeInfo.b(NumberUtility.format((Number)info.getCyclicity()));
                        CycleBreakUpView.this.m_currentComputeInfo.c(NumberUtility.format((Number)info.getNumberOfEdges()));
                        CycleBreakUpView.this.m_currentComputeInfo.e(String.valueOf(NumberUtility.format((Number)info.getNumberOfEdgesToRemove())) + " (" + info.getPercentOfEdgesToRemove() + "%)");
                        CycleBreakUpView.this.m_currentComputeInfo.d(NumberUtility.format((Number)info.getWeightOfEdges()));
                        CycleBreakUpView.this.m_currentComputeInfo.f(String.valueOf(NumberUtility.format((Number)info.getWeightOfEdgesToRemove())) + " (" + info.getPercentOfWeightToRemove() + "%)");
                        CycleBreakUpView.this.m_breakupInfoComposite.a(CycleBreakUpView.this.m_currentComputeInfo);
                        CycleBreakUpView.this.m_currentComputeInfo.a(info);
                        CycleBreakUpView.this.m_currentComputeInfo.a(notKeptEdges);
                        CycleBreakUpView.this.m_currentComputeInfo.c().clear();
                        CycleBreakUpView.this.m_currentComputeInfo.c().addAll(CycleBreakUpView.this.m_currentComputeInfo.a());
                        CycleBreakUpView.this.m_currentComputeInfo.e().addAll(CycleBreakUpView.this.m_currentComputeInfo.b());
                        for (GraphViewNode.GraphViewDependency nextEdge : edges) {
                            Pair endpoint = new Pair((Object)nextEdge.getFromEndPoint(), (Object)nextEdge.getToEndPoint());
                            CycleBreakUpView.this.m_currentComputeInfo.a((Pair<NamedElement, NamedElement>)endpoint, nextEdge);
                        }
                        CycleBreakUpView.this.m_currentComputeInfo.g().addAll(edges);
                        CycleBreakUpView.this.m_currentComputeInfo.h().addAll(CycleBreakUpView.this.m_currentComputeInfo.b());
                        CycleBreakUpView.this.m_currentComputeInfo.i().addAll(CycleBreakUpView.this.m_currentComputeInfo.a());
                        CycleBreakUpView.this.m_currentComputeInfo.f().addAll(CycleBreakUpView.this.m_currentComputeInfo.b());
                        CycleBreakUpView.this.m_currentComputeInfo.d().addAll(CycleBreakUpView.this.m_currentComputeInfo.a());
                        CycleBreakUpView.this.m_currentComputeInfo.b(true);
                        CycleBreakUpView.this.m_reset.setEnabled(true);
                        CycleBreakUpView.this.notifyAboutConflictsOrOverdefinedRemove(cycleBreakUpSet);
                    }
                }
            });
        }
    }

    private void notifyAboutConflictsOrOverdefinedRemove(CycleBreakUpSet cycleBreakUpSet) {
        boolean hasOverdefinitions;
        assert (cycleBreakUpSet != null) : "Parameter 'cycleBreakUpSet' of method 'notifyAboutConflictsOrOverdefinedRemove' must not be null";
        int numberOfNotKept = cycleBreakUpSet.getNotKeptEdges().size();
        boolean hasConflicts = numberOfNotKept > 0;
        int numberOfOverdefined = cycleBreakUpSet.getInfo().getOverdefinedEdges().size();
        boolean bl2 = hasOverdefinitions = numberOfOverdefined > 0;
        if (hasConflicts || hasOverdefinitions) {
            StringBuilder msg = new StringBuilder();
            if (hasConflicts) {
                msg.append("The breakup set contains ").append(numberOfNotKept).append(" edge(s) that could not be kept (yellow node icon background).\n").append("Check the edges in the ").append(KEEP_IF_POSSIBLE).append(" table.\n");
            }
            if (hasOverdefinitions) {
                msg.append("The breakup set contains ").append(numberOfOverdefined).append(" edge(s) that do not need to be removed to break the cycle (grey node icon background).\n").append("Check the edges in the ").append(REMOVE).append(" table.\n");
            }
            UserInterfaceAdapter.b().a("Cycle Breakup Set Info", msg.toString());
        }
    }

    private void addListeners() {
        this.m_breakUpViewer.m().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_keepViewer.m().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_removeViewer.m().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void removeListeners() {
        this.m_breakUpViewer.m().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_keepViewer.m().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_removeViewer.m().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addListeners();
    }

    @Override
    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_breakUpViewer.n(), this.m_keepViewer.n(), this.m_removeViewer.n());
    }

    @Override
    public List<Control> getViewComponents() {
        return Arrays.asList(this.m_breakUpViewer.n(), this.m_keepViewer.n(), this.m_removeViewer.n());
    }

    @Override
    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (component == this.m_breakUpViewer.n()) {
            this.m_selectedComponent = CycleBreakUpViewComponent.BREAK_UP_VIEWER;
            this.m_breakUpViewer.n().setFocus();
        } else if (component == this.m_keepViewer.n()) {
            this.m_selectedComponent = CycleBreakUpViewComponent.KEEP_VIEWER;
            this.m_keepViewer.n().setFocus();
        } else if (component == this.m_removeViewer.n()) {
            this.m_selectedComponent = CycleBreakUpViewComponent.REMOVE_VIEWER;
            this.m_removeViewer.n().setFocus();
        } else assert (false) : "Unhandled component: " + component;
    }

    @Override
    public Control getSelectedViewComponent() {
        switch (this.m_selectedComponent) {
            case BREAK_UP_VIEWER: {
                return this.m_breakUpViewer.n();
            }
            case KEEP_VIEWER: {
                return this.m_keepViewer.n();
            }
            case REMOVE_VIEWER: {
                return this.m_removeViewer.n();
            }
        }
        assert (false) : "Unhandled component: " + (Object)((Object)this.m_selectedComponent);
        return null;
    }

    private void reset() {
        this.reset(false, true, false);
        this.m_currentComputeInfo = null;
        this.m_currentViolations.clear();
        this.m_removeViolations.setEnabled(this.enableRemoveViolations());
        this.m_reset.setEnabled(false);
        this.resetPartName();
        this.m_dragAndDropAdapter.a();
    }

    @Override
    protected void handleSelection(WorkbenchView connectedView, List<Element> elements) {
        assert (connectedView != null && connectedView instanceof CycleView) : "Unexpected class in method 'handleSelection': " + connectedView;
        assert (elements != null) : "Parameter 'elements' of method 'handleSelection' must not be null";
        StrictPair<CycleGroup, GraphViewCycleGroupNode> cycleGroupInfo = t.a(elements);
        if (cycleGroupInfo != null) {
            this.setPartName("'" + ((CycleGroup)cycleGroupInfo.getFirst()).getName() + "' Breakup");
            this.m_currentNodes = new LinkedHashSet<GraphViewNode>(((GraphViewCycleGroupNode)cycleGroupInfo.getSecond()).getChildren(GraphViewNode.class));
            this.m_currentViolations.clear();
            this.m_currentViolations.addAll(GraphViewNode.getViolations(this.m_currentNodes));
            if (this.m_currentComputeInfo != null && this.m_currentComputeInfo.p() != cycleGroupInfo.getFirst()) {
                this.m_currentComputeInfo = null;
            }
            if (this.m_currentComputeInfo == null) {
                this.reset(true, true, true);
                this.m_currentComputeInfo = new d();
                this.m_currentComputeInfo.a((CycleGroup)cycleGroupInfo.getFirst());
            }
            this.m_dragAndDropAdapter.a((CycleView)connectedView);
            this.m_breakUpTextSearchHandler.c();
            this.m_keepTextSearchHandler.c();
            this.m_removeTextSearchHandler.c();
        } else {
            this.reset();
        }
        this.m_viewEnabled = true;
    }

    @Override
    protected void disconnect() {
        this.m_viewEnabled = false;
        this.reset();
        super.disconnect();
    }

    @Override
    public List<Element> getSelectedElements() {
        IStructuredSelection selection;
        switch (this.m_selectedComponent) {
            case BREAK_UP_VIEWER: {
                selection = this.m_breakUpViewer.o();
                break;
            }
            case KEEP_VIEWER: {
                selection = this.m_keepViewer.o();
                break;
            }
            case REMOVE_VIEWER: {
                selection = this.m_removeViewer.o();
                break;
            }
            default: {
                assert (false) : "Unhandled component: " + (Object)((Object)this.m_selectedComponent);
                selection = null;
            }
        }
        return x.a(selection);
    }

    private void createNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationState' must not be null";
        state.b(CycleBreakUpViewDependencies.BREAK_UP_DEPENDENCIES, GraphViewNode.GraphViewDependency.getDescriptors(this.m_breakUpViewer.p(), (IElementResolver)this.getElementResolver()));
        state.b(CycleBreakUpViewDependencies.KEEP_DEPENDENCIES, GraphViewNode.GraphViewDependency.getDescriptors(this.m_keepViewer.p(), (IElementResolver)this.getElementResolver()));
        state.b(CycleBreakUpViewDependencies.REMOVE_DEPENDENCIES, GraphViewNode.GraphViewDependency.getDescriptors(this.m_removeViewer.p(), (IElementResolver)this.getElementResolver()));
        switch (this.m_selectedComponent) {
            case BREAK_UP_VIEWER: {
                state.a((IStateData)CycleBreakUpViewViewerData.SELECTED_COMPONENT, CycleBreakUpViewComponent.BREAK_UP_VIEWER);
                break;
            }
            case KEEP_VIEWER: {
                state.a((IStateData)CycleBreakUpViewViewerData.SELECTED_COMPONENT, CycleBreakUpViewComponent.KEEP_VIEWER);
                break;
            }
            case REMOVE_VIEWER: {
                state.a((IStateData)CycleBreakUpViewViewerData.SELECTED_COMPONENT, CycleBreakUpViewComponent.REMOVE_VIEWER);
                break;
            }
            default: {
                assert (false) : "Unhandled component: " + (Object)((Object)this.m_selectedComponent);
                break;
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.initializeTextSearchData();
        NavigationState state = ViewNavigationManager.a().a(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.createNavigationState(state);
        ViewNavigationManager.a().b(state);
        this.getSelectionProviderAdapter().a(this.getSelectedElements());
    }

    @Override
    public void completeViewNavigationState(NavigationState state) {
        this.createNavigationState(state);
    }

    @Override
    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        if (control == this.m_breakUpViewer.n()) {
            this.m_breakUpViewer.m().setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_keepViewer.n()) {
            this.m_keepViewer.m().setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_removeViewer.n()) {
            this.m_keepViewer.m().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    @Override
    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'performRestoreNavigationState' must not be null";
        this.removeListeners();
        this.m_selectedComponent = (CycleBreakUpViewComponent)((Object)state.getConstant(CycleBreakUpViewViewerData.SELECTED_COMPONENT));
        assert (this.m_selectedComponent != null) : "'m_selectedComponent' of method 'restoreElementSelection' must not be null";
        switch (this.m_selectedComponent) {
            case KEEP_VIEWER: {
                this.m_keepViewer.n().setFocus();
                break;
            }
            case BREAK_UP_VIEWER: {
                this.m_breakUpViewer.n().setFocus();
                break;
            }
            case REMOVE_VIEWER: {
                this.m_removeViewer.n().setFocus();
                break;
            }
            default: {
                assert (false) : "Unhandled component: " + (Object)((Object)this.m_selectedComponent);
                break;
            }
        }
        Set<Pair<NamedElement, NamedElement>> endpoints = state.getDependenciesEndpoints(CycleBreakUpViewDependencies.BREAK_UP_DEPENDENCIES, this.getElementResolver());
        List<GraphViewNode.GraphViewDependency> edges = f.a(endpoints, this.m_currentComputeInfo);
        this.m_breakUpViewer.m().setSelection((ISelection)new StructuredSelection(edges));
        endpoints = state.getDependenciesEndpoints(CycleBreakUpViewDependencies.KEEP_DEPENDENCIES, this.getElementResolver());
        edges = f.a(endpoints, this.m_currentComputeInfo);
        this.m_keepViewer.m().setSelection((ISelection)new StructuredSelection(edges));
        endpoints = state.getDependenciesEndpoints(CycleBreakUpViewDependencies.REMOVE_DEPENDENCIES, this.getElementResolver());
        edges = f.a(endpoints, this.m_currentComputeInfo);
        this.m_removeViewer.m().setSelection((ISelection)new StructuredSelection(edges));
        this.addListeners();
    }

    @Override
    public boolean perform(GraphViewNode.GraphViewDependency targetEdge, DropLocation location, List<GraphViewNode.GraphViewDependency> droppedEdges, PropertyTableViewer<GraphViewNode.GraphViewDependency> sourceViewer, PropertyTableViewer<GraphViewNode.GraphViewDependency> targetViewer) {
        assert (targetViewer != null) : "Parameter 'targetViewer' of method 'perform' must not be null";
        assert (!droppedEdges.isEmpty()) : "no dropped egde";
        assert (this.m_currentComputeInfo != null) : "'m_currentComputeInformation' of method 'perform' must not be null";
        if (!this.m_viewEnabled) {
            return false;
        }
        if (sourceViewer == null && targetViewer != this.m_removeViewer && targetViewer != this.m_keepViewer) {
            return false;
        }
        if (sourceViewer == this.m_removeViewer && targetViewer == this.m_removeViewer) {
            return false;
        }
        boolean dropPerformed = false;
        this.m_breakUpViewer.n().setRedraw(false);
        this.m_keepViewer.n().setRedraw(false);
        this.m_removeViewer.n().setRedraw(false);
        if (targetViewer == this.m_keepViewer) {
            dropPerformed = f.a(location, this.m_currentComputeInfo.b(), droppedEdges, targetEdge);
            if (dropPerformed) {
                this.m_currentComputeInfo.a().removeAll(droppedEdges);
            }
        } else if (targetViewer == this.m_removeViewer) {
            dropPerformed = f.a(location, this.m_currentComputeInfo.a(), droppedEdges, targetEdge);
            if (dropPerformed) {
                this.m_currentComputeInfo.b().removeAll(droppedEdges);
            }
        } else {
            assert (targetViewer == this.m_breakUpViewer) : "Unexpected viewer";
            if (sourceViewer == this.m_removeViewer) {
                this.m_currentComputeInfo.a().removeAll(droppedEdges);
            } else {
                this.m_currentComputeInfo.b().removeAll(droppedEdges);
            }
            dropPerformed = true;
        }
        if (dropPerformed) {
            boolean enableCompute = false;
            if (sourceViewer == this.m_removeViewer || targetViewer == this.m_removeViewer) {
                this.m_currentComputeInfo.i().clear();
                this.m_currentComputeInfo.i().addAll(this.m_currentComputeInfo.a());
                this.m_currentComputeInfo.d().clear();
                this.m_currentComputeInfo.d().addAll(this.m_currentComputeInfo.a());
                boolean bl2 = enableCompute = !this.m_currentComputeInfo.c().equals(this.m_currentComputeInfo.d());
            }
            if (sourceViewer == this.m_keepViewer || targetViewer == this.m_keepViewer) {
                this.m_currentComputeInfo.h().clear();
                this.m_currentComputeInfo.h().addAll(this.m_currentComputeInfo.b());
                this.m_currentComputeInfo.f().clear();
                this.m_currentComputeInfo.f().addAll(this.m_currentComputeInfo.b());
                boolean bl3 = enableCompute = enableCompute || !this.m_currentComputeInfo.e().equals(this.m_currentComputeInfo.f());
            }
            if (!this.m_compute.isEnabled() && enableCompute) {
                this.m_compute.setEnabled(com.hello2morrow.sonargraph.core.command.common.e.b().a(SonargraphFeature.CYCLE_BREAK_UP));
                this.m_currentComputeInfo.a(true);
            }
            this.m_currentComputeInfo.b(!this.m_compute.isEnabled());
            this.m_breakUpViewer.c(this.m_currentComputeInfo.g());
            this.m_removeViewer.c(this.m_currentComputeInfo.a());
            this.m_keepViewer.c(this.m_currentComputeInfo.b());
            this.m_reset.setEnabled(!this.m_currentComputeInfo.g().isEmpty() || !this.m_currentComputeInfo.a().isEmpty() || !this.m_currentComputeInfo.b().isEmpty());
        }
        this.m_removeViolations.setEnabled(this.enableRemoveViolations());
        this.m_breakUpViewer.n().setRedraw(true);
        this.m_keepViewer.n().setRedraw(true);
        this.m_removeViewer.n().setRedraw(true);
        return dropPerformed;
    }

    @Override
    public Image getCellImage(PropertyTableViewer<GraphViewNode.GraphViewDependency> viewer, GraphViewNode.GraphViewDependency edge, String propertyName, Image columnImage) {
        assert (viewer != null) : "Parameter 'viewer' of method 'getCellImage' must not be null";
        assert (edge != null) : "Parameter 'edge' of method 'getCellImage' must not be null";
        assert (this.m_currentComputeInfo != null) : "'m_currentComputeInformation' of method 'getCellImage' must not be null";
        if (FROM_PROPERTY.equals(propertyName) || TO_PROPERTY.equals(propertyName)) {
            if ((viewer == this.m_keepViewer || viewer == this.m_breakUpViewer) && this.m_currentComputeInfo.s() && this.m_currentComputeInfo.u().contains(edge)) {
                return UiResourceManager.b().a(edge.getFrom().getImageResourceName(), CycleBreakUpView.createImageDecoratorInfo(edge, "ConflictBackground"));
            }
            if (viewer == this.m_removeViewer && this.m_currentComputeInfo.q() != null && this.m_currentComputeInfo.q().isEdgeOverDefined((INode.IEdge)edge)) {
                return UiResourceManager.b().a(edge.getFrom().getImageResourceName(), CycleBreakUpView.createImageDecoratorInfo(edge, "OverdefinedBackground"));
            }
        }
        return null;
    }

    private static ImageDecoratorInfo createImageDecoratorInfo(GraphViewNode.GraphViewDependency edge, String backgroundImage) {
        assert (edge != null) : "Parameter 'edge' of method 'createImageDecoratorInfo' must not be null";
        assert (backgroundImage != null && backgroundImage.length() > 0) : "Parameter 'backgroundImage' of method 'createImageDecoratorInfo' must not be empty";
        ImageDecoratorInfo decoratorInfo = edge.getImageResourceDecoratorInfo();
        ImageDecoratorInfo newDecoratorInfo = decoratorInfo != null ? new ImageDecoratorInfo(decoratorInfo.getOne(), decoratorInfo.getTwo(), decoratorInfo.getThree(), decoratorInfo.getFour(), "ConflictBackground") : new ImageDecoratorInfo(null, null, null, null, backgroundImage);
        return newDecoratorInfo;
    }

    @Override
    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    @Override
    protected ITextSearchHandler getTextSearchHandler() {
        switch (this.m_selectedComponent) {
            case BREAK_UP_VIEWER: {
                return this.m_breakUpTextSearchHandler;
            }
            case KEEP_VIEWER: {
                return this.m_keepTextSearchHandler;
            }
            case REMOVE_VIEWER: {
                return this.m_removeTextSearchHandler;
            }
        }
        assert (false) : "Unhandled component: " + (Object)((Object)this.m_selectedComponent);
        return null;
    }
}

