/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.common;

import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.e;
import com.hello2morrow.sonargraph.ui.swt.common.k;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ViewNavigationManager {
    private static final Logger b = LoggerFactory.getLogger(ViewNavigationManager.class);
    private static final Integer c = 100;
    private static ViewNavigationManager d = null;
    private final ArrayList<NavigationState> e = new ArrayList();
    private final Map<k, NavigationState> f = new THashMap();
    private final Map<k, NavigationState> g = new THashMap();
    private final e h;
    private int i = -1;
    private int j = 0;

    private ViewNavigationManager(e accesor) {
        assert (accesor != null) : "Parameter 'accesor' of method 'ViewNavigationManager' must not be null";
        this.h = accesor;
    }

    public static void a(e accesor) {
        assert (d == null) : "'s_instance' of method 'createInstance' must be null";
        d = new ViewNavigationManager(accesor);
    }

    public static ViewNavigationManager a() {
        assert (d != null) : "'s_instance' of method 'getInstance' must not be null";
        return d;
    }

    public void b() {
        assert (d != null) : "Instance not created";
        d = null;
    }

    public NavigationState a(IViewId viewId, String secondaryId, NavigationState.Type type) {
        assert (viewId != null) : "Parameter 'viewId' of method 'createNavigationState' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createNavigationState' must not be null";
        return new NavigationState(new k(viewId, secondaryId), type, this.j++);
    }

    private boolean a(k viewKey) {
        if (this.e.isEmpty()) {
            assert (this.i == -1) : "'m_currentIndex' must be '-1'" + (viewKey != null ? " [" + viewKey + "]" : "");
            return true;
        }
        assert (this.i >= 0 && this.i < this.e.size()) : "'m_currentIndex' out of range" + (viewKey != null ? " [" + viewKey + "]" : "");
        return false;
    }

    private void b(int startIndex) {
        assert (startIndex >= 0 && startIndex < this.e.size()) : "'startIndex' out of range";
        if (startIndex < this.e.size() - 1) {
            List<NavigationState> removed = this.e.subList(startIndex + 1, this.e.size());
            this.h.a(removed);
            removed.clear();
        }
    }

    public synchronized boolean a(int stateId) {
        return this.e.stream().anyMatch(navigationState -> navigationState.getId() == stateId);
    }

    public synchronized void a(IViewId viewId, String secondaryId, String newSecondaryId) {
        NavigationState currentState;
        assert (viewId != null) : "Parameter 'viewId' of method 'changeSecondaryId' must not be null";
        assert (secondaryId != null && secondaryId.length() > 0) : "Parameter 'secondaryId' of method 'changeSecondaryId' must not be empty";
        assert (newSecondaryId != null && newSecondaryId.length() > 0) : "Parameter 'newSecondaryId' of method 'changeSecondaryId' must not be empty";
        assert (!secondaryId.equals(newSecondaryId)) : "Secondary ids not different";
        k viewKey = new k(viewId, secondaryId);
        k newViewKey = new k(viewId, newSecondaryId);
        for (NavigationState nextState : this.e) {
            if (!nextState.a().equals(viewKey)) continue;
            nextState.a(newViewKey);
        }
        NavigationState initialState = this.f.remove(viewKey);
        if (initialState != null) {
            this.f.put(newViewKey, initialState);
        }
        if ((currentState = this.g.remove(viewKey)) != null) {
            this.g.put(newViewKey, currentState);
        }
    }

    private StateAction a(NavigationState first, NavigationState second) {
        k secondViewKey;
        assert (first != null) : "Parameter 'first' of method 'determineStateAction' must not be null";
        assert (second != null) : "Parameter 'second' of method 'determineStateAction' must not be null";
        assert (first != second) : "Same instances";
        k firstViewKey = first.a();
        if (firstViewKey.equals(secondViewKey = second.a())) {
            NavigationState.Type firstStateType = first.b();
            NavigationState.Type secondStateType = second.b();
            if (secondStateType == NavigationState.Type.VIEW_SELECTED) {
                b.debug("Discarded state '" + secondViewKey + "' [" + (Object)((Object)secondStateType) + "] - view already selected");
                return StateAction.DISCARD_SECOND;
            }
            if ((firstStateType == NavigationState.Type.VIEW_SELECTED || firstStateType == secondStateType) && first.b(second)) {
                b.debug("Discarded state '" + secondViewKey + "' [" + (Object)((Object)secondStateType) + "] - equal content");
                return StateAction.DISCARD_SECOND;
            }
            if (firstStateType == NavigationState.Type.VIEW_SELECTED && (secondStateType == NavigationState.Type.VIEW_SELECTED || secondStateType.isContentRelated()) && first.c() && second.a(first)) {
                b.debug("Replace state '" + firstViewKey + "' [" + (Object)((Object)firstStateType) + "] with more detailed state '" + secondViewKey + "' [" + (Object)((Object)secondStateType) + "]");
                return StateAction.REPLACE_FIRST;
            }
        }
        return StateAction.ADD_SECOND;
    }

    public static int a(List<NavigationState> states, NavigationState indexOf) {
        assert (states != null) : "Parameter 'states' of method 'getIndexOf' must not be null";
        assert (indexOf != null) : "Parameter 'indexOf' of method 'getIndexOf' must not be null";
        int i2 = 0;
        while (i2 < states.size()) {
            if (states.get(i2) == indexOf) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private int h(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'getIndexOf' must not be null";
        return ViewNavigationManager.a(this.e, state);
    }

    public synchronized void a(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'setCurrentNavigationState' must not be null";
        k viewKey = state.a();
        b.debug("Set current navigation state for state for '" + viewKey + "'");
        int indexOf = this.h(state);
        if (indexOf != -1) {
            if (this.i != indexOf) {
                this.i = indexOf;
            } else {
                b.debug("Ignored - is already the current navigation state.");
            }
        } else {
            b.warn("Navigation state not found in list.");
        }
        b.debug("Set current navigation state for state for '" + viewKey + "' - done");
    }

    public synchronized void b(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'addNavigationState' must not be null";
        k viewKey = state.a();
        b.debug("Add state for '" + viewKey + "'");
        if (this.h.b()) {
            b.warn("Discarded state during navigation state restore");
            return;
        }
        if (!this.e.isEmpty()) {
            NavigationState currentState = this.g();
            this.b(this.i);
            StateAction stateAction = this.a(currentState, state);
            switch (stateAction) {
                case DISCARD_SECOND: {
                    this.h.h();
                    b.debug("Add state for '" + viewKey + "' - done");
                    return;
                }
                case REPLACE_FIRST: {
                    NavigationState removed = this.e.remove(this.i);
                    assert (removed != null) : "'removed' of method 'addNavigationState' must not be null";
                    this.i = this.e.isEmpty() ? -1 : --this.i;
                    this.a(viewKey);
                    if (removed == this.f.get(viewKey)) {
                        this.f.remove(viewKey);
                    }
                    if (removed == this.g.get(viewKey)) {
                        this.g.remove(viewKey);
                    }
                    this.h.a(Collections.singletonList(removed));
                    break;
                }
                case ADD_SECOND: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled state action: " + (Object)((Object)stateAction);
                    break;
                }
            }
        }
        if (!this.f.containsKey(viewKey)) {
            this.f.put(viewKey, state);
        }
        this.g.put(viewKey, state);
        this.e.add(state);
        this.i = this.h(state);
        assert (this.i != -1) : "State not found";
        this.a(state.a());
        this.h.a(state);
        if (this.e.size() > c) {
            NavigationState removed = this.e.remove(0);
            --this.i;
            this.a(state.a());
            this.h.a(Collections.singletonList(removed));
        }
        this.h.h();
        b.debug("Add state for '" + viewKey + "' - done");
    }

    public synchronized boolean c() {
        return this.i > 0;
    }

    public synchronized boolean d() {
        return this.i < this.e.size() - 1;
    }

    public synchronized void e() {
        ++this.i;
        this.a((k)null);
        NavigationState state = this.e.get(this.i);
        assert (state != null) : "'state' of method 'restoreNextNavigationState' must not be null";
        this.h.b(state);
        this.g.put(state.a(), state);
        this.h.h();
    }

    public synchronized void f() {
        NavigationState currentState = this.g();
        assert (currentState != null) : "'currentState' of method 'restorePreviousNavigationState' must not be null";
        --this.i;
        this.a(currentState.a());
        NavigationState state = this.e.get(this.i);
        this.h.b(state);
        this.g.put(state.a(), state);
        this.h.h();
    }

    public synchronized void c(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'restoreNavigationState' must not be null";
        this.h.b(state);
    }

    public synchronized NavigationState a(IViewId viewId, String secondaryId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'getInitialViewNavigationState' must not be null";
        return this.f.get(new k(viewId, secondaryId));
    }

    public synchronized NavigationState b(IViewId viewId, String secondaryId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'getCurrentViewNavigationState' must not be null";
        return this.g.get(new k(viewId, secondaryId));
    }

    public synchronized void d(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'setCurrentViewNavigationState' must not be null";
        assert (this.f.containsKey(state.a())) : "Has no initial state: " + state.a();
        assert (this.h(state) != -1) : "State not found for '" + state.a() + "': " + state;
        this.g.put(state.a(), state);
    }

    public synchronized void e(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'removeNavigationState' must not be null";
        NavigationState currentState = this.g();
        assert (currentState != null) : "'currentState' of method 'removeNavigationState' must not be null";
        k viewKey = state.a();
        assert (this.f.get(viewKey) != state) : "The initial view state cannot be removed: " + viewKey;
        assert (this.g.get(viewKey) != state) : "The current view state cannot be removed: " + viewKey;
        assert (currentState != state) : "The current state cannot be removed";
        int nextIndexToRemove = this.h(state);
        assert (nextIndexToRemove != -1) : "No index of for state to remove: " + state;
        this.e.remove(nextIndexToRemove);
        this.i = this.h(currentState);
        assert (this.i != -1) : "No index of for: " + currentState;
        this.h.a(Collections.singletonList(state));
        this.h.h();
    }

    public synchronized NavigationState g() {
        return this.e.isEmpty() ? null : this.e.get(this.i);
    }

    public synchronized boolean h() {
        return this.e.isEmpty();
    }

    public synchronized List<NavigationState> c(IViewId viewId, String secondaryId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'getCurrentViewNavigationState' must not be null";
        k viewKey = new k(viewId, secondaryId);
        ArrayList<NavigationState> states = new ArrayList<NavigationState>();
        for (NavigationState nextState : this.e) {
            if (!nextState.a().equals(viewKey)) continue;
            states.add(nextState);
        }
        return states;
    }

    public synchronized List<NavigationState> i() {
        return Collections.unmodifiableList(this.e);
    }

    public synchronized List<NavigationState> j() {
        return new ArrayList<NavigationState>(this.f.values());
    }

    public synchronized List<NavigationState> k() {
        return new ArrayList<NavigationState>(this.g.values());
    }

    public synchronized boolean f(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'isInitialViewNavigationState' must not be null";
        return this.f.get(state.a()) == state;
    }

    public synchronized boolean g(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'isCurrentViewNavigationState' must not be null";
        return this.g.get(state.a()) == state;
    }

    public synchronized void l() {
        if (!(this.e.isEmpty() && this.g.isEmpty() && this.f.isEmpty())) {
            this.e.clear();
            this.f.clear();
            this.g.clear();
            this.i = -1;
            this.h.h();
        }
    }

    public synchronized NavigationState d(IViewId viewId, String secondaryId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'clear' must not be null";
        k viewKey = new k(viewId, secondaryId);
        b.debug("Clear navigation states of '" + viewKey + "'");
        NavigationState currentNavigationStateOfClearedView = this.g.remove(viewKey);
        this.f.remove(viewKey);
        if (!this.e.isEmpty()) {
            ArrayList<NavigationState> removedStates = new ArrayList<NavigationState>();
            ArrayList<NavigationState> statesToProcess = new ArrayList<NavigationState>(this.e);
            this.e.clear();
            NavigationState lastTransferredSate = null;
            block5: for (NavigationState nextStateToProcess : statesToProcess) {
                if (nextStateToProcess.a().equals(viewKey)) {
                    removedStates.add(nextStateToProcess);
                    continue;
                }
                if (lastTransferredSate == null) {
                    this.e.add(nextStateToProcess);
                    lastTransferredSate = nextStateToProcess;
                    continue;
                }
                StateAction nextStateAction = this.a(lastTransferredSate, nextStateToProcess);
                switch (nextStateAction) {
                    case DISCARD_SECOND: {
                        removedStates.add(nextStateToProcess);
                        break;
                    }
                    case REPLACE_FIRST: {
                        NavigationState replaced = this.e.set(this.e.size() - 1, nextStateToProcess);
                        lastTransferredSate = nextStateToProcess;
                        removedStates.add(replaced);
                        break;
                    }
                    case ADD_SECOND: {
                        this.e.add(nextStateToProcess);
                        lastTransferredSate = nextStateToProcess;
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled state action: " + (Object)((Object)nextStateAction);
                        continue block5;
                    }
                }
            }
            if (this.e.isEmpty()) {
                this.i = -1;
                this.a(viewKey);
            } else {
                this.i = this.e.size() - 1;
                this.a(viewKey);
            }
            if (!removedStates.isEmpty()) {
                this.h.a(removedStates);
            }
            this.h.h();
        }
        b.debug("Clear navigation states of '" + viewKey + "' - done");
        return currentNavigationStateOfClearedView;
    }

    static enum StateAction {
        REPLACE_FIRST,
        DISCARD_SECOND,
        ADD_SECOND;

    }
}

