/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.common;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.ui.swt.common.k;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NavigationState
implements INavigationState {
    private static final Logger b = LoggerFactory.getLogger(NavigationState.class);
    private static final a c = new a();
    private final int d;
    private Type e;
    private Map<IElementGroup, Collection<String>> f;
    private Map<IElementGroup, Collection<Pair<String, String>>> g;
    private Map<IStateData, Set<Pair<String, Class<? extends Enum<?>>>>> h;
    private Map<IStateData, Object> i;
    private b j;
    private k k;
    private boolean l;
    private boolean m;
    private boolean n = true;

    NavigationState(k viewKey, Type type, int id) {
        assert (viewKey != null) : "Parameter 'viewKey' of method 'NavigationState' must not be null";
        assert (type != null) : "Parameter 'type' of method 'NavigationState' must not be null";
        this.k = viewKey;
        this.e = type;
        this.d = id;
        this.j = c;
    }

    void a(k viewKey) {
        assert (viewKey != null) : "Parameter 'viewKey' of method 'setViewKey' must not be null";
        assert (!this.k.equals(viewKey)) : "View keys are equal";
        this.k = viewKey;
    }

    public k a() {
        return this.k;
    }

    public void a(Type type) {
        assert (type != null) : "Parameter 'type' of method 'setType' must not be null";
        this.e = type;
    }

    public Type b() {
        return this.e;
    }

    public int getId() {
        return this.d;
    }

    public void a(boolean replace) {
        this.n = replace;
    }

    public boolean c() {
        return this.n;
    }

    public void d() {
        this.l = true;
    }

    public boolean e() {
        return this.l;
    }

    public void a(b deadStateInfoProvider) {
        assert (deadStateInfoProvider != null) : "Parameter 'deadStateInfoProvider' of method 'setDeadStateInfoProvider' must not be null";
        this.j = deadStateInfoProvider;
    }

    public boolean a(IElementResolver resolver) {
        return this.j.a(this, resolver);
    }

    public boolean a(NavigationState other) {
        Collection<String> nextValues;
        assert (other != null) : "Parameter 'other' of method 'containsAllElementFrom' must not be null";
        if (this == other) {
            return true;
        }
        if (other.f != null) {
            for (Map.Entry<IElementGroup, Collection<String>> entry : other.f.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                if (this.f == null) {
                    return false;
                }
                nextValues = this.f.get(entry.getKey());
                if (nextValues == null) {
                    return false;
                }
                if (nextValues.equals(entry.getValue())) continue;
                return false;
            }
        }
        if (other.g != null) {
            for (Map.Entry<IElementGroup, Collection<String>> entry : other.g.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                if (this.g == null) {
                    return false;
                }
                nextValues = this.g.get(entry.getKey());
                if (nextValues == null) {
                    return false;
                }
                if (nextValues.equals(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public <T extends Enum<T>> void a(IStateData stateData, T constant) {
        assert (stateData != null) : "Parameter 'viewData' of method 'addConstant' must not be null";
        assert (constant != null) : "Parameter 'constant' of method 'addConstant' must not be null";
        this.a(stateData, Collections.singleton(constant));
    }

    public <T extends Enum<T>> void a(IStateData stateData, Collection<T> data) {
        assert (stateData != null) : "Parameter 'elementGroup' of method 'addGroupOfData' must not be null";
        assert (data != null) : "Parameter 'data' of method 'addGroupOfData' must not be null";
        if (this.h == null) {
            this.h = new THashMap();
        }
        Set<Pair<String, Class<T>>> descriptors = this.a(data);
        THashSet set = new THashSet(descriptors.size());
        for (Pair<String, Class<T>> pair : descriptors) {
            set.add(new Pair((Object)((String)pair.getFirst()), (Object)((Class)pair.getSecond())));
        }
        this.h.put(stateData, (Set<Pair<String, Class<Enum<?>>>>)set);
    }

    public <T extends Enum<T>> void a(Map<IStateData, Object> fullViewData) {
        assert (fullViewData != null) : "Parameter 'fullViewData' of method 'addFullViewData' must not be null";
        for (Map.Entry<IStateData, Object> entry : fullViewData.entrySet()) {
            IStateData data = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Integer) {
                this.a(data, (Integer)object);
                continue;
            }
            if (object instanceof Double) {
                this.a(data, (Double)object);
                continue;
            }
            if (object instanceof Boolean) {
                this.a(data, (Boolean)object);
                continue;
            }
            if (object instanceof String) {
                this.a(data, (String)object);
                continue;
            }
            if (object instanceof Enum && object instanceof IStandardEnumeration) {
                this.a(data, (Enum)object);
                continue;
            }
            assert (false) : "Unexpected class: " + object;
        }
    }

    public void a(IStateData data) {
        assert (data != null) : "Parameter 'data' of method 'removeViewData' must not be null";
        if (this.i != null) {
            this.i.remove(data);
        }
    }

    public void a(IStateData data, Object object) {
        assert (data != null) : "Parameter 'data' of method 'addBoolean' must not be null";
        assert (object != null) : "Parameter 'object' of method 'addBoolean' must not be null";
        if (this.i == null) {
            this.i = new THashMap();
        }
        this.i.put(data, object);
    }

    public void a(IStateData data, int object) {
        this.a(data, (Object)object);
    }

    public void a(IStateData data, boolean object) {
        this.a(data, (Object)object);
    }

    public void a(IStateData data, String object) {
        this.a(data, (Object)object);
    }

    public void a(IStateData data, double object) {
        this.a(data, (Object)object);
    }

    public void a(IElementGroup aspect, Set<String> descriptors) {
        assert (aspect != null) : "Parameter 'aspect' of method 'addInformationFromViewAspect' must not be null";
        assert (descriptors != null) : "Parameter 'descriptors' of method 'addInformationFromViewAspect' must not be null";
        assert (aspect.informationType() == IElementGroup.InformationType.SINGLE_ELEMENT) : "Unexpected information type: '" + aspect.informationType() + "'";
        if (this.f == null) {
            this.f = new THashMap();
        }
        this.f.put(aspect, descriptors);
    }

    public void b(IElementGroup aspect, Set<Pair<String, String>> descriptors) {
        assert (aspect != null) : "Parameter 'aspect' of method 'addDependenciesInformation' must not be null";
        assert (descriptors != null) : "Parameter 'descriptors' of method 'addDependenciesInformation' must not be null";
        assert (aspect.informationType() == IElementGroup.InformationType.ENDPOINTS) : "Unexpected information type: '" + aspect.informationType() + "'";
        if (this.g == null) {
            this.g = new THashMap();
        }
        this.g.put(aspect, descriptors);
    }

    public <T extends Element> List<T> getElements(IElementGroup aspect, Class<T> clazz, IElementResolver resolver) {
        Collection<String> descriptors;
        assert (aspect != null) : "Parameter 'aspect' of method 'getElements' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getElements' must not be null";
        if (this.f != null && (descriptors = this.f.get(aspect)) != null) {
            return Collections.unmodifiableList(this.a(descriptors, clazz, resolver));
        }
        return Collections.emptyList();
    }

    public Set<Pair<NamedElement, NamedElement>> getDependenciesEndpoints(IElementGroup aspect, IElementResolver resolver) {
        Collection<Pair<String, String>> descriptors;
        assert (aspect != null) : "Parameter 'option' of method 'getDependenciesEndpoints' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getDependenciesEndpoints' must not be null";
        if (this.g != null && (descriptors = this.g.get(aspect)) != null) {
            return this.b(descriptors, resolver);
        }
        return Collections.emptySet();
    }

    public boolean a(IElementGroup aspect) {
        Collection<Pair<String, String>> descriptors;
        assert (aspect != null) : "Parameter 'aspect' of method 'hasDependenciesEndpoints' must not be null";
        return this.g != null && (descriptors = this.g.get(aspect)) != null;
    }

    public <T extends IStandardEnumeration> Set<T> getConstants(IStateData stateData) {
        Set<Pair<String, Class<? extends Enum<?>>>> descriptors;
        assert (stateData != null) : "Parameter 'aspect' of method 'getStandardEnums' must not be null";
        if (this.h != null && (descriptors = this.h.get(stateData)) != null) {
            return Collections.unmodifiableSet(this.b(descriptors));
        }
        return Collections.emptySet();
    }

    public Object b(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getBoolean' must not be null";
        if (this.i != null) {
            return this.i.get(option);
        }
        return null;
    }

    public Integer c(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getViewData' must not be null";
        Object object = this.b(option);
        if (object != null) assert (object instanceof Integer) : "Unexpected class in method 'getViewData': " + object;
        return (Integer)object;
    }

    public Boolean d(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getViewData' must not be null";
        Object object = this.b(option);
        if (object != null) assert (object instanceof Boolean) : "Unexpected class in method 'getViewData': " + object;
        return (Boolean)object;
    }

    public Double getDouble(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getViewData' must not be null";
        Object object = this.b(option);
        if (object != null) assert (object instanceof Double) : "Unexpected class in method 'getViewData': " + object;
        return (Double)object;
    }

    public String e(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getViewData' must not be null";
        Object object = this.b(option);
        if (object != null) assert (object instanceof String) : "Unexpected class in method 'getViewData': " + object;
        return (String)object;
    }

    public <T extends Enum<T>> T getConstant(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getConstant' must not be null";
        Set<T> constants = this.getConstants(option);
        assert (constants.size() == 1) : "Only 1 constant expected for IStateData '" + option + "' but was: " + constants.size();
        return (T)((Enum)constants.iterator().next());
    }

    public boolean hasConstant(IStateData option) {
        assert (option != null) : "Parameter 'option' of method 'getConstant' must not be null";
        return !this.getConstants(option).isEmpty();
    }

    public static <T extends Element> Set<String> a(Collection<T> elementsToAdd, IElementResolver resolver) {
        assert (elementsToAdd != null) : "Parameter 'elementsToAdd' of method 'addDescriptors' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getDescriptors' must not be null";
        THashSet descriptors = new THashSet(elementsToAdd.size());
        for (Element next : elementsToAdd) {
            String descriptor = resolver.getDescriptor(next);
            if (descriptor != null) {
                descriptors.add(descriptor);
                continue;
            }
            b.warn("Null descriptor for element of class: '" + next.getClass() + "'.");
        }
        return descriptors;
    }

    private <T extends Enum<T>> Set<Pair<String, Class<T>>> a(Collection<T> elementsToAdd) {
        assert (elementsToAdd != null) : "Parameter 'elementsToAdd' of method 'getStandardNames' must not be null";
        THashSet standardNames = new THashSet(elementsToAdd.size());
        for (IStandardEnumeration element : elementsToAdd) {
            Enum enumConstant = (Enum)element;
            String constantName = enumConstant.name();
            if (constantName == null) continue;
            standardNames.add(new Pair((Object)constantName, element.getClass()));
        }
        return standardNames;
    }

    private <T> List<T> a(Collection<String> descriptors, Class<T> clazz, IElementResolver resolver) {
        assert (descriptors != null) : "Parameter 'descriptors' of method 'getNamedElements' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getElementsByClass' must not be null";
        LinkedHashSet<Element> namedElements = new LinkedHashSet<Element>();
        for (String descriptor : descriptors) {
            Element resolved = resolver.resolve(descriptor);
            if (resolved == null) continue;
            assert (clazz.isAssignableFrom(resolved.getClass())) : "Unexpected class: " + resolved.getClass().getName() + " in method " + "'getElementsByClass'";
            namedElements.add(resolved);
        }
        return new ArrayList(namedElements);
    }

    private Set<Pair<NamedElement, NamedElement>> b(Collection<Pair<String, String>> descriptors, IElementResolver resolver) {
        assert (descriptors != null) : "Parameter 'descriptors' of method 'getNamedElementsForEndPoints' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'getNamedElementsForEndPoints' must not be null";
        LinkedHashSet<Pair<NamedElement, NamedElement>> endPoints = new LinkedHashSet<Pair<NamedElement, NamedElement>>();
        for (Pair<String, String> fromTo : descriptors) {
            Element from = resolver.resolve((String)fromTo.getFirst());
            Element to = resolver.resolve((String)fromTo.getSecond());
            if (from == null || to == null) continue;
            assert (from instanceof NamedElement) : "Unexpected class: " + from.getClass().getName() + " in method " + "'getNamedElementsForEndPoints'";
            assert (to instanceof NamedElement) : "Unexpected class: " + to.getClass().getName() + " in method " + "'getNamedElementsForEndPoints'";
            endPoints.add((Pair<NamedElement, NamedElement>)new Pair((Object)((NamedElement)from), (Object)((NamedElement)to)));
        }
        return endPoints;
    }

    private <T extends Enum<T>> Set<IStandardEnumeration> b(Collection<Pair<String, Class<? extends Enum<?>>>> standardNames) {
        assert (standardNames != null) : "Parameter 'standardNames' of method 'getStandardEnums' must not be null";
        LinkedHashSet<IStandardEnumeration> enums = new LinkedHashSet<IStandardEnumeration>();
        for (Pair<String, Class<Enum<?>>> pair : standardNames) {
            String standardName = (String)pair.getFirst();
            Class clazz = (Class)pair.getSecond();
            Object enumConstant = Enum.valueOf(clazz, standardName);
            assert (enumConstant != null) : "'enumConstant' of method 'getConstantsFromStandardNames' must not be null";
            enums.add((IStandardEnumeration)enumConstant);
        }
        return enums;
    }

    public Map<IStateData, Object> f() {
        return this.i == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.i);
    }

    public boolean g() {
        return this.m;
    }

    public void b(boolean isInvolvedInUndoRedoOperation) {
        this.m = isInvolvedInUndoRedoOperation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 0;
        result = 31 * result + this.k.hashCode();
        result = 31 * result + this.e.hashCode();
        result = 31 * result + (this.g == null ? 0 : this.g.hashCode());
        result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
        result = 31 * result + (this.h == null ? 0 : this.h.hashCode());
        result = 31 * result + (this.i == null ? 0 : this.i.hashCode());
        return result;
    }

    public boolean b(NavigationState other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.g == null ? other.g != null : !this.g.equals(other.g)) {
            return false;
        }
        if (this.f == null ? other.f != null : !this.f.equals(other.f)) {
            return false;
        }
        if (this.h == null ? other.h != null : !this.h.equals(other.h)) {
            return false;
        }
        return !(this.i == null ? other.i != null : !this.i.equals(other.i));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NavigationState other = (NavigationState)obj;
        if (!this.k.equals(other.k)) {
            return false;
        }
        if (!this.e.equals((Object)other.e)) {
            return false;
        }
        return this.b(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.k).append(": ").append(this.e.name()).append(", ID: ").append(this.d).append(" [").append(Integer.toHexString(this.hashCode())).append("]").append(this.n ? " (may be replaced)" : " (may not be replaced)");
        builder.append("\n");
        builder.append("Dead state info provider: ");
        builder.append(this.j);
        builder.append("\n");
        if (this.i != null) {
            builder.append("View data: ");
            builder.append("\n");
            for (Map.Entry<Object, Object> entry : this.i.entrySet()) {
                builder.append(entry.getKey()).append(": ");
                Object nextValue = entry.getValue();
                builder.append(" [").append(nextValue.getClass().getSimpleName()).append("] ");
                if (nextValue instanceof Collection) {
                    builder.append(((Collection)nextValue).size());
                } else {
                    builder.append(nextValue);
                }
                builder.append("\n");
            }
        }
        if (this.f != null) {
            builder.append("Single element(s): ");
            for (Map.Entry<Object, Object> entry : this.f.entrySet()) {
                builder.append(entry.getKey());
                builder.append(" [" + ((Collection)entry.getValue()).size() + "]");
                builder.append(" ");
            }
            builder.append("\n");
        }
        if (this.g != null) {
            builder.append("End point(s): ");
            for (Map.Entry<Object, Object> entry : this.g.entrySet()) {
                builder.append(entry.getKey());
                builder.append(" [" + ((Collection)entry.getValue()).size() + "]");
                builder.append(" ");
            }
            builder.append("\n");
        }
        if (this.h != null) {
            builder.append("Standard enumerations(s): ");
            for (Map.Entry<Object, Object> entry : this.h.entrySet()) {
                builder.append(entry.getKey());
                builder.append(" [" + ((Set)entry.getValue()).size() + "]: ");
                for (Pair nextConstant : (Set)entry.getValue()) {
                    builder.append((String)nextConstant.getFirst()).append(" ");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    private static final class a
    implements b {
        private a() {
        }

        @Override
        public boolean a(NavigationState navigationState, IElementResolver resolver) {
            assert (navigationState != null) : "Parameter 'navigationState' of method 'meetsDeadStateCriteria' must not be null";
            assert (resolver != null) : "Parameter 'resolver' of method 'meetsDeadStateCriteria' must not be null";
            if (navigationState.f != null && !navigationState.f.isEmpty()) {
                for (IElementGroup elementGroup : navigationState.f.keySet()) {
                    if (!navigationState.f.get(elementGroup).isEmpty() && (navigationState.f.get(elementGroup).isEmpty() || navigationState.getElements(elementGroup, Element.class, resolver).isEmpty())) continue;
                    return false;
                }
            }
            if (navigationState.g != null && !navigationState.g.isEmpty()) {
                for (IElementGroup elementGroup : navigationState.g.keySet()) {
                    if (!navigationState.g.get(elementGroup).isEmpty() && (navigationState.g.get(elementGroup).isEmpty() || navigationState.getDependenciesEndpoints(elementGroup, resolver).isEmpty())) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "DEFAULT_DEAD_STATE_INFO_PROVIDER";
        }
    }

    public static interface b {
        public boolean a(NavigationState var1, IElementResolver var2);
    }

    public static enum Type {
        LINK(false),
        VIEW_SELECTED(false),
        VIEW_OPTIONS_CHANGED(false),
        CONTENT_SELECTED(true),
        CONTENT_COLLAPSED(true),
        CONTENT_EXPANDED(true),
        CONTENT_MODIFIED(true),
        CONTENT_VIEW_INSTANCE_REUSED(true),
        CONTENT_FOCUSED(true),
        CONTENT_EXTENDED_FOCUS_WITH_DEPENDENCIES(true),
        CONTENT_EXPANDED_DEPENDENCY_TO_COMPONENTS(true),
        CONTENT_FLATTENED(true),
        CONTENT_ZOOM_CHANGED(true),
        CONTENT_MARKED(true),
        CONTENT_UNMARKED(true),
        CONTENT_ALL_UNMARKED(true);

        private boolean m_contentRelated;

        private Type(boolean contentRelated) {
            this.m_contentRelated = contentRelated;
        }

        public boolean isContentRelated() {
            return this.m_contentRelated;
        }
    }
}

