/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.commandhandler;

import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.ui.swt.base.h;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public abstract class CommandHandler
implements h {
    protected CommandHandler() {
    }

    public static boolean performCheck(Check check, boolean allowCancel) {
        AnalyzerExecutionLevel analyzerExecutionLevel;
        SoftwareSystem softwareSystem;
        assert (check != null) : "Parameter 'check' of method 'performCheck' must not be null";
        String msg = null;
        if (Check.PARSER_MODEL_AND_LEVEL.equals((Object)check) && ((softwareSystem = WorkbenchRegistry.c().q()) == null || softwareSystem.getState() != SoftwareSystemState.MODEL_LOADED)) {
            msg = "Currently no parser model is available.";
        }
        if (msg == null && (analyzerExecutionLevel = WorkbenchRegistry.c().o().getAnalyzerExecutionLevel()) != AnalyzerExecutionLevel.FULL) {
            msg = "Currently the analyzer execution level is set to '" + analyzerExecutionLevel.getPresentationName() + "'." + "\nOnly on level '" + AnalyzerExecutionLevel.FULL.getPresentationName() + "' all possible metrics/issues are available.";
        }
        if (msg != null) {
            if (allowCancel) {
                if (UserInterfaceAdapter.b().a(String.valueOf(msg) + "\nDo you want to continue?", false) != UserInterfaceAdapter.Feedback.CONFIRMED) {
                    return false;
                }
            } else {
                UserInterfaceAdapter.b().a(msg, (String)null);
            }
        }
        return true;
    }

    public static void setVisibility(MMenuItem menuItem, boolean visible) {
        if (menuItem != null) {
            if (visible) {
                if (!menuItem.isVisible()) {
                    menuItem.setVisible(true);
                }
            } else if (menuItem.isVisible()) {
                menuItem.setVisible(false);
            }
        }
    }

    public static final <T> T getSingleSelection(Class<T> clazz, List<? extends Element> elements, boolean mustBePresent) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getSingleSelection' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'getSingleSelection' must not be null";
        assert (!mustBePresent || elements.size() == 1) : "Exactly one element expected";
        if (elements.size() == 1) {
            Element singleElement = elements.get(0);
            if (mustBePresent) {
                assert (clazz.isAssignableFrom(singleElement.getClass())) : "Unexpected element selected: " + singleElement;
                return (T)singleElement;
            }
            if (clazz.isAssignableFrom(singleElement.getClass())) {
                return (T)singleElement;
            }
        }
        return null;
    }

    public static final <T> List<T> getMultipleSelection(Class<T> clazz, List<? extends Element> elements) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getMultipleSelection' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getMultipleSelection' must not be empty";
        ArrayList<Element> selected = new ArrayList<Element>(elements.size());
        for (Element element : elements) {
            if (!clazz.isAssignableFrom(element.getClass())) continue;
            selected.add(element);
        }
        return selected;
    }

    public static final <T> List<T> getMultipleSelectionIfAllAreAssignable(Class<T> clazz, List<? extends Element> elements) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getMultipleSelectionIfAllAreAssignable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'getMultipleSelectionIfAllAreAssignable' must not be null";
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> selected = new ArrayList<Element>(elements.size());
        for (Element element : elements) {
            if (clazz.isAssignableFrom(element.getClass())) {
                selected.add(element);
                continue;
            }
            return Collections.emptyList();
        }
        return selected;
    }

    public IContextMenuContributor createContextMenuContributor() {
        return null;
    }

    public boolean isAvailable() {
        return true;
    }

    public static enum Check {
        LEVEL,
        PARSER_MODEL_AND_LEVEL;

    }
}

