/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.api.AnyFactory;
import com.hello2morrow.sonargraph.api.CallToResourceMatcher;
import com.hello2morrow.sonargraph.api.IAggregatedDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.IGenericProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.IMetaClass;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IProgrammingElementAccess;
import com.hello2morrow.sonargraph.api.WebMethodType;
import com.hello2morrow.sonargraph.api.WebProperty;
import com.hello2morrow.sonargraph.api.WebResource;
import com.hello2morrow.sonargraph.api.java.IAnnotationAccess;
import com.hello2morrow.sonargraph.api.java.IAnnotationValueAccess;
import com.hello2morrow.sonargraph.api.java.IJavaMethodAccess;
import com.hello2morrow.sonargraph.api.java.IJavaModuleAccess;
import com.hello2morrow.sonargraph.api.java.IJavaTypeAccess;
import com.hello2morrow.sonargraph.api.java.JavaDependencyKind;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import com.hello2morrow.sonargraph.plugin.spring.microservices.a;
import com.hello2morrow.sonargraph.plugin.spring.microservices.c;
import com.hello2morrow.sonargraph.plugin.spring.microservices.e;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SpringWebResourceDetector
extends e {
    private final c h;
    private final WebResource i;

    SpringWebResourceDetector(c contextPathProvider, WebResource webResourceMetaClass) {
        assert (contextPathProvider != null) : "Parameter 'contextPathProvider' of method 'SpringWebResourceDetector' must not be null";
        assert (webResourceMetaClass != null) : "Parameter 'webResourceMetaClass' of method 'SpringWebResourceDetector' must not be null";
        this.h = contextPathProvider;
        this.i = webResourceMetaClass;
    }

    public void a(IPluginContext context, IPluginJavaAccess javaAccess) {
        assert (context != null) : "Parameter 'context' of method 'detect' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'detect' must not be null";
        HashMap<IJavaTypeAccess, IAnnotationAccess> requestMappingAnnotatedTypes = new HashMap<IJavaTypeAccess, IAnnotationAccess>();
        Set<IJavaTypeAccess> excludedTypes = this.a(context, javaAccess, Arrays.asList("Workspace:External [Java]:[Unknown]:org:springframework:cloud:openfeign:FeignClient:FeignClient"));
        this.a(context, javaAccess, requestMappingAnnotatedTypes, excludedTypes);
        String[] stringArray = d;
        int n = d.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (context.hasBeenCanceled()) {
                return;
            }
            IJavaTypeAccess annotation = (IJavaTypeAccess)javaAccess.findElementByFqn(next);
            if (annotation != null) {
                this.a(context, javaAccess, requestMappingAnnotatedTypes, annotation, excludedTypes, EnumSet.of(AnnotationTarget.METHOD));
            }
            ++n2;
        }
    }

    private Set<IJavaTypeAccess> a(IPluginContext context, IPluginJavaAccess javaAccess, List<String> typeAnnotationsToExclude) {
        assert (context != null) : "Parameter 'context' of method 'collectExcludedTypes' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'collectExcludedTypes' must not be null";
        assert (typeAnnotationsToExclude != null && !typeAnnotationsToExclude.isEmpty()) : "Parameter 'typeAnnotationsToExclude' of method 'collectExcludedTypes' must not be empty";
        HashSet<IJavaTypeAccess> excludedTypes = new HashSet<IJavaTypeAccess>();
        for (String nextAnnotation : typeAnnotationsToExclude) {
            if (context.hasBeenCanceled()) {
                return excludedTypes;
            }
            IJavaTypeAccess annotation = (IJavaTypeAccess)javaAccess.findElementByFqn(nextAnnotation);
            if (annotation == null) continue;
            List annotatedElements = annotation.getIncomingDependencies(Aggregator.ELEMENT, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
            for (IAggregatedDependencyAccess nextAnnotatedElement : annotatedElements) {
                IJavaTypeAccess type;
                List typeAnnotations;
                IAnnotationAccess annotationToExclude;
                assert (nextAnnotatedElement.getNumberOfDependencies() == 1);
                IDependencyAccess dep = (IDependencyAccess)nextAnnotatedElement.getDependencies().get(0);
                IProgrammingElementAccess programmingElement = dep.getFrom();
                if (!(programmingElement instanceof IJavaTypeAccess) || (annotationToExclude = com.hello2morrow.sonargraph.plugin.spring.microservices.a.a((List<IAnnotationAccess>)(typeAnnotations = (type = (IJavaTypeAccess)programmingElement).getAnnotations()), nextAnnotation)) == null) continue;
                excludedTypes.add(type);
            }
        }
        return excludedTypes;
    }

    private void a(IPluginContext context, IPluginJavaAccess javaAccess, Map<IJavaTypeAccess, IAnnotationAccess> requestAnnotatedTypes, Set<IJavaTypeAccess> excludedTypes) {
        assert (context != null) : "Parameter 'context' of method 'identifyRequestMappingAnnotatedTypes' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'identifyRequestMappingAnnotatedTypes' must not be null";
        assert (requestAnnotatedTypes != null) : "Parameter 'requestAnnotatedTypes' of method 'identifyRequestMappingAnnotatedTypes' must not be null";
        assert (excludedTypes != null) : "Parameter 'excludedTypes' of method 'identifyRequestMappingAnnotatedTypes' must not be null";
        IJavaTypeAccess requestMappingAnnotation = (IJavaTypeAccess)javaAccess.findElementByFqn("Workspace:External [Java]:[Unknown]:org:springframework:web:bind:annotation:RequestMapping:RequestMapping");
        if (requestMappingAnnotation == null) {
            return;
        }
        List annotatedElements = requestMappingAnnotation.getIncomingDependencies(Aggregator.ELEMENT, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
        for (IAggregatedDependencyAccess nextAnnotatedElement : annotatedElements) {
            List typeAnnotations;
            IAnnotationAccess requestMapping;
            IJavaTypeAccess type;
            assert (nextAnnotatedElement.getNumberOfDependencies() == 1);
            if (context.hasBeenCanceled()) {
                return;
            }
            IDependencyAccess dep = (IDependencyAccess)nextAnnotatedElement.getDependencies().get(0);
            IProgrammingElementAccess programmingElement = dep.getFrom();
            if (!(programmingElement instanceof IJavaTypeAccess) || excludedTypes.contains(type = (IJavaTypeAccess)programmingElement) || (requestMapping = com.hello2morrow.sonargraph.plugin.spring.microservices.a.a((List<IAnnotationAccess>)(typeAnnotations = type.getAnnotations()), requestMappingAnnotation)) == null) continue;
            requestAnnotatedTypes.put(type, requestMapping);
        }
    }

    private void a(IPluginContext context, IPluginJavaAccess javaAccess, Map<IJavaTypeAccess, IAnnotationAccess> requestMappingAnnotatedTypes, IJavaTypeAccess mappingAnnotation, Set<IJavaTypeAccess> excludedTypes, EnumSet<AnnotationTarget> annotationTargets) {
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'handleSpringMappingAnnotation' must not be null";
        assert (requestMappingAnnotatedTypes != null) : "Parameter 'requestMappingAnnotatedTypes' of method 'handleSpringMappingAnnotation' must not be null";
        assert (mappingAnnotation != null) : "Parameter 'mappingAnnotation' of method 'handleSpringMappingAnnotation' must not be null";
        assert (annotationTargets != null && !annotationTargets.isEmpty()) : "Parameter 'annotationTargets' of method 'handleSpringMappingAnnotation' must not be empty";
        assert (excludedTypes != null) : "Parameter 'excludedTypes' of method 'identifySpringAnnotatedMethods' must not be null";
        HashMap<IJavaMethodAccess, IAnnotationAccess> methodAnnotations = new HashMap<IJavaMethodAccess, IAnnotationAccess>();
        List annotatedElements = mappingAnnotation.getIncomingDependencies(Aggregator.ELEMENT, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
        for (IAggregatedDependencyAccess iAggregatedDependencyAccess : annotatedElements) {
            IAnnotationAccess annotation;
            IJavaMethodAccess method;
            assert (iAggregatedDependencyAccess.getNumberOfDependencies() == 1);
            if (context.hasBeenCanceled()) {
                return;
            }
            IDependencyAccess dep = (IDependencyAccess)iAggregatedDependencyAccess.getDependencies().get(0);
            IProgrammingElementAccess programmingElement = dep.getFrom();
            if (!annotationTargets.contains((Object)AnnotationTarget.METHOD) || !(programmingElement instanceof IJavaMethodAccess) || excludedTypes.contains((method = (IJavaMethodAccess)programmingElement).getParent()) || (annotation = com.hello2morrow.sonargraph.plugin.spring.microservices.a.a((List<IAnnotationAccess>)method.getAnnotations(), mappingAnnotation)) == null) continue;
            methodAnnotations.put(method, annotation);
        }
        for (Map.Entry entry : methodAnnotations.entrySet()) {
            if (context.hasBeenCanceled()) {
                return;
            }
            IJavaMethodAccess method = (IJavaMethodAccess)entry.getKey();
            IAnnotationAccess annotation = (IAnnotationAccess)entry.getValue();
            IAnnotationAccess typeAnnotation = requestMappingAnnotatedTypes.get(method.getParent());
            List<String> paths = this.a(annotation, Arrays.asList("path", "value"));
            ArrayList<String> methods = new ArrayList<String>(this.a(annotation));
            List<String> roots = typeAnnotation != null ? this.a(typeAnnotation, Arrays.asList("path", "value")) : Arrays.asList("");
            for (String root : roots) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                for (String path : paths) {
                    if (context.hasBeenCanceled()) {
                        return;
                    }
                    IJavaModuleAccess module = (IJavaModuleAccess)method.getParent(IJavaModuleAccess.class);
                    assert (module != null) : "'module' of method '" + method + "' must not be null";
                    String contextPath = this.h.a(module);
                    String resultingPath = (String.valueOf(contextPath) + root + path).replaceAll("//", "/");
                    if (!resultingPath.startsWith("/")) {
                        resultingPath = "/" + resultingPath;
                    }
                    resultingPath = this.h.a(module, resultingPath);
                    IGenericProgrammingElementAccess webResource = javaAccess.createProgrammingElement((INamedElementAccess)method, (IMetaClass)this.i, resultingPath, annotation.getLineNumber());
                    webResource.setProperty(WebProperty.HTTP_METHOD.getStandardName(), AnyFactory.createFrom(methods));
                    webResource.setProperty(WebProperty.FRAMEWORK.getStandardName(), AnyFactory.createFrom((Object)"Spring.Web"));
                    webResource.setProperty(WebProperty.PATH_TO_MATCH.getStandardName(), AnyFactory.createFrom((Object)CallToResourceMatcher.removeVariablesFromPath((String)resultingPath)));
                }
            }
        }
    }

    @Override
    protected List<String> a(IAnnotationAccess annotation) {
        assert (annotation != null) : "Parameter 'annotation' of method 'extractMethodFromRequestMapping' must not be null";
        String annotationName = annotation.getAnnotationClass().getShortName();
        if (!annotationName.startsWith("Request")) {
            assert (annotationName.endsWith("Mapping")) : "Annotation '" + annotationName + "' does not end with '...Request'";
            String methodName = annotationName.substring(0, annotationName.length() - "Mapping".length()).toUpperCase();
            return Arrays.asList(methodName);
        }
        IAnnotationValueAccess method = annotation.getValue(WebProperty.HTTP_METHOD.getStandardName());
        if (method == null) {
            return Collections.emptyList();
        }
        String name = method.getEnumContantName();
        if (name != null) {
            return Arrays.asList(name);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (IAnnotationValueAccess val : method.getValueList()) {
            String enumName = val.getEnumContantName();
            if (enumName == null) continue;
            result.add(enumName);
        }
        if (result.isEmpty()) {
            result = new ArrayList(WebMethodType.asList());
            result.add("PATCH");
        }
        return result;
    }

    private static enum AnnotationTarget {
        TYPE,
        METHOD;

    }
}

