/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.pmd;

import com.hello2morrow.sonargraph.api.IDirectoryAccess;
import com.hello2morrow.sonargraph.api.IModuleAccess;
import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.ModelVisitor;
import com.hello2morrow.sonargraph.api.PluginIssueSeverity;
import com.hello2morrow.sonargraph.api.PluginIssueType;
import com.hello2morrow.sonargraph.api.ResultSet;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphBooleanPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphIntPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import com.hello2morrow.sonargraph.plugin.pmd.b;
import com.hello2morrow.sonargraph.plugin.pmd.c;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.renderers.Renderer;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class a
extends SonargraphPlugin
implements IPluginAnalyzerContributor {
    public static final String a = "com.hello2morrow.sonargraph.plugin.pmd";
    private static final Logger c = LoggerFactory.getLogger(a.class);
    private static final String d = "Java";
    private static final java.util.logging.Logger e = java.util.logging.Logger.getLogger("net.sourceforge.pmd");
    private final Map<Pair<RulePriority, PluginIssueSeverity>, IPluginIssueId> f = new HashMap<Pair<RulePriority, PluginIssueSeverity>, IPluginIssueId>();
    private final SonargraphBooleanPluginAttribute g = new SonargraphBooleanPluginAttribute("cache", "Cache", "Use internal cache", "Basic", true);
    private final SonargraphStringPluginAttribute h;
    private final SonargraphIntPluginAttribute i;
    private final SonargraphStringPluginAttribute j;
    private final SonargraphStringPluginAttribute k;
    private final SonargraphStringPluginAttribute l;
    private final SonargraphStringPluginAttribute m;
    private final SonargraphStringPluginAttribute n;
    private static volatile /* synthetic */ int[] o;

    public a() {
        this.addAttributeDefinition((SonargraphPluginAttribute)this.g);
        this.h = new SonargraphStringPluginAttribute("ruleSets", "Rule Sets", "Comma separated list of rule sets (if not specified an internal basic rule set is used)", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.h);
        this.i = new SonargraphIntPluginAttribute("minimumPriority", "Minimum Priority", "Set the minimum priority threshold when loading Rules from RuleSets", "violations", 5, Arrays.asList("LOW", "MEDIUM_LOW", "MEDIUM", "MEDIUM_HIGH", "HIGH"), Arrays.asList(5, 4, 3, 2, 1));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.i);
        this.j = new SonargraphStringPluginAttribute("high", "HIGH", "Mark violations with rule priority 'HIGH' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.j);
        this.k = new SonargraphStringPluginAttribute("mediumHigh", "MEDIUM_HIGH", "Mark violations with rule priority 'MEDIUM_HIGH' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.k);
        this.l = new SonargraphStringPluginAttribute("medium", "MEDIUM", "Mark violations with rule priority 'MEDIUM' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.l);
        this.m = new SonargraphStringPluginAttribute("mediumLow", "MEDIUM_LOW", "Mark violations with rule priority 'MEDIUM_LOW' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m);
        this.n = new SonargraphStringPluginAttribute("low", "LOW", "Mark violations with rule priority 'LOW' as ...", "violations", "error", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.n);
        c.debug("[" + this.getId() + "] Instantiated: " + this.getHexReference());
        SonargraphPluginManager.getInstance().addPlugin((SonargraphPlugin)this);
    }

    public String getId() {
        return a;
    }

    public String getVendor() {
        return "hello2morrow GmbH";
    }

    public String getVersion() {
        return "n/a";
    }

    public String getDescription() {
        return "Uses PMD to detect issues.";
    }

    public String getPresentationName() {
        return "Sonargraph PMD Plugin";
    }

    public IPluginAnalyzerContributor getAnalyzerContributor() {
        return this;
    }

    public Set<String> getSupportedLanguages() {
        return Collections.singleton(d);
    }

    public void initialize(ISonargraphPluginContributor contributor) {
        assert (contributor != null) : "Parameter 'contributor' of method 'initialize' must not be null";
        c.debug("[" + this.getId() + "] Initialize: " + this.getHexReference());
        RulePriority[] rulePriorityArray = RulePriority.values();
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority nextRulePriority = rulePriorityArray[n2];
            PluginIssueSeverity[] pluginIssueSeverityArray = PluginIssueSeverity.values();
            int n3 = pluginIssueSeverityArray.length;
            int n4 = 0;
            while (n4 < n3) {
                PluginIssueSeverity nextPluginIssueSeverity = pluginIssueSeverityArray[n4];
                String nextIssueId = "PMD_" + nextRulePriority.name() + "_" + nextPluginIssueSeverity.name();
                String nextIssueName = "PMD " + nextRulePriority.name();
                IPluginIssueId nextPluginIssueId = contributor.createIssueId(nextIssueId, nextIssueName, nextPluginIssueSeverity, PluginIssueType.ELEMENT);
                this.f.put((Pair<RulePriority, PluginIssueSeverity>)Pair.of((Object)nextRulePriority, (Object)nextPluginIssueSeverity), nextPluginIssueId);
                ++n4;
            }
            ++n2;
        }
        e.addHandler((Handler)new SLF4JBridgeHandler());
        e.setUseParentHandlers(false);
        e.setLevel(Level.FINEST);
        c.debug("[" + this.getId() + "] Initialize - done");
    }

    public void cleared(IPluginContext context) {
        c.debug("[" + this.getId() + "] Cleared");
    }

    private String a(IPluginJavaAccess javaAccess) {
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'getCacheLocation' must not be null";
        File hiddenDataDirectory = javaAccess.getHiddenDataDirectory(this.getId());
        if (hiddenDataDirectory == null) {
            c.error("[" + this.getId() + "] Couldn't get hidden directory for cache");
            return null;
        }
        File cache = new File(hiddenDataDirectory, "cache");
        if (this.g.getValue().booleanValue()) {
            return cache.getAbsolutePath();
        }
        if (!cache.delete()) {
            c.warn("[" + this.getId() + "] Couldn't delete cache '" + cache.getAbsolutePath());
        }
        return null;
    }

    private PluginIssueSeverity a(RulePriority priority) {
        assert (priority != null) : "Parameter 'priority' of method 'getSeverityFromPriority' must not be null";
        switch (com.hello2morrow.sonargraph.plugin.pmd.a.a()[priority.ordinal()]) {
            case 1: {
                return PluginIssueSeverity.valueOf((String)this.j.getValue().toUpperCase());
            }
            case 2: {
                return PluginIssueSeverity.valueOf((String)this.k.getValue().toUpperCase());
            }
            case 3: {
                return PluginIssueSeverity.valueOf((String)this.l.getValue().toUpperCase());
            }
            case 4: {
                return PluginIssueSeverity.valueOf((String)this.m.getValue().toUpperCase());
            }
        }
        return PluginIssueSeverity.valueOf((String)this.n.getValue().toUpperCase());
    }

    private Renderer a(IPluginContext context, ResultSet result, c sourceFileRegistry) {
        assert (context != null) : "Parameter 'context' of method 'createRenderer' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createRenderer' must not be null";
        assert (sourceFileRegistry != null) : "Parameter 'sourceFileRegistry' of method 'createRenderer' must not be null";
        HashMap<RulePriority, IPluginIssueId> issues = new HashMap<RulePriority, IPluginIssueId>();
        RulePriority[] rulePriorityArray = RulePriority.values();
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority priority = rulePriorityArray[n2];
            issues.put(priority, this.f.get(Pair.of((Object)priority, (Object)this.a(priority))));
            ++n2;
        }
        return new b(context, result, issues, sourceFileRegistry);
    }

    private List<String> a(IPluginContext context, IPluginJavaAccess javaAccess) {
        String[] splitted;
        assert (context != null) : "Parameter 'context' of method 'getRuleSets' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'getRuleSets' must not be null";
        String baseDirectory = javaAccess.getBaseDirectoryPath();
        c.info("[" + this.getId() + "] Base directory (parent directory of the  Sonargraph system directory): " + baseDirectory);
        String ruleSets = this.h.getValue();
        if (ruleSets != null && !ruleSets.isEmpty() && (splitted = ruleSets.split(",")) != null && splitted.length > 0) {
            TreeSet<String> sorted = new TreeSet<String>();
            String[] stringArray = splitted;
            int n = splitted.length;
            int n2 = 0;
            while (n2 < n) {
                block11: {
                    String next = stringArray[n2];
                    String nextTrimmed = next.trim();
                    if (!nextTrimmed.isEmpty()) {
                        if (nextTrimmed.startsWith("./") || nextTrimmed.startsWith("../")) {
                            try {
                                Path nextPath = Paths.get(baseDirectory, nextTrimmed);
                                File nextFile = nextPath.toFile();
                                if (nextFile.exists()) {
                                    if (nextFile.isFile()) {
                                        sorted.add(nextFile.getCanonicalPath());
                                        break block11;
                                    }
                                    throw new IllegalArgumentException("Rule set path '" + nextTrimmed + "' is not a file");
                                }
                                throw new IllegalArgumentException("Rule set path '" + nextTrimmed + "' does not exist");
                            }
                            catch (IOException | InvalidPathException ex) {
                                throw new IllegalArgumentException("Unable to load rule set from '" + nextTrimmed + "'", ex);
                            }
                        }
                        sorted.add(nextTrimmed);
                    }
                }
                ++n2;
            }
            if (!sorted.isEmpty()) {
                return new ArrayList<String>(sorted);
            }
        }
        return Collections.singletonList("/defaultRuleSet.xml");
    }

    public void analyze(IPluginContext context, ResultSet result) {
        assert (context != null) : "Parameter 'context' of method 'analyze' must not be null";
        assert (result != null) : "Parameter 'result' of method 'analyze' must not be null";
        c.info("[" + this.getId() + "] Analyze");
        long startTime = System.currentTimeMillis();
        IPluginJavaAccess javaAccess = (IPluginJavaAccess)context.getAccess(IPluginJavaAccess.class);
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'analyze' must not be null";
        c sourceFileRegistry = new c();
        javaAccess.visitParserModel((ModelVisitor)sourceFileRegistry);
        if (sourceFileRegistry.a()) {
            c.info("[" + this.getId() + "] No Java source files found. Nothing to analyze.");
            return;
        }
        PMDConfiguration configuration = new PMDConfiguration();
        List<String> ruleSets = this.a(context, javaAccess);
        for (String next : ruleSets) {
            c.info("[" + this.getId() + "] Using rule set: " + next);
        }
        ruleSets.forEach(rs -> configuration.addRuleSet(rs));
        configuration.setMinimumPriority(RulePriority.valueOf((int)this.i.getValue()));
        String cacheLocation = this.a(javaAccess);
        configuration.setAnalysisCacheLocation(cacheLocation);
        c.info("[" + this.getId() + "] " + (cacheLocation != null ? "Using cache location '" + cacheLocation + "'" : "Not using cache"));
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int numberThreads = Math.max(availableProcessors - 4, 1);
        c.info("[" + this.getId() + "] Using " + numberThreads + " threads (" + availableProcessors + " processors)");
        configuration.setThreads(numberThreads);
        assert (javaAccess != null) : "'javaAccess' of method 'analyze' must not be null";
        Throwable throwable = null;
        Object var13_15 = null;
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)configuration);){
            for (IModuleAccess module : javaAccess.getModules()) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                if (!d.equalsIgnoreCase(module.getLanguage())) continue;
                for (IDirectoryAccess sourceRootDirectory : module.getSourceRootDirectories()) {
                    if (context.hasBeenCanceled()) {
                        return;
                    }
                    String nextPath = sourceRootDirectory.getAbsolutePath();
                    try {
                        Path nextToAdd = Paths.get(nextPath, new String[0]);
                        File nextToAddAsFile = nextToAdd.toFile();
                        if (nextToAddAsFile.exists()) {
                            if (nextToAddAsFile.isDirectory()) {
                                c.debug("[" + this.getId() + "] Include plain root directory: {}", (Object)nextPath);
                                pmd.files().addDirectory(nextToAdd);
                                continue;
                            }
                            c.debug("[" + this.getId() + "] Include compressed root directory: {}", (Object)nextPath);
                            pmd.files().addZipFile(nextToAdd);
                            continue;
                        }
                        c.warn("[" + this.getId() + "] Ignoring non existing source root directory: {}", (Object)nextPath);
                    }
                    catch (Exception e) {
                        c.warn("[" + this.getId() + "] Unable to add source root directory: " + nextPath, (Throwable)e);
                    }
                }
            }
            pmd.addRenderer(this.a(context, result, sourceFileRegistry));
            int numberOfFiles = pmd.files().getCollectedFiles().size();
            context.beginBlockOfWork(numberOfFiles);
            pmd.performAnalysis();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - startTime;
        c.info("[" + this.getId() + "] Analyze - done [" + (context.hasBeenCanceled() ? "canceled" : "finished") + " after " + millis / 1000L + " seconds]");
    }

    static /* synthetic */ int[] a() {
        if (o != null) {
            return o;
        }
        int[] nArray = new int[RulePriority.values().length];
        try {
            nArray[RulePriority.HIGH.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RulePriority.LOW.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RulePriority.MEDIUM.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RulePriority.MEDIUM_HIGH.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RulePriority.MEDIUM_LOW.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        o = nArray;
        return nArray;
    }
}

