/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin;

import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SonargraphBooleanPluginAttribute
extends SonargraphPluginAttribute {
    private final Map<String, Object> m_optionLabelToValue = new LinkedHashMap<String, Object>(2);
    private final boolean m_defaultValue;

    public SonargraphBooleanPluginAttribute(String name, String presentationName, String description, String group, boolean defaultValue) {
        super(name, presentationName, description, group);
        this.m_defaultValue = defaultValue;
        this.m_optionLabelToValue.put(Boolean.TRUE.toString(), Boolean.TRUE);
        this.m_optionLabelToValue.put(Boolean.FALSE.toString(), Boolean.FALSE);
    }

    @Override
    public Boolean getDefaultValue() {
        return this.m_defaultValue;
    }

    @Override
    public Boolean getValue() {
        Object value = this.getConfiguration().getValue(this);
        assert (value != null && value instanceof Boolean) : "Unexpected class in method 'getValue': " + value;
        return (Boolean)value;
    }

    @Override
    public Map<String, Object> getOptionLabelToValue() {
        return Collections.unmodifiableMap(this.m_optionLabelToValue);
    }
}

