/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.system;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.AssignmentInfo;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.DetectedRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RootDirectoryPathsModification {
    private final SoftwareSystem m_softwareSystem;
    private final Map<AssignmentInfo<Workspace>, JavaModule> m_movedModules = new HashMap<AssignmentInfo<Workspace>, JavaModule>();
    private final List<RootDirectoryPath> m_unassignedRootDirectoryPaths = new ArrayList<RootDirectoryPath>();
    private final Map<AssignmentInfo<JavaModule>, RootDirectoryPath> m_assignmentChangedRootDirectoryPaths = new HashMap<AssignmentInfo<JavaModule>, RootDirectoryPath>();
    private final Map<AssignmentInfo<JavaModule>, DetectedRootDirectoryPath> m_assignedRootDirectoryPaths = new HashMap<AssignmentInfo<JavaModule>, DetectedRootDirectoryPath>();

    public RootDirectoryPathsModification(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'RootDirectoryPathsModification' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    public SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    public void unassigned(RootDirectoryPath extisting) {
        assert (extisting != null) : "Parameter 'extisting' of method 'unassigned' must not be null";
        assert (!this.m_unassignedRootDirectoryPaths.contains(extisting)) : "Parameter 'existing' of method 'unassigned' already added";
        this.m_unassignedRootDirectoryPaths.add(extisting);
    }

    public List<RootDirectoryPath> getUnassignedRootDirectoryPaths() {
        return Collections.unmodifiableList(this.m_unassignedRootDirectoryPaths);
    }

    public void assignmentChanged(RootDirectoryPath existing, JavaModule module, int pos) {
        assert (existing != null) : "Parameter 'existing' of method 'assignmentChanged' must not be null";
        RootDirectoryPath previous = this.m_assignmentChangedRootDirectoryPaths.put((AssignmentInfo<JavaModule>)new AssignmentInfo((NamedElement)module, pos), existing);
        assert (previous == null) : "Parameter 'previous' of method 'assignmentChanged' must be null";
    }

    public Map<AssignmentInfo<JavaModule>, RootDirectoryPath> getAssignmentChangedRootDirectoryPaths() {
        return Collections.unmodifiableMap(this.m_assignmentChangedRootDirectoryPaths);
    }

    public void moved(JavaModule module, int pos) {
        assert (module != null) : "Parameter 'module' of method 'moved' must not be null";
        JavaModule previous = this.m_movedModules.put((AssignmentInfo<Workspace>)new AssignmentInfo((NamedElement)((Workspace)module.getParent(Workspace.class, new Class[0])), pos), module);
        assert (previous == null) : "Parameter 'previous' of method 'moved' must be null";
    }

    public Map<AssignmentInfo<Workspace>, JavaModule> getMovedModules() {
        return Collections.unmodifiableMap(this.m_movedModules);
    }

    public void assigned(DetectedRootDirectoryPath detected, JavaModule module, int pos) {
        assert (detected != null) : "Parameter 'detected' of method 'assigned' must not be null";
        DetectedRootDirectoryPath previous = this.m_assignedRootDirectoryPaths.put((AssignmentInfo<JavaModule>)new AssignmentInfo((NamedElement)module, pos), detected);
        assert (previous == null) : "Parameter 'previous' of method 'assigned' must be null";
    }

    public Map<AssignmentInfo<JavaModule>, DetectedRootDirectoryPath> getAssignedRootDirectoryPaths() {
        return Collections.unmodifiableMap(this.m_assignedRootDirectoryPaths);
    }

    public boolean isEmpty() {
        return this.m_movedModules.isEmpty() && this.m_assignedRootDirectoryPaths.isEmpty() && this.m_assignmentChangedRootDirectoryPaths.isEmpty() && this.m_unassignedRootDirectoryPaths.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Modification: ");
        if (this.isEmpty()) {
            builder.append("Empty");
        } else {
            if (!this.m_assignedRootDirectoryPaths.isEmpty()) {
                for (Map.Entry<AssignmentInfo<JavaModule>, DetectedRootDirectoryPath> entry : this.m_assignedRootDirectoryPaths.entrySet()) {
                    builder.append(StringUtility.LINE_SEPARATOR);
                    builder.append("Assigned: ");
                    builder.append(entry.getValue().getDirectory());
                    builder.append(" to ");
                    builder.append(((JavaModule)entry.getKey().getNamedElement()).getName());
                    builder.append(" (");
                    builder.append(entry.getKey().getPos());
                    builder.append(")");
                }
            }
            if (!this.m_assignmentChangedRootDirectoryPaths.isEmpty()) {
                for (Map.Entry<AssignmentInfo<JavaModule>, DetectedRootDirectoryPath> entry : this.m_assignmentChangedRootDirectoryPaths.entrySet()) {
                    builder.append(StringUtility.LINE_SEPARATOR);
                    builder.append("Assignment changed: ");
                    builder.append(((RootDirectoryPath)entry.getValue()).getName());
                    builder.append(" to ");
                    builder.append(((JavaModule)entry.getKey().getNamedElement()).getName());
                    builder.append(" (");
                    builder.append(entry.getKey().getPos());
                    builder.append(")");
                }
            }
            if (!this.m_unassignedRootDirectoryPaths.isEmpty()) {
                for (RootDirectoryPath rootDirectoryPath : this.m_unassignedRootDirectoryPaths) {
                    builder.append(StringUtility.LINE_SEPARATOR);
                    builder.append("Unassigned: ");
                    builder.append(rootDirectoryPath.getName());
                }
            }
        }
        return builder.toString();
    }
}

