/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming;

import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.b;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaSignatureWriter;
import org.objectweb.asm.signature.SignatureVisitor;

final class JavaTypeSignatureWriter
extends JavaSignatureWriter {
    private static final String SEPARATOR = ", ";
    private final StringBuilder m_declaration;
    private final boolean m_mainTypeOnly;
    private boolean m_isInterface;
    private boolean m_seenFormalParameter;
    private boolean m_seenInterfaceBound;
    private boolean m_seenParameter;
    private boolean m_seenInterface;
    private StringBuilder m_returnType;
    private StringBuilder m_exceptions;
    private int m_argumentStack;
    private int m_arrayStack;
    private String m_separator = "";

    public JavaTypeSignatureWriter(boolean isInterface) {
        this.m_mainTypeOnly = true;
        this.m_isInterface = isInterface;
        this.m_declaration = new StringBuilder();
    }

    private JavaTypeSignatureWriter(StringBuilder buffer) {
        assert (buffer != null) : "Parameter 'buffer' of method 'JavaTypeSignatureWriter' must not be null";
        this.m_declaration = buffer;
        this.m_mainTypeOnly = false;
    }

    public void visitFormalTypeParameter(String name) {
        this.m_declaration.append(this.m_seenFormalParameter ? SEPARATOR : "<").append(name);
        this.m_seenFormalParameter = true;
        this.m_seenInterfaceBound = false;
    }

    public SignatureVisitor visitClassBound() {
        this.m_separator = " extends ";
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.m_separator = this.m_seenInterfaceBound ? SEPARATOR : " extends ";
        this.m_seenInterfaceBound = true;
        this.startType();
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        if (this.m_mainTypeOnly) {
            return this.getDoNothingSignatureVisitor();
        }
        this.m_separator = " extends ";
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        if (this.m_mainTypeOnly) {
            return this.getDoNothingSignatureVisitor();
        }
        this.m_separator = this.m_seenInterface ? SEPARATOR : (this.m_isInterface ? " extends " : " implements ");
        this.m_seenInterface = true;
        this.startType();
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (this.m_seenParameter) {
            this.m_declaration.append(SEPARATOR);
        } else {
            this.m_seenParameter = true;
            this.m_declaration.append('(');
        }
        this.startType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (this.m_seenParameter) {
            this.m_seenParameter = false;
        } else {
            this.m_declaration.append('(');
        }
        this.m_declaration.append(')');
        this.m_returnType = new StringBuilder();
        return new JavaTypeSignatureWriter(this.m_returnType);
    }

    public SignatureVisitor visitExceptionType() {
        if (this.m_exceptions == null) {
            this.m_exceptions = new StringBuilder();
        } else {
            this.m_exceptions.append(SEPARATOR);
        }
        return new JavaTypeSignatureWriter(this.m_exceptions);
    }

    public void visitBaseType(char descriptor) {
        super.handleBaseType(descriptor, this.m_declaration);
        this.endType();
    }

    public void visitTypeVariable(String name) {
        this.m_declaration.append(name);
        this.endType();
    }

    public SignatureVisitor visitArrayType() {
        this.startType();
        this.m_arrayStack |= 1;
        return this;
    }

    public void visitClassType(String name) {
        if ("java/lang/Object".equals(name)) {
            boolean needObjectClass;
            boolean bl2 = needObjectClass = this.m_argumentStack % 2 != 0 || this.m_seenParameter;
            if (needObjectClass) {
                this.m_declaration.append(this.m_separator).append(b.d(name.replace('/', '.')));
            }
        } else {
            this.m_declaration.append(this.m_separator).append(b.d(name.replace('/', '.')));
        }
        this.m_separator = "";
        this.m_argumentStack *= 2;
    }

    public void visitInnerClassType(String name) {
        if (this.m_argumentStack % 2 != 0) {
            this.m_declaration.append('>');
        }
        this.m_argumentStack /= 2;
        this.m_declaration.append(".");
        this.m_declaration.append(this.m_separator).append(b.d(name.replace('/', '.')));
        this.m_separator = "";
        this.m_argumentStack *= 2;
    }

    public void visitTypeArgument() {
        if (this.m_argumentStack % 2 == 0) {
            ++this.m_argumentStack;
            this.m_declaration.append('<');
        } else {
            this.m_declaration.append(SEPARATOR);
        }
        this.m_declaration.append('?');
    }

    public SignatureVisitor visitTypeArgument(char tag) {
        if (this.m_argumentStack % 2 == 0) {
            ++this.m_argumentStack;
            this.m_declaration.append('<');
        } else {
            this.m_declaration.append(SEPARATOR);
        }
        if (tag == '+') {
            this.m_declaration.append("? extends ");
        } else if (tag == '-') {
            this.m_declaration.append("? super ");
        }
        this.startType();
        return this;
    }

    public void visitEnd() {
        if (this.m_argumentStack % 2 != 0) {
            this.m_declaration.append('>');
        }
        this.m_argumentStack /= 2;
        this.endType();
    }

    public String getDeclaration() {
        return this.m_declaration.toString();
    }

    public String getReturnType() {
        return this.m_returnType == null ? null : this.m_returnType.toString();
    }

    public String getExceptions() {
        return this.m_exceptions == null ? null : this.m_exceptions.toString();
    }

    private void endFormals() {
        if (this.m_seenFormalParameter) {
            this.m_declaration.append('>');
            this.m_seenFormalParameter = false;
        }
    }

    private void startType() {
        this.m_arrayStack *= 2;
    }

    /*
     * Unable to fully structure code
     */
    private void endType() {
        block1: {
            if (this.m_arrayStack % 2 != 0) ** GOTO lbl7
            this.m_arrayStack /= 2;
            break block1;
lbl-1000:
            // 1 sources

            {
                this.m_arrayStack /= 2;
                this.m_declaration.append("[]");
lbl7:
                // 2 sources

                ** while (this.m_arrayStack % 2 != 0)
            }
        }
    }
}

