/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import java.io.IOException;

public final class JavaNonInitializer
extends JavaMethod {
    private int m_endLineNumber = -1;

    public JavaNonInitializer(IModelServiceProvider msp, NamedElement parent, String name, String descriptor) {
        super(msp, parent, name, descriptor);
    }

    public JavaNonInitializer(NamedElement parent) {
        super(parent);
    }

    @Override
    protected boolean mightHaveParameters() {
        return true;
    }

    public String getPresentationKind() {
        return "Java Method";
    }

    @Override
    public boolean isInitializer() {
        return false;
    }

    @Property
    public boolean isMethodDefinedInSuperType() {
        return !this.isDefinedInEnclosingElement();
    }

    public void setEndLineNumber(int endLine) {
        assert (this.m_endLineNumber == -1) : "End line number must only be set once!";
        this.m_endLineNumber = endLine;
    }

    @Override
    public int getEndLineNumber() {
        return this.m_endLineNumber;
    }

    @Override
    public void aboutToReparse() {
        this.m_endLineNumber = -1;
        super.aboutToReparse();
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_endLineNumber = reader.getVersion() >= 16 ? reader.readInt() : -1;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_endLineNumber);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitJavaNonInitializer(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitJavaNonInitializer(JavaNonInitializer var1);
    }
}

