/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming;

import com.hello2morrow.sonargraph.core.model.programming.CoreKeywords;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class JavaKeywords {
    private static final Set<String> SCALA_KEYWORDS = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield")));
    private static final Set<String> ADDITIONAL_ASPECTJ_KEYWORDS = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("aspect", "pointcut", "privileged", "call", "execution", "initialization", "preinitialization", "handler", "get", "set", "staticinitialization", "target", "args", "within", "withincode", "cflow", "cflowbelow", "annotation", "before", "after", "around", "proceed", "throwing", "returning", "adviceexecution", "declare", "parents", "warning", "error", "soft", "precedence", "thisJoinPoint", "thisJoinPointStaticPart", "thisEnclosingJoinPointStaticPart", "issingleton", "perthis", "pertarget", "percflow", "percflowbelow", "pertypewithin", "lock", "unlock", "thisAspectInstance")));
    private static final Set<String> ADDITIONAL_KOTLIN_KEYWORDS = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("as", "as?", "fun", "in", "!in", "is", "!is", "object", "typealias", "typeof", "val", "var", "by", "constructor", "delegate", "dynamic", "field", "file", "get", "init", "param", "property", "receiver", "set", "setparam", "where", "actual", "annotation", "companion", "const", "crossinline", "data", "enum", "expect", "external", "infix", "inline", "inner", "internal", "lateinit", "noline", "open", "operator", "out", "reified", "seal", "susopend", "tailrec", "vararg", "field", "it")));
    private static final Set<String> ASPECTJ_KEYWORDS = new TreeSet<String>(CoreKeywords.getJavaKeywords());
    private static final Set<String> KOTLIN_KEYWORDS;

    static {
        ASPECTJ_KEYWORDS.addAll(ADDITIONAL_ASPECTJ_KEYWORDS);
        KOTLIN_KEYWORDS = new TreeSet<String>(CoreKeywords.getJavaKeywords());
        KOTLIN_KEYWORDS.addAll(ADDITIONAL_KOTLIN_KEYWORDS);
    }

    private JavaKeywords() {
    }

    public static Set<String> getJavaKeywords() {
        return CoreKeywords.getJavaKeywords();
    }

    public static Set<String> getGroovyKeywords() {
        return CoreKeywords.getGroovyKeywords();
    }

    public static Set<String> getKotlinKeywords() {
        return KOTLIN_KEYWORDS;
    }

    public static Set<String> getAspectJKeywords() {
        return ASPECTJ_KEYWORDS;
    }

    public static Set<String> getScalaKeywords() {
        return SCALA_KEYWORDS;
    }
}

