/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.DirectoryScanner;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.foundation.common.graph.AdjacencyGraph;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportRootDirectoryPathCandidate;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.EclipseImportMessageCause;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.n;
import com.hello2morrow.sonargraph.languageprovider.java.model.externalimport.eclipse.IEclipseImportProvider;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class g
extends Extension
implements IEclipseImportProvider {
    private static final Logger b = LoggerFactory.getLogger(g.class);
    private static final byte[] c;
    private static final int d;
    private static final String e = ".metadata";
    private static final String f = ".metadata/.plugins/org.eclipse.core.resources/.projects";
    private static final String g = ".location";
    private static final String h = "classpathentry";
    private static final String i = "kind";
    private static final String j = "output";
    private static final String k = ".classpath";
    private static final String l = "combineaccessrules";
    private static final String m = "exported";
    private static final String n = "path";
    private static final String o = "src";
    private static final String p = "output";
    private static final String q = "URI//file:";
    private static final String r = "URI//sourcecontrol:";
    private static final String s = "//jazz/default/";

    static {
        byte[] byArray = new byte[16];
        byArray[0] = 64;
        byArray[1] = -79;
        byArray[2] = -117;
        byArray[3] = -127;
        byArray[4] = 35;
        byArray[5] = -68;
        byArray[7] = 20;
        byArray[8] = 26;
        byArray[9] = 37;
        byArray[10] = -106;
        byArray[11] = -25;
        byArray[12] = -93;
        byArray[13] = -109;
        byArray[14] = -66;
        byArray[15] = 30;
        c = byArray;
        d = c.length;
    }

    @Override
    public IPathValidator getWorkspaceValidator() {
        return new IPathValidator(){

            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput != null && newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (newInput == null || !newInput.exists()) {
                    result.addError("Invalid path");
                } else if (!new TFile((File)newInput, com.hello2morrow.sonargraph.languageprovider.java.controller.system.g.e).exists()) {
                    result.addError("Not an Eclipse Workspace directory");
                }
                return result;
            }

            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }
        };
    }

    @Override
    public OperationResultWithOutcome<Set<ImportModuleCandidate>> getEclipseImportCandidates(IWorkerContext workerContext, TFile eclipseWorkspace) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getEclipseImportCandidates' must not be null";
        assert (this.getWorkspaceValidator().isValid(null, eclipseWorkspace).isSuccess()) : "Not valid: " + eclipseWorkspace;
        OperationResultWithOutcome result = new OperationResultWithOutcome("Detect Eclipse import candidates");
        LinkedHashSet<ImportModuleCandidate> moduleCandidates = new LinkedHashSet<ImportModuleCandidate>();
        THashMap exportedMap = new THashMap();
        THashMap trimmedNameToCandidate = new THashMap();
        TFile workspaceMetadataProjectsDir = new TFile((File)eclipseWorkspace, f);
        TFile[] workspaceMetadataProjects = workspaceMetadataProjectsDir.listFiles();
        String absoluteRootPath = eclipseWorkspace.getAbsolutePath();
        int absoluteRootPathLength = absoluteRootPath.length();
        if (workspaceMetadataProjects != null && workspaceMetadataProjects.length > 0) {
            THashSet allRootPaths = new THashSet();
            TFile[] tFileArray = workspaceMetadataProjects;
            int n2 = workspaceMetadataProjects.length;
            int n3 = 0;
            while (n3 < n2) {
                TFile metadataProjectDir = tFileArray[n3];
                if (workerContext.hasBeenCanceled()) {
                    return result;
                }
                TFile projectDir = this.a(eclipseWorkspace, metadataProjectDir);
                if (projectDir == null) {
                    b.error("Could not read project directory from the metadata directory: '{}'", (Object)metadataProjectDir);
                } else {
                    String nextAbsolutePath = projectDir.getAbsolutePath();
                    String nextWorkingMessage = nextAbsolutePath.startsWith(absoluteRootPath) ? "./" + nextAbsolutePath.substring(absoluteRootPathLength + 1) : nextAbsolutePath;
                    workerContext.working("Analyzing '" + nextWorkingMessage + "'", true);
                    LinkedHashSet<String> exportedAccu = new LinkedHashSet<String>();
                    ImportModuleCandidate nextCandidate = new ImportModuleCandidate(projectDir, metadataProjectDir.getName());
                    if (this.a(workerContext, (OperationResultWithOutcome<Set<ImportModuleCandidate>>)result, nextCandidate, exportedAccu, workspaceMetadataProjects, (Set<ImportRootDirectoryPathCandidate>)allRootPaths)) {
                        moduleCandidates.add(nextCandidate);
                    }
                    exportedMap.put(projectDir.getName(), exportedAccu);
                    ImportModuleCandidate previous = (ImportModuleCandidate)trimmedNameToCandidate.get(nextCandidate.getName());
                    trimmedNameToCandidate.put(nextCandidate.getName(), nextCandidate);
                    if (previous != null) {
                        String error = "Module name is duplicated";
                        nextCandidate.addError("Module name is duplicated");
                        previous.addError("Module name is duplicated");
                        result.addError((OperationResult.IMessageCause)EclipseImportMessageCause.DUPLICATE_MODULE_FOUND, " '" + nextCandidate.getName() + "' is duplicated. ", new Object[0]);
                    }
                }
                ++n3;
            }
        }
        if (!moduleCandidates.isEmpty()) {
            Map transitiveHullOfExported = new AdjacencyGraph((Map)exportedMap).getTransitiveHull();
            THashMap possibleIndirectEfferencesMap = new THashMap();
            List<String> candidatesNames = this.a(workerContext, moduleCandidates);
            for (ImportModuleCandidate nextCandidate : moduleCandidates) {
                if (workerContext.hasBeenCanceled()) {
                    return result;
                }
                LinkedHashSet<String> possibleIndirectEfferences = new LinkedHashSet<String>();
                possibleIndirectEfferencesMap.put(nextCandidate, possibleIndirectEfferences);
                for (String efferent : nextCandidate.getDependencies()) {
                    if (workerContext.hasBeenCanceled()) {
                        return result;
                    }
                    Set transitivelyExported = (Set)transitiveHullOfExported.get(efferent);
                    if (transitivelyExported == null) continue;
                    for (String exported : transitivelyExported) {
                        if (workerContext.hasBeenCanceled()) {
                            return result;
                        }
                        if (!candidatesNames.contains(exported)) continue;
                        possibleIndirectEfferences.add(exported);
                    }
                }
            }
            for (ImportModuleCandidate nextModuleCandidate : moduleCandidates) {
                if (workerContext.hasBeenCanceled()) {
                    return result;
                }
                for (String indirectEfferent : (Set)possibleIndirectEfferencesMap.get(nextModuleCandidate)) {
                    if (workerContext.hasBeenCanceled()) {
                        return result;
                    }
                    if (nextModuleCandidate.getDependencies().contains(indirectEfferent)) continue;
                    nextModuleCandidate.addDependency(indirectEfferent);
                }
            }
            result.setOutcome(moduleCandidates);
        } else {
            result.addError((OperationResult.IMessageCause)EclipseImportMessageCause.NO_MODULES_FOUND);
        }
        return result;
    }

    protected TFile a(TFile eclipseWorkspace, TFile projectMetadataDir) {
        assert (projectMetadataDir != null) : "Parameter 'projectMetadataDir' of method 'getProjectDirectoyFromWorkspaceDirectory' must not be null";
        if (com.hello2morrow.sonargraph.languageprovider.java.controller.system.g.b(projectMetadataDir)) {
            String projectName = projectMetadataDir.getName();
            TFile projectLocation = new TFile((File)eclipseWorkspace, projectName);
            TFile locationFile = new TFile((File)projectMetadataDir, g);
            return this.a(eclipseWorkspace, locationFile, projectName, projectLocation);
        }
        return null;
    }

    public static String a(TFile locationFile) {
        assert (locationFile != null) : "Parameter 'locationFile' of method 'getUrlFromLocationFile1' must not be null";
        b.debug("Trying to get URL from location file '{}' ", (Object)locationFile.getAbsolutePath());
        if (locationFile.exists() && locationFile.canRead() && !FileUtility.isArchive((TFile)locationFile)) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (DataInputStream dataIn = new DataInputStream(new FileInputStream((File)locationFile));){
                    dataIn.skipBytes(d);
                    return dataIn.readUTF();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                b.error("Couldn't get URL from location file", (Throwable)ioe);
            }
        } else {
            b.warn("Couldn't get URL from location file '{}' ", (Object)locationFile.getAbsolutePath());
        }
        return null;
    }

    public TFile a(TFile eclipseWorkspace, TFile locationFile, String projectName, TFile defaultLocation) {
        assert (eclipseWorkspace != null) : "Parameter 'eclipseWorkspace' of method 'getProjectDirectoryFromLocationFile' must not be null";
        assert (locationFile != null) : "Parameter 'locationFile' of method 'getProjectDirectoryFromLocationFile' must not be null";
        assert (projectName != null && projectName.length() > 0) : "Parameter 'projectName' of method 'getProjectDirectoryFromLocationFile' must not be empty";
        assert (defaultLocation != null) : "Parameter 'defaultLocation' of method 'getProjectDirectoryFromLocationFile' must not be null";
        if (locationFile.exists() && locationFile.canRead() && !FileUtility.isArchive((TFile)locationFile)) {
            TFile defaultLocationCandidate;
            b.debug("Trying to get location of eclipse project '{}' from '{}' file...", (Object)projectName, (Object)g);
            String location = com.hello2morrow.sonargraph.languageprovider.java.controller.system.g.a(locationFile);
            if (location != null && location.startsWith(q)) {
                if ((location = location.substring(q.length())).length() > 0) {
                    String name;
                    TFile defaultLocationCandidate2 = new TFile(location);
                    if (defaultLocationCandidate2.exists()) {
                        b.debug("...got location '{}' of eclipse project '{}' from '{}' file", new Object[]{defaultLocationCandidate2, projectName, g});
                        return defaultLocationCandidate2;
                    }
                    if (defaultLocationCandidate2.isAbsolute() && (name = eclipseWorkspace.getName()) != null && !name.isEmpty()) {
                        try {
                            String canonicalCandidatePath = defaultLocationCandidate2.getCanonicalPath();
                            int pos = canonicalCandidatePath.lastIndexOf(name);
                            if (pos != -1 && canonicalCandidatePath.length() > pos + name.length() && (defaultLocationCandidate2 = new TFile((File)eclipseWorkspace, canonicalCandidatePath.substring(pos + name.length()))).exists()) {
                                b.debug("...got absolute location and transformed it to relative location '{}' of eclipse project '{}' from '{}' file", new Object[]{defaultLocationCandidate2, projectName, g});
                                return defaultLocationCandidate2;
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else if (location != null && location.startsWith(r) && (location = location.substring(r.length())).startsWith(s) && (location = location.substring(s.length())).length() > 0 && (defaultLocationCandidate = new TFile((File)eclipseWorkspace, location)).exists()) {
                b.debug("...got rtc/jazz location '{}' of eclipse project '{}' from '{}' file", new Object[]{defaultLocationCandidate, projectName, g});
                return defaultLocationCandidate;
            }
        } else {
            b.debug("Eclipse project '{}' is contained in workspace", (Object)projectName);
        }
        if (defaultLocation.exists()) {
            return defaultLocation;
        }
        return null;
    }

    private static boolean b(TFile projectMetadataDir) {
        assert (projectMetadataDir != null) : "Parameter 'projectMetadataDir' of method 'checkProjectMetadataDirectory' must not be null";
        String absolutePath = projectMetadataDir.getAbsolutePath();
        if (!projectMetadataDir.isDirectory()) {
            b.warn("Project metadata directory '{}' must be a directory", (Object)absolutePath);
            return false;
        }
        if (projectMetadataDir.isArchive()) {
            b.warn("Project metadata directory '{}' must not be an archive", (Object)absolutePath);
            return false;
        }
        if (!projectMetadataDir.canRead()) {
            b.warn("Can't read project metadata directory '{}'", (Object)absolutePath);
            return false;
        }
        String name = projectMetadataDir.getName();
        return !"..".equals(name) && !".".equals(name);
    }

    private List<String> a(IWorkerContext workerContext, Set<ImportModuleCandidate> candidates) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getCandidatesNames' must not be null";
        assert (candidates != null) : "Parameter 'candidates' of method 'getCandidatesNames' must not be null";
        ArrayList<String> candidatesNames = new ArrayList<String>();
        for (ImportModuleCandidate nextCandidate : candidates) {
            if (workerContext.hasBeenCanceled()) break;
            candidatesNames.add(nextCandidate.getName());
        }
        return candidatesNames;
    }

    private boolean a(IWorkerContext workerContext, OperationResultWithOutcome<Set<ImportModuleCandidate>> result, ImportModuleCandidate nextCandidate, Set<String> exportedAccu, TFile[] realWorkspaceChildren, Set<ImportRootDirectoryPathCandidate> allRootPaths) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'readClassPath' must not be null";
        assert (result != null) : "Parameter 'result' of method 'readClassPath' must not be null";
        assert (nextCandidate != null) : "Parameter 'nextCandidate' of method 'readClassPath' must not be null";
        assert (exportedAccu != null) : "Parameter 'exportedAccu' of method 'readClassPath' must not be null";
        assert (allRootPaths != null) : "Parameter 'allRootPaths' of method 'readClassPath' must not be null";
        TFile projectLocation = nextCandidate.getFile();
        assert (projectLocation != null) : "Parameter 'projectLocation' of method 'readClassPath' must not be null";
        boolean hasRootPath = false;
        TFile classpathFile = new TFile((File)projectLocation, k);
        if (classpathFile.exists()) {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element classpathElement = parser.parse((File)classpathFile).getDocumentElement();
                NodeList list = classpathElement.getElementsByTagName(h);
                int length = list.getLength();
                int i2 = 0;
                while (i2 < length) {
                    String kind;
                    NamedNodeMap attributes;
                    Node kindNode;
                    if (workerContext.hasBeenCanceled()) {
                        return hasRootPath;
                    }
                    Node node = list.item(i2);
                    if (node.getNodeType() == 1 && (kindNode = (attributes = node.getAttributes()).getNamedItem(i)) != null && (o.equals(kind = kindNode.getNodeValue()) || "output".equals(kind))) {
                        Node combineAccessRules = attributes.getNamedItem(l);
                        Node exportedNode = attributes.getNamedItem(m);
                        boolean exported = exportedNode != null && exportedNode.getNodeValue().equals("true");
                        Node pathNode = attributes.getNamedItem(n);
                        if (pathNode != null) {
                            String projectName;
                            String path = pathNode.getNodeValue();
                            boolean localHasRootPath = this.a(workerContext, result, nextCandidate, projectLocation, kind, combineAccessRules, path, allRootPaths);
                            if (b.isDebugEnabled()) {
                                this.a(nextCandidate, localHasRootPath, path);
                            }
                            hasRootPath = localHasRootPath || hasRootPath;
                            Node outputNode = attributes.getNamedItem("output");
                            if (outputNode != null) {
                                String outputPath = outputNode.getNodeValue();
                                boolean hasOutputRootPath = this.a(workerContext, result, nextCandidate, projectLocation, null, combineAccessRules, outputPath, allRootPaths);
                                if (b.isDebugEnabled()) {
                                    this.a(nextCandidate, hasOutputRootPath, outputPath);
                                }
                                boolean bl2 = hasRootPath = hasOutputRootPath || hasRootPath;
                            }
                            if (path.length() > 0 && path.charAt(0) == '/' && this.a(workerContext, projectName = path.substring(1), realWorkspaceChildren)) {
                                nextCandidate.addDependency(projectName);
                                if (exported) {
                                    exportedAccu.add(projectName);
                                }
                            }
                        }
                    }
                    ++i2;
                }
            }
            catch (ParserConfigurationException pce) {
                b.error("Error trying to create Document Builder", (Throwable)pce);
            }
            catch (IOException | SAXException e2) {
                b.error("Error trying to parse classpath file", (Throwable)e2);
            }
        } else {
            b.warn("No '.classpath' found in directory '{}'", (Object)projectLocation.getAbsolutePath());
        }
        return hasRootPath;
    }

    private void a(ImportModuleCandidate nextCandidate, boolean hasRootPath, String outputPath) {
        if (hasRootPath) {
            b.debug("Content found for project '" + nextCandidate.getFile().getAbsolutePath() + "' in path '" + outputPath + "'");
        } else {
            b.debug("No content found for project '" + nextCandidate.getFile().getAbsolutePath() + "' in path '" + outputPath + "'");
        }
    }

    private boolean a(IWorkerContext workerContext, OperationResultWithOutcome<Set<ImportModuleCandidate>> result, ImportModuleCandidate nextCandidate, TFile projectLocation, String kind, Node combineAccessRules, String path, Set<ImportRootDirectoryPathCandidate> allRootDirectories) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'loadContentFromPath' must not be null";
        assert (result != null) : "Parameter 'result' of method 'loadContentFromPath' must not be null";
        boolean hasRootPath = false;
        if (combineAccessRules == null && (path.length() == 0 || path.charAt(0) != '/')) {
            boolean hasContent;
            TFile rootPath = path.length() == 0 ? projectLocation : new TFile((File)projectLocation, path);
            boolean hasSourceCurrentRootPath = false;
            if (kind != null) {
                hasSourceCurrentRootPath = o.equals(kind);
            }
            hasRootPath = true;
            if (!rootPath.exists()) {
                hasContent = false;
            } else {
                DirectoryScanner scanner = new DirectoryScanner(Collections.emptyList(), false);
                n fileConsumer = new n();
                scanner.scan(rootPath, (DirectoryScanner.IFileConsumer)fileConsumer);
                hasContent = fileConsumer.a();
            }
            if (!nextCandidate.hasRootPath(rootPath.getAbsolutePath(), hasSourceCurrentRootPath)) {
                ImportRootDirectoryPathCandidate pathCandidate = new ImportRootDirectoryPathCandidate(rootPath, hasSourceCurrentRootPath, hasContent);
                if (this.a(workerContext, allRootDirectories, pathCandidate)) {
                    String warningString = "Root Directory Path was already added";
                    nextCandidate.addWarning("Root Directory Path was already added");
                    result.addWarning((OperationResult.IMessageCause)EclipseImportMessageCause.DUPLICATE_ROOT_DIRECTORY_PATH_FOUND, " '" + rootPath.getAbsolutePath() + "' is duplicated. ", new Object[0]);
                } else {
                    nextCandidate.addRootPath(pathCandidate);
                    allRootDirectories.add(pathCandidate);
                }
            }
        }
        return hasRootPath;
    }

    private boolean a(IWorkerContext workerContext, Set<ImportRootDirectoryPathCandidate> allRootPaths, ImportRootDirectoryPathCandidate candidate) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'candidateForRootPathAlreadyExists' must not be null";
        for (ImportRootDirectoryPathCandidate alreadyCreated : allRootPaths) {
            if (workerContext.hasBeenCanceled()) break;
            if (!FileUtility.areEqual((TFile)alreadyCreated.getFile(), (TFile)candidate.getFile()) || alreadyCreated.hasSource() != candidate.hasSource()) continue;
            return true;
        }
        return false;
    }

    private boolean a(IWorkerContext workerContext, String projectName, TFile[] workspaceChildren) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'hasEclipseProject' must not be null";
        assert (projectName != null && projectName.length() > 0) : "Parameter 'projectName' of method 'hasEclipseProject' must not be empty";
        TFile[] tFileArray = workspaceChildren;
        int n2 = workspaceChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            TFile nextChild = tFileArray[n3];
            if (workerContext.hasBeenCanceled()) break;
            if (nextChild.isDirectory() && nextChild.getName().equals(projectName)) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

