/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.commandline.ProcessExecutor;
import com.hello2morrow.foundation.commandline.ProcessMessageSink;
import com.hello2morrow.foundation.file.DirectoryMapping;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.Platform;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.foundation.utilities.XmlSlurper;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportRootDirectoryPathCandidate;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.BazelImportMessageCause;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.f;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.j;
import com.hello2morrow.sonargraph.languageprovider.java.model.externalimport.bazel.IBazelImportProvider;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class d
extends Extension
implements IBazelImportProvider {
    private static final Logger g = LoggerFactory.getLogger(d.class);
    public static final String a = "bazel";
    public static final String b = "bazelisk";
    public static final String c = "WORKSPACE";
    public static final String d = "BUILD";
    public static final String e = "BUILD.bazel";
    private static final String h = "release ";
    private static volatile /* synthetic */ int[] i;

    @Override
    public IPathValidator getWorkspaceValidator() {
        return new IPathValidator(){

            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput != null && newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (newInput == null || !newInput.exists()) {
                    result.addError("Invalid path");
                } else if (!new TFile((File)newInput, com.hello2morrow.sonargraph.languageprovider.java.controller.system.d.c).exists()) {
                    result.addError("Not a bazel workspace directory");
                }
                return result;
            }

            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }
        };
    }

    @Override
    public IPathValidator getBuildfileValidator() {
        return new IPathValidator(){

            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput != null && newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (newInput == null || !newInput.exists()) {
                    result.addError("Invalid path");
                } else if (!newInput.getName().equals(com.hello2morrow.sonargraph.languageprovider.java.controller.system.d.d) && !newInput.getName().equals(com.hello2morrow.sonargraph.languageprovider.java.controller.system.d.e)) {
                    result.addError("Not a valid bazel build file");
                }
                return result;
            }

            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.FILE;
            }
        };
    }

    @Override
    public OperationResultWithOutcome<ImportModuleCandidate> getBazelImportCandidate(IWorkerContext workerContext, TFile bazelWorkspace, boolean includeTest) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getBazelImportCandidate' must not be null";
        assert (bazelWorkspace != null) : "Parameter 'bazelWorkspace' of method 'getBazelImportCandidate' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading module candidate from bazel workspace");
        workerContext.working("Getting bazel bin directory", false);
        OperationResultWithOutcome<TFile> bazelBinResult = this.b(bazelWorkspace);
        if (bazelBinResult.isFailure()) {
            result.addMessagesFrom(bazelBinResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_BIN_DIRECTORY_PROBLEM);
            return result;
        }
        TFile bazelBin = (TFile)bazelBinResult.getOutcome();
        ImportModuleCandidate candidate = new ImportModuleCandidate(bazelWorkspace, bazelWorkspace.getName());
        result.setOutcome((Object)candidate);
        workerContext.working("Parsing bazel workspace info", true);
        XmlSlurper xmlOutput = this.a(workerContext, bazelWorkspace, (OperationResult)result);
        if (result.isSuccess() && !workerContext.hasBeenCanceled()) {
            try {
                for (Element javaRule : xmlOutput.getElementList(this.a(includeTest))) {
                    this.a(workerContext, bazelWorkspace, bazelBin, (OperationResult)result, candidate, javaRule);
                    this.a(workerContext, bazelWorkspace, (OperationResult)result, candidate, xmlOutput, (Node)javaRule);
                }
            }
            catch (XPathExpressionException xpee) {
                result.addError((OperationResult.IMessageCause)BazelImportMessageCause.XPATH_ERROR, (Throwable)xpee);
            }
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<Set<ImportModuleCandidate>> getBazelImportCandidatesPerRule(IWorkerContext workerContext, TFile bazelWorkspace, IBazelImportProvider.RootMode classRootMode, IBazelImportProvider.RootMode sourceRootMode, IBazelImportProvider.NamingMode namingMode, boolean includeTest) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getBazelImportCandidatesPerRule' must not be null";
        assert (bazelWorkspace != null) : "Parameter 'bazelWorkspace' of method 'getBazelImportCandidatesPerRule' must not be null";
        assert (classRootMode != null) : "Parameter 'classRootMode' of method 'getBazelImportCandidatesPerRule' must not be null";
        assert (sourceRootMode != null) : "Parameter 'sourceRootMode' of method 'getBazelImportCandidatesPerRule' must not be null";
        assert (namingMode != null) : "Parameter 'namingMode' of method 'getBazelImportCandidatesPerRule' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading module candidates from bazel build files");
        workerContext.working("Getting bazel bin directory", true);
        OperationResultWithOutcome<TFile> bazelBinResult = this.b(bazelWorkspace);
        if (bazelBinResult.isFailure()) {
            result.addMessagesFrom(bazelBinResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_BIN_DIRECTORY_PROBLEM);
            return result;
        }
        TFile bazelBin = (TFile)bazelBinResult.getOutcome();
        g.info("Processing bazel workspace '{}'", (Object)bazelWorkspace.getAbsolutePath());
        workerContext.working("Processing bazel workspace", true);
        XmlSlurper xmlOutput = this.a(workerContext, bazelWorkspace, (OperationResult)result);
        if (result.isFailure() || workerContext.hasBeenCanceled()) {
            return result;
        }
        try {
            HashSet<ImportModuleCandidate> candidates = new HashSet<ImportModuleCandidate>();
            for (Element javaRule : xmlOutput.getElementList(this.a(includeTest))) {
                if (workerContext.hasBeenCanceled()) {
                    return result;
                }
                String rawName = xmlOutput.getString((Node)javaRule, "@name");
                String name = this.adaptName(rawName, namingMode, bazelWorkspace.getName());
                workerContext.working("Found bazel java rule '" + name + "'", true);
                ImportModuleCandidate candidate = new ImportModuleCandidate(bazelWorkspace, name);
                if (sourceRootMode == IBazelImportProvider.RootMode.OUTPUT_JAR || classRootMode == IBazelImportProvider.RootMode.OUTPUT_JAR) {
                    this.a(bazelBin, (OperationResult)result, javaRule, candidate, xmlOutput, sourceRootMode, classRootMode, workerContext);
                }
                if (sourceRootMode == IBazelImportProvider.RootMode.DIRECTORY) {
                    this.a(workerContext, bazelWorkspace, (OperationResult)result, candidate, xmlOutput, (Node)javaRule);
                }
                if (classRootMode == IBazelImportProvider.RootMode.DIRECTORY) {
                    this.a(workerContext, bazelWorkspace, bazelBin, (OperationResult)result, candidate, javaRule);
                }
                this.a(javaRule, (OperationResultWithOutcome<Set<ImportModuleCandidate>>)result, candidate, xmlOutput, workerContext, namingMode, bazelWorkspace.getName());
                candidates.add(candidate);
            }
            result.setOutcome(candidates);
        }
        catch (Exception e2) {
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.XML_OUTPUT_ERROR, (Throwable)e2);
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<Set<ImportModuleCandidate>> getBazelImportCandidatesPerBuildFile(IWorkerContext workerContext, TFile bazelWorkspace, IBazelImportProvider.RootMode classRootMode, IBazelImportProvider.RootMode sourceRootMode, IBazelImportProvider.NamingMode namingMode, boolean includeTest) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        assert (bazelWorkspace != null) : "Parameter 'bazelWorkspace' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        assert (classRootMode != null) : "Parameter 'classRootMode' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        assert (sourceRootMode != null) : "Parameter 'sourceRootMode' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        assert (namingMode != null) : "Parameter 'namingMode' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading module candidates from bazel build files in a workspace");
        workerContext.working("Getting bazel bin directory", true);
        OperationResultWithOutcome<TFile> bazelBinResult = this.b(bazelWorkspace);
        if (bazelBinResult.isFailure()) {
            result.addMessagesFrom(bazelBinResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_BIN_DIRECTORY_PROBLEM);
            return result;
        }
        TFile bazelBin = (TFile)bazelBinResult.getOutcome();
        g.info("Processing bazel workspace '{}'", (Object)bazelWorkspace.getAbsolutePath());
        workerContext.working("Processing bazel workspace", true);
        XmlSlurper xmlOutput = this.a(workerContext, bazelWorkspace, (OperationResult)result);
        if (result.isFailure() || workerContext.hasBeenCanceled()) {
            return result;
        }
        try {
            HashMap<String, ImportModuleCandidate> candidates = new HashMap<String, ImportModuleCandidate>();
            for (Element javaRule : xmlOutput.getElementList(this.a(includeTest))) {
                if (workerContext.hasBeenCanceled()) {
                    return result;
                }
                String rawName = xmlOutput.getString((Node)javaRule, "@name");
                String location = this.a(rawName, bazelWorkspace.getName());
                workerContext.working("Found bazel build file at location '" + location + "'", true);
                ImportModuleCandidate candidate = (ImportModuleCandidate)candidates.get(location);
                if (candidate == null) {
                    candidate = new ImportModuleCandidate(bazelWorkspace, location);
                    candidates.put(location, candidate);
                }
                if (sourceRootMode == IBazelImportProvider.RootMode.OUTPUT_JAR || classRootMode == IBazelImportProvider.RootMode.OUTPUT_JAR) {
                    this.a(bazelBin, (OperationResult)result, javaRule, candidate, xmlOutput, sourceRootMode, classRootMode, workerContext);
                }
                if (sourceRootMode == IBazelImportProvider.RootMode.DIRECTORY) {
                    this.a(workerContext, bazelWorkspace, (OperationResult)result, candidate, xmlOutput, (Node)javaRule);
                }
                if (classRootMode == IBazelImportProvider.RootMode.DIRECTORY) {
                    this.a(workerContext, bazelWorkspace, bazelBin, (OperationResult)result, candidate, javaRule);
                }
                this.a(javaRule, (OperationResultWithOutcome<Set<ImportModuleCandidate>>)result, candidate, xmlOutput, workerContext, IBazelImportProvider.NamingMode.BUILD_FILE, bazelWorkspace.getName());
            }
            result.setOutcome(new HashSet(candidates.values()));
        }
        catch (Exception e2) {
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.XML_OUTPUT_ERROR, (Throwable)e2);
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<Set<ImportModuleCandidate>> getBazelImportCandidatesFromBuildFiles(IWorkerContext workerContext, List<TFile> bazelBuildFiles, IBazelImportProvider.RootMode classRootMode, IBazelImportProvider.RootMode sourceRootMode, IBazelImportProvider.NamingMode namingMode, boolean includeTest) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        assert (bazelBuildFiles != null) : "Parameter 'bazelBuildFiles' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        assert (classRootMode != null) : "Parameter 'classRootMode' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        assert (sourceRootMode != null) : "Parameter 'sourceRootMode' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        assert (namingMode != null) : "Parameter 'namingMode' of method 'getBazelImportCandidatesPerBuildFile' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading module candidates from a list of bazel build files");
        HashMap<String, ImportModuleCandidate> candidates = new HashMap<String, ImportModuleCandidate>();
        for (TFile nextBuildFile : bazelBuildFiles) {
            TFile bazelWorkspace = this.a(nextBuildFile);
            if (bazelWorkspace == null) {
                result.addWarning((OperationResult.IMessageCause)BazelImportMessageCause.BUILDFILE_WITHOUT_WORKSPACE);
                continue;
            }
            g.info("Processing bazel build file '{}' in workspace '{}'", (Object)nextBuildFile.getAbsolutePath(), (Object)bazelWorkspace.getAbsolutePath());
            workerContext.working("Getting bazel bin directory", true);
            OperationResultWithOutcome<TFile> bazelBinResult = this.b(bazelWorkspace);
            if (bazelBinResult.isFailure()) {
                result.addMessagesFrom(bazelBinResult);
                result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_BIN_DIRECTORY_PROBLEM);
                return result;
            }
            TFile bazelBin = (TFile)bazelBinResult.getOutcome();
            workerContext.working("Processing bazel buildfile", true);
            XmlSlurper xmlOutput = this.a(workerContext, bazelWorkspace, nextBuildFile, (OperationResult)result);
            if (result.isFailure() || workerContext.hasBeenCanceled()) {
                return result;
            }
            try {
                for (Element javaRule : xmlOutput.getElementList(this.a(includeTest))) {
                    if (workerContext.hasBeenCanceled()) {
                        return result;
                    }
                    String rawName = xmlOutput.getString((Node)javaRule, "@name");
                    String location = this.a(rawName, bazelWorkspace.getName());
                    workerContext.working("Found bazel build file at location '" + location + "'", true);
                    ImportModuleCandidate candidate = (ImportModuleCandidate)candidates.get(location);
                    if (candidate == null) {
                        candidate = new ImportModuleCandidate(bazelWorkspace, location);
                        candidates.put(location, candidate);
                    }
                    if (sourceRootMode == IBazelImportProvider.RootMode.OUTPUT_JAR || classRootMode == IBazelImportProvider.RootMode.OUTPUT_JAR) {
                        this.a(bazelBin, (OperationResult)result, javaRule, candidate, xmlOutput, sourceRootMode, classRootMode, workerContext);
                    }
                    if (sourceRootMode == IBazelImportProvider.RootMode.DIRECTORY) {
                        this.a(workerContext, bazelWorkspace, (OperationResult)result, candidate, xmlOutput, (Node)javaRule);
                    }
                    if (classRootMode == IBazelImportProvider.RootMode.DIRECTORY) {
                        this.a(workerContext, bazelWorkspace, bazelBin, (OperationResult)result, candidate, javaRule);
                    }
                    this.a(javaRule, (OperationResultWithOutcome<Set<ImportModuleCandidate>>)result, candidate, xmlOutput, workerContext, IBazelImportProvider.NamingMode.BUILD_FILE, bazelWorkspace.getName());
                }
            }
            catch (Exception e2) {
                result.addError((OperationResult.IMessageCause)BazelImportMessageCause.XML_OUTPUT_ERROR, (Throwable)e2);
                return result;
            }
        }
        result.setOutcome(new HashSet(candidates.values()));
        return result;
    }

    private TFile a(TFile buildFile) {
        assert (buildFile != null) : "Parameter 'buildFile' of method 'getWorkspaceForBuildFile' must not be null";
        TFile parent = buildFile.getParentFile();
        while (parent != null) {
            TFile workspaceFile = new TFile((File)parent, c);
            if (workspaceFile.exists() && workspaceFile.isFile()) {
                return parent;
            }
            parent = parent.getParentFile();
        }
        return null;
    }

    private String a(String ruleName, String rootName) {
        assert (ruleName != null && ruleName.length() > 0) : "Parameter 'ruleName' of method 'getLocationFromRuleName' must not be empty";
        String location = ruleName;
        if (location.startsWith("//")) {
            location = ruleName.substring(2);
        }
        if (location.indexOf(":") == -1) {
            return location;
        }
        List parts = StringUtility.splitAndTrim((String)location, (String)":");
        if (parts.size() == 1) {
            location = rootName;
        } else if (parts.size() == 2) {
            location = (String)parts.get(0);
        }
        return location;
    }

    @Override
    public String adaptName(String rawName, IBazelImportProvider.NamingMode namingMode, String rootName) {
        assert (rawName != null && rawName.length() > 0) : "Parameter 'rawName' of method 'adaptName' must not be empty";
        assert (namingMode != null) : "Parameter 'namingMode' of method 'adaptName' must not be null";
        switch (com.hello2morrow.sonargraph.languageprovider.java.controller.system.d.a()[namingMode.ordinal()]) {
            default: {
                return rawName;
            }
            case 2: {
                String name = rawName;
                if (name.startsWith("//")) {
                    name = rawName.substring(2);
                    List parts = StringUtility.splitAndTrim((String)name, (String)":");
                    if (parts.size() == 1) {
                        name = (String)parts.get(0);
                    } else if (parts.size() == 2 && ((String)parts.get(0)).equals(parts.get(1))) {
                        name = (String)parts.get(0);
                    }
                }
                return name.isEmpty() ? rawName : name;
            }
            case 3: 
        }
        return this.a(rawName, rootName != null ? rootName : "");
    }

    @Override
    public OperationResultWithOutcome<Version> getBazelVersion(TFile workspace) {
        assert (workspace != null) : "Parameter 'workspace' of method 'getBazelVersion' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Run bazel info to get its version.");
        OperationResultWithOutcome<String> infoResult = this.a(workspace, "release");
        if (infoResult.isFailure()) {
            result.addMessagesFrom(infoResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_INFO_PROBLEM);
            return result;
        }
        String release = (String)infoResult.getOutcome();
        if (release.startsWith(h)) {
            Version version;
            String versionOnly = release.substring(h.length()).trim();
            int dashPos = versionOnly.indexOf(45);
            if (dashPos > 0) {
                versionOnly = versionOnly.substring(0, dashPos);
            }
            if ((version = Version.create((String)versionOnly)) != null) {
                result.setOutcome((Object)version);
            } else {
                result.addError((OperationResult.IMessageCause)BazelImportMessageCause.INVALID_VERSION_STRING, "Can't create version from invalid String '" + release + "'", new Object[0]);
            }
        } else {
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.INVALID_VERSION_STRING, "Expected 'release' at beginning of '" + release + "'", new Object[0]);
        }
        return result;
    }

    private void a(TFile bazelBin, OperationResult result, Element javaRule, ImportModuleCandidate candidate, XmlSlurper xmlOutput, IBazelImportProvider.RootMode sourceRootMode, IBazelImportProvider.RootMode classRootMode, IWorkerContext workerContext) throws XPathExpressionException {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'handleRuleOutputs' must not be null";
        assert (result != null) : "Parameter 'result' of method 'handleRuleOutputs' must not be null";
        workerContext.working("Looking for output jars", true);
        for (Element ruleOutput : xmlOutput.getElementList((Node)javaRule, "rule-output")) {
            ImportRootDirectoryPathCandidate root;
            TFile path;
            String relativePath;
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            String ruleOutputName = xmlOutput.getString((Node)ruleOutput, "@name");
            if (ruleOutputName.endsWith("_deploy-src.jar")) {
                g.debug("Ignoring deploy-src.jar {}", (Object)ruleOutputName);
                continue;
            }
            if (ruleOutputName.endsWith("_deploy.jar")) {
                g.debug("Ignoring deploy.jar {}", (Object)ruleOutputName);
                continue;
            }
            if (ruleOutputName.endsWith("-src.jar")) {
                g.debug("Found source jar {}", (Object)ruleOutputName);
                if (sourceRootMode != IBazelImportProvider.RootMode.OUTPUT_JAR) continue;
                relativePath = this.a(ruleOutputName);
                path = new TFile((File)bazelBin, relativePath);
                root = new ImportRootDirectoryPathCandidate(path, true, true);
                candidate.addRootPath(root);
                continue;
            }
            if (ruleOutputName.endsWith(".jar")) {
                g.debug("Found jar {}", (Object)ruleOutputName);
                if (classRootMode != IBazelImportProvider.RootMode.OUTPUT_JAR) continue;
                relativePath = this.a(ruleOutputName);
                path = new TFile((File)bazelBin, relativePath);
                root = new ImportRootDirectoryPathCandidate(path, false, true);
                candidate.addRootPath(root);
                continue;
            }
            g.debug("Found unexpected jar {}", (Object)ruleOutputName);
        }
    }

    private void a(IWorkerContext workerContext, TFile bazelWorkspace, OperationResult result, ImportModuleCandidate candidate, XmlSlurper xmlOutput, Node rootNode) {
        workerContext.working("Looking for source directories", true);
        ArrayList<TFile> javaInputFiles = new ArrayList<TFile>();
        try {
            for (Element javaInputFileXml : xmlOutput.getElementList(rootNode, "list[@name='srcs']/label")) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                String path = javaInputFileXml.getAttribute("value");
                String resolvedPath = this.a(path);
                TFile javaInputFile = new TFile((File)bazelWorkspace, resolvedPath);
                if (!javaInputFile.exists()) continue;
                javaInputFiles.add(javaInputFile);
            }
            List misplacedSourceDirectories = FileUtility.findRootDirectories(javaInputFiles);
            for (DirectoryMapping next : misplacedSourceDirectories) {
                TFile rootDirectory;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                assert (next.getFiles() != null) : "'next.getFiles()' in method 'getBazelImportCandidate' must not be null";
                assert (!next.getFiles().isEmpty()) : "'next.getFiles()' in method 'getBazelImportCandidate' must not be empty";
                TFile oneOfThem = (TFile)next.getFiles().get(0);
                String packageName = com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.f.a(oneOfThem);
                ImportRootDirectoryPathCandidate pathCandidate = null;
                if (packageName != null && (rootDirectory = j.a(oneOfThem.getAbsolutePath(), packageName, '.')) != null) {
                    pathCandidate = new ImportRootDirectoryPathCandidate(rootDirectory, true, true);
                }
                if (pathCandidate == null) {
                    TFile maybeMisplacedDirectory = next.getDirectory();
                    pathCandidate = new ImportRootDirectoryPathCandidate(maybeMisplacedDirectory, true, true);
                }
                if (candidate.hasRootPath(pathCandidate.getFile().getAbsolutePath(), true)) continue;
                candidate.addRootPath(pathCandidate);
            }
        }
        catch (XPathExpressionException xpee) {
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.XPATH_ERROR, (Throwable)xpee);
        }
    }

    private void a(IWorkerContext workerContext, TFile bazelWorkspace, TFile bazelBin, OperationResult result, ImportModuleCandidate candidate, Element javaRule) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'handleClassRootDirectory' must not be null";
        assert (result != null) : "Parameter 'result' of method 'handleClassRootDirectory' must not be null";
        ImportRootDirectoryPathCandidate pathCandidate = this.a(bazelWorkspace, bazelBin, javaRule);
        candidate.addRootPath(pathCandidate);
    }

    private ImportRootDirectoryPathCandidate a(TFile bazelWorkspace, TFile bazelBin, Element javaRule) {
        assert (bazelWorkspace != null) : "Parameter 'bazelWorkspace' of method 'getPathCandidate' must not be null";
        String prefix = "java_library".equals(javaRule.getAttribute("class")) ? "lib" : "";
        String path = this.a(javaRule.getAttribute("name"));
        String constructedPath = this.b(path, prefix);
        TFile classRoot = new TFile((File)bazelBin, constructedPath);
        ImportRootDirectoryPathCandidate pathCandidate = new ImportRootDirectoryPathCandidate(classRoot, false, true);
        return pathCandidate;
    }

    private String b(String path, String prefix) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'constructBazelBinPathForJavaRule' must not be empty";
        if (prefix == null) {
            prefix = "";
        }
        List pathParts = FileUtility.getPathParts((String)path);
        String shortName = (String)pathParts.get(pathParts.size() - 1);
        pathParts.add(pathParts.size() - 1, "_javac");
        pathParts.add(String.valueOf(prefix) + shortName + "_classes");
        String completedPath = StringUtility.concat((Collection)pathParts, (String)"/");
        return completedPath;
    }

    private XmlSlurper a(IWorkerContext workerContext, TFile bazelWorkspace, OperationResult result) {
        ProcessExecutor.ProcessOperationResult processResult;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getWorkspaceInfo' must not be null";
        assert (bazelWorkspace != null) : "Parameter 'bazelWorkspace' of method 'getWorkspaceInfo' must not be null";
        assert (result != null) : "Parameter 'result' of method 'getWorkspaceInfo' must not be null";
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        workerContext.working("Getting workspace info", true);
        OperationResultWithOutcome<TFile> bazelExecutableResult = this.c(bazelWorkspace);
        if (!bazelExecutableResult.isSuccess()) {
            result.addMessagesFrom(bazelExecutableResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_EXECUTABLE_PROBLEM);
            return null;
        }
        TFile bazelExecutable = (TFile)bazelExecutableResult.getOutcome();
        List<String> command = Arrays.asList(bazelExecutable.getAbsolutePath(), "query", "'...'", "--output", "xml", "--notool_deps", "--noimplicit_deps");
        boolean success = ProcessExecutor.execute(command, (TFile)bazelWorkspace, (ProcessExecutor.ProcessOperationResult)(processResult = new ProcessExecutor.ProcessOperationResult("Get Workspace Info", new ProcessMessageSink(workerContext))), (OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_EXECUTABLE_EXCEPTION);
        if (!success) {
            result.addMessagesFrom((OperationResult)processResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_WORKSPACE_INFO_PROBLEM);
            return null;
        }
        try {
            XmlSlurper xmlOutput = new XmlSlurper();
            xmlOutput.parse(processResult.getOutput());
            return xmlOutput;
        }
        catch (Exception e2) {
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.XML_OUTPUT_ERROR, (Throwable)e2);
            return null;
        }
    }

    private XmlSlurper a(IWorkerContext workerContext, TFile bazelWorkspace, TFile bazelBuildFile, OperationResult result) {
        ProcessExecutor.ProcessOperationResult processResult;
        List<String> command;
        boolean success;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getBuildFileInfo' must not be null";
        assert (bazelWorkspace != null) : "Parameter 'bazelWorkspace' of method 'getBuildFileInfo' must not be null";
        assert (bazelBuildFile != null) : "Parameter 'bazelBuildFile' of method 'getBuildFileInfo' must not be null";
        assert (result != null) : "Parameter 'result' of method 'getBuildFileInfo' must not be null";
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        workerContext.working("Getting build file info", true);
        OperationResultWithOutcome<TFile> bazelExecutableResult = this.c(bazelWorkspace);
        if (!bazelExecutableResult.isSuccess()) {
            result.addMessagesFrom(bazelExecutableResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_EXECUTABLE_PROBLEM);
            return null;
        }
        TFile bazelExecutable = (TFile)bazelExecutableResult.getOutcome();
        String path_to_directory_with_buildfile = FileUtility.calculateRelativePath((TFile)bazelBuildFile.getParentFile(), (TFile)bazelWorkspace);
        if (path_to_directory_with_buildfile.startsWith("./")) {
            path_to_directory_with_buildfile = path_to_directory_with_buildfile.substring("./".length());
        }
        if (!(success = ProcessExecutor.execute(command = Arrays.asList(bazelExecutable.getAbsolutePath(), "query", String.valueOf(path_to_directory_with_buildfile) + ":all", "--output", "xml", "--notool_deps", "--noimplicit_deps"), (TFile)bazelWorkspace, (ProcessExecutor.ProcessOperationResult)(processResult = new ProcessExecutor.ProcessOperationResult("Get Build File Info", new ProcessMessageSink(workerContext))), (OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_EXECUTABLE_EXCEPTION))) {
            result.addMessagesFrom((OperationResult)processResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_BUILD_FILE_PROBLEM);
            return null;
        }
        try {
            XmlSlurper xmlOutput = new XmlSlurper();
            xmlOutput.parse(processResult.getOutput());
            return xmlOutput;
        }
        catch (Exception e2) {
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.XML_OUTPUT_ERROR, (Throwable)e2);
            return null;
        }
    }

    private void a(Element javaRule, OperationResultWithOutcome<Set<ImportModuleCandidate>> result, ImportModuleCandidate candidate, XmlSlurper xmlOutput, IWorkerContext workerContext, IBazelImportProvider.NamingMode namingMode, String rootName) throws XPathExpressionException {
        assert (result != null) : "Parameter 'result' of method 'handleWorkspaceDependencies' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'handleWorkspaceDependencies' must not be null";
        assert (namingMode != null) : "Parameter 'namingMode' of method 'handleWorkspaceDependencies' must not be null";
        workerContext.working("Adding workspace dependencies", true);
        for (Element dep : xmlOutput.getElementList((Node)javaRule, "list[@name='deps']/label")) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            String dependency = xmlOutput.getString((Node)dep, "@value");
            if (dependency.startsWith("//")) {
                String adaptedDependencyName = this.adaptName(dependency, namingMode, rootName);
                if (candidate.getName().equals(adaptedDependencyName)) continue;
                candidate.addDependency(adaptedDependencyName);
                continue;
            }
            if (dependency.startsWith("@maven")) {
                g.debug("Ignoring maven dependency '{}'", (Object)dependency);
                continue;
            }
            g.warn("Ignoring unknown dependency '{}'", (Object)dependency);
        }
    }

    private String a(String bazelName) {
        assert (bazelName != null && bazelName.length() > 0) : "Parameter 'bazelName' of method 'getPathFromRuleOutput' must not be empty";
        if (bazelName.startsWith("//:")) {
            String path = bazelName.substring("//:".length());
            g.debug("Path from toplevel bazel 'package': {}", (Object)path);
            return path;
        }
        if (bazelName.startsWith("//") && bazelName.indexOf(58) != -1) {
            String path = bazelName.substring("//".length()).replaceFirst(":", "/");
            g.debug("Path from subdirectory bazel 'package': {}", (Object)path);
            return path;
        }
        return bazelName;
    }

    private OperationResultWithOutcome<TFile> b(TFile workspace) {
        assert (workspace != null) : "Parameter 'workspace' of method 'getBazelBinDirectory' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Get bazel-bin directory");
        TFile createdLink = new TFile((File)workspace, "bazel-bin");
        if (createdLink.exists()) {
            g.debug("link to bazel bin directory is '{}'", (Object)createdLink);
            result.setOutcome((Object)createdLink);
            return result;
        }
        OperationResultWithOutcome<String> infoResult = this.a(workspace, "bazel-bin");
        if (infoResult.isFailure()) {
            result.addMessagesFrom(infoResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_INFO_PROBLEM);
            return result;
        }
        TFile bazelBin = new TFile((String)infoResult.getOutcome());
        g.debug("bazel bin directory is '{}'", (Object)bazelBin);
        result.setOutcome((Object)bazelBin);
        return result;
    }

    private OperationResultWithOutcome<String> a(TFile bazelWorkspace, String info) {
        assert (bazelWorkspace != null) : "Parameter 'bazelWorkspace' of method 'getBazelInfo' must not be null";
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'getBazelInfo' must not be empty";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Run bazel info.");
        OperationResultWithOutcome<TFile> bazelExecutableResult = this.c(bazelWorkspace);
        if (!bazelExecutableResult.isSuccess()) {
            result.addMessagesFrom(bazelExecutableResult);
            result.addError((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_EXECUTABLE_PROBLEM);
            return result;
        }
        TFile bazelExecutable = (TFile)bazelExecutableResult.getOutcome();
        List<String> command = Arrays.asList(bazelExecutable.getAbsolutePath(), "info", info);
        String output = ProcessExecutor.execute(command, (TFile)bazelWorkspace, (OperationResult)result, (OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_EXECUTABLE_EXCEPTION);
        if (result.isSuccess()) {
            result.setOutcome((Object)output.trim());
        }
        return result;
    }

    private OperationResultWithOutcome<TFile> c(TFile workspace) {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Find bazelisk/bazel executable in workspace or path");
        result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.PATH_INFO, "Path is " + Platform.getPath());
        if (workspace != null) {
            result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.WORKSPACE_INFO, "Workspace is " + workspace.getAbsolutePath());
            TFile bazeliskInWorkspace = new TFile((File)workspace, b);
            if (bazeliskInWorkspace.isFile() && bazeliskInWorkspace.canExecute()) {
                result.setOutcome((Object)bazeliskInWorkspace);
                result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.BAZELISK_FROM_WORKSPACE);
                return result;
            }
            result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.NO_BAZELISK_IN_WORKSPACE);
            TFile bazelInWorkspace = new TFile((File)workspace, a);
            if (bazelInWorkspace.isFile() && bazelInWorkspace.canExecute()) {
                result.setOutcome((Object)bazelInWorkspace);
                result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_FROM_WORKSPACE);
                return result;
            }
            result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.NO_BAZEL_IN_WORKSPACE);
        } else {
            result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.NOT_SEARCHING_IN_WORKSPACE);
        }
        OperationResultWithOutcome whichBazelisk = ProcessExecutor.which((String)b);
        if (whichBazelisk.isSuccess()) {
            String bazeliskOutcome = (String)whichBazelisk.getOutcome();
            TFile bazeliskInPath = new TFile(bazeliskOutcome);
            result.setOutcome((Object)bazeliskInPath);
            result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.BAZELISK_FROM_PATH);
            return result;
        }
        result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.NO_BAZELISK_IN_PATH);
        OperationResultWithOutcome whichBazel = ProcessExecutor.which((String)a);
        if (whichBazel.isSuccess()) {
            String bazelOutcome = (String)whichBazel.getOutcome();
            TFile bazelInPath = new TFile(bazelOutcome);
            result.setOutcome((Object)bazelInPath);
            result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.BAZEL_FROM_PATH);
            return result;
        }
        result.addInfo((OperationResult.IMessageCause)BazelImportMessageCause.NO_BAZEL_IN_PATH);
        result.addError((OperationResult.IMessageCause)BazelImportMessageCause.NO_EXECUTABLE_FOUND, "Could not find bazel/bazelisk executable, neither in workspace, nor in path.", new Object[0]);
        return result;
    }

    private String a(boolean includeTest) {
        if (includeTest) {
            return "/query/rule[@class='java_library' or @class='java_binary' or @class='java_test']";
        }
        return "/query/rule[@class='java_library' or @class='java_binary']";
    }

    static /* synthetic */ int[] a() {
        if (i != null) {
            return i;
        }
        int[] nArray = new int[IBazelImportProvider.NamingMode.values().length];
        try {
            nArray[IBazelImportProvider.NamingMode.BUILD_FILE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IBazelImportProvider.NamingMode.RAW.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IBazelImportProvider.NamingMode.SHORT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        i = nArray;
        return nArray;
    }
}

