/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.a.d;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.f;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.j;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.q;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.DetectedRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IRootDirectoryPathCollector;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IRootDirectoryPathDetectionConsumer;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L
implements IRootDirectoryPathCollector {
    private static final Logger b = LoggerFactory.getLogger(L.class);
    private final Set<String> c = new THashSet();
    private final Set<String> d = new THashSet();
    private final Map<String, Module> e = new THashMap();
    private final Map<String, Module> f = new THashMap();
    private final Set<String> g;
    private IRootDirectoryPathDetectionConsumer h;
    private IWorkerContext i;
    private TFile j;
    private boolean k;
    private boolean l;
    private boolean m;
    private static volatile /* synthetic */ int[] n;

    L(Set<String> directoriesToIgnore) {
        assert (directoriesToIgnore != null) : "Parameter 'directoriesToIgnore' of method 'RootDirectoryPathCollector' must not be null";
        this.g = new THashSet(directoriesToIgnore);
    }

    L(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'RootDirectoryPathCollector' must not be null";
        this.g = Collections.emptySet();
        List modules = ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(JavaModule.class);
        for (JavaModule nextModule : modules) {
            List rootDirectoryPaths = nextModule.getChildren(JavaClassRootDirectoryPath.class, true);
            for (JavaClassRootDirectoryPath nextRootDirectoryPath : rootDirectoryPaths) {
                this.e.put(FileUtility.getIdentifyingPath((TFile)nextRootDirectoryPath.getDirectoryFile()), nextModule);
            }
            List sourceRootDirectoryPaths = nextModule.getChildren(JavaSourceRootDirectoryPath.class, true);
            for (JavaSourceRootDirectoryPath nextSourceRootDirectoryPath : sourceRootDirectoryPaths) {
                this.f.put(FileUtility.getIdentifyingPath((TFile)nextSourceRootDirectoryPath.getDirectoryFile()), nextModule);
            }
        }
    }

    @Override
    public void collect(IRootDirectoryPathDetectionConsumer consumer, IWorkerContext workerContext, TFile startDirectory, boolean includePathsStartingWithDot, boolean includeZips, boolean includeNestedZips) {
        assert (consumer != null) : "Parameter 'consumer' of method 'collect' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collect' must not be null";
        assert (startDirectory != null) : "Parameter 'startDirectory' of method 'collect' must not be null";
        assert (startDirectory.exists()) : "Parameter 'startDirectory' of method 'collect' must exist";
        assert (startDirectory.isDirectory()) : "Parameter 'startDirectory' of method 'collect' must be a directory";
        this.h = consumer;
        this.i = workerContext;
        this.j = startDirectory;
        this.k = includePathsStartingWithDot;
        this.l = includeZips;
        this.m = includeNestedZips;
        this.a(this.j, FileUtility.isArchive((TFile)this.j));
        this.h = null;
        this.i = null;
        this.j = null;
        this.k = false;
        this.l = false;
        this.m = false;
        this.c.clear();
        this.d.clear();
    }

    private void a(List<TFile> filesInDirectory, boolean inArchive) {
        DetectedRootDirectoryPath candidate;
        String normalizedAbsoultePath;
        assert (filesInDirectory != null) : "Parameter 'filesInDirectory' of method 'detectRootDirectories' must not be null";
        TFile detectedClassRoot = null;
        TFile detectedSourceRoot = null;
        for (TFile nextFile : filesInDirectory) {
            TFile detectedRootDirectory;
            if (this.i.hasBeenCanceled()) {
                b.debug("Canceled");
                return;
            }
            assert (nextFile.isFile()) : "Not a file: " + nextFile;
            b.debug("Process file: {}", (Object)nextFile.getAbsolutePath());
            this.i.working("Check file", false);
            String packageName = null;
            boolean isClassRoot = false;
            JavaFileType fileType = JavaFileType.determine(nextFile.getName());
            if (fileType != null) {
                switch (L.a()[fileType.ordinal()]) {
                    case 1: {
                        if (detectedClassRoot != null) break;
                        b.debug("Extract package name from class file");
                        packageName = com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.a.d.a(nextFile);
                        isClassRoot = true;
                        break;
                    }
                    case 2: {
                        if (detectedSourceRoot != null) break;
                        packageName = com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.f.a(nextFile);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (detectedSourceRoot != null) break;
                        packageName = q.a(nextFile);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled Java file type: " + (Object)((Object)fileType);
                        break;
                    }
                }
            }
            if (packageName != null && (detectedRootDirectory = com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.javafile.j.a(nextFile.getAbsolutePath(), packageName, '.')) != null) {
                if (isClassRoot) {
                    detectedClassRoot = detectedRootDirectory;
                } else {
                    detectedSourceRoot = detectedRootDirectory;
                }
            }
            if (detectedClassRoot != null && detectedSourceRoot != null) break;
        }
        if (detectedClassRoot != null && !this.h.ignoreClassRootDirectory(detectedClassRoot) && this.c.add(normalizedAbsoultePath = FileUtility.getIdentifyingPath(detectedClassRoot))) {
            candidate = new DetectedRootDirectoryPath(inArchive ? DetectedRootDirectoryPath.Type.CLASSES_ARCHIVE : DetectedRootDirectoryPath.Type.CLASSES_DIRECTORY, detectedClassRoot, this.e.get(normalizedAbsoultePath));
            b.debug("Found candidate: {}", (Object)candidate.getDirectory());
            this.h.found(candidate);
        }
        if (detectedSourceRoot != null && !this.h.ignoreSourceRootDirectory(detectedSourceRoot) && this.d.add(normalizedAbsoultePath = FileUtility.getIdentifyingPath(detectedSourceRoot))) {
            candidate = new DetectedRootDirectoryPath(inArchive ? DetectedRootDirectoryPath.Type.SOURCE_ARCHIVE : DetectedRootDirectoryPath.Type.SOURCE_DIRECTORY, detectedSourceRoot, this.f.get(normalizedAbsoultePath));
            b.debug("Found candidate: {}", (Object)candidate.getDirectory());
            this.h.found(candidate);
        }
    }

    private void a(TFile file, boolean inArchive, List<TFile> directories, List<TFile> files) {
        assert (file != null) : "Parameter 'file' of method 'skipPath' must not be null";
        assert (directories != null) : "Parameter 'directories' of method 'skipPath' must not be null";
        assert (files != null) : "Parameter 'files' of method 'skipPath' must not be null";
        if (this.i.hasBeenCanceled()) {
            b.debug("Canceled");
            return;
        }
        try {
            boolean isArchive;
            String fileName = file.getName();
            this.i.working("Processing file: " + fileName, false);
            if (!this.k && fileName.startsWith(".")) {
                b.debug("Skipped (./*): {}", (Object)fileName);
                return;
            }
            boolean bl2 = isArchive = inArchive ? file.isArchive() : FileUtility.isArchive((TFile)file);
            if (!this.l && isArchive) {
                b.debug("Skipped (Zip): {}", (Object)fileName);
                return;
            }
            if (!this.m && isArchive && inArchive) {
                b.debug("Skipped (Nested Zip): {}", (Object)fileName);
                return;
            }
            if (file.exists()) {
                if (file.isFile()) {
                    JavaFileType fileType = JavaFileType.determine(fileName);
                    if (fileType != null) {
                        files.add(file);
                    }
                } else if (file.isDirectory()) {
                    if (!this.g.contains(FileUtility.getCanonicalFilePath((TFile)file))) {
                        directories.add(file);
                    } else {
                        b.debug("Ignoring directory {}", (Object)file.getAbsolutePath());
                    }
                } else {
                    b.warn("Found file that is neither a file nor a directory: " + file.getAbsolutePath());
                }
            }
        }
        catch (Throwable t2) {
            b.warn("Unable to process file: " + file, t2);
        }
    }

    private void a(TFile currentDirectory, boolean inArchive) {
        assert (currentDirectory != null) : "Parameter 'currentDirectory' of method 'collectRootDirectories' must not be null";
        if (!(currentDirectory.exists() && currentDirectory.isDirectory() && currentDirectory.canRead())) {
            return;
        }
        if (this.i.hasBeenCanceled()) {
            b.debug("Canceled");
            return;
        }
        this.i.working("Searching in: " + FileUtility.calculateRelativePath((TFile)currentDirectory, (TFile)this.j), true);
        b.debug("Process: {}", (Object)currentDirectory);
        ArrayList<TFile> directories = new ArrayList<TFile>();
        ArrayList<TFile> files = new ArrayList<TFile>();
        TFile[] filesInCurrentDirectory = currentDirectory.listFiles();
        if (filesInCurrentDirectory == null) {
            b.error("Failed to determine files in directory '{}'", (Object)currentDirectory.getAbsolutePath());
            return;
        }
        TFile[] tFileArray = filesInCurrentDirectory;
        int n2 = filesInCurrentDirectory.length;
        int n3 = 0;
        while (n3 < n2) {
            TFile nextFile = tFileArray[n3];
            if (this.i.hasBeenCanceled()) {
                b.debug("Canceled");
                return;
            }
            this.a(nextFile, inArchive, directories, files);
            ++n3;
        }
        this.a(files, inArchive);
        for (TFile nextDirectory : directories) {
            if (this.i.hasBeenCanceled()) {
                b.debug("Canceled");
                return;
            }
            boolean isArchive = inArchive ? nextDirectory.isArchive() : FileUtility.isArchive((TFile)nextDirectory);
            this.a(nextDirectory, inArchive || isArchive);
        }
    }

    static /* synthetic */ int[] a() {
        if (n != null) {
            return n;
        }
        int[] nArray = new int[JavaFileType.values().length];
        try {
            nArray[JavaFileType.ASPECTJ_FILE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JavaFileType.CLASS_FILE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JavaFileType.GROOVY_FILE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JavaFileType.JAVA_FILE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JavaFileType.KOTLIN_FILE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JavaFileType.SCALA_FILE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        n = nArray;
        return nArray;
    }
}

