/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.architecture.model;

import com.hello2morrow.sonargraph.integration.architecture.model.ArchitectureElement;
import com.hello2morrow.sonargraph.integration.architecture.model.Interface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Connector
extends ArchitectureElement {
    private final ArchitectureElement parent;
    private final boolean isOptional;
    private final List<Connector> includedConnectors = new ArrayList<Connector>();
    private final List<Interface> connectedInterfaces = new ArrayList<Interface>();

    public Connector(ArchitectureElement parent, String name, boolean isOptional) {
        super(name);
        assert (parent != null);
        this.parent = parent;
        this.isOptional = isOptional;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public ArchitectureElement getParent() {
        return this.parent;
    }

    public void addIncludedConnector(Connector included) {
        assert (included != null);
        this.includedConnectors.add(included);
    }

    public List<Connector> getIncludedConnectors() {
        return Collections.unmodifiableList(this.includedConnectors);
    }

    public void addConnectedInterface(Interface connection) {
        assert (connection != null);
        this.connectedInterfaces.add(connection);
    }

    public List<Interface> getConnectedInterfaces() {
        return Collections.unmodifiableList(this.connectedInterfaces);
    }
}

