/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.architecture.a;

import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultCause;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.integration.architecture.model.ArchitecturalModel;
import com.hello2morrow.sonargraph.integration.architecture.model.ArchitectureElement;
import com.hello2morrow.sonargraph.integration.architecture.model.Artifact;
import com.hello2morrow.sonargraph.integration.architecture.model.Connector;
import com.hello2morrow.sonargraph.integration.architecture.model.Interface;
import com.hello2morrow.sonargraph.integration.architecture.persistence.Architecture;
import com.hello2morrow.sonargraph.integration.architecture.persistence.ArchitectureJaxbAdapter;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdArtifact;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdConnection;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdConnector;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdDependencyRestrictions;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdDependencyType;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdInclude;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdInterface;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdStereotype;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class a {
    private static final Logger b = LoggerFactory.getLogger(a.class);
    private final Map<String, Connector> c = new HashMap<String, Connector>();
    private final Map<String, Interface> d = new HashMap<String, Interface>();

    public Optional<ArchitecturalModel> a(File modelFile, Result result) {
        assert (modelFile != null) : "Parameter 'reportFile' of method 'readReportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'readReportFile' must not be null";
        JaxbAdapter<Architecture> jaxbAdapter = ArchitectureJaxbAdapter.create();
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl(result);
        ArchitecturalModel model = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(modelFile));){
                Architecture xmlRoot = jaxbAdapter.load(in, eventHandler);
                if (xmlRoot != null) {
                    model = this.a(xmlRoot);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            b.error("Failed to read report from '" + modelFile.getAbsolutePath() + "'", (Throwable)ex);
            result.b(ResultCause.READ_ERROR, ex);
        }
        return Optional.ofNullable(model);
    }

    private ArchitecturalModel a(Architecture architecture) {
        assert (architecture != null) : "Parameter 'architecture' of method 'convertXmlArchitectureToPojo' must not be null";
        ArchitecturalModel model = architecture.getTimestamp() == null ? new ArchitecturalModel(architecture.getName(), architecture.getModel()) : new ArchitecturalModel(architecture.getName(), architecture.getModel(), architecture.getSystemPath(), architecture.getSystemId(), architecture.getTimestamp().toGregorianCalendar().getTimeInMillis(), architecture.getVersion());
        for (XsdArtifact xmlArtifact : architecture.getArtifact()) {
            model.addArtifact(this.a(null, xmlArtifact));
        }
        for (XsdArtifact xmlArtifact : architecture.getArtifact()) {
            this.a(xmlArtifact);
        }
        return model;
    }

    private void a(ArchitectureElement element, List<XsdInclude> includeFilters, List<String> excludeFilter) {
        includeFilters.forEach(inc -> element.addIncludeFilter(inc.getValue(), inc.isIsStrong()));
        excludeFilter.forEach(element::addExcludeFilter);
    }

    private Artifact a(Artifact parent, XsdArtifact xmlArtifact) {
        Artifact artifact = new Artifact(parent, xmlArtifact.getName());
        this.a(artifact, xmlArtifact.getInclude(), xmlArtifact.getExclude());
        for (XsdStereotype xmlSt : xmlArtifact.getStereotype()) {
            artifact.addStereoType(Artifact.Stereotype.valueOf(xmlSt.name()));
        }
        for (XsdArtifact child : xmlArtifact.getArtifact()) {
            artifact.addChild(this.a(artifact, child));
        }
        for (XsdInterface xmlIface : xmlArtifact.getInterface()) {
            Interface iface = this.a(artifact, xmlIface);
            artifact.addInterface(iface);
        }
        for (XsdConnector xmlConn : xmlArtifact.getConnector()) {
            Connector conn = this.a(artifact, xmlConn);
            artifact.addConnector(conn);
        }
        return artifact;
    }

    private Connector a(Artifact parent, XsdConnector xmlConnector) {
        Connector connector = new Connector(parent, xmlConnector.getName(), xmlConnector.isIsOptional());
        this.c.put(connector.getFullName(), connector);
        this.a(connector, xmlConnector.getInclude(), xmlConnector.getExclude());
        return connector;
    }

    private Interface a(Artifact parent, XsdInterface xmlIface) {
        EnumSet<Interface.DependencyType> allowedDependencyTypes = null;
        XsdDependencyRestrictions restrictions = xmlIface.getDependencyRestrictions();
        if (restrictions != null) {
            allowedDependencyTypes = EnumSet.noneOf(Interface.DependencyType.class);
            for (XsdDependencyType depType : restrictions.getAllowedDependencyType()) {
                allowedDependencyTypes.add(Interface.DependencyType.valueOf(depType.name()));
            }
        }
        Interface iface = new Interface(parent, xmlIface.getName(), xmlIface.isIsOptional(), allowedDependencyTypes);
        this.d.put(iface.getFullName(), iface);
        this.a(iface, xmlIface.getInclude(), xmlIface.getExclude());
        return iface;
    }

    private void a(XsdArtifact xmlArtifact) {
        for (XsdArtifact child : xmlArtifact.getArtifact()) {
            this.a(child);
        }
        for (XsdInterface xmlInterface : xmlArtifact.getInterface()) {
            this.a(xmlInterface);
        }
        for (XsdConnector xmlConnector : xmlArtifact.getConnector()) {
            this.a(xmlConnector);
        }
    }

    private void a(XsdConnector xmlConnector) {
        Connector connector = this.c.get(xmlConnector.getName());
        assert (connector != null);
        for (String includedConnectorName : xmlConnector.getIncludedConnector()) {
            Connector includedConnector = this.c.get(includedConnectorName);
            assert (includedConnector != null);
            connector.addIncludedConnector(includedConnector);
        }
        for (XsdConnection connection : xmlConnector.getConnectTo()) {
            if (connection.getViaParentConnector() != null) continue;
            Interface connectedInterface = this.d.get(connection.getValue());
            assert (connectedInterface != null);
            connector.addConnectedInterface(connectedInterface);
        }
    }

    private void a(XsdInterface xmlInterface) {
        Interface iface = this.d.get(xmlInterface.getName());
        assert (iface != null);
        for (String exportName : xmlInterface.getExport()) {
            Interface exportedInterface = this.d.get(exportName);
            assert (exportedInterface != null);
            iface.addExportedInterface(exportedInterface);
        }
    }
}

