/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.model.IIssueCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricProvider;
import com.hello2morrow.sonargraph.integration.access.model.Severity;
import com.hello2morrow.sonargraph.integration.access.model.internal.BasicSoftwareSystemInfoImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.IssueCategoryImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.IssueProviderImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.IssueTypeImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MetricCategoryImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MetricIdImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MetricLevelImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MetricProviderImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.SingleExportMetaDataImpl;
import com.hello2morrow.sonargraph.integration.access.persistence.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlAccess;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExportMetaData;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExportMetaDataRoot;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueCategory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueProvider;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueType;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricCategory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricId;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricLevel;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlExportMetaDataReader
extends XmlAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlExportMetaDataReader.class);

    /*
     * Exception decompiling
     */
    public Optional<SingleExportMetaDataImpl> readMetaDataFromStream(InputStream input, String identifier, Result result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Optional<SingleExportMetaDataImpl> convertXmlMetaDataToPojo(XsdExportMetaDataRoot xsdMetaData, String identifier, Result result) {
        assert (xsdMetaData != null) : "Parameter 'xsdMetrics' of method 'convertXmlMetricsToPojo' must not be null";
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'convertXmlMetricsToPojo' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'convertXmlMetaDataToPojo' must not be null";
        SingleExportMetaDataImpl metaData = new SingleExportMetaDataImpl(new BasicSoftwareSystemInfoImpl(xsdMetaData.getSystemPathUsedForExport(), xsdMetaData.getSystemId(), xsdMetaData.getVersion(), xsdMetaData.getTimestamp().toGregorianCalendar().getTimeInMillis()), identifier);
        Map<Object, IssueCategoryImpl> issueCategoryXsdToPojoMap = XmlExportMetaDataReader.processIssueCategories(xsdMetaData);
        for (IssueCategoryImpl category : issueCategoryXsdToPojoMap.values()) {
            metaData.addIssueCategory(category);
        }
        Map<Object, IssueProviderImpl> issueProviderXsdToPojoMap = XmlExportMetaDataReader.processIssueProviders(xsdMetaData);
        for (IssueProviderImpl provider : issueProviderXsdToPojoMap.values()) {
            metaData.addIssueProvider(provider);
        }
        Map<Object, IssueTypeImpl> issueTypeXsdToPojoMap = XmlExportMetaDataReader.processIssueTypes(xsdMetaData, issueCategoryXsdToPojoMap, issueProviderXsdToPojoMap, result);
        for (IssueTypeImpl issueType : issueTypeXsdToPojoMap.values()) {
            metaData.addIssueType(issueType);
        }
        Map<Object, MetricCategoryImpl> categoryXsdToPojoMap = XmlExportMetaDataReader.processMetricCategories(xsdMetaData);
        for (MetricCategoryImpl category : categoryXsdToPojoMap.values()) {
            metaData.addMetricCategory(category);
        }
        Map<Object, MetricProviderImpl> providerXsdToPojoMap = XmlExportMetaDataReader.processProviders(xsdMetaData);
        for (MetricProviderImpl provider : providerXsdToPojoMap.values()) {
            metaData.addMetricProvider(provider);
        }
        Map<Object, MetricLevelImpl> metricLevelXsdToPojoMap = XmlExportMetaDataReader.processMetricLevels(xsdMetaData);
        for (MetricLevelImpl level : metricLevelXsdToPojoMap.values()) {
            metaData.addMetricLevel(level);
        }
        for (MetricIdImpl id : XmlExportMetaDataReader.processMetricIds(xsdMetaData, categoryXsdToPojoMap, providerXsdToPojoMap, metricLevelXsdToPojoMap).values()) {
            metaData.addMetricId(id);
        }
        return Optional.of(metaData);
    }

    static Map<Object, MetricCategoryImpl> processMetricCategories(XsdExportMetaData xsdMetaData) {
        assert (xsdMetaData != null) : "Parameter 'xsdMetaData' of method 'processMetricCategories' must not be null";
        LinkedHashMap<XsdMetricCategory, MetricCategoryImpl> categoryXsdToPojoMap = new LinkedHashMap<XsdMetricCategory, MetricCategoryImpl>();
        for (XsdMetricCategory xsdCategory : xsdMetaData.getMetricCategories().getCategory()) {
            MetricCategoryImpl category = new MetricCategoryImpl(xsdCategory.getName(), xsdCategory.getPresentationName(), xsdCategory.getOrderNumber());
            categoryXsdToPojoMap.put(xsdCategory, category);
        }
        return Collections.unmodifiableMap(categoryXsdToPojoMap);
    }

    static Map<Object, MetricProviderImpl> processProviders(XsdExportMetaData xsdMetaData) {
        assert (xsdMetaData != null) : "Parameter 'xsdMetaData' of method 'processProviders' must not be null";
        LinkedHashMap<XsdMetricProvider, MetricProviderImpl> providerXsdToPojoMap = new LinkedHashMap<XsdMetricProvider, MetricProviderImpl>();
        for (XsdMetricProvider xsdProvider : xsdMetaData.getMetricProviders().getProvider()) {
            MetricProviderImpl provider = new MetricProviderImpl(xsdProvider.getName(), xsdProvider.getPresentationName());
            providerXsdToPojoMap.put(xsdProvider, provider);
        }
        return Collections.unmodifiableMap(providerXsdToPojoMap);
    }

    static Map<Object, MetricLevelImpl> processMetricLevels(XsdExportMetaData xsdExportMetaData) {
        assert (xsdExportMetaData != null) : "Parameter 'xsdMetaData' of method 'processMetricLevels' must not be null";
        LinkedHashMap<XsdMetricLevel, MetricLevelImpl> metricLevelXsdToPojoMap = new LinkedHashMap<XsdMetricLevel, MetricLevelImpl>();
        for (XsdMetricLevel xsdLevel : xsdExportMetaData.getMetricLevels().getLevel()) {
            MetricLevelImpl level = new MetricLevelImpl(xsdLevel.getName(), xsdLevel.getPresentationName(), xsdLevel.getOrderNumber());
            metricLevelXsdToPojoMap.put(xsdLevel, level);
        }
        return Collections.unmodifiableMap(metricLevelXsdToPojoMap);
    }

    static Map<Object, MetricIdImpl> processMetricIds(XsdExportMetaData xsdMetaData, Map<Object, MetricCategoryImpl> categoryXsdToPojoMap, Map<Object, MetricProviderImpl> providerXsdToPojoMap, Map<Object, MetricLevelImpl> metricLevelXsdToPojoMap) {
        assert (xsdMetaData != null) : "Parameter 'xsdMetaData' of method 'processMetricIds' must not be null";
        assert (categoryXsdToPojoMap != null) : "Parameter 'categoryXsdToPojoMap' of method 'processMetricIds' must not be null";
        assert (providerXsdToPojoMap != null) : "Parameter 'providerXsdToPojoMap' of method 'processMetricIds' must not be null";
        assert (metricLevelXsdToPojoMap != null) : "Parameter 'metricLevelXsdToPojoMap' of method 'processMetricIds' must not be null";
        LinkedHashMap<XsdMetricId, MetricIdImpl> metricIdXsdToPojoMap = new LinkedHashMap<XsdMetricId, MetricIdImpl>();
        for (XsdMetricId xsdMetricId : xsdMetaData.getMetricIds().getMetricId()) {
            ArrayList<IMetricCategory> categories = new ArrayList<IMetricCategory>();
            for (Object xsdCategory : xsdMetricId.getCategories()) {
                IMetricCategory category = categoryXsdToPojoMap.get(xsdCategory);
                assert (category != null) : "'category' for metric '" + xsdMetricId.getName() + "' must not be null";
                categories.add(category);
            }
            ArrayList<IMetricLevel> metricLevels = new ArrayList<IMetricLevel>();
            for (Object xsdMetricLevel : xsdMetricId.getLevels()) {
                MetricLevelImpl metricLevel = metricLevelXsdToPojoMap.get(xsdMetricLevel);
                assert (metricLevel != null) : "Metric level for '" + xsdMetricId.getName() + "' must not be null";
                metricLevels.add(metricLevel);
            }
            IMetricProvider provider = providerXsdToPojoMap.get(xsdMetricId.getProvider());
            assert (provider != null) : "'provider' for metric '" + xsdMetricId.getName() + "' must not be null";
            metricIdXsdToPojoMap.put(xsdMetricId, new MetricIdImpl(xsdMetricId.getName(), xsdMetricId.getPresentationName(), xsdMetricId.getDescription(), categories, metricLevels, provider, xsdMetricId.isIsFloat(), xsdMetricId.getBestValue(), xsdMetricId.getWorstValue(), xsdMetricId.getMinValue(), xsdMetricId.getMaxValue(), XmlExportMetaDataReader.determineSortDirection(xsdMetricId)));
        }
        return Collections.unmodifiableMap(metricIdXsdToPojoMap);
    }

    private static IMetricId.SortDirection determineSortDirection(XsdMetricId xsdMetricId) {
        if (xsdMetricId.getDirection() == null) {
            LOGGER.info("Sort direction of metric '{}' is undefined, setting it to '{}'", (Object)xsdMetricId.getName(), (Object)IMetricId.SortDirection.INDIFFERENT.getStandardName());
            return IMetricId.SortDirection.INDIFFERENT;
        }
        try {
            return IMetricId.SortDirection.fromStandardName(xsdMetricId.getDirection());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Invalid sort direction '{}' detected for metric '{}', setting it to '{}'", new Object[]{xsdMetricId.getDirection(), xsdMetricId.getName(), IMetricId.SortDirection.INDIFFERENT.getStandardName()});
            return IMetricId.SortDirection.INDIFFERENT;
        }
    }

    static Map<Object, IssueCategoryImpl> processIssueCategories(XsdExportMetaData xsdMetaData) {
        assert (xsdMetaData != null) : "Parameter 'xsdMetaData' of method 'processIssueCategories' must not be null";
        LinkedHashMap<XsdIssueCategory, IssueCategoryImpl> issueCategoryXsdToPojoMap = new LinkedHashMap<XsdIssueCategory, IssueCategoryImpl>();
        for (XsdIssueCategory next : xsdMetaData.getIssueCategories().getCategory()) {
            IssueCategoryImpl category = new IssueCategoryImpl(next.getName(), next.getPresentationName());
            issueCategoryXsdToPojoMap.put(next, category);
        }
        return Collections.unmodifiableMap(issueCategoryXsdToPojoMap);
    }

    private static Map<Object, IssueProviderImpl> processIssueProviders(XsdExportMetaData xsdMetaData) {
        assert (xsdMetaData != null) : "Parameter 'xsdMetaData' of method 'processIssueProviders' must not be null";
        LinkedHashMap<XsdIssueProvider, IssueProviderImpl> issueProviderXsdToPojoMap = new LinkedHashMap<XsdIssueProvider, IssueProviderImpl>();
        for (XsdIssueProvider next : xsdMetaData.getIssueProviders().getIssueProvider()) {
            IssueProviderImpl provider = new IssueProviderImpl(next.getName(), next.getPresentationName());
            issueProviderXsdToPojoMap.put(next, provider);
        }
        return Collections.unmodifiableMap(issueProviderXsdToPojoMap);
    }

    private static Map<Object, IssueTypeImpl> processIssueTypes(XsdExportMetaData xsdMetaData, Map<Object, IssueCategoryImpl> categories, Map<Object, IssueProviderImpl> providers, Result result) {
        assert (xsdMetaData != null) : "Parameter 'xsdMetaData' of method 'processIssueTypes' must not be null";
        assert (categories != null && !categories.isEmpty()) : "Parameter 'categories' of method 'processIssueTypes' must not be empty";
        assert (providers != null) : "Parameter 'providers' of method 'processIssueTypes' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processIssueTypes' must not be null";
        LinkedHashMap<XsdIssueType, IssueTypeImpl> issueTypeXsdToPojoMap = new LinkedHashMap<XsdIssueType, IssueTypeImpl>();
        for (XsdIssueType next : xsdMetaData.getIssueTypes().getIssueType()) {
            IIssueCategory category = categories.get(next.getCategory());
            assert (category != null) : "Category '" + next.getCategory().toString() + "' has not been processed";
            ArrayList<Severity> severities = new ArrayList<Severity>();
            try {
                String[] stringArray = next.getSeverity().split(", ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String nextSeverityString = stringArray[n2];
                    severities.add(Severity.fromString(nextSeverityString));
                    ++n2;
                }
            }
            catch (Exception e2) {
                LOGGER.error("Failed to process severity type '" + next.getSeverity() + "'", (Throwable)e2);
                result.a((Result.a)ValidationEventHandlerImpl.ValidationMessageCauses.NOT_SUPPORTED_ENUM_CONSTANT, "Severity type '" + next.getSeverity() + "' is not supported, setting to '" + Severity.ERROR + "'", new Object[0]);
                severities.add(Severity.ERROR);
            }
            IssueTypeImpl issueType = new IssueTypeImpl(next.getName(), next.getPresentationName(), severities, category, providers.get(next.getProvider()), next.getDescription());
            issueTypeXsdToPojoMap.put(next, issueType);
        }
        return Collections.unmodifiableMap(issueTypeXsdToPojoMap);
    }
}

