/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import com.hello2morrow.sonargraph.integration.access.foundation.e;
import com.hello2morrow.sonargraph.integration.access.model.internal.LineBasedIssueImpl;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Base64;

class HashExtractor {
    private static final String DESCRIPTOR_NAME_PARTS_SEPARATOR = ":";

    private HashExtractor() {
    }

    static LineBasedIssueImpl.PatternInfo extractLineBasedIssuePatternInfo(String hash) {
        assert (hash != null) : "Parameter 'hash' of method 'extractLineBasedIssuePatternInfo' must not be null";
        String[] parts = hash.split(DESCRIPTOR_NAME_PARTS_SEPARATOR);
        assert (parts.length == 5) : "Unexpected format of hash: " + hash;
        String encodedLine = parts[1];
        String lineText = e.g(encodedLine);
        String encodedPrefixHashs = parts[3];
        int[] prefixHashs = HashExtractor.decodeHash(encodedPrefixHashs);
        String encodedPostfixHash = parts[4];
        int[] postfixHashs = HashExtractor.decodeHash(encodedPostfixHash);
        return new LineBasedIssueImpl.PatternInfo(lineText, prefixHashs, postfixHashs);
    }

    static int[] decodeHash(String base64Encoded) {
        if (base64Encoded == null || base64Encoded.length() == 0) {
            return null;
        }
        assert (base64Encoded != null) : "Parameter 'base64Encoded' of method 'decodeHash' must not be null";
        byte[] decodeBuffer = Base64.getDecoder().decode(base64Encoded);
        int[] hash = new int[decodeBuffer.length / 4];
        ByteBuffer buffer = ByteBuffer.allocate(4);
        int i2 = 0;
        int k2 = 0;
        while (i2 < decodeBuffer.length) {
            buffer.put(decodeBuffer, i2, 4);
            HashExtractor.flip(buffer);
            hash[k2] = buffer.getInt();
            HashExtractor.flip(buffer);
            i2 += 4;
            ++k2;
        }
        return hash;
    }

    private static void flip(Buffer buffer) {
        assert (buffer != null) : "Parameter 'buffer' of method 'flip' must not be null";
        buffer.flip();
    }
}

