/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.foundation.e;
import com.hello2morrow.sonargraph.integration.access.model.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.integration.access.model.IAnalyzer;
import com.hello2morrow.sonargraph.integration.access.model.IAnalyzerConfiguration;
import com.hello2morrow.sonargraph.integration.access.model.IComponentFilter;
import com.hello2morrow.sonargraph.integration.access.model.IExternal;
import com.hello2morrow.sonargraph.integration.access.model.IFeature;
import com.hello2morrow.sonargraph.integration.access.model.IFilter;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssueCategory;
import com.hello2morrow.sonargraph.integration.access.model.IIssueProvider;
import com.hello2morrow.sonargraph.integration.access.model.IIssueType;
import com.hello2morrow.sonargraph.integration.access.model.IMetricCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricProvider;
import com.hello2morrow.sonargraph.integration.access.model.IMetricThreshold;
import com.hello2morrow.sonargraph.integration.access.model.IMetricValue;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IPlugin;
import com.hello2morrow.sonargraph.integration.access.model.IPluginConfiguration;
import com.hello2morrow.sonargraph.integration.access.model.IPluginExternal;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFile;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFileElement;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import com.hello2morrow.sonargraph.integration.access.model.internal.ExternalImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MetaDataAccessImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MetricThreshold;
import com.hello2morrow.sonargraph.integration.access.model.internal.ModuleImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementContainerImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementRegistry;
import com.hello2morrow.sonargraph.integration.access.model.internal.PluginConfigurationImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.PluginExternalImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.SourceFileImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class SoftwareSystemImpl
extends NamedElementContainerImpl
implements ISoftwareSystem {
    private static final long serialVersionUID = -4666348701032432245L;
    private final Map<String, ModuleImpl> modules = new LinkedHashMap<String, ModuleImpl>();
    private final Map<String, ExternalImpl> externals = new LinkedHashMap<String, ExternalImpl>();
    private final Map<String, PluginExternalImpl> pluginExternals = new LinkedHashMap<String, PluginExternalImpl>();
    private final Map<String, IIssueProvider> issueProviders = new HashMap<String, IIssueProvider>();
    private final Map<String, IIssueType> issueTypes = new HashMap<String, IIssueType>();
    private final Map<IIssueType, List<IIssue>> issueMap = new HashMap<IIssueType, List<IIssue>>();
    private final Map<String, IAnalyzer> analyzerMap = new HashMap<String, IAnalyzer>();
    private final Map<String, IPlugin> pluginMap = new HashMap<String, IPlugin>();
    private final Map<String, IFeature> featuresMap = new HashMap<String, IFeature>();
    private final List<String> duplicateCodeConfigurationEntries = new ArrayList<String>();
    private final List<String> scriptRunnerConfigurationEntries = new ArrayList<String>();
    private final List<String> architectureCheckConfigurationEntries = new ArrayList<String>();
    private final List<IMetricThreshold> thresholds = new ArrayList<IMetricThreshold>();
    private final Map<String, IAnalyzerConfiguration> analyzerIdToConfigurationMap = new HashMap<String, IAnalyzerConfiguration>();
    private final Map<String, IPluginConfiguration> pluginIdToConfigurationMap = new HashMap<String, IPluginConfiguration>();
    private final List<ISystemFile> systemFiles = new ArrayList<ISystemFile>();
    private final List<ISystemFileElement> m_systemFileElements = new ArrayList<ISystemFileElement>();
    private final Map<ResolutionType, ArrayList<IResolution>> resolutionMap = new EnumMap<ResolutionType, ArrayList<IResolution>>(ResolutionType.class);
    private final Map<IIssue, IResolution> issueToResolution = new HashMap<IIssue, IResolution>();
    private final Map<NamedElementImpl, SourceFileImpl> namedElementToSourceFile = new HashMap<NamedElementImpl, SourceFileImpl>();
    private final String systemId;
    private final String path;
    private final String version;
    private final String virtualModel;
    private final long timestamp;
    private String baseDir;
    private final AnalyzerExecutionLevel analyzerExecutionLevel;
    private IFilter workspaceFilter;
    private IComponentFilter productionCodeFilter;
    private IComponentFilter issueFilter;
    private int numberOfIssues = 0;
    private final Map<String, String> metaData = new HashMap<String, String>();
    private String m_contextInfo;

    public SoftwareSystemImpl(String kind, String presentationKind, String systemId, String name, String description, String path, String version, long timestamp, String virtualModel, AnalyzerExecutionLevel analyzerExecutionLevel) {
        this(kind, presentationKind, systemId, name, description, path, null, version, timestamp, virtualModel, analyzerExecutionLevel);
    }

    public SoftwareSystemImpl(String kind, String presentationKind, String systemId, String name, String description, String path, String baseDir, String version, long timestamp, String virtualModel, AnalyzerExecutionLevel analyzerExecutionLevel) {
        super(kind, presentationKind, name, name, name, description, new MetaDataAccessImpl(path, systemId, version, timestamp), new NamedElementRegistry(), "SoftwareSystem");
        assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'SoftwareSystem' must not be empty";
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'SoftwareSystem' must not be empty";
        assert (version != null && version.length() > 0) : "Parameter 'version' of method 'SoftwareSystem' must not be empty";
        assert (timestamp > 0L) : "Parameter 'timestamp' of method 'SoftwareSystem' must be > 0";
        assert (virtualModel != null && virtualModel.length() > 0) : "Parameter 'virtualModel' of method 'SoftwareSystemImpl' must not be empty";
        assert (analyzerExecutionLevel != null) : "Parameter 'analyzerExecutionLevel' of method 'SoftwareSystemImpl' must not be null";
        this.systemId = systemId;
        this.path = path;
        if (baseDir == null) {
            int lastIndexOf = path.lastIndexOf(47);
            if (lastIndexOf == -1) {
                lastIndexOf = path.lastIndexOf(92);
            }
            assert (lastIndexOf != -1) : "Invalid path for system file: " + path;
            this.baseDir = e.a(path.substring(0, lastIndexOf));
        } else {
            this.baseDir = baseDir;
        }
        this.version = version;
        this.timestamp = timestamp;
        this.virtualModel = virtualModel;
        this.analyzerExecutionLevel = analyzerExecutionLevel;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, IModule> getModules() {
        LinkedHashMap map = new LinkedHashMap();
        this.modules.values().stream().forEach(module -> {
            IModule iModule = map.put(module.getName(), module);
        });
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Optional<IModule> getModule(String simpleName) {
        assert (simpleName != null && simpleName.length() > 0) : "Parameter 'name' of method 'getModule' must not be empty";
        String key = "Workspace:" + simpleName;
        if (this.modules.containsKey(key)) {
            return Optional.of((IModule)this.modules.get(key));
        }
        return Optional.empty();
    }

    public void addModule(ModuleImpl moduleImpl) {
        assert (moduleImpl != null) : "Parameter 'moduleImpl' of method 'addModule' must not be null";
        this.modules.put(moduleImpl.getFqName(), moduleImpl);
    }

    public void setWorkspaceFilter(IFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'addWorkspaceFilter' must not be null";
        this.workspaceFilter = filter;
    }

    @Override
    public Optional<IFilter> getWorkspaceFilter() {
        return Optional.ofNullable(this.workspaceFilter);
    }

    public void setWorkspaceFileFilter(IFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'addWorkspaceFileFilter' must not be null";
        this.workspaceFilter = filter;
    }

    public void setProductionCodeFilter(IComponentFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'setProductionCodeFilter' must not be null";
        this.productionCodeFilter = filter;
    }

    @Override
    public Optional<IComponentFilter> getProductionCodeFilter() {
        return Optional.ofNullable(this.productionCodeFilter);
    }

    public void setIssueFilter(IComponentFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'setIssueFilter' must not be null";
        this.issueFilter = filter;
    }

    @Override
    public Optional<IComponentFilter> getIssueFilter() {
        return Optional.ofNullable(this.issueFilter);
    }

    public void addExternal(ExternalImpl externalImpl) {
        assert (externalImpl != null) : "Parameter 'externalImpl' of method 'addExternal' must not be null";
        this.externals.put(externalImpl.getFqName(), externalImpl);
    }

    @Override
    public Map<String, IExternal> getExternals() {
        LinkedHashMap map = new LinkedHashMap();
        this.externals.values().stream().forEach(external -> {
            IExternal iExternal = map.put(external.getName(), external);
        });
        return Collections.unmodifiableMap(map);
    }

    public void addPluginExternal(PluginExternalImpl pluginExternalImpl) {
        assert (pluginExternalImpl != null) : "Parameter 'pluginExternalImpl' of method 'addPluginExternal' must not be null";
        this.pluginExternals.put(pluginExternalImpl.getFqName(), pluginExternalImpl);
    }

    @Override
    public Map<String, IPluginExternal> getPluginExternals() {
        LinkedHashMap map = new LinkedHashMap();
        this.pluginExternals.values().stream().forEach(external -> {
            IPluginExternal iPluginExternal = map.put(external.getName(), external);
        });
        return Collections.unmodifiableMap(map);
    }

    public void addIssueProvider(IIssueProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'addIssueProvider' must not be null";
        assert (!this.issueProviders.containsKey(provider.getName())) : "IssueProvider '" + provider.getName() + "' has already been added";
        this.issueProviders.put(provider.getName(), provider);
    }

    public Map<String, IIssueProvider> getIssueProviders() {
        return Collections.unmodifiableMap(this.issueProviders);
    }

    public Map<String, IIssueType> getIssueTypes() {
        return Collections.unmodifiableMap(this.issueTypes);
    }

    public void addIssueType(IIssueType issueType) {
        assert (issueType != null) : "Parameter 'issueType' of method 'addIssueType' must not be null";
        assert (!this.issueTypes.containsKey(issueType.getName())) : "issueType '" + issueType + "has already been added";
        this.issueTypes.put(issueType.getName(), issueType);
        this.issueMap.put(issueType, new ArrayList());
    }

    public void addIssue(IIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addIssue' must not be null";
        assert (this.issueMap.containsKey(issue.getIssueType())) : "issueType '" + issue.getIssueType() + "' has not beend added";
        List<IIssue> issues = this.issueMap.get(issue.getIssueType());
        assert (issues != null) : "'issues' of method 'addIssue' must not be null";
        issues.add(issue);
    }

    public Map<IIssueType, List<IIssue>> getIssues() {
        return Collections.unmodifiableMap(this.issueMap);
    }

    public void setNumberOfIssues(int numberOfIssues) {
        assert (numberOfIssues >= 0) : "Parameter 'numberOfIssues' of method 'setNumberOfIssues' must be >= 0";
        this.numberOfIssues = numberOfIssues;
    }

    public int getNumberOfIssues() {
        assert (this.numberOfIssues == this.issueMap.values().stream().mapToInt(i2 -> i2.size()).sum()) : "Number of issues does not match";
        return this.numberOfIssues;
    }

    public void addMetricId(IMetricId metricId) {
        assert (metricId != null) : "Parameter 'metricId' of method 'addMetricId' must not be null";
        this.getMetaDataAccess().addMetricId(metricId);
    }

    public Map<String, IMetricId> getMetricIds() {
        return this.getMetaDataAccess().getMetricIds();
    }

    public void addAnalyzer(IAnalyzer analyzer) {
        assert (analyzer != null) : "Parameter 'analyzer' of method 'addAnalyzer' must not be null";
        assert (!this.analyzerMap.containsKey(analyzer.getName())) : "Analyzer '" + analyzer.getName() + "' has already been added";
        this.analyzerMap.put(analyzer.getName(), analyzer);
    }

    public void addPlugin(IPlugin plugin) {
        assert (plugin != null) : "Parameter 'plugin' of method 'addPlugin' must not be null";
        assert (!this.pluginMap.containsKey(plugin.getName())) : "Plugin '" + plugin.getName() + "' has already been added";
        this.pluginMap.put(plugin.getName(), plugin);
    }

    @Override
    public AnalyzerExecutionLevel getAnalyzerExecutionLevel() {
        return this.analyzerExecutionLevel;
    }

    @Override
    public Map<String, IAnalyzer> getAnalyzers() {
        return Collections.unmodifiableMap(this.analyzerMap);
    }

    @Override
    public Map<String, IPlugin> getPlugins() {
        return Collections.unmodifiableMap(this.pluginMap);
    }

    public void addFeature(IFeature feature) {
        assert (feature != null) : "Parameter 'feature' of method 'addFeature' must not be null";
        assert (!this.featuresMap.containsKey(feature.getName())) : "Feature '" + feature.getName() + "' has already been added";
        this.featuresMap.put(feature.getName(), feature);
    }

    public Map<String, IFeature> getFeatures() {
        return Collections.unmodifiableMap(this.featuresMap);
    }

    public void addDuplicateCodeConfigurationEntry(String entry) {
        assert (entry != null && entry.length() > 0) : "Parameter 'entry' of method 'addDuplicateCodeConfigurationEntry' must not be empty";
        this.duplicateCodeConfigurationEntries.add(entry);
    }

    public List<String> getDuplicateCodeConfigurationEntries() {
        return Collections.unmodifiableList(this.duplicateCodeConfigurationEntries);
    }

    public void addScriptRunnerConfigurationEntry(String entry) {
        assert (entry != null && entry.length() > 0) : "Parameter 'entry' of method 'addScriptRunnerConfigurationEntry' must not be empty";
        this.scriptRunnerConfigurationEntries.add(entry);
    }

    public List<String> getScriptRunnerConfigurationEntries() {
        return Collections.unmodifiableList(this.scriptRunnerConfigurationEntries);
    }

    public void addArchitectureCheckConfigurationEntry(String entry) {
        assert (entry != null && entry.length() > 0) : "Parameter 'entry' of method 'addArchitectureCheckConfigurationEntry' must not be empty";
        this.architectureCheckConfigurationEntries.add(entry);
    }

    public List<String> getArchitectureCheckConfigurationEntries() {
        return Collections.unmodifiableList(this.architectureCheckConfigurationEntries);
    }

    public void addResolution(IResolution resolution) {
        ArrayList<Object> resolutions;
        assert (resolution != null) : "Parameter 'resolution' of method 'addResolution' must not be null";
        if (!this.resolutionMap.containsKey(resolution.getType())) {
            resolutions = new ArrayList();
            this.resolutionMap.put(resolution.getType(), resolutions);
        } else {
            resolutions = this.resolutionMap.get(resolution.getType());
        }
        resolutions.add(resolution);
        for (IIssue nextIssue : resolution.getIssues()) {
            this.issueToResolution.put(nextIssue, resolution);
        }
    }

    public IResolution getResolution(IIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getResolution' must not be null";
        return this.issueToResolution.get(issue);
    }

    public final Optional<IMetricValue> getSystemMetricValue(IMetricId metricId) {
        assert (metricId != null) : "Parameter 'metricId' of method 'getSystemMetricValue' must not be null";
        return super.getMetricValueForElement(metricId, this.getMetaDataAccess().getMetricLevels().get("System"), this.getName());
    }

    public void addMetricCategory(IMetricCategory metricCategory) {
        assert (metricCategory != null) : "Parameter 'metricCategory' of method 'addMetricCategory' must not be null";
        this.getMetaDataAccess().addMetricCategory(metricCategory);
    }

    public Map<String, IMetricCategory> getMetricCategories() {
        return this.getMetaDataAccess().getMetricCategories();
    }

    @Override
    public Map<String, IMetricLevel> getMetricLevels() {
        HashMap<String, IMetricLevel> systemMetricLevel = new HashMap<String, IMetricLevel>();
        systemMetricLevel.put("System", this.getMetaDataAccess().getMetricLevel("System"));
        return Collections.unmodifiableMap(systemMetricLevel);
    }

    public void addMetricProvider(IMetricProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'addMetricProvider' must not be null";
        this.getMetaDataAccess().addMetricProvider(provider);
    }

    public Map<String, IMetricProvider> getMetricProviders() {
        return this.getMetaDataAccess().getMetricProviders();
    }

    public void addIssueCategory(IIssueCategory category) {
        assert (category != null) : "Parameter 'category' of method 'addIssueCategory' must not be null";
        this.getMetaDataAccess().addIssueCategory(category);
    }

    public Map<String, IIssueCategory> getIssueCategories() {
        return this.getMetaDataAccess().getIssueCategories();
    }

    @Override
    public String getVirtualModel() {
        return this.virtualModel;
    }

    public Map<ResolutionType, List<IResolution>> getResolutions() {
        return Collections.unmodifiableMap(this.resolutionMap);
    }

    public void addMetricThreshold(MetricThreshold threshold) {
        this.thresholds.add(threshold);
    }

    public List<IMetricThreshold> getMetricThresholds() {
        return Collections.unmodifiableList(this.thresholds);
    }

    public void addSourceFile(NamedElementImpl forNamedElement, SourceFileImpl sourceFile) {
        assert (forNamedElement != null) : "Parameter 'forNamedElement' of method 'addSourceFile' must not be null";
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'addSourceFile' must not be null";
        SourceFileImpl previous = this.namedElementToSourceFile.put(forNamedElement, sourceFile);
        assert (previous == null) : "'previous' of method 'addSourceFile' must be null";
    }

    public Optional<SourceFileImpl> getSourceFile(INamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getSourceFile' must not be null";
        return Optional.ofNullable(this.namedElementToSourceFile.get(namedElement));
    }

    public void setBaseDir(String baseDirectory) {
        assert (baseDirectory != null && baseDirectory.length() > 0) : "Parameter 'baseDirectory' of method 'setBaseDir' must not be empty";
        this.baseDir = baseDirectory;
    }

    @Override
    public Map<String, String> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public String addMetaData(String key, String value) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'addMetaData' must not be empty";
        assert (value != null) : "Parameter 'value' of method 'addMetaData' must not be null";
        return this.metaData.put(key, value);
    }

    public Map<String, IAnalyzerConfiguration> getAnalyzerConfigurations() {
        return Collections.unmodifiableMap(this.analyzerIdToConfigurationMap);
    }

    public void addAnalyzerConfiguration(IAnalyzerConfiguration configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'addAnalyzerConfiguration' must not be null";
        this.analyzerIdToConfigurationMap.put(configuration.getName(), configuration);
    }

    public void addPluginConfiguration(PluginConfigurationImpl pluginConfiguration) {
        assert (pluginConfiguration != null) : "Parameter 'pluginConfiguration' of method 'addPluginConfiguration' must not be null";
        this.pluginIdToConfigurationMap.put(pluginConfiguration.getName(), pluginConfiguration);
    }

    public Map<String, IPluginConfiguration> getPluginConfigurations() {
        return Collections.unmodifiableMap(this.pluginIdToConfigurationMap);
    }

    public void setContextInfo(String contextInfo) {
        assert (contextInfo != null) : "Parameter 'contextInfo' of method 'setContextInfo' must not be null";
        this.m_contextInfo = contextInfo;
    }

    @Override
    public String getContextInfo() {
        return this.m_contextInfo;
    }

    public List<ISystemFile> getSystemFiles() {
        return Collections.unmodifiableList(this.systemFiles);
    }

    public void addSystemFile(ISystemFile systemFile) {
        assert (systemFile != null) : "Parameter 'systemFile' of method 'addSystemFile' must not be null";
        this.systemFiles.add(systemFile);
    }

    public void addSystemFileElement(ISystemFileElement systemFile) {
        assert (systemFile != null) : "Parameter 'systemFile' of method 'addSystemFileElement' must not be null";
        this.m_systemFileElements.add(systemFile);
    }

    public List<ISystemFileElement> getSystemFileElements() {
        return Collections.unmodifiableList(this.m_systemFileElements);
    }
}

