/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.foundation.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public final class LogbackConfigurator {
    private static final String ROOT_LOGGER_NAME = "Root";

    private LogbackConfigurator() {
    }

    private static OS getOS() {
        String osName = System.getProperty("os.name", "unknown").trim().toLowerCase();
        if (osName.contains("windows")) {
            return OS.WINDOWS;
        }
        if (osName.contains("mac") && osName.contains("x")) {
            return OS.MAC;
        }
        return OS.LINUX;
    }

    private static boolean isAbsolute(OS os, String path) {
        assert (os != null) : "Parameter 'os' of method 'isAbsolute' must not be null";
        assert (path != null) : "Parameter 'path' of method 'isAbsolute' must not be null";
        switch (os) {
            case WINDOWS: {
                return path.length() >= 3 && path.charAt(1) == ':' && (path.charAt(2) == '\\' || path.charAt(2) == '/');
            }
            case MAC: 
            case LINUX: {
                return path.startsWith("/");
            }
        }
        assert (false) : "Unknown os: " + (Object)((Object)os);
        return false;
    }

    private static URL getConfigUrl(OS os, File searchInDirectory, Class<?> searchInClassPath) {
        assert (os != null) : "Parameter 'os' of method 'getConfigUrl' must not be null";
        File file = null;
        try {
            System.out.println("Checking property 'logback.configurationFile'.");
            String logbackConfig = System.getProperty("logback.configurationFile");
            if (logbackConfig != null) {
                System.out.println("Found property 'logback.configurationFile' with value '" + logbackConfig + "'");
                if (LogbackConfigurator.isAbsolute(os, logbackConfig)) {
                    file = new File(logbackConfig);
                    if (file.exists() && !file.isDirectory() && file.canRead()) {
                        return file.toURI().toURL();
                    }
                    System.err.println("Unable to read file: " + file.getCanonicalPath());
                } else {
                    file = new File(new File("."), logbackConfig);
                    if (file.exists() && !file.isDirectory() && file.canRead()) {
                        return file.toURI().toURL();
                    }
                    System.err.println("Unable to read file: " + file.getCanonicalPath());
                }
            } else if (searchInDirectory != null) {
                System.out.println("Checking directory '" + searchInDirectory.getAbsolutePath() + "' for 'logback.xml'");
                file = new File(searchInDirectory, "logback.xml");
                if (file.exists() && !file.isDirectory() && file.canRead()) {
                    return file.toURI().toURL();
                }
            }
        }
        catch (Exception e2) {
            System.err.println("Unable determine URL of logback configuration file" + (file != null ? " '" + file.getAbsolutePath() + "':" : ":") + e2);
        }
        if (searchInClassPath != null) {
            System.out.println("Checking classpath for 'logback.xml'");
            URL resourceUrl = searchInClassPath.getResource("/logback.xml");
            if (resourceUrl != null) {
                return resourceUrl;
            }
        }
        return null;
    }

    private static final FileAppender<ILoggingEvent> getFileAppender() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)loggerFactory;
            for (Logger logger : context.getLoggerList()) {
                Iterator index = logger.iteratorForAppenders();
                while (index.hasNext()) {
                    Appender appender = (Appender)index.next();
                    if (!(appender instanceof FileAppender)) continue;
                    return (FileAppender)appender;
                }
            }
        } else if (loggerFactory != null) {
            LoggerFactory.getLogger(LogbackConfigurator.class).warn("Unexpected ILoggerFactory implementation '" + loggerFactory.getClass().getName() + "'");
        } else {
            System.err.println("No logger factory configured");
        }
        return null;
    }

    private static String getLogFileDirectory(OS os, String logFileDirectory) {
        String directoryPath;
        assert (logFileDirectory != null && logFileDirectory.length() > 0) : "Parameter 'logFileDirectory' of method 'getLogFileDirectory' must not be empty";
        String userHome = System.getProperty("user.home");
        switch (os) {
            case WINDOWS: {
                String appDataEnvVar = System.getenv("APPDATA");
                if (appDataEnvVar == null) {
                    appDataEnvVar = String.format("%s\\AppData\\Roaming", userHome);
                }
                directoryPath = String.format("%s\\hello2morrow\\Sonargraph\\%s", appDataEnvVar, logFileDirectory);
                break;
            }
            case MAC: {
                directoryPath = String.format("%s/Library/Application Support/hello2morrow/Sonargraph/%s", userHome, logFileDirectory);
                break;
            }
            case LINUX: {
                directoryPath = String.format("%s/.hello2morrow/Sonargraph/%s", userHome, logFileDirectory);
                break;
            }
            default: {
                directoryPath = "";
                assert (false) : "Unhandled os: " + (Object)((Object)os);
                break;
            }
        }
        File directory = new File(directoryPath);
        directory.mkdirs();
        return directory.getAbsolutePath();
    }

    private static RollingFileAppender<ILoggingEvent> configureLogFileAppender(LoggerContext loggerContext, String logFileDirectory) {
        assert (loggerContext != null) : "Parameter 'loggerContext' of method 'configureLogFileAppender' must not be null";
        assert (logFileDirectory != null && logFileDirectory.length() > 0) : "Parameter 'logFileDirectory' of method 'configureLogFileAppender' must not be empty";
        PatternLayoutEncoder logFileEncoder = new PatternLayoutEncoder();
        logFileEncoder.setContext((Context)loggerContext);
        logFileEncoder.setPattern("%date %level [%thread{20}] %logger %msg%n");
        logFileEncoder.start();
        RollingFileAppender logFileAppender = new RollingFileAppender();
        logFileAppender.setContext((Context)loggerContext);
        logFileAppender.setName("logFile");
        logFileAppender.setEncoder((Encoder)logFileEncoder);
        logFileAppender.setAppend(true);
        logFileAppender.setFile(String.valueOf(logFileDirectory) + "/sonargraph.log");
        TimeBasedRollingPolicy logFilePolicy = new TimeBasedRollingPolicy();
        logFilePolicy.setContext((Context)loggerContext);
        logFilePolicy.setParent((FileAppender)logFileAppender);
        logFilePolicy.setFileNamePattern("sonargraph-%d{yyyy_MM_dd}.log");
        logFilePolicy.setMaxHistory(10);
        logFilePolicy.setCleanHistoryOnStart(true);
        logFilePolicy.start();
        logFileAppender.setRollingPolicy((RollingPolicy)logFilePolicy);
        logFileAppender.start();
        return logFileAppender;
    }

    public static void configure(String logFileDirectory, File searchInDirectory, Class<?> searchInClassPath) {
        assert (logFileDirectory != null && logFileDirectory.length() > 0) : "Parameter 'logFileDirectory' of method 'configure' must not be empty";
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (!(loggerFactory instanceof LoggerContext)) {
            if (loggerFactory == null) {
                System.err.println("Unable to configure logging - no logger factory created");
            } else {
                System.err.println("Unable to configure logger factory '" + loggerFactory.getClass() + "'");
            }
            return;
        }
        OS os = LogbackConfigurator.getOS();
        String inputMsg = "Configure logback [OS='" + (Object)((Object)os) + "', " + "logFileDirectory='" + logFileDirectory + "'" + (searchInDirectory != null ? ", searchInDirectory='" + searchInDirectory + "'" : "") + (searchInClassPath != null ? ", searchInCasspath='" + searchInClassPath.getName() + "'" : "") + "]";
        System.out.println(inputMsg);
        LoggerContext loggerContext = (LoggerContext)loggerFactory;
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext((Context)loggerContext);
        loggerContext.reset();
        URL configFileUrl = LogbackConfigurator.getConfigUrl(os, searchInDirectory, searchInClassPath);
        boolean useFallback = true;
        if (configFileUrl != null) {
            try {
                String urlMsg = "Using file url to configure logback '" + configFileUrl.toString() + "'";
                System.out.println(urlMsg);
                InputStream configurationStream = configFileUrl.openStream();
                joranConfigurator.doConfigure(configurationStream);
                configurationStream.close();
                FileAppender<ILoggingEvent> fileAppender = LogbackConfigurator.getFileAppender();
                if (fileAppender == null) {
                    RollingFileAppender<ILoggingEvent> logFileAppender = LogbackConfigurator.configureLogFileAppender(loggerContext, LogbackConfigurator.getLogFileDirectory(os, logFileDirectory));
                    Logger log = loggerContext.getLogger(ROOT_LOGGER_NAME);
                    log.addAppender(logFileAppender);
                    String msg = "Logback successfully configured - auto-configured log file path '" + logFileAppender.getFile() + "'";
                    System.out.println(msg);
                    LoggerFactory.getLogger(LogbackConfigurator.class).info(inputMsg);
                    LoggerFactory.getLogger(LogbackConfigurator.class).info(urlMsg);
                    LoggerFactory.getLogger(LogbackConfigurator.class).info(msg);
                } else {
                    String msg = "Logback successfully configured - user defined log file path '" + fileAppender.getFile() + "'";
                    System.out.println(msg);
                    LoggerFactory.getLogger(LogbackConfigurator.class).info(inputMsg);
                    LoggerFactory.getLogger(LogbackConfigurator.class).info(urlMsg);
                    LoggerFactory.getLogger(LogbackConfigurator.class).info(msg);
                }
                useFallback = false;
            }
            catch (Exception e2) {
                System.err.println("Unable to initialize logback: " + e2);
            }
        }
        if (useFallback) {
            PatternLayoutEncoder consoleLogEncoder = new PatternLayoutEncoder();
            consoleLogEncoder.setContext((Context)loggerContext);
            consoleLogEncoder.setPattern("%d{HH:mm:ss.SSS} %level [%thread{20}|%logger{30}] (%file:%line\\) %msg%n");
            consoleLogEncoder.start();
            ConsoleAppender logConsoleAppender = new ConsoleAppender();
            logConsoleAppender.setContext((Context)loggerContext);
            logConsoleAppender.setName("console");
            logConsoleAppender.setEncoder((Encoder)consoleLogEncoder);
            logConsoleAppender.start();
            RollingFileAppender<ILoggingEvent> logFileAppender = LogbackConfigurator.configureLogFileAppender(loggerContext, LogbackConfigurator.getLogFileDirectory(os, logFileDirectory));
            Logger log = loggerContext.getLogger(ROOT_LOGGER_NAME);
            log.setAdditive(false);
            log.setLevel(Level.TRACE);
            log.addAppender((Appender)logConsoleAppender);
            log.addAppender(logFileAppender);
            String msg = "Logback successfully configured using fallback - log file path '" + logFileAppender.getFile() + "'";
            System.out.println(msg);
            LoggerFactory.getLogger(LogbackConfigurator.class).info(inputMsg);
            LoggerFactory.getLogger(LogbackConfigurator.class).info(msg);
        }
    }

    public static File getLogFile() {
        File logFile;
        String logFilePath;
        FileAppender<ILoggingEvent> fileAppender = LogbackConfigurator.getFileAppender();
        if (fileAppender != null && (logFilePath = fileAppender.getFile()) != null && !logFilePath.isEmpty() && (logFile = new File(logFilePath)).exists() && !logFile.isDirectory() && logFile.canRead()) {
            return logFile.getAbsoluteFile();
        }
        return null;
    }

    public static void setRootLogLevel(String level) {
        assert (level != null) : "Parameter 'level' of method 'setRootLogLevel' must not be null";
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger rootLogger = lc.getLogger("ROOT");
        rootLogger.info("Setting log level to '" + level + "'");
        Level logLevel = Level.toLevel((String)level);
        rootLogger.setLevel(logLevel);
    }

    static enum OS {
        WINDOWS,
        MAC,
        LINUX;

    }
}

