/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.d;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class j
implements IResourceChangeListener,
IElementChangedListener {
    private static final Logger b = LoggerFactory.getLogger(j.class);
    private final ISoftwareSystemProvider c;
    private boolean d = false;
    private final IEventBroker e;

    public j(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'SonargraphResourceChangeListener' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'SonargraphEclipseWorkspaceChangeListener' must not be null";
        this.c = systemProvider;
        this.e = eventBroker;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        if (!this.d) {
            this.a(delta);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.c.hasSoftwareSystem()) {
            b.error("No system is opened, but workspace change listener is still active and will be deactivated now.");
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            return;
        }
        if (this.d) {
            return;
        }
        if (b.isTraceEnabled()) {
            b.trace("\n------------------- event type [" + event.getType() + "]--------------------");
            if (event.getSource() instanceof IProject) {
                b.trace("Change scope: Eclipse Project");
            } else if (event.getSource() instanceof IWorkspace) {
                b.trace("Change scope: Eclipse Workspace");
            } else {
                b.trace("Change scope: " + event.getSource().getClass().getName());
            }
        }
        switch (event.getType()) {
            case 2: {
                if (EclipseWorkspaceUtils.isSonargraphResource(event.getResource())) {
                    if (b.isDebugEnabled()) {
                        b.debug("Pre close of project {}", (Object)event.getResource());
                    }
                    this.a(event.getResource().getName());
                }
                return;
            }
            case 4: {
                if (EclipseWorkspaceUtils.isSonargraphResource(event.getResource())) {
                    if (b.isDebugEnabled()) {
                        b.debug("Pre delete of project {}", (Object)event.getResource());
                    }
                    this.a(event.getResource().getName());
                }
                return;
            }
            case 1: {
                if (!b.isTraceEnabled()) break;
                b.trace("Post change!");
                break;
            }
            default: {
                if (!b.isTraceEnabled()) break;
                b.trace("Event type: " + event.getType());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(IJavaElementDelta delta) {
        if (this.d) {
            return;
        }
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                this.b(delta);
                return;
            }
            case 2: {
                if (!EclipseWorkspaceUtils.isSonargraphResource(element.getResource())) return;
                if (this.a(delta.getFlags())) {
                    b.debug("Project closed: " + element.getElementName());
                    this.a(element.getElementName());
                    return;
                }
                if (!this.b(delta.getFlags()) || !(element instanceof IJavaProject)) return;
                IJavaProject javaProject = (IJavaProject)element;
                IProject project = javaProject.getProject();
                try {
                    ModuleInfo projectInfo = EclipseWorkspaceUtils.convertToModuleInfo(project);
                    Workspace workspace = (Workspace)this.c.getSoftwareSystem().getUniqueExistingChild(Workspace.class);
                    Object moduleName = project.getSessionProperty(com.hello2morrow.sonargraph.ide.eclipse.foundation.common.d.q);
                    JavaModule module = (JavaModule)workspace.getUniqueChild((NamedElement.IFilter)new ShortNameFilter(moduleName.toString()), JavaModule.class);
                    if (this.b(module, projectInfo)) {
                        b.info("Active root paths changed of project: " + project.getName() + ", resource: " + element.getResource().getName());
                        this.a(project.getName());
                        return;
                    }
                    if (!this.a(module, projectInfo)) return;
                    b.info("Inactive root paths are now present in project: " + project.getName() + ", resource: " + element.getResource().getName());
                    this.a(project.getName());
                    return;
                }
                catch (JavaModelException ex) {
                    b.error("Failed to convert project '" + project.getName() + "' to module info: ", (Throwable)ex);
                    UserInterfaceAdapter.b().c("Failed to Convert Project", "Failed to process project '" + project.getName() + "'");
                    this.a(project.getName());
                    return;
                }
                catch (CoreException ex) {
                    b.error("Failed to get module name property from project '" + project.getName() + "': ", (Throwable)ex);
                    UserInterfaceAdapter.b().c("Failed to Get Module Name", "Failed to get module name of project '" + project.getName() + "'");
                    this.a(project.getName());
                    return;
                }
            }
        }
    }

    private boolean a(int flags) {
        boolean closed = (flags & 0x400) != 0;
        return closed;
    }

    private void b(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n2 = iJavaElementDeltaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IJavaElementDelta nextDelta = iJavaElementDeltaArray[n3];
            if (this.d) {
                return;
            }
            this.a(nextDelta);
            ++n3;
        }
    }

    private final boolean b(int flags) {
        boolean changed = (flags & 0x200000) != 0;
        return changed;
    }

    private void a(String projectName) {
        assert (projectName != null && projectName.length() > 0) : "Parameter 'projectName' of method 'closeSoftwareSystem' must not be empty";
        this.d = true;
        if (!this.c.hasSoftwareSystem()) {
            return;
        }
        com.hello2morrow.sonargraph.ide.eclipse.jobs.d closeJob = new com.hello2morrow.sonargraph.ide.eclipse.jobs.d(this.e, this.c, "Sonargraph analysis will be suspended due to detected workspace changes in project '" + projectName + "'.\n" + "Resume the Sonargraph analysis when you are finished with the modifications.");
        closeJob.schedule();
    }

    private boolean a(JavaModule module, ModuleInfo projectInfo) {
        assert (module != null) : "Parameter 'module' of method 'areInactiveRootPathsNowPresent' must not be null";
        assert (projectInfo != null) : "Parameter 'projectInfo' of method 'areInactiveRootPathsNowPresent' must not be null";
        List projectSrcRoots = projectInfo.getNonStandardRootPaths().stream().map(r2 -> r2.getPath()).collect(Collectors.toList());
        List inactiveModuleScrRoots = module.getChildren(JavaSourceRootDirectoryPath.class).stream().filter(r2 -> !r2.isEnabled()).map(r2 -> FileUtility.getIdentifyingPath((TFile)r2.getFile())).collect(Collectors.toList());
        List inactiveSourceRoots = inactiveModuleScrRoots.stream().filter(r2 -> projectSrcRoots.contains(r2)).collect(Collectors.toList());
        if (inactiveSourceRoots.size() > 0) {
            b.info("Inactive Sonargraph source root(s) '" + inactiveSourceRoots.stream().collect(Collectors.joining(", ")) + "' now present in project");
            return true;
        }
        List projectClsRoots = projectInfo.getStandardRootPaths().stream().map(r2 -> r2.getPath()).collect(Collectors.toList());
        List inactiveModuleClsRoots = module.getChildren(JavaClassRootDirectoryPath.class).stream().filter(r2 -> !r2.isEnabled()).map(r2 -> FileUtility.getIdentifyingPath((TFile)r2.getFile())).collect(Collectors.toList());
        List inactiveClassRoots = inactiveModuleClsRoots.stream().filter(r2 -> projectClsRoots.contains(r2)).collect(Collectors.toList());
        if (inactiveClassRoots.size() > 0) {
            b.info("Inactive Sonargraph class root(s) '" + inactiveClassRoots.stream().collect(Collectors.joining(", ")) + "' now present in project");
            return true;
        }
        return false;
    }

    private boolean b(JavaModule module, ModuleInfo projectInfo) {
        assert (module != null) : "Parameter 'module' of method 'haveActiveRootPathsChanged' must not be null";
        assert (projectInfo != null) : "Parameter 'projectInfo' of method 'haveActiveRootPathsChanged' must not be null";
        List srcRoots = module.getChildren(JavaSourceRootDirectoryPath.class);
        List activeSourceRoots = srcRoots.stream().filter(r2 -> r2.isEnabled()).map(r2 -> FileUtility.getIdentifyingPath((TFile)r2.getOriginal().getFile())).collect(Collectors.toList());
        List eclipseSrcRoots = projectInfo.getNonStandardRootPaths().stream().map(r2 -> r2.getPath()).collect(Collectors.toList());
        activeSourceRoots.removeAll(eclipseSrcRoots);
        if (activeSourceRoots.size() > 0) {
            b.info("Active Sonargraph source root(s) '" + activeSourceRoots.stream().collect(Collectors.joining(", ")) + "' no longer present.");
            return true;
        }
        List classRoots = module.getChildren(JavaClassRootDirectoryPath.class);
        List activeClassRoots = classRoots.stream().filter(r2 -> r2.isEnabled()).map(r2 -> FileUtility.getIdentifyingPath((TFile)r2.getOriginal().getFile())).collect(Collectors.toList());
        List eclipseClassRoots = projectInfo.getStandardRootPaths().stream().map(r2 -> r2.getPath()).collect(Collectors.toList());
        activeClassRoots.removeAll(eclipseClassRoots);
        if (activeClassRoots.size() > 0) {
            b.info("Active Sonargraph class root(s) '" + activeClassRoots.stream().collect(Collectors.joining(", ")) + "' no longer present.");
            return true;
        }
        return false;
    }
}

