/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.ide.eclipse.e3.b;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.b.a;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.g;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.w;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class f
extends IncrementalProjectBuilder {
    private static final Logger b = LoggerFactory.getLogger(f.class);

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        ModuleDelta moduleDelta;
        long start = System.currentTimeMillis();
        if (!EclipseWorkspaceUtils.isSonargraphResource((IResource)this.getProject())) {
            return null;
        }
        ISonargraphEclipsePlugin plugin = this.a();
        if (plugin == null) {
            b.info("Sonargraph plugin not yet initialized when builder is triggered for project '{}'", (Object)this.getProject().getName());
            return null;
        }
        ISoftwareSystemProvider provider = this.a(plugin);
        if (provider == null) {
            b.info("No Sonargraph system available when builder is triggered for project '{}'", (Object)this.getProject().getName());
            return null;
        }
        Optional<ModuleInfo> moduleInfoOpt = this.a(plugin, provider);
        if (!moduleInfoOpt.isPresent()) {
            b.info("No Sonargraph module found for project '{}'", (Object)this.getProject().getName());
            return null;
        }
        ModuleInfo moduleInfo = moduleInfoOpt.get();
        JavaModule module = (JavaModule)((Workspace)provider.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new NameFilter(moduleInfo.getName()), JavaModule.class);
        if (module == null) {
            b.error("Failed to determine Sonargraph module '{}' for project '{}'", (Object)moduleInfo.getName(), (Object)this.getProject().getName());
            return null;
        }
        if (b.isDebugEnabled()) {
            b.debug("-----------------------------");
            b.debug("Building project '{}', Sonargraph module '{}'", (Object)this.getProject().getName(), (Object)moduleInfo.getName());
        }
        boolean isIncremental = false;
        FileRegistry fileRegistry = plugin.getFileRegistry();
        if (b.isDebugEnabled()) {
            b.debug("{} ms needed to prepare delta retrieval", (Object)(System.currentTimeMillis() - start));
        }
        long afterPreparation = System.currentTimeMillis();
        if (kind == 6) {
            moduleDelta = this.a(plugin, provider, fileRegistry, module, moduleInfo, monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                moduleDelta = this.a(plugin, provider, fileRegistry, module, moduleInfo, monitor);
            } else {
                isIncremental = true;
                moduleDelta = this.a(plugin, provider, fileRegistry, module, moduleInfo, delta, monitor);
            }
        }
        if (b.isDebugEnabled()) {
            b.debug("{} ms needed to determine delta.", (Object)(System.currentTimeMillis() - afterPreparation));
        }
        if (moduleDelta != null) {
            plugin.getRefreshInfo().addModuleDelta(moduleDelta);
            if (!moduleDelta.isEmpty()) {
                com.hello2morrow.sonargraph.ide.eclipse.jobs.b.a.a(a.class);
            }
        } else {
            b.debug("Delta computation failed for project '{}'", (Object)this.getProject().getName());
            this.forgetLastBuiltState();
        }
        if (b.isDebugEnabled()) {
            b.debug("{} ms needed to do {} build of project '{}'", new Object[]{System.currentTimeMillis() - start, isIncremental ? "an incremental" : "a full", this.getProject().getName()});
            b.debug("-----------------------------");
            b.debug("{} ms needed to determine delta.", (Object)(System.currentTimeMillis() - afterPreparation));
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        ISoftwareSystemProvider provider;
        ISonargraphEclipsePlugin plugin = this.a();
        if (plugin != null && !plugin.isStopping() && (provider = plugin.getSoftwareSystemProvider()) != null) {
            plugin.getMarkerProvider().clear(provider, plugin.getEventBroker(), this.getProject());
        }
    }

    private ModuleDelta a(ISonargraphEclipsePlugin plugin, ISoftwareSystemProvider provider, FileRegistry fileRegistry, JavaModule module, ModuleInfo moduleInfo, IResourceDelta delta, IProgressMonitor monitor) {
        assert (plugin != null) : "Parameter 'plugin' of method 'incrementalBuild' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'incrementalBuild' must not be null";
        assert (fileRegistry != null) : "Parameter 'fileRegistry' of method 'incrementalBuild' must not be null";
        assert (module != null) : "Parameter 'module' of method 'incrementalBuild' must not be null";
        assert (moduleInfo != null) : "Parameter 'moduleInfo' of method 'incrementalBuild' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'incrementalBuild' must not be null";
        assert (monitor != null) : "Parameter 'monitor' of method 'incrementalBuild' must not be null";
        if (b.isDebugEnabled()) {
            b.debug("BUILD INCREMENTAL: " + module.getName());
        }
        w visitor = new w(provider, fileRegistry, module, monitor);
        try {
            delta.accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException ex) {
            b.error("Failed to convert delta of project '{}'", (Object)this.getProject().getName(), (Object)ex);
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        ModuleDelta moduleDelta = visitor.b();
        if (b.isTraceEnabled()) {
            b.trace("\n--------------------\nIncremental delta:\n" + moduleDelta);
        }
        return moduleDelta;
    }

    private ModuleDelta a(ISonargraphEclipsePlugin plugin, ISoftwareSystemProvider provider, FileRegistry fileRegistry, JavaModule module, ModuleInfo moduleInfo, IProgressMonitor monitor) {
        ModuleDelta moduleDelta;
        g visitor;
        block10: {
            assert (plugin != null) : "Parameter 'plugin' of method 'fullBuild' must not be null";
            assert (provider != null) : "Parameter 'provider' of method 'fullBuild' must not be null";
            assert (fileRegistry != null) : "Parameter 'fileRegistry' of method 'fullBuild' must not be null";
            assert (module != null) : "Parameter 'module' of method 'fullBuild' must not be null";
            assert (moduleInfo != null) : "Parameter 'moduleInfo' of method 'fullBuild' must not be null";
            assert (monitor != null) : "Parameter 'monitor' of method 'fullBuild' must not be null";
            if (b.isDebugEnabled()) {
                b.debug("BUILD FULL: " + module.getName());
            }
            visitor = new g(provider, module, monitor);
            moduleDelta = null;
            this.getProject().accept((IResourceVisitor)visitor);
            if (!monitor.isCanceled()) break block10;
            return null;
        }
        try {
            moduleDelta = visitor.b();
        }
        catch (CoreException ex) {
            b.error("Failed to determine files of project '{}'", (Object)this.getProject().getName(), (Object)ex);
        }
        return moduleDelta;
    }

    private Optional<ModuleInfo> a(ISonargraphEclipsePlugin plugin, ISoftwareSystemProvider provider) {
        assert (plugin != null) : "Parameter 'plugin' of method 'getSonargraphModuleOfProject' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'getSonargraphModuleOfProject' must not be null";
        IProject project = this.getProject();
        if (!EclipseWorkspaceUtils.isSonargraphResource((IResource)project)) {
            return Optional.empty();
        }
        SystemMappingInfo systemMapping = plugin.getSystemMapping();
        if (project != null && systemMapping != null) {
            return systemMapping.getSonargraphModuleForExternal(project.getName());
        }
        return Optional.empty();
    }

    private ISoftwareSystemProvider a(ISonargraphEclipsePlugin plugin) {
        ISoftwareSystemProvider provider = plugin.getSoftwareSystemProvider();
        if (provider == null) {
            return null;
        }
        if (!provider.hasSoftwareSystem()) {
            return null;
        }
        return provider;
    }

    private ISonargraphEclipsePlugin a() {
        IEclipseContext context = com.hello2morrow.sonargraph.ide.eclipse.e3.b.a();
        if (context == null) {
            b.debug("No active eclipse context.");
            return null;
        }
        ISonargraphEclipsePlugin plugin = (ISonargraphEclipsePlugin)context.get(ISonargraphEclipsePlugin.class);
        if (plugin == null || !plugin.isInitialized()) {
            b.debug("Plugin has not been initialized");
            return null;
        }
        return plugin;
    }
}

