/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.foundation.event.EventHandler;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.file.TrueZipFacade;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.client.eclipse.application.EclipseRelease;
import com.hello2morrow.sonargraph.core.command.common.o;
import com.hello2morrow.sonargraph.core.command.common.p;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemClosedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemIssuesModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemOpenedEvent;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.RenewLicenseTicketAutomaticallyHandler;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.b;
import com.hello2morrow.sonargraph.ide.eclipse.e3.E3DecoratorManager;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.d;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.r;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.ide.eclipse.model.IMarkerProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.model.RefreshInfo;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.MarkerController;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.StatusController;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.c;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.g;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.h;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.i;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.j;
import com.hello2morrow.sonargraph.ide.eclipse.view.a;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.O;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.T;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionDialog;
import com.hello2morrow.sonargraph.ui.swt.license.ConnectionMode;
import com.hello2morrow.sonargraph.ui.swt.license.e;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphEclipsePlugin
implements com.hello2morrow.sonargraph.core.application.a,
o.a,
ISonargraphEclipsePlugin,
com.hello2morrow.sonargraph.ui.swt.base.h,
O {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphEclipsePlugin.class);
    @Inject
    private IEclipseContext m_eclipseContext;
    @Inject
    private g m_application;
    @Inject
    private E3DecoratorManager m_decoratorManager;
    @Inject
    private IEventBroker m_eventBroker;
    @Inject
    private StatusController m_statusController;
    @Inject
    private MarkerController m_markerProvider;
    @Inject
    private org.eclipse.e4.core.services.log.Logger m_logger;
    private Display m_display;
    private final FileRegistry m_fileRegistry = new FileRegistry();
    private final RefreshInfo m_refreshInfo = new RefreshInfo();
    private ILogListener m_logListener;
    private ISoftwareSystemProvider m_softwareSystemProvider;
    private i m_buildEventListener;
    private j m_resourceChangeListener;
    private p m_licenseHandler;
    private SystemMappingInfo m_currentMappingInfo;
    private OperationResult m_licenseHandlerInitializationResult;
    private boolean m_isStopping = false;
    private ISonargraphEclipsePlugin.SystemDiffStatus m_systemDiffStatus;

    @Inject
    public SonargraphEclipsePlugin() {
    }

    @PostConstruct
    public void start(final IEventBroker eventBroker, Display display) throws Exception {
        LOGGER.info("Start Sonargraph Eclipse plugin");
        this.m_display = display;
        this.m_eclipseContext.set(ISonargraphEclipsePlugin.class, (Object)this);
        this.m_eclipseContext.set(ISonargraphStatusProvider.class, (Object)this.m_statusController);
        this.m_statusController.connect();
        this.m_eclipseContext.set(IMarkerProvider.class, (Object)this.m_markerProvider);
        this.m_logListener = new h(new c(this, this));
        Platform.addLogListener((ILogListener)this.m_logListener);
        org.osgi.service.event.EventHandler eventHandler = new org.osgi.service.event.EventHandler(){

            public void handleEvent(Event event) {
                eventBroker.unsubscribe((org.osgi.service.event.EventHandler)this);
                SonargraphEclipsePlugin.this.initialize(a.b() ? ISonargraphEclipsePlugin.StartupOption.LOAD_SYSTEM : ISonargraphEclipsePlugin.StartupOption.PLAIN, JobType.PROVIDES_PROGESS);
            }
        };
        eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appStartupComplete", eventHandler);
        LOGGER.info("Start Sonargraph Eclipse plugin - done");
    }

    private void loadLastUsedSystem(JobType jobType) {
        String message;
        LOGGER.debug("loadLastUsedSystem {}", (Object)jobType);
        assert (jobType != null) : "Parameter 'jobType' of method 'loadLastUsedSystem' must not be null";
        assert (this.m_softwareSystemProvider != null) : "SoftwareSystemProvider must be initialized";
        String lastUsedSystemPath = a.a();
        TFile systemDir = this.getSystemDirectory(lastUsedSystemPath);
        if (lastUsedSystemPath != null && systemDir == null) {
            message = "Last used system no longer exists:\n" + lastUsedSystemPath + "\n";
            a.a(null);
        } else {
            message = null;
        }
        if (systemDir == null) {
            UserInterfaceAdapter.b().b(() -> {
                com.hello2morrow.sonargraph.ide.eclipse.view.c dialog;
                List<String> sonargraphSystemPaths = EclipseWorkspaceUtils.getSonargraphSystemPaths();
                if (sonargraphSystemPaths.size() > 0 && (dialog = new com.hello2morrow.sonargraph.ide.eclipse.view.c(WorkbenchRegistry.c().s(), sonargraphSystemPaths, message)).open() == 0) {
                    String systemPath = dialog.c();
                    assert (systemPath != null) : "systemPath must not be null";
                    this.openSystem(JobType.PROVIDES_PROGESS, new TFile(systemPath));
                }
            });
        } else {
            this.openSystem(jobType, systemDir);
        }
    }

    private void openSystem(JobType jobType, TFile systemDir) {
        LOGGER.debug("openSystem {} {}", (Object)jobType, (Object)systemDir);
        assert (jobType != null) : "Parameter 'jobType' of method 'openSystem' must not be null";
        assert (systemDir != null) : "Parameter 'systemDir' of method 'openSystem' must not be null";
        r job = new r(this.m_eventBroker, this, this.m_softwareSystemProvider, this.m_fileRegistry, systemDir, jobType);
        job.schedule();
    }

    private TFile getSystemDirectory(String path) {
        if (path == null) {
            return null;
        }
        TFile systemDir = new TFile(path);
        if (!systemDir.exists() || !systemDir.isDirectory()) {
            return null;
        }
        return systemDir;
    }

    @Override
    public boolean initialize(ISonargraphEclipsePlugin.StartupOption option, JobType jobType) {
        LOGGER.debug("initialize {} {}", (Object)option, (Object)jobType);
        assert (option != null) : "Parameter 'option' of method 'initialize' must not be null";
        assert (jobType != null) : "Parameter 'jobType' of method 'initialize' must not be null";
        assert (this.m_logger != null) : "'m_logger' of method 'initialize' must not be null";
        this.detachEventHandler();
        this.setStopping(false);
        if (this.m_application.e()) {
            if (this.m_softwareSystemProvider != null && this.m_softwareSystemProvider.hasSoftwareSystem()) {
                d closeJob = new d(this.m_eventBroker, this.m_softwareSystemProvider);
                closeJob.schedule();
                try {
                    closeJob.join();
                }
                catch (InterruptedException ex) {
                    LOGGER.error("Interrupted while closing software system during re-initialization", (Throwable)ex);
                }
            }
            this.m_application.a(this.m_softwareSystemProvider);
            this.m_application.d();
        }
        TrueZipFacade.clear();
        this.m_softwareSystemProvider = this.m_application.a(com.hello2morrow.sonargraph.ide.eclipse.a.a.a(), new ScriptOutputStreamProvider(), Collections.singleton(com.hello2morrow.sonargraph.languageprovider.java.foundation.common.a.a.getStandardName().toLowerCase()), WorkbenchRegistry.e(), this, this);
        if (this.m_softwareSystemProvider == null) {
            LOGGER.error("Failed to initialize system controller: {}", (Object)this.m_licenseHandlerInitializationResult);
            if (this.m_licenseHandlerInitializationResult.isFailure()) {
                this.showInitializationWarningDialog("No valid Sonargraph developer license found!", "Please use the \"Manage License\" dialog from the Sonargraph menu to activate Sonargraph.");
            } else {
                this.showInitializationWarningDialog("Failed to initialize Sonargraph", "Initialization of Sonargraph failed.\nPlease get in contact with support@hello2morrow.com");
            }
            return false;
        }
        this.enableDecoratorManager();
        this.m_markerProvider.clear(this.m_softwareSystemProvider, this.m_eventBroker);
        this.attachEventHandler();
        if (WorkbenchRegistry.b()) {
            WorkbenchRegistry.d();
        }
        MApplication application = (MApplication)this.m_eclipseContext.get(MApplication.class);
        MWindow mainApplicationWindow = (MWindow)application.getChildren().get(0);
        WorkbenchRegistry.a((IEclipseContext)this.m_eclipseContext, (IEventBroker)this.m_eventBroker, (Display)this.m_display, (MWindow)mainApplicationWindow, (ISoftwareSystemProvider)this.m_softwareSystemProvider, Collections.emptySet(), (WorkbenchRegistry.a)new T(), Collections.emptyList(), Collections.emptyList(), (WorkbenchRegistry.Mode)WorkbenchRegistry.Mode.INTEGRATED);
        UserInterfaceAdapter.a((org.eclipse.e4.core.services.log.Logger)this.m_logger, (boolean)false);
        this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.INITIALIZED, this);
        this.m_application.c();
        WorkbenchRegistry.c().f();
        if (option == ISonargraphEclipsePlugin.StartupOption.LOAD_SYSTEM) {
            this.loadLastUsedSystem(jobType);
        }
        return true;
    }

    @Override
    public void showInitializationWarningDialog(String title, String message) {
        this.m_display.asyncExec(() -> {
            com.hello2morrow.sonargraph.ui.swt.dialog.b dialog = new com.hello2morrow.sonargraph.ui.swt.dialog.b(this.m_display.getActiveShell(), title, 4, message);
            dialog.open();
        });
    }

    private void attachEventHandler() {
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemOpenedEvent>(SoftwareSystemOpenedEvent.class, (Object)this){

            public void a(SoftwareSystemOpenedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                SonargraphEclipsePlugin.this.m_buildEventListener = new i(SonargraphEclipsePlugin.this, SonargraphEclipsePlugin.this.m_eventBroker);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)SonargraphEclipsePlugin.this.m_buildEventListener, 24);
                SonargraphEclipsePlugin.this.m_resourceChangeListener = new j(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)SonargraphEclipsePlugin.this.m_resourceChangeListener, 6);
                JavaCore.addElementChangedListener((IElementChangedListener)SonargraphEclipsePlugin.this.m_resourceChangeListener, (int)1);
                a.a(SonargraphEclipsePlugin.this.getCurrentSoftwareSystemPath());
                SonargraphEclipsePlugin.this.enableDecoratorManager();
                SonargraphEclipsePlugin.this.determineSystemDiffStatus();
                if (!SonargraphEclipsePlugin.this.isSystemDiffActive()) {
                    SonargraphEclipsePlugin.this.m_markerProvider.initForCurrentIssues(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker);
                }
            }

            public /* synthetic */ void handleEvent(com.hello2morrow.foundation.event.Event event) {
                this.a((SoftwareSystemOpenedEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemIssuesModifiedEvent>(SoftwareSystemIssuesModifiedEvent.class, (Object)this){

            public void a(SoftwareSystemIssuesModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (!event.getDelta().isEmpty() && !SonargraphEclipsePlugin.this.isSystemDiffActive()) {
                    SonargraphEclipsePlugin.this.m_markerProvider.update(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker, event.getDelta());
                } else {
                    THashMap data = new THashMap();
                    ISonargraphStatusProvider.SonargraphStatus status = ISonargraphStatusProvider.SonargraphStatus.ANALYZING;
                    data.put(ISonargraphStatusProvider.Property.STATUS.name(), status);
                    data.put(ISonargraphStatusProvider.Property.SENDER.name(), ((Object)((Object)this)).getClass().getSimpleName());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Posting status for issues modified: {}, sender: {}", (Object)status, (Object)((Object)((Object)this)).getClass().getSimpleName());
                    }
                    SonargraphEclipsePlugin.this.m_eventBroker.post(ISonargraphStatusProvider.Topic.SONARGRAPH_STATUS.getName(), (Object)data);
                }
            }

            public /* synthetic */ void handleEvent(com.hello2morrow.foundation.event.Event event) {
                this.a((SoftwareSystemIssuesModifiedEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersStartedEvent>(AnalyzersStartedEvent.class, (Object)this){

            public void a(AnalyzersStartedEvent startedEvent) {
                if (!$assertionsDisabled && startedEvent == null) {
                    throw new AssertionError((Object)"Parameter 'started' of method 'handleEvent' must not be null");
                }
                THashMap data = new THashMap();
                ISonargraphStatusProvider.SonargraphStatus status = ISonargraphStatusProvider.SonargraphStatus.ANALYZING;
                data.put(ISonargraphStatusProvider.Property.STATUS.name(), status);
                data.put(ISonargraphStatusProvider.Property.SENDER.name(), ((Object)((Object)this)).getClass().getSimpleName());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Posting status: {}, sender: {}", (Object)status, (Object)((Object)((Object)this)).getClass().getSimpleName());
                }
                SonargraphEclipsePlugin.this.m_eventBroker.post(ISonargraphStatusProvider.Topic.SONARGRAPH_STATUS.getName(), (Object)data);
            }

            public /* synthetic */ void handleEvent(com.hello2morrow.foundation.event.Event event) {
                this.a((AnalyzersStartedEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersFinishedEvent>(AnalyzersFinishedEvent.class, (Object)this){

            public void a(AnalyzersFinishedEvent finishedEvent) {
                if (!$assertionsDisabled && finishedEvent == null) {
                    throw new AssertionError((Object)"Parameter 'finishedEvent' of method 'handleEvent' must not be null");
                }
                if (SonargraphEclipsePlugin.this.isSystemDiffActive()) {
                    SonargraphEclipsePlugin.this.m_markerProvider.refreshForSystemDiff(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker);
                } else {
                    SonargraphEclipsePlugin.this.m_markerProvider.analysisFinished(SonargraphEclipsePlugin.this.m_softwareSystemProvider, SonargraphEclipsePlugin.this.m_eventBroker);
                }
            }

            public /* synthetic */ void handleEvent(com.hello2morrow.foundation.event.Event event) {
                this.a((AnalyzersFinishedEvent)event);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemClosedEvent>(SoftwareSystemClosedEvent.class, (Object)this){

            public void a(SoftwareSystemClosedEvent event) {
                if (SonargraphEclipsePlugin.this.m_buildEventListener != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)SonargraphEclipsePlugin.this.m_buildEventListener);
                    SonargraphEclipsePlugin.this.m_buildEventListener = null;
                }
                if (SonargraphEclipsePlugin.this.m_resourceChangeListener != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)SonargraphEclipsePlugin.this.m_resourceChangeListener);
                    JavaCore.removeElementChangedListener((IElementChangedListener)SonargraphEclipsePlugin.this.m_resourceChangeListener);
                    SonargraphEclipsePlugin.this.m_resourceChangeListener = null;
                }
                SonargraphEclipsePlugin.this.innerDeactivate();
            }

            public /* synthetic */ void handleEvent(com.hello2morrow.foundation.event.Event event) {
                this.a((SoftwareSystemClosedEvent)event);
            }
        });
    }

    @Override
    public void determineSystemDiffStatus() {
        long start = System.currentTimeMillis();
        if (!this.m_softwareSystemProvider.hasSoftwareSystem()) {
            this.m_systemDiffStatus = ISonargraphEclipsePlugin.SystemDiffStatus.INACTIVE;
            return;
        }
        SoftwareSystem softwareSystem = this.m_softwareSystemProvider.getSoftwareSystem();
        ISystemDiffProvider diffProvider = (ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class);
        boolean isDiffActive = diffProvider.isSystemDiffActive();
        LOGGER.debug("Needed {} ms to determine that system diff is {}.", (Object)(System.currentTimeMillis() - start), (Object)(isDiffActive ? "active" : "inactive"));
        this.m_systemDiffStatus = isDiffActive ? ISonargraphEclipsePlugin.SystemDiffStatus.ACTIVE : ISonargraphEclipsePlugin.SystemDiffStatus.INACTIVE;
    }

    @Override
    public boolean isSystemDiffActive() {
        return this.m_softwareSystemProvider.getAnalyzerExecutionLevel() == AnalyzerExecutionLevel.FULL && this.m_systemDiffStatus == ISonargraphEclipsePlugin.SystemDiffStatus.ACTIVE;
    }

    private void detachEventHandler() {
        LOGGER.debug("detach");
        EventManager.getInstance().detach(SoftwareSystemOpenedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersStartedEvent.class, (Object)this);
        EventManager.getInstance().detach(SoftwareSystemIssuesModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersFinishedEvent.class, (Object)this);
        EventManager.getInstance().detach(SoftwareSystemClosedEvent.class, (Object)this);
    }

    @Override
    public boolean reinitializeAfterError() {
        LOGGER.debug("reinitializeAfterError");
        this.innerDeactivate();
        WorkbenchRegistry.c().g();
        this.m_application.a(this.m_softwareSystemProvider);
        this.m_application.d();
        this.resetLicenseHandler();
        this.m_softwareSystemProvider = null;
        UserInterfaceAdapter.c();
        return this.initialize(ISonargraphEclipsePlugin.StartupOption.PLAIN, JobType.PROVIDES_PROGESS);
    }

    private void resetLicenseHandler() {
        if (this.m_licenseHandler != null) {
            this.m_licenseHandler.g();
            this.m_licenseHandler = null;
            this.m_eclipseContext.remove(o.class);
        }
    }

    private void innerDeactivate() {
        LOGGER.debug("innerDeactivate");
        this.m_fileRegistry.clear();
        this.m_currentMappingInfo = null;
        this.m_refreshInfo.clear();
        this.m_markerProvider.clear(this.m_softwareSystemProvider, this.m_eventBroker);
        for (IProject project : EclipseWorkspaceUtils.getActiveSonargraphProjects()) {
            EclipseWorkspaceUtils.clearSonargraphResourceProperties((IResource)project);
        }
        this.disableDecoratorManager();
        TrueZipFacade.clear();
        String lastUsedSystem = a.a();
        if (lastUsedSystem != null) {
            this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.SUSPENDED, this);
        } else {
            this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.INITIALIZED, this);
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        LOGGER.info("Stop Sonargraph Eclipse plugin");
        LOGGER.debug("Cancel all Sonargraph jobs...");
        Job.getJobManager().cancel((Object)"com.hello2morrow.sonargraph.ide.eclipse.jobs");
        this.m_statusController.disconnect();
        this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.UNINITIALIZED, this);
        boolean isExecuting = false;
        if (this.m_softwareSystemProvider != null && this.m_softwareSystemProvider.hasSoftwareSystem()) {
            LOGGER.debug("Close Sonargraph software system...");
            isExecuting = true;
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_buildEventListener);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_resourceChangeListener);
            JavaCore.removeElementChangedListener((IElementChangedListener)this.m_resourceChangeListener);
            d closeJob = new d(this.m_eventBroker, this.m_softwareSystemProvider);
            closeJob.schedule();
        }
        a.a(isExecuting);
        try {
            LOGGER.debug("Wait for all Sonargraph jobs to finish...");
            Job.getJobManager().join((Object)"com.hello2morrow.sonargraph.ide.eclipse.jobs", null);
            LOGGER.debug("All Sonargraph jobs finished");
        }
        catch (OperationCanceledException e2) {
            LOGGER.debug("... canceled");
        }
        catch (InterruptedException e3) {
            LOGGER.debug("... interrupted");
        }
        catch (Exception e4) {
            LOGGER.error("Could not wait for Sonargraph jobs to finish", (Throwable)e4);
        }
        this.detachEventHandler();
        if (WorkbenchRegistry.b()) {
            WorkbenchRegistry.c().g();
        }
        this.m_application.a(this.m_softwareSystemProvider);
        this.m_softwareSystemProvider = null;
        this.resetLicenseHandler();
        if (this.m_logListener != null) {
            Platform.removeLogListener((ILogListener)this.m_logListener);
        }
        this.m_application.d();
        LOGGER.info("Stop Sonargraph Eclipse plugin - done");
    }

    @Override
    public FileRegistry getFileRegistry() {
        return this.m_fileRegistry;
    }

    @Override
    public IEventBroker getEventBroker() {
        return this.m_eventBroker;
    }

    public o initializeLicenseHandler(SonargraphProduct product, Set<Language> availableLanguages, o.a handler) {
        LOGGER.debug("initializeLicenseHandler {} {} {}", new Object[]{product, availableLanguages, handler});
        assert (product != null) : "Parameter 'product' of method 'initializeLicenseHandler' must not be null";
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'getLicenseHandler' must not be null";
        this.m_licenseHandler = new p(product, availableLanguages, handler);
        this.m_eclipseContext.set(o.class, (Object)this.m_licenseHandler);
        b proxySettingsProvider = new b(o.a());
        ConnectionMode connectionMode = ConnectionDialog.a((com.hello2morrow.sonargraph.ui.swt.base.g)proxySettingsProvider);
        if (connectionMode == ConnectionMode.ONLINE) {
            boolean autoRenew = RenewLicenseTicketAutomaticallyHandler.isActive();
            this.m_licenseHandler.b(autoRenew);
            this.m_licenseHandler.a(proxySettingsProvider.a(false));
            this.m_licenseHandler.a(e.a((boolean)false));
        }
        this.m_licenseHandlerInitializationResult = this.m_licenseHandler.i();
        return this.m_licenseHandler;
    }

    @Override
    public boolean isInitialized() {
        return this.m_application.e() && this.m_softwareSystemProvider != null;
    }

    public void handleLicenseLostEvent(String serverReply) {
        UserInterfaceAdapter.b().b(() -> UserInterfaceAdapter.b().b("Sonargraph License Lost", serverReply));
        this.updateSonargraphAnalysisStatus(ISonargraphEclipsePlugin.AnalysisStatus.SUSPENDED);
    }

    @Override
    public String getCurrentSoftwareSystemPath() {
        return ((Files)this.m_softwareSystemProvider.getSoftwareSystem().getUniqueExistingChild(Files.class)).getSystemDirectory().getFile().getNormalizedAbsolutePath();
    }

    @Override
    public void updateSonargraphAnalysisStatus(ISonargraphEclipsePlugin.AnalysisStatus status) {
        boolean isExecuting;
        assert (status != null) : "Parameter 'status' of method 'setSonargraphAnalysisStatus' must not be null";
        if (this.m_softwareSystemProvider.hasSoftwareSystem()) {
            Job.getJobManager().cancel((Object)"com.hello2morrow.sonargraph.ide.eclipse.jobs");
            d closeJob = new d(this.m_eventBroker, this.m_softwareSystemProvider);
            closeJob.schedule();
        }
        if (status == ISonargraphEclipsePlugin.AnalysisStatus.ACTIVE) {
            this.loadLastUsedSystem(JobType.PROVIDES_PROGESS);
            isExecuting = true;
        } else {
            isExecuting = false;
            this.m_statusController.setStatus(ISonargraphStatusProvider.SonargraphStatus.SUSPENDED, this);
        }
        a.a(isExecuting);
    }

    @Override
    public void resetSonargraphAnalysisStatus() {
        if (this.m_softwareSystemProvider.hasSoftwareSystem()) {
            d closeJob = new d(this.m_eventBroker, this.m_softwareSystemProvider);
            closeJob.schedule();
        }
        this.loadLastUsedSystem(JobType.PROVIDES_PROGESS);
        a.a(true);
    }

    public boolean isRunning() {
        return this.m_softwareSystemProvider != null;
    }

    @Override
    public ISoftwareSystemProvider getSoftwareSystemProvider() {
        return this.m_softwareSystemProvider;
    }

    @Override
    public IMarkerProvider getMarkerProvider() {
        return this.m_markerProvider;
    }

    @Override
    public void refactoringStarted() {
    }

    @Override
    public void refactoringFinished() {
    }

    @Override
    public String getEclipsePlatformVersion() {
        return EclipseRelease.getEclipseVersion().toString();
    }

    @Override
    public RefreshInfo getRefreshInfo() {
        return this.m_refreshInfo;
    }

    @Override
    public void setSystemMapping(SystemMappingInfo mappingInfo) {
        assert (mappingInfo != null) : "Parameter 'mappingInfo' of method 'setCurrentSystemMapping' must not be null";
        this.m_currentMappingInfo = mappingInfo;
    }

    @Override
    public SystemMappingInfo getSystemMapping() {
        return this.m_currentMappingInfo;
    }

    private void enableDecoratorManager() {
        assert (this.m_decoratorManager != null) : "Field 'm_decoratorManager' must be injected";
        this.m_decoratorManager.enable();
    }

    private void disableDecoratorManager() {
        assert (this.m_decoratorManager != null) : "Field 'm_decoratorManager' must be injected";
        this.m_decoratorManager.disable();
    }

    public String toString() {
        return SonargraphEclipsePlugin.class.getSimpleName();
    }

    @Override
    public void setStopping(boolean stop) {
        this.m_isStopping = stop;
    }

    @Override
    public boolean isStopping() {
        return this.m_isStopping;
    }

    @Override
    public Version getVersion() {
        return this.m_licenseHandler.e();
    }
}

