/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model.wrapper;

import com.hello2morrow.sonargraph.ide.eclipse.model.ResourceInfo;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.IEclipseWrapperForMarkerProcessing;
import de.schlichtherle.truezip.file.TFile;

public class DuplicateCodeBlockOccurrenceDto
implements IEclipseWrapperForMarkerProcessing {
    private final TFile m_sourceFile;
    private final int m_startLine;
    private final int m_endLine;
    private final int m_blockSize;
    private final int m_tolerance;
    private final ResourceInfo m_resourceInfo;

    public DuplicateCodeBlockOccurrenceDto(ResourceInfo resourceInfo, TFile sourceFile, int startLine, int endLine, int blockSize, int tolerance) {
        assert (resourceInfo != null) : "Parameter 'resourceInfo' of method 'DuplicateCodeBlockOccurrenceDto' must not be null";
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'DuplicateCodeBlockOccurrenceDto' must not be null";
        assert (startLine > 0) : "Start line must be > 0";
        assert (endLine > startLine) : "End line must be > start line";
        assert (blockSize > 0) : "Block size must be > 0";
        assert (tolerance >= 0) : "Tolerance cannot be negative";
        this.m_resourceInfo = resourceInfo;
        this.m_sourceFile = sourceFile;
        this.m_startLine = startLine;
        this.m_endLine = endLine;
        this.m_blockSize = blockSize;
        this.m_tolerance = tolerance;
    }

    public ResourceInfo getResourceInfo() {
        return this.m_resourceInfo;
    }

    public int getBlockSize() {
        return this.m_blockSize;
    }

    public int getEndLine() {
        return this.m_endLine;
    }

    public int getStartLine() {
        return this.m_startLine;
    }

    public TFile getSourceFile() {
        return this.m_sourceFile;
    }

    public int getTolerance() {
        return this.m_tolerance;
    }

    public String getPresentationName() {
        StringBuilder builder = new StringBuilder();
        builder.append("lines: ").append(this.m_startLine).append("-").append(this.m_endLine).append(", tolerance: ").append(this.m_tolerance);
        return builder.toString();
    }
}

