/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model.wrapper;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.ide.eclipse.model.ResourceInfo;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.IEclipseWrapperForMarkerProcessing;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractIssueDto
implements IEclipseWrapperForMarkerProcessing {
    private final Issue m_issue;
    private final Collection<TFile> m_affectedPhysicalSourceFiles;
    private final String m_issueDescription;
    private final ResourceInfo m_resourceInfo;

    public AbstractIssueDto(Issue issue, ResourceInfo resouceInfo, String issueDescription, Collection<TFile> affectedPhysicalSourceFiles) {
        assert (issue != null) : "Parameter 'issue' of method 'AbstractIssueDto' must not be null";
        assert (resouceInfo != null) : "Parameter 'resouceInfo' of method 'AbstractIssueDto' must not be null";
        assert (issueDescription != null) : "Parameter 'issueDescriptione' of method 'AbstractIssueDto' must not be null";
        assert (affectedPhysicalSourceFiles != null) : "Parameter 'affectedPhysicalSourceFiles' of method 'AbstractIssueDto' must not be null";
        this.m_issue = issue;
        this.m_resourceInfo = resouceInfo;
        this.m_issueDescription = issueDescription;
        this.m_affectedPhysicalSourceFiles = affectedPhysicalSourceFiles;
    }

    public final Issue getIssue() {
        return this.m_issue;
    }

    public Severity getSeverity() {
        return this.m_issue.getSeverity();
    }

    public final ResourceInfo getResourceInfo() {
        return this.m_resourceInfo;
    }

    public final boolean isValid() {
        return this.m_resourceInfo.isValid();
    }

    public final boolean hasLineNumber() {
        return this.m_issue.getLineNumber() > -1;
    }

    public final int getLineNumber() {
        return this.m_issue.getLineNumber();
    }

    public final IIssueId getId() {
        return this.m_issue.getId();
    }

    public final String getKey() {
        return this.m_issue.getKey();
    }

    public final Collection<TFile> getAffectedPhysicalSourceFiles() {
        return Collections.unmodifiableCollection(this.m_affectedPhysicalSourceFiles);
    }

    public String getIssueDescription() {
        return this.m_issueDescription;
    }

    public String getIssueDescription(TFile sourceFile) {
        return this.m_issueDescription;
    }

    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Id: ");
        builder.append(this.getId().getStandardName());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Affected element name: ");
        builder.append(this.getResourceInfo().getSonargraphElementName());
        builder.append("LineNumber: ").append(this.getLineNumber());
        return builder.toString();
    }
}

