/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import com.hello2morrow.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.d;
import com.hello2morrow.sonargraph.ide.eclipse.model.AbstractASTBasedFinder;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FieldFinder;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JavaElementNameFilter;
import com.hello2morrow.sonargraph.ide.eclipse.model.MethodFinder;
import com.hello2morrow.sonargraph.ide.eclipse.model.PackageFragmentRootNameFilter;
import com.hello2morrow.sonargraph.ide.eclipse.model.TypeFinder;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaConstructor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaPackageFragment;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElementMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementMapper.class);
    private static final int HIGHEST_JLS_TO_TRY = 12;

    private ElementMapper() {
    }

    public static IJavaElement getEclipseElementFromSelection(Object selection) {
        assert (selection != null) : "Parameter 'selection' of method 'getEclipseElementFromSelection' must not be null";
        if (selection instanceof IIssue && (selection = ((IIssue)selection).getAffectedElement()) instanceof Dependency) {
            selection = ((Dependency)selection).getFrom();
        }
        if (selection instanceof Resolution) {
            return null;
        }
        if (selection instanceof NamedElement) {
            selection = ElementMapper.getEclipseElement((NamedElement)selection);
        }
        if (selection instanceof IJavaElement) {
            return (IJavaElement)selection;
        }
        return null;
    }

    public static List<IJavaElement> getEclipseElements(List<NamedElement> namedElements) {
        assert (namedElements != null) : "Parameter 'namedElements' of method 'getEclipseElements' must not be null";
        ArrayList<IJavaElement> eclipseElements = new ArrayList<IJavaElement>();
        for (NamedElement namedElement : namedElements) {
            IJavaElement eclipseElement = ElementMapper.getEclipseElement(namedElement);
            if (eclipseElement != null) {
                eclipseElements.add(eclipseElement);
                continue;
            }
            LOGGER.warn("Eclipse element not found for namedElement: {}", (Object)namedElement.getFullyQualifiedName());
        }
        return eclipseElements;
    }

    public static IJavaElement getEclipseElement(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getEclipseElement' must not be null";
        if (namedElement instanceof NamedElementProxy) {
            namedElement = ((NamedElementProxy)namedElement).getElement();
        }
        if (namedElement instanceof JavaModule) {
            return EclipseWorkspaceUtils.getProjectForModule(namedElement.getName()).map(p2 -> JavaCore.create((IProject)p2)).orElse(null);
        }
        if (namedElement instanceof RootDirectoryPath) {
            return EclipseWorkspaceUtils.getRootDirectory(namedElement.getFullyQualifiedName());
        }
        if (namedElement instanceof JavaPackageFragment) {
            JavaPackageFragment packageFragment = (JavaPackageFragment)namedElement;
            TFile folder = packageFragment.getPhysicalCorrespondent();
            IFolder iFolder = EclipseWorkspaceUtils.getLocationForDirectory(folder).orElse(null);
            if (iFolder == null) {
                return null;
            }
            return EclipseWorkspaceUtils.getPackage(iFolder);
        }
        if (namedElement instanceof JavaInternalCompilationUnit) {
            return ElementMapper.mapCompilationUnit((JavaInternalCompilationUnit)namedElement);
        }
        JavaInternalCompilationUnit parentCompilationUnit = (JavaInternalCompilationUnit)namedElement.getOriginalParent(JavaInternalCompilationUnit.class);
        if (parentCompilationUnit == null) {
            LOGGER.warn("Element cannot be mapped: {}", (Object)namedElement.getOriginalFullyQualifiedName());
            return null;
        }
        ICompilationUnit sgCompilationUnit = ElementMapper.mapCompilationUnit(parentCompilationUnit);
        if (sgCompilationUnit == null) {
            LOGGER.warn("Failed to find compilation unit {} for element {}", (Object)parentCompilationUnit, (Object)namedElement.getOriginalFullyQualifiedName());
            return null;
        }
        CompilationUnit eclipseCompilationUnit = null;
        try {
            eclipseCompilationUnit = ElementMapper.createEclipseCompilationUnit(sgCompilationUnit);
            if (eclipseCompilationUnit == null) {
                return null;
            }
        }
        catch (Throwable t2) {
            LOGGER.error("Failed to create Eclipse compilation unit: " + ExceptionUtility.collectAll((Throwable)t2));
            return null;
        }
        assert (eclipseCompilationUnit != null) : "'compilationUnit' of method 'getEclipseElement' must not be null";
        AbstractASTBasedFinder finder = null;
        if (namedElement instanceof JavaType) {
            finder = new TypeFinder(eclipseCompilationUnit, (JavaType)namedElement);
        } else if (namedElement instanceof JavaMethod) {
            finder = new MethodFinder(eclipseCompilationUnit, (JavaMethod)namedElement);
        } else if (namedElement instanceof JavaField) {
            finder = new FieldFinder(eclipseCompilationUnit, (JavaField)namedElement);
        } else {
            LOGGER.error("Unsupported element type: " + namedElement.getClass().getCanonicalName());
            return null;
        }
        eclipseCompilationUnit.accept((ASTVisitor)finder);
        return finder.getMatch();
    }

    private static CompilationUnit createEclipseCompilationUnit(ICompilationUnit compilationUnit) {
        assert (compilationUnit != null) : "Parameter 'compilationUnit' of method 'createEclipseCompilationUnit' must not be null";
        ASTParser parser = null;
        int jls = 12;
        while (jls >= 8) {
            try {
                parser = ASTParser.newParser((int)jls);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                --jls;
            }
        }
        if (parser == null) {
            return null;
        }
        parser.setKind(8);
        parser.setSource(compilationUnit);
        parser.setResolveBindings(true);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        return cu;
    }

    private static ICompilationUnit mapCompilationUnit(JavaInternalCompilationUnit compilationUnit) {
        assert (compilationUnit != null) : "Parameter 'compilationUnit' of method 'mapCompilationUnit' must not be null";
        TFile file = compilationUnit.getFile();
        IFile iFile = EclipseWorkspaceUtils.getLocationForFile(file).orElse(null);
        if (iFile == null) {
            return null;
        }
        return EclipseWorkspaceUtils.getCompilationUnit(iFile);
    }

    public static JavaModule getSonargraphElement(IJavaProject eclipseProject, ISonargraphEclipsePlugin plugin) {
        assert (eclipseProject != null) : "Parameter 'eclipseProject' of method 'getSonargraphElement' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'getSonargraphElement' must not be null";
        IProject project = eclipseProject.getProject();
        if (EclipseWorkspaceUtils.isSonargraphResource((IResource)project)) {
            try {
                String moduleName = (String)project.getSessionProperty(d.q);
                List modules = ((Workspace)plugin.getSoftwareSystemProvider().getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getChildren((NamedElement.IFilter)new NameFilter(moduleName), JavaModule.class);
                if (modules.size() == 1) {
                    return (JavaModule)modules.get(0);
                }
            }
            catch (CoreException ce) {
                LOGGER.warn("Can't get Sonargraph module for eclipse project '{}': {}", (Object)eclipseProject.getElementName(), (Object)ce.getMessage());
            }
        }
        return null;
    }

    public static RootDirectoryPath getSonargraphElement(IPackageFragmentRoot eclipseRoot, ISonargraphEclipsePlugin plugin) {
        assert (eclipseRoot != null) : "Parameter 'eclipseRoot' of method 'getSonargraphElement' must not be null";
        IJavaProject javaProject = eclipseRoot.getJavaProject();
        JavaModule module = ElementMapper.getSonargraphElement(javaProject, plugin);
        if (module != null) {
            try {
                List rootDirectories;
                IResource correspondingResource = eclipseRoot.getCorrespondingResource();
                if (correspondingResource == null) {
                    if (!eclipseRoot.isArchive()) {
                        LOGGER.warn("IPackageFragmentRoot {} does not have a corresponding resource", (Object)eclipseRoot);
                    }
                } else if (EclipseWorkspaceUtils.isSonargraphResource(correspondingResource) && (rootDirectories = module.getChildren((NamedElement.IFilter)new PackageFragmentRootNameFilter(eclipseRoot), RootDirectoryPath.class)).size() == 1) {
                    return (RootDirectoryPath)rootDirectories.get(0);
                }
            }
            catch (CoreException ce) {
                LOGGER.warn("Can't get Sonargraph root directory path for eclipse root '{}': {}", (Object)eclipseRoot.getElementName(), (Object)ce.getMessage());
            }
        }
        return null;
    }

    public static NamedElement getSonargraphElement(IJavaElement eclipseElement, ISonargraphEclipsePlugin plugin) {
        RootDirectoryPath rootDirectory;
        IPackageFragmentRoot eclipseRoot;
        assert (eclipseElement != null) : "Parameter 'eclipseElement' of method 'getSonargraphElement' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'getSonargraphElement' must not be null";
        IProject eclipseProject = eclipseElement.getJavaProject().getProject();
        if (EclipseWorkspaceUtils.isSonargraphResource((IResource)eclipseProject) && (eclipseRoot = ElementMapper.getPackageFragmentRoot(eclipseElement)) != null && (rootDirectory = ElementMapper.getSonargraphElement(eclipseRoot, plugin)) != null) {
            Class<JavaInternalCompilationUnit> namedElementClass;
            switch (eclipseElement.getElementType()) {
                case 6: {
                    namedElementClass = JavaInternalCompilationUnit.class;
                    break;
                }
                case 5: {
                    namedElementClass = JavaInternalCompilationUnit.class;
                    break;
                }
                case 4: {
                    namedElementClass = JavaPackageFragment.class;
                    break;
                }
                case 7: {
                    namedElementClass = JavaType.class;
                    break;
                }
                case 10: {
                    namedElementClass = JavaConstructor.class;
                    break;
                }
                case 9: {
                    namedElementClass = JavaMethod.class;
                    break;
                }
                case 8: {
                    namedElementClass = JavaField.class;
                    break;
                }
                default: {
                    namedElementClass = NamedElement.class;
                }
            }
            try {
                List namedElements = rootDirectory.getChildrenRecursively((NamedElement.IFilter)new JavaElementNameFilter(eclipseElement), namedElementClass, new Class[0]);
                if (namedElements.size() == 1) {
                    return (NamedElement)namedElements.get(0);
                }
            }
            catch (JavaModelException jme) {
                LOGGER.error("Couldn't create JavaElementNameFilter: " + ExceptionUtility.collectAll((Throwable)jme));
            }
        }
        return null;
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement eclipseElement) {
        while (eclipseElement != null && !(eclipseElement instanceof IPackageFragmentRoot)) {
            eclipseElement = eclipseElement.getParent();
        }
        return (IPackageFragmentRoot)eclipseElement;
    }
}

