/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import java.util.StringTokenizer;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public final class EclipseMethodSignatureResolver {
    private static final String SUPER = "super";
    private static final String EXTENDS = "extends";
    private static final String DELIMITERS = "<>[],?& ";

    private EclipseMethodSignatureResolver() {
    }

    public static String getResolvedParameterList(IType type, IMethod method) throws JavaModelException {
        assert (type != null) : "Parameter 'type' of method 'getResolvedParameterList' must not be null";
        assert (method != null) : "Parameter 'method' of method 'getResolvedParameterList' must not be null";
        StringBuffer result = new StringBuffer();
        ILocalVariable[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return "";
        }
        ILocalVariable[] iLocalVariableArray = parameters;
        int n2 = parameters.length;
        int n3 = 0;
        while (n3 < n2) {
            ILocalVariable parameter = iLocalVariableArray[n3];
            String name = parameter.getTypeSignature();
            String fqnParameterName = EclipseMethodSignatureResolver.resolveMethodParametersSignature(type, name);
            result.append(",").append(fqnParameterName);
            ++n3;
        }
        return result.toString().substring(1);
    }

    public static String resolveMethodParametersSignature(IType type, String methodParametersSignature) throws JavaModelException {
        assert (type != null) : "Parameter 'type' of method 'resolveMethodParametersSignature' must not be null";
        assert (methodParametersSignature != null) : "Parameter 'methodParametersSignature' of method 'resolveMethodParametersSignature' must not be null";
        if (methodParametersSignature.isEmpty()) {
            return methodParametersSignature;
        }
        StringBuffer result = new StringBuffer();
        String rawToSimple = Signature.getSignatureSimpleName((String)methodParametersSignature);
        StringTokenizer tokenizer = new StringTokenizer(rawToSimple, DELIMITERS, true);
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            if (EclipseMethodSignatureResolver.isDelimiter(next)) {
                result.append(next);
                continue;
            }
            if (EclipseMethodSignatureResolver.isKeyword(next)) {
                result.append(next);
                continue;
            }
            try {
                String resolved = EclipseMethodSignatureResolver.resolve(type, next);
                result.append(resolved);
            }
            catch (JavaModelException e2) {
                result.append(next);
            }
        }
        return result.toString();
    }

    private static String resolve(IType type, String name) throws JavaModelException {
        String[][] allResults = type.resolveType(name);
        if (allResults != null && allResults[0] != null) {
            String qualifiedName = Signature.toQualifiedName((String[])allResults[0]);
            if (!name.equals(qualifiedName)) {
                qualifiedName = String.valueOf(Signature.getQualifier((String)qualifiedName)) + "." + name;
            }
            return qualifiedName;
        }
        return name;
    }

    private static boolean isDelimiter(String next) {
        return DELIMITERS.contains(next);
    }

    private static boolean isKeyword(String next) {
        return EXTENDS.equals(next) || SUPER.equals(next);
    }
}

