/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.model.system.IDynamicSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemInfoMessageCause;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class EclipseClassRootProvider
implements IDynamicSystemProvider.ISourceToClassRootProvider {
    public OperationResultWithOutcome<List<RootPathInfo>> getClassRootsForSourceRoots(String projectName, List<RootPathInfo> srcRoots) {
        assert (projectName != null && projectName.length() > 0) : "Parameter 'projectName' of method 'getClassRootsForSourceRoots' must not be empty";
        assert (srcRoots != null && srcRoots.size() > 0) : "Parameter 'srcRoots' of method 'getClassRootsForSourceRoots' must not be empty";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Determine class roots for source roots of project '" + projectName + "'");
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        if (!project.exists()) {
            result.addWarning((OperationResult.IMessageCause)SystemInfoMessageCause.PROJECT_COULD_NOT_BE_MAPPED, "Project '" + projectName + "' does not exist", new Object[0]);
            return result;
        }
        if (!project.isOpen()) {
            result.addWarning((OperationResult.IMessageCause)SystemInfoMessageCause.PROJECT_COULD_NOT_BE_MAPPED, "Project '" + projectName + "' is closed", new Object[0]);
            return result;
        }
        if (!EclipseWorkspaceUtils.hasJavaNature(project)) {
            result.addError((OperationResult.IMessageCause)SystemInfoMessageCause.PROJECT_COULD_NOT_BE_MAPPED, "Project '" + projectName + "' is not a Java project", new Object[0]);
            return result;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<RootPathInfo> classRoots = new ArrayList<RootPathInfo>();
        try {
            IPath defaultOutputLocation = javaProject.getOutputLocation();
            List sourceRootsToMatch = srcRoots.stream().map(root -> root.getPath()).collect(Collectors.toList());
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n2 = iPackageFragmentRootArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IPackageFragmentRoot root2 = iPackageFragmentRootArray[n3];
                if (EclipseWorkspaceUtils.isSourceRootOfProject(javaProject, root2)) {
                    Optional<IPath> outputPathOptional;
                    String eclipseSourceRoot = FileUtility.getIdentifyingPath((TFile)new TFile(root2.getResource().getLocation().makeAbsolute().toFile()));
                    if (sourceRootsToMatch.stream().anyMatch(src -> src.equals(eclipseSourceRoot)) && (outputPathOptional = EclipseWorkspaceUtils.getOutputPathForSource(workspaceRoot, javaProject, root2, defaultOutputLocation)).isPresent()) {
                        IPath path = outputPathOptional.get();
                        TFile absoluteDir = new TFile(path.toFile());
                        classRoots.add(new RootPathInfo(FileUtility.getIdentifyingPath((TFile)absoluteDir), RootPathType.STANDARD));
                    }
                }
                ++n3;
            }
            result.setOutcome(classRoots);
        }
        catch (JavaModelException jme) {
            result.addError((OperationResult.IMessageCause)SystemInfoMessageCause.PROJECT_COULD_NOT_BE_MAPPED, "Failed to determine class roots of project '" + projectName + "'", new Object[]{jme});
        }
        catch (Exception e2) {
            result.addError((OperationResult.IMessageCause)SystemInfoMessageCause.PROJECT_COULD_NOT_BE_MAPPED, "Eclipse problem", new Object[]{e2});
        }
        return result;
    }
}

