/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.command.common.f;
import com.hello2morrow.sonargraph.core.command.system.h;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.IDynamicSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.g;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.i;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.l;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.p;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseClassRootProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class t
extends AbstractSonargraphEclipseJob
implements i {
    private static final Logger c = LoggerFactory.getLogger(t.class);
    private static final String d = "com.hello2morrow.sonargraph.ide.eclipse.jobs.reparse";
    private final FileRegistry e;

    public t(IEventBroker eventBroker, ISoftwareSystemProvider provider, FileRegistry fileRegistry) {
        super(eventBroker, provider, "Clean and full refresh of the Sonargraph workspace", JobType.PROVIDES_PROGESS, 40);
        assert (fileRegistry != null) : "Parameter 'fileRegistry' of method 'FullSoftwareSystemRefreshJob' must not be null";
        this.e = fileRegistry;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition a() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    static final IStatus a(ISoftwareSystemProvider provider, FileRegistry registry, IProgressMonitor monitor) throws Exception {
        assert (provider != null) : "Parameter 'provider' of method 'executeFullRefresh' must not be null";
        assert (registry != null) : "Parameter 'registry' of method 'executeFullRefresh' must not be null";
        assert (monitor != null) : "Parameter 'monitor' of method 'run' must not be null";
        if (!provider.hasSoftwareSystem()) {
            return new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", "Full Refresh not possible without SoftwareSystem");
        }
        if (provider.getSoftwareSystem().isClearable()) {
            h clear = new h(provider, new h.a(){

                public void a(OperationResult result) {
                    if (!a && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processClearSoftwareSystemResult' must not be null");
                    }
                }
            });
            l consumer = new l();
            clear.b((IWorkerContext)DefaultWorkerContext.INSTANCE, (f)consumer);
            if (consumer.a().isPresent()) {
                throw consumer.a().get();
            }
            registry.clear();
        } else assert (registry.isEmpty()) : "File registry not empty: " + registry;
        ArrayList<ModuleDelta> moduleDeltas = new ArrayList<ModuleDelta>();
        for (IProject project : EclipseWorkspaceUtils.getActiveSonargraphProjects()) {
            ModuleInfo projectInfo;
            if (monitor.isCanceled()) {
                c.debug("Cancelled full refresh!");
                return Status.CANCEL_STATUS;
            }
            if (!EclipseWorkspaceUtils.isSonargraphResource((IResource)project)) {
                c.debug("Project '{}' is not monitored by Sonargraph", (Object)project.getName());
                continue;
            }
            try {
                projectInfo = EclipseWorkspaceUtils.convertToModuleInfo(project);
            }
            catch (CoreException ex) {
                c.error("Failed to process project '{}'", (Object)project.getName(), (Object)ex);
                continue;
            }
            IDynamicSystemProvider assignmentProvider = (IDynamicSystemProvider)provider.getInstallation().getExtension(IDynamicSystemProvider.class);
            Optional moduleOpt = assignmentProvider.mapModule(projectInfo, (IDynamicSystemProvider.ISourceToClassRootProvider)new EclipseClassRootProvider(), provider.getSoftwareSystem());
            if (!moduleOpt.isPresent()) continue;
            ModuleInfo moduleInfo = (ModuleInfo)moduleOpt.get();
            JavaModule module = (JavaModule)((Workspace)provider.getSoftwareSystem().getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new NameFilter(moduleInfo.getName()), JavaModule.class);
            if (module == null) {
                c.error("Failed to determine Sonargraph module '" + moduleInfo.getName() + "' for project '" + projectInfo.getName() + "'");
                continue;
            }
            g visitor = new g(provider, module, monitor);
            try {
                project.accept((IResourceVisitor)visitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ModuleDelta delta = visitor.b();
                if (delta.isEmpty()) continue;
                moduleDeltas.add(delta);
            }
            catch (CoreException ex) {
                c.error("Failed to determine files of project '{}'", (Object)project.getName(), (Object)ex);
            }
        }
        if (moduleDeltas.isEmpty()) {
            c.warn("No delta determined");
            return new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "No delta determined");
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        p deltaRefresh = new p(provider, registry, moduleDeltas);
        deltaRefresh.a(monitor);
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    @Override
    protected IStatus a(IProgressMonitor monitor) throws Exception {
        IStatus result = t.a(this.h(), this.e, monitor);
        return result.isOK() ? this.c("System reparse successful") : result;
    }

    public static boolean i() {
        return Job.getJobManager().find((Object)d).length > 0;
    }

    public static void j() {
        Job[] jobs;
        Job[] jobArray = jobs = Job.getJobManager().find((Object)d);
        int n2 = jobs.length;
        int n3 = 0;
        while (n3 < n2) {
            Job job = jobArray[n3];
            job.cancel();
            ++n3;
        }
    }

    @Override
    public boolean belongsTo(Object family) {
        return family instanceof t || super.belongsTo(family) || family == d;
    }
}

