/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.command.common.d;
import com.hello2morrow.sonargraph.core.model.system.IDynamicSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemInfoMessageCause;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.j;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseClassRootProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class s
implements j {
    private static final Logger b = LoggerFactory.getLogger(s.class);
    private final TFile c;
    private final ISoftwareSystemProvider d;
    private SystemMappingInfo e;
    private DynamicSystemInfo f;

    public s(ISoftwareSystemProvider provider, TFile systemDirectory) {
        assert (provider != null) : "Parameter 'provider' of method 'ReloadSystemTask' must not be null";
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'ReloadSystemTask' must not be null";
        this.d = provider;
        this.c = systemDirectory;
    }

    @Override
    public OperationResult a(IProgressMonitor monitor) throws d {
        List<IProject> allJavaProjects = EclipseWorkspaceUtils.getJavaProjects();
        OperationResult result = new OperationResult("Load system info");
        if (!allJavaProjects.isEmpty()) {
            try {
                IDynamicSystemProvider dynamicSystemProvider = (IDynamicSystemProvider)this.d.getInstallation().getExtension(IDynamicSystemProvider.class);
                OperationResultWithOutcome loadSystemInfoResult = dynamicSystemProvider.loadSystemInfo((IWorkerContext)DefaultWorkerContext.INSTANCE, this.c);
                if (loadSystemInfoResult.isFailure()) {
                    return loadSystemInfoResult;
                }
                List<ModuleInfo> eclipseProjectModuleInfos = this.a(allJavaProjects);
                OperationResultWithOutcome mappingResult = dynamicSystemProvider.mapSystemInfo(this.d, (DynamicSystemInfo)loadSystemInfoResult.getOutcome(), eclipseProjectModuleInfos, (IDynamicSystemProvider.ISourceToClassRootProvider)new EclipseClassRootProvider(), IDynamicSystemProvider.MappingType.MATCHED_ONLY);
                if (mappingResult.isSuccess()) {
                    this.e = (SystemMappingInfo)mappingResult.getOutcome();
                    this.f = EclipseWorkspaceUtils.convertToDynamicInfo(this.e);
                }
                result.addMessagesFrom((OperationResult)loadSystemInfoResult);
            }
            catch (CoreException ex) {
                String title = "Failed to determine Sonargraph projects in workspace";
                b.error("Failed to determine Sonargraph projects in workspace", (Throwable)ex);
                result.addError((OperationResult.IMessageCause)SystemInfoMessageCause.PROJECT_COULD_NOT_BE_MAPPED, (Throwable)ex);
            }
        } else {
            result.addError((OperationResult.IMessageCause)SystemInfoMessageCause.NO_MATCHING_MODULE_FOUND);
        }
        return result;
    }

    public SystemMappingInfo a() {
        return this.e;
    }

    public DynamicSystemInfo b() {
        return this.f;
    }

    private List<ModuleInfo> a(List<IProject> eclipseProjects) throws CoreException {
        assert (eclipseProjects != null) : "Parameter 'eclipseProjects' of method 'convertProjectsToModuleInfos' must not be null";
        ArrayList<ModuleInfo> modules = new ArrayList<ModuleInfo>();
        for (IProject project : eclipseProjects) {
            modules.add(EclipseWorkspaceUtils.convertToModuleInfo(project));
        }
        return modules;
    }
}

