/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs.b;

import com.hello2morrow.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.h;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.i;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.x;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.IIssueToMarkerMap;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.model.ResourceInfo;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.AbstractIssueDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.AbstractIssueDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.CycleGroupIssueDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.CycleGroupIssueDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateCodeBlockOccurrenceDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateCodeBlockOccurrenceDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateIssueDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateIssueDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.RefactoringDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.ResolutionDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.StandardIssueDto;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaIssueId;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class a
extends AbstractSonargraphEclipseJob {
    private static final Logger a = LoggerFactory.getLogger(a.class);
    public static final String c = "com.hello2morrow.sonargraph.ide.eclipse.jobs.createMarkers";
    protected static final Set<IssueCategory> d = EnumSet.of(IssueCategory.INSTALLATION_CONFIGURATION, new IssueCategory[]{IssueCategory.SYSTEM_CONFIGURATION, IssueCategory.WORKSPACE, IssueCategory.ARCHITECTURE_CONSISTENCY, IssueCategory.ARCHITECTURE_DEFINITION, IssueCategory.SCRIPT_DEFINITION, IssueCategory.ARCHITECTURAL_VIEW});
    private static final List<Class<?>> g = Arrays.asList(h.class, i.class);
    protected static final Predicate<? super Issue> e = i2 -> !i2.getId().equals(JavaIssueId.JAVA_FILE_UNPARSEABLE) && !i2.getId().equals(JavaIssueId.JAVA_FILE_PARSE_ERROR);
    private final IIssueToMarkerMap h;
    private final Set<Issue> i;
    private final Set<Issue> j;

    public a(IEventBroker eventBroker, ISoftwareSystemProvider provider, String name, IIssueToMarkerMap issueToMarkerMap, Set<Issue> issuesToAdd, Set<Issue> issuesToRemove) {
        super(eventBroker, provider, name, JobType.BACKGROUND, 50, AbstractSonargraphEclipseJob.Scheduling.SEQUENTIALLY);
        assert (issueToMarkerMap != null) : "Parameter 'cache' of method 'CreateMarkerJob' must not be null";
        assert (issuesToAdd != null) : "Parameter 'issuesToAdd' of method 'AbstractCreateMarkerJob' must not be null";
        assert (issuesToRemove != null) : "Parameter 'issuesToRemove' of method 'AbstractCreateMarkerJob' must not be null";
        this.h = issueToMarkerMap;
        this.j = issuesToAdd;
        this.i = issuesToRemove;
    }

    public a(IEventBroker eventBroker, ISoftwareSystemProvider provider, String name, IIssueToMarkerMap cache) {
        super(eventBroker, provider, name, JobType.BACKGROUND, 50, AbstractSonargraphEclipseJob.Scheduling.SEQUENTIALLY);
        this.h = cache;
        this.i = null;
        this.j = null;
    }

    @Override
    protected List<Class<?>> d() {
        return g;
    }

    @Override
    protected IStatus a(IProgressMonitor monitor) {
        StrictPair totalIssueCount;
        List<ResolutionDto> resolutionDtos;
        assert (monitor != null) : "Parameter 'monitor' of method 'runInWorkspaceInternal' must not be null";
        if (!this.h().hasSoftwareSystem()) {
            return this.b("No software system");
        }
        long start = System.currentTimeMillis();
        if (this.i != null && !this.i.isEmpty()) {
            this.a(this.i, this.h);
        }
        List<AbstractIssueDto> issueDtos = this.a(this.j, monitor);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.j != null) {
            Set<Issue> issuesWithResolution = this.j.stream().filter(i2 -> i2.getResolution() != null).collect(Collectors.toSet());
            resolutionDtos = this.b(issuesWithResolution, monitor);
        } else {
            resolutionDtos = this.b(null, monitor);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (a.isDebugEnabled()) {
            a.debug("Time needed to convert issues and resolutions: {} ms", (Object)(System.currentTimeMillis() - start));
        }
        StrictPair issueCount = this.a(monitor, issueDtos);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        int taskCount = this.b(monitor, resolutionDtos);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (a.isDebugEnabled()) {
            a.debug("Added {} problem markers, {} task markers in {} ms", new Object[]{issueCount, taskCount, System.currentTimeMillis() - start});
        }
        THashMap eventData = new THashMap();
        if (this.j == null) {
            eventData.put(ISonargraphStatusProvider.Property.ERROR_WARNING_COUNT.name(), issueCount);
            totalIssueCount = issueCount;
        } else {
            totalIssueCount = new StrictPair((Object)this.h.getNumberOfErrors(), (Object)this.h.getNumberOfWarnings());
            eventData.put(ISonargraphStatusProvider.Property.ERROR_WARNING_COUNT.name(), totalIssueCount);
        }
        this.a((Map<String, Object>)eventData, (Integer)totalIssueCount.getFirst(), (Integer)totalIssueCount.getSecond());
        this.i();
        return Status.OK_STATUS;
    }

    private void a(Collection<Issue> issuesRemoved, IIssueToMarkerMap processedIssueCache) {
        assert (issuesRemoved != null) : "Parameter 'issuesRemoved' of method 'removeIssues' must not be null";
        assert (processedIssueCache != null) : "Parameter 'processedIssueCache' of method 'removeIssues' must not be null";
        for (Issue next : issuesRemoved) {
            List<IMarker> markers = processedIssueCache.removed(next);
            for (IMarker marker : markers) {
                try {
                    marker.delete();
                }
                catch (CoreException e2) {
                    a.error("Exception occurred for deleting markers of issue '" + next + "'", (Throwable)e2);
                }
            }
        }
    }

    protected abstract void a(Map<String, Object> var1, int var2, int var3);

    protected void i() {
    }

    protected final AbstractIssueDto a(IIssueProvider issueProvider, Issue issue) {
        AbstractIssueDto dto;
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'convertIssue' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'convertIssue' must not be null";
        if (!issue.isValid()) {
            return null;
        }
        IssueCategory issueCategory = issue.getId().getCategory();
        if (com.hello2morrow.sonargraph.ide.eclipse.jobs.b.a.a(issue)) {
            if (a.isDebugEnabled()) {
                a.debug("Ignoring issue with id '{}' of category '{}'.", (Object)issue.getId().getStandardName(), (Object)issueCategory.getStandardName());
            }
            return null;
        }
        if (issueCategory == IssueCategory.CYCLE_GROUP) {
            AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)issue.getAffectedElement();
            NamedElement scope = cycleGroup.getScope();
            if (scope == null) {
                return null;
            }
            ResourceInfo scopeInfo = x.a((Element)scope);
            ResourceInfo info = new ResourceInfo(scopeInfo.getResource(), cycleGroup.getName(), false, scopeInfo.isPartOfActiveWorkspace());
            dto = issue.getId() == CoreIssueId.COMPONENT_CYCLE_GROUP ? new CycleGroupIssueDto((CycleGroupIssue)issue, info, this.a(issue, cycleGroup.getName(), false), this.b(issueProvider, issue)) : new CycleGroupIssueDto((CycleGroupIssue)issue, info, this.a(issue, cycleGroup.getName(), false), Collections.emptyList());
        } else if (issue.getId() == CoreIssueId.DUPLICATE_CODE_BLOCK) {
            ArrayList<DuplicateCodeBlockOccurrenceDto> occurrences = new ArrayList<DuplicateCodeBlockOccurrenceDto>();
            DuplicateCodeBlockIssue duplicateIssue = (DuplicateCodeBlockIssue)issue;
            ResourceInfo info = x.a(issue.getAffectedElement());
            for (DuplicateCodeBlockOccurrence next : duplicateIssue.getAffectedElement().getChildren(DuplicateCodeBlockOccurrence.class)) {
                DuplicateCodeBlockOccurrenceDto occurrenceDto = new DuplicateCodeBlockOccurrenceDto(info, next.getSourceFile().getFile(), next.getBlockBegin(), next.getBlockEnd(), next.getBlockSize(), next.getToleranceAsInt());
                occurrences.add(occurrenceDto);
            }
            dto = new DuplicateIssueDto(duplicateIssue, info, this.a(issue, info.getSonargraphElementName(), info.isResourceTrueElement()), occurrences);
        } else {
            Element affectedElement = issue.getAffectedElement();
            if (affectedElement.isExternal()) {
                if (a.isTraceEnabled()) {
                    a.trace("Omitting issue for external element '{}'", (Object)affectedElement.getName());
                }
                dto = null;
            } else if (affectedElement.isExcluded()) {
                if (a.isTraceEnabled()) {
                    a.trace("Omitting issue for excluded element '{}'", (Object)affectedElement.getName());
                }
                dto = null;
            } else {
                ResourceInfo info = affectedElement instanceof ElementWithIssues ? x.a((Element)((ElementWithIssues)affectedElement).getOriginal()) : x.a(affectedElement);
                dto = new StandardIssueDto(issue, info, this.a(issue, info.getSonargraphElementName(), info.isResourceTrueElement()), this.b(issueProvider, issue));
            }
        }
        return dto;
    }

    private List<TFile> b(IIssueProvider issueProvider, Issue issue) {
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'getSourceFiles' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'getSourceFiles' must not be null";
        List affectedPhysicalSourceFiles = issueProvider.getAffectedPhysicalSourceFiles(issue);
        if (affectedPhysicalSourceFiles.size() == 1) {
            return Collections.singletonList(((FilePath)affectedPhysicalSourceFiles.get(0)).getFile());
        }
        ArrayList<TFile> files = new ArrayList<TFile>(affectedPhysicalSourceFiles.size());
        for (FilePath path : affectedPhysicalSourceFiles) {
            files.add(path.getFile());
        }
        return files;
    }

    protected final ResolutionDto a(IIssueProvider issueProvider, Resolution resolution) {
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'convertResolution' must not be null";
        assert (resolution != null) : "Parameter 'resolution' of method 'convertResolution' must not be null";
        if (!resolution.isValid() || resolution.getMatchingElementsCount() == 0) {
            return null;
        }
        ArrayList associatedIssues = new ArrayList(resolution.getAssociatedIssues());
        ArrayList<AbstractIssueDto> issueDtos = new ArrayList<AbstractIssueDto>();
        for (IIssue accessor : associatedIssues) {
            Issue issue;
            if (!(accessor instanceof Issue) || !(issue = (Issue)accessor).isValid()) continue;
            AbstractIssueDto issueDto = this.a(issueProvider, issue);
            if (issueDto != null && issueDto.isValid()) {
                issueDtos.add(issueDto);
                continue;
            }
            if (issueDto == null || !a.isTraceEnabled()) continue;
            a.trace("Omitting issue '{}' for resource '{}'", (Object)issueDto.getDebugInfo(), (Object)issueDto.getResourceInfo());
        }
        if (issueDtos.isEmpty()) {
            if (a.isTraceEnabled()) {
                a.trace("Ignoring resolution '{}' because it does not contain any valid issues.", (Object)resolution.getDebugInfo());
            }
            return null;
        }
        ResolutionDto dto = resolution instanceof RefactoringDefinition ? new RefactoringDto((RefactoringDefinition)resolution, issueDtos) : new ResolutionDto(resolution, issueDtos);
        return dto;
    }

    protected static boolean a(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'isIssueToBeIgnored' must not be null";
        return d.contains(issue.getId().getCategory());
    }

    @Override
    public final boolean belongsTo(Object family) {
        return family instanceof a || super.belongsTo(family) || family == c;
    }

    protected final int a(Priority priority) {
        int eclipsePrio;
        assert (priority != null) : "Parameter 'priority' of method 'determinePriority' must not be null";
        switch (priority) {
            case HIGH: {
                eclipsePrio = 2;
                break;
            }
            case MEDIUM: {
                eclipsePrio = 1;
                break;
            }
            case LOW: {
                eclipsePrio = 0;
                break;
            }
            default: {
                eclipsePrio = 1;
            }
        }
        return eclipsePrio;
    }

    protected final int a(Severity severity) {
        int severityCode;
        assert (severity != null) : "Parameter 'severity' of method 'determineSeverity' must not be null";
        switch (severity) {
            case ERROR: {
                severityCode = 2;
                break;
            }
            case WARNING: {
                severityCode = 1;
                break;
            }
            default: {
                severityCode = 0;
            }
        }
        return severityCode;
    }

    protected String a(Issue issue, String elementName, boolean isResourceTrueElement) {
        assert (issue != null) : "Parameter 'issue' of method 'createDescriptionForProblem(Issue)' must not be null";
        StringBuilder description = new StringBuilder();
        if (issue.getId() == CoreIssueId.DUPLICATE_CODE_BLOCK || issue.getId().getCategory() == IssueCategory.CYCLE_GROUP) {
            NamedElementIssue namedElementIssue = (NamedElementIssue)issue;
            description.append(namedElementIssue.getAffectedElement().getShortName()).append(": ");
        } else if (issue.getId() != CoreIssueId.TODO) {
            description.append(issue.getName()).append(": ");
        }
        description.append(issue.getDescription());
        return description.toString();
    }

    protected StrictPair<Integer, Integer> a(IProgressMonitor monitor, List<AbstractIssueDto> issues) {
        assert (monitor != null) : "Parameter 'monitor' of method 'createMarkersForIssues' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'createMarkersForIssues' must not be null";
        a errors = new a();
        a warnings = new a();
        for (AbstractIssueDto issueDto : issues) {
            if (monitor.isCanceled()) {
                return new StrictPair((Object)-1, (Object)-1);
            }
            if (!issueDto.getIssue().isValid()) continue;
            ArrayList<IMarker> markers = new ArrayList<IMarker>();
            if (issueDto.getId().getCategory() == IssueCategory.CYCLE_GROUP) {
                if (issueDto.getId() == CoreIssueId.COMPONENT_CYCLE_GROUP) {
                    for (TFile nextCyclicElement : issueDto.getAffectedPhysicalSourceFiles()) {
                        IMarker cyclicMarker = this.a(nextCyclicElement, issueDto, errors, warnings);
                        if (cyclicMarker == null) continue;
                        markers.add(cyclicMarker);
                    }
                } else {
                    IMarker marker = this.a(null, issueDto.getResourceInfo().getResource(), issueDto, errors, warnings);
                    if (marker != null) {
                        markers.add(marker);
                    }
                }
                this.a(issueDto.getIssue(), markers);
                continue;
            }
            if (issueDto.getId().getCategory() == IssueCategory.DUPLICATE_CODE) {
                List<DuplicateCodeBlockOccurrenceDto> occurrences;
                if (issueDto instanceof DuplicateIssueDiffDto) {
                    occurrences = ((DuplicateIssueDiffDto)issueDto).getOccurrences();
                } else if (issueDto instanceof DuplicateIssueDto) {
                    occurrences = ((DuplicateIssueDto)issueDto).getOccurrences();
                } else {
                    assert (false) : "Unsupported issueDto " + issueDto.getClass().getCanonicalName();
                    occurrences = Collections.emptyList();
                }
                for (DuplicateCodeBlockOccurrenceDto occurrence : occurrences) {
                    IMarker marker = this.a(issueDto, occurrence, errors, warnings);
                    if (marker == null) continue;
                    markers.add(marker);
                }
                this.a(issueDto.getIssue(), markers);
                continue;
            }
            Collection<TFile> sourceFiles = issueDto.getAffectedPhysicalSourceFiles();
            if (!sourceFiles.isEmpty()) {
                for (TFile sourceFile : sourceFiles) {
                    IMarker marker;
                    assert (sourceFile != null) : "source file received must not be null";
                    Optional<IFile> eclipseSourceFile = EclipseWorkspaceUtils.getLocationForFile(sourceFile);
                    if (!eclipseSourceFile.isPresent() || (marker = this.a(sourceFile, (IResource)eclipseSourceFile.get(), issueDto, errors, warnings)) == null) continue;
                    markers.add(marker);
                }
            } else {
                IMarker marker = this.a(null, issueDto.getResourceInfo().getResource(), issueDto, errors, warnings);
                if (marker != null) {
                    markers.add(marker);
                }
            }
            this.a(issueDto.getIssue(), markers);
        }
        return new StrictPair((Object)errors.b(), (Object)warnings.b());
    }

    private IMarker a(TFile cyclicElement, AbstractIssueDto issueDto, a errors, a warnings) {
        assert (cyclicElement != null) : "Parameter 'cyclicElement' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (issueDto != null) : "Parameter 'issue' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (errors != null) : "Parameter 'errors' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (warnings != null) : "Parameter 'warnings' of method 'addProblemMarkerForCyclicElement' must not be null";
        boolean isDiff = issueDto instanceof AbstractIssueDiffDto;
        Optional<IFile> locationForFile = EclipseWorkspaceUtils.getLocationForFile(cyclicElement);
        if (!locationForFile.isPresent()) {
            return null;
        }
        IResource resource = (IResource)locationForFile.get();
        if (isDiff) {
            CycleGroupIssueDiffDto diffDto = (CycleGroupIssueDiffDto)issueDto;
            IDiffElement.Change change = diffDto.getChange(cyclicElement);
            if (change != IDiffElement.Change.REMOVED && change != IDiffElement.Change.RESOLUTION_ADDED) {
                String issueDescription = issueDto.getIssueDescription(cyclicElement);
                Severity severity = change == IDiffElement.Change.UNMODIFIED ? Severity.INFO : issueDto.getSeverity();
                IMarker cylicElementMarker = this.a(resource, issueDto, issueDescription, severity, errors, warnings);
                return cylicElementMarker;
            }
        } else {
            String issueDescription = issueDto.getIssueDescription(cyclicElement);
            Severity severity = issueDto.getSeverity();
            IMarker cylicElementMarker = this.a(resource, issueDto, issueDescription, severity, errors, warnings);
            return cylicElementMarker;
        }
        return null;
    }

    private IMarker a(IResource resource, AbstractIssueDto issueDto, String issueDescription, Severity severity, a errors, a warnings) {
        assert (resource != null) : "Parameter 'resource' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (issueDto != null) : "Parameter 'issue' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (errors != null) : "Parameter 'errors' of method 'addProblemMarkerForCyclicElement' must not be null";
        assert (warnings != null) : "Parameter 'warnings' of method 'addProblemMarkerForCyclicElement' must not be null";
        int severityCode = this.a(severity);
        try {
            IMarker marker = this.a(resource, issueDto);
            marker.setAttribute("message", (Object)issueDescription);
            marker.setAttribute("severity", severityCode);
            marker.setAttribute("lineNumber", 1);
            if (!this.a(issueDto)) {
                if (severityCode == 2) {
                    errors.a();
                } else if (severityCode == 1) {
                    warnings.a();
                }
            }
            return marker;
        }
        catch (CoreException e2) {
            a.error("Failed to create marker for resource " + resource.getFullPath(), (Throwable)e2);
            return null;
        }
    }

    protected int b(IProgressMonitor monitor, List<ResolutionDto> resolutions) {
        assert (monitor != null) : "Parameter 'monitor' of method 'createMarkersForTasks' must not be null";
        int markerCount = 0;
        int resolutionCount = 0;
        for (ResolutionDto resolutionDto : resolutions) {
            ++resolutionCount;
            if (monitor.isCanceled()) {
                return markerCount;
            }
            for (AbstractIssueDto issueDto : resolutionDto.getAssociatedIssues()) {
                IMarker marker;
                Issue issue = issueDto.getIssue();
                if (!issue.isValid() || issue.getResolution() == null || issue.getResolution() != resolutionDto.getResolution()) continue;
                ArrayList<IMarker> markers = new ArrayList<IMarker>();
                if (issueDto.getId().getCategory() == IssueCategory.CYCLE_GROUP && issueDto.getId() != CoreIssueId.COMPONENT_CYCLE_GROUP) {
                    CycleGroupIssueDto cycleGroupIssue = (CycleGroupIssueDto)issueDto;
                    marker = this.a(cycleGroupIssue.getResourceInfo().getResource(), resolutionDto, (AbstractIssueDto)cycleGroupIssue);
                    if (marker == null) continue;
                    markers.add(marker);
                    ++markerCount;
                    this.a(issue, markers);
                    continue;
                }
                if (issueDto.getId() == CoreIssueId.DUPLICATE_CODE_BLOCK) {
                    DuplicateIssueDto duplicate = (DuplicateIssueDto)issueDto;
                    for (DuplicateCodeBlockOccurrenceDto occurrence : duplicate.getOccurrences()) {
                        IMarker marker2 = this.a(resolutionDto, duplicate, occurrence, resolutionCount);
                        if (marker2 == null) continue;
                        markers.add(marker2);
                        ++markerCount;
                    }
                    this.a(duplicate.getIssue(), markers);
                    continue;
                }
                Collection<TFile> physicalSourceFiles = issueDto.getAffectedPhysicalSourceFiles();
                if (!physicalSourceFiles.isEmpty()) {
                    for (TFile sourceFile : physicalSourceFiles) {
                        IMarker marker3;
                        if (sourceFile == null) {
                            a.error("Received 'null' instead of source file for issue '{}'", (Object)issueDto.getDebugInfo());
                            continue;
                        }
                        assert (sourceFile != null) : "source file received must not be null";
                        Optional<IFile> eclipseSourceFile = EclipseWorkspaceUtils.getLocationForFile(sourceFile);
                        if (!eclipseSourceFile.isPresent() || (marker3 = this.a((IResource)eclipseSourceFile.get(), resolutionDto, issueDto)) == null) continue;
                        ++markerCount;
                        markers.add(marker3);
                    }
                } else {
                    marker = this.a(issueDto.getResourceInfo().getResource(), resolutionDto, issueDto);
                    if (marker != null) {
                        ++markerCount;
                        markers.add(marker);
                    }
                }
                this.a(issue, markers);
            }
        }
        return markerCount;
    }

    private void a(Issue issue, List<IMarker> markers) {
        assert (issue != null) : "Parameter 'issue' of method 'addMarkersToMap' must not be null";
        assert (markers != null) : "Parameter 'markers' of method 'addMarkersToMap' must not be null";
        List<IMarker> previous = this.h.added(issue, markers);
        if (previous != null) {
            a.warn("Deleting {} previous markers for issue {} that should not exist", (Object)previous.size(), (Object)issue);
            previous.forEach(m2 -> {
                try {
                    m2.delete();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            });
        }
    }

    private IMarker a(IResource resource, ResolutionDto resolution, AbstractIssueDto issue) {
        assert (resource != null) : "Parameter 'resource' of method 'addTaskMarker' must not be null";
        assert (resolution != null) : "Parameter 'resolution' of method 'addTaskMarker' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'addTaskMarker' must not be null";
        int priority = this.a(resolution.getPriority());
        StringBuilder description = new StringBuilder();
        description.append(this.a(resolution, issue, true));
        int lineNumber = issue.getLineNumber();
        try {
            IMarker marker = this.a(resource, resolution.getKind(), issue);
            marker.setAttribute("message", (Object)description.toString());
            marker.setAttribute("priority", priority);
            marker.setAttribute("issueId", (Object)issue.getId().getStandardName());
            if (resource instanceof IFile) {
                marker.setAttribute("lineNumber", lineNumber < 1 ? 1 : lineNumber);
            }
            return marker;
        }
        catch (CoreException e2) {
            a.error("Failed to create marker for resource '{}'", (Object)resource.getFullPath());
            return null;
        }
    }

    private IMarker a(ResolutionDto resolution, DuplicateIssueDto duplicate, DuplicateCodeBlockOccurrenceDto occurrence, int resolutionCount) {
        assert (resolution != null) : "Parameter 'resolution' of method 'addTaskMarker' must not be null";
        assert (duplicate != null) : "Parameter 'duplicate' of method 'addTaskMarkerForDuplicate' must not be null";
        assert (occurrence != null) : "Parameter 'occurrence' of method 'addTaskMarkerForDuplicate' must not be null";
        int priority = this.a(resolution.getPriority());
        StringBuilder description = new StringBuilder();
        description.append(resolutionCount).append(". ").append(this.a(resolution, duplicate, false)).append(", ").append(duplicate.getResourceInfo().getSonargraphElementName()).append(" ").append(occurrence.getPresentationName());
        try {
            Optional<IFile> fileOpt = EclipseWorkspaceUtils.getLocationForFile(occurrence.getSourceFile());
            if (fileOpt.isPresent()) {
                IMarker marker = this.a((IResource)fileOpt.get(), resolution.getKind(), (AbstractIssueDto)duplicate);
                marker.setAttribute("message", (Object)description.toString());
                marker.setAttribute("priority", priority);
                marker.setAttribute("issueId", (Object)duplicate.getId().getStandardName());
                marker.setAttribute("lineNumber", occurrence.getStartLine());
                return marker;
            }
        }
        catch (CoreException e2) {
            a.error("Failed to create marker for file '{}'", (Object)occurrence.getSourceFile().getAbsolutePath());
        }
        return null;
    }

    private String a(ResolutionDto resolutionDto, AbstractIssueDto issueDto, boolean addIssueDescription) {
        assert (resolutionDto != null) : "Parameter 'resolution' of method 'createDescriptionForTask' must not be null";
        assert (issueDto != null) : "Parameter 'issue' of method 'createDescriptionForTask' must not be null";
        StringBuilder description = new StringBuilder();
        description.append(Iso8601DateFormat.formatDateAndTime((Date)resolutionDto.getResolution().getDate())).append(" ");
        if (resolutionDto.getChange() != null) {
            description.append("[").append(resolutionDto.getChange().getPresentationName()).append("] ");
        }
        description.append("[").append(resolutionDto.getKind().getPresentationName()).append("]");
        String assignee = resolutionDto.getAssignee();
        if (!assignee.trim().isEmpty()) {
            description.append(" [").append(resolutionDto.getAssignee()).append("]");
        }
        if (resolutionDto.getKind() == ResolutionKind.TODO) {
            description.append(" ").append(issueDto.getIssueDescription());
        } else {
            String desc = resolutionDto.getDescription();
            if (!desc.trim().isEmpty()) {
                description.append(" ").append(resolutionDto.getDescription());
            }
            if (addIssueDescription) {
                description.append(" ").append(issueDto.getIssueDescription());
            }
        }
        return description.toString();
    }

    private IMarker a(TFile sourceFile, IResource resource, AbstractIssueDto issueDto, a errors, a warnings) {
        assert (resource != null) : "Parameter 'resource' of method 'addProblemMarker' must not be null";
        assert (issueDto != null) : "Parameter 'issue' of method 'addProblemMarker' must not be null";
        assert (errors != null) : "Parameter 'errors' of method 'addProblemMarker' must not be null";
        assert (warnings != null) : "Parameter 'warnings' of method 'addProblemMarker' must not be null";
        int severity = this.a(issueDto.getSeverity());
        try {
            IMarker marker = this.a(resource, issueDto);
            marker.setAttribute("message", (Object)(sourceFile == null ? issueDto.getIssueDescription() : issueDto.getIssueDescription(sourceFile)));
            marker.setAttribute("severity", severity);
            int lineNumber = issueDto.getLineNumber();
            if (lineNumber > 0) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            if (!this.a(issueDto)) {
                if (severity == 2) {
                    errors.a();
                } else if (severity == 1) {
                    warnings.a();
                }
            }
            return marker;
        }
        catch (CoreException e2) {
            a.error("Failed to create marker for resource " + resource.getFullPath(), (Throwable)e2);
            return null;
        }
    }

    protected boolean a(AbstractIssueDto issueDto) {
        return false;
    }

    private IMarker a(AbstractIssueDto duplicate, DuplicateCodeBlockOccurrenceDto occurrence, a errors, a warnings) {
        assert (duplicate != null) : "Parameter 'duplicate' of method 'addProblemMarkerForDuplicate' must not be null";
        assert (occurrence != null) : "Parameter 'occurrence' of method 'addProblemMarkerForDuplicate' must not be null";
        assert (errors != null) : "Parameter 'errors' of method 'addProblemMarkerForDuplicate' must not be null";
        assert (warnings != null) : "Parameter 'warnings' of method 'addProblemMarkerForDuplicate' must not be null";
        int severity = this.a(duplicate.getSeverity());
        try {
            Optional<IFile> fileOpt = EclipseWorkspaceUtils.getLocationForFile(occurrence.getSourceFile());
            if (fileOpt.isPresent()) {
                IMarker marker = this.a((IResource)fileOpt.get(), duplicate);
                StringBuilder message = new StringBuilder();
                if (occurrence instanceof DuplicateCodeBlockOccurrenceDiffDto) {
                    DuplicateCodeBlockOccurrenceDiffDto diff = (DuplicateCodeBlockOccurrenceDiffDto)occurrence;
                    message.append("[").append(diff.getChange().getPresentationName()).append("] ");
                    message.append(duplicate.getResourceInfo().getSonargraphElementName());
                    message.append(" (");
                    if (diff.getChangeDescription() == null || diff.getChangeDescription().trim().length() == 0) {
                        message.append(diff.getPresentationName());
                    } else {
                        message.append(diff.getChangeDescription());
                    }
                    message.append(")");
                    if (diff.getChange() == IDiffElement.Change.UNMODIFIED) {
                        severity = 0;
                    }
                } else {
                    message.append(duplicate.getResourceInfo().getSonargraphElementName()).append(" (").append(occurrence.getPresentationName()).append(")");
                }
                marker.setAttribute("message", (Object)message.toString());
                marker.setAttribute("severity", severity);
                marker.setAttribute("lineNumber", occurrence.getStartLine());
                if (severity == 2) {
                    errors.a();
                } else if (severity == 1) {
                    warnings.a();
                }
                return marker;
            }
        }
        catch (CoreException e2) {
            a.error("Failed to create marker for file '{}'", (Object)occurrence.getSourceFile().getAbsolutePath());
        }
        return null;
    }

    private IMarker a(IResource resource, ResolutionKind resolutionKind, AbstractIssueDto issue) throws CoreException {
        IMarker marker;
        assert (resource != null) : "Parameter 'resource' of method 'createMarkerType' must not be null";
        assert (resolutionKind != null) : "Parameter 'resolutionKind' of method 'createProblemMarkerType' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'createMarkerType' must not be null";
        IssueCategory category = issue.getId().getCategory();
        if (resolutionKind == ResolutionKind.REFACTORING) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.task.refactoring");
            marker.setAttribute("issueKey", (Object)(String.valueOf(issue.getKey()) + issue.getIssueDescription()));
        } else if (resolutionKind == ResolutionKind.FIX) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.task.fix");
        } else if (resolutionKind == ResolutionKind.TODO) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.task.todo");
        } else {
            a.error("Unsupported ResolutionKind '{}'. Using Todo marker type.", (Object)resolutionKind.getStandardName());
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.task.todo");
        }
        if (category == IssueCategory.CYCLE_GROUP) {
            marker.setAttribute("cycleName", (Object)issue.getResourceInfo().getSonargraphElementName());
        }
        return marker;
    }

    private IMarker a(IResource resource, AbstractIssueDto issue) throws CoreException {
        IMarker marker;
        assert (resource != null) : "Parameter 'resource' of method 'createMarkerType' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'createMarkerType' must not be null";
        IssueCategory category = issue.getId().getCategory();
        if (category == IssueCategory.DUPLICATE_CODE) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.duplicate");
        } else if (category == IssueCategory.ARCHITECTURE_VIOLATION) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.architecture");
        } else if (category == IssueCategory.SCRIPT_BASED) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.script");
        } else if (category == IssueCategory.THRESHOLD_VIOLATION) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.threshold");
        } else if (category == IssueCategory.CYCLE_GROUP) {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.cycle");
            marker.setAttribute("cycleName", (Object)issue.getResourceInfo().getSonargraphElementName());
        } else {
            marker = resource.createMarker("com.hello2morrow.sonargraph.ide.eclipse.marker.issue.generic");
        }
        return marker;
    }

    protected abstract List<AbstractIssueDto> a(Collection<Issue> var1, IProgressMonitor var2);

    protected abstract List<ResolutionDto> b(Collection<Issue> var1, IProgressMonitor var2);

    private static final class a {
        private int a = 0;

        private a() {
        }

        public void a() {
            ++this.a;
        }

        public int b() {
            return this.a;
        }
    }
}

