/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.e3;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public final class E3DecoratorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(E3DecoratorManager.class);
    UISynchronize m_uiSynchronize;

    @Inject
    public E3DecoratorManager(UISynchronize uiSynchronize) {
        this.m_uiSynchronize = uiSynchronize;
    }

    public void enable() {
        assert (this.m_uiSynchronize != null) : "Field 'm_uiSynchronize' in method 'enable' must be injected";
        if (PlatformUI.isWorkbenchRunning()) {
            IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
            this.m_uiSynchronize.syncExec(() -> {
                try {
                    decoratorManager.setEnabled("com.hello2morrow.sonargraph.ide.eclipse.sonargraphDecorator", true);
                    decoratorManager.update("com.hello2morrow.sonargraph.ide.eclipse.sonargraphDecorator");
                }
                catch (CoreException ce) {
                    LOGGER.error("Failed to enable Sonargraph decorator", (Throwable)ce);
                }
            });
        }
    }

    public void disable() {
        assert (this.m_uiSynchronize != null) : "Field 'm_uiSynchronize' in method 'disable' must be injected";
        if (PlatformUI.isWorkbenchRunning()) {
            IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
            this.m_uiSynchronize.syncExec(() -> {
                try {
                    decoratorManager.update("com.hello2morrow.sonargraph.ide.eclipse.sonargraphDecorator");
                    decoratorManager.setEnabled("com.hello2morrow.sonargraph.ide.eclipse.sonargraphDecorator", false);
                }
                catch (CoreException ce) {
                    LOGGER.error("Failed to disable Sonargraph decorator", (Throwable)ce);
                }
            });
        }
    }
}

