/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler.remoting;

import com.hello2morrow.sonargraph.core.model.remoting.IRemoteSelectionProvider;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.remoting.ConfigureRemoteSelectionHandler;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.EclipseRevealRemoteSelectionJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.PreferredViewForRevealingRemoteSelection;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.navigator.resources.ProjectExplorer;

public final class EclipseRevealRemoteSelectionHandler
extends CommandHandler {
    private static final String PACKAGE_EXPLORER = "org.eclipse.jdt.ui.PackageExplorer";
    private static final String PROJECT_EXPLORER = "org.eclipse.ui.navigator.ProjectExplorer";

    @Execute
    public Object execute(ISonargraphEclipsePlugin plugin, EPartService partService) {
        TreeViewer viewer;
        if (ConfigureRemoteSelectionHandler.getPreferredView() == PreferredViewForRevealingRemoteSelection.PACKAGE_EXPLORER) {
            viewer = this.getPackageExplorerTreeViewer(partService);
            if (viewer == null) {
                viewer = this.getProjectExplorerTreeViewer(partService);
            }
        } else {
            viewer = this.getProjectExplorerTreeViewer(partService);
            if (viewer == null) {
                viewer = this.getPackageExplorerTreeViewer(partService);
            }
        }
        if (viewer == null) {
            UserInterfaceAdapter.b().c("Failed to Reveal Remote Selection", "Neither 'Package Explorer' nor 'Project Explorer' views could be found\nto reveal remote selection request.");
            return null;
        }
        EclipseRevealRemoteSelectionJob job = new EclipseRevealRemoteSelectionJob(plugin, viewer);
        job.schedule();
        return null;
    }

    private TreeViewer getProjectExplorerTreeViewer(EPartService partService) {
        IWorkbenchPart workbenchPart;
        assert (partService != null) : "Parameter 'partService' of method 'getProjectExplorerTreeViewer' must not be null";
        MPart projectExplorerPart = partService.findPart(PROJECT_EXPLORER);
        if (projectExplorerPart == null || !projectExplorerPart.isVisible()) {
            return null;
        }
        projectExplorerPart = partService.showPart(PROJECT_EXPLORER, EPartService.PartState.ACTIVATE);
        Object projectExplorerViewPart = projectExplorerPart == null ? null : (projectExplorerPart.getObject() instanceof CompatibilityPart ? ((workbenchPart = ((CompatibilityPart)projectExplorerPart.getObject()).getPart()) instanceof ProjectExplorer ? (ProjectExplorer)workbenchPart : null) : (projectExplorerPart.getObject() instanceof ProjectExplorer ? (ProjectExplorer)projectExplorerPart.getObject() : null));
        if (projectExplorerViewPart != null) {
            return projectExplorerViewPart.getCommonViewer();
        }
        return null;
    }

    private TreeViewer getPackageExplorerTreeViewer(EPartService partService) {
        IWorkbenchPart workbenchPart;
        assert (partService != null) : "Parameter 'partService' of method 'getTreeViewerOf' must not be null";
        MPart packageExplorerPart = partService.findPart(PACKAGE_EXPLORER);
        if (packageExplorerPart == null || !packageExplorerPart.isVisible()) {
            return null;
        }
        packageExplorerPart = partService.showPart(PACKAGE_EXPLORER, EPartService.PartState.ACTIVATE);
        Object packagesViewPart = packageExplorerPart == null ? null : (packageExplorerPart.getObject() instanceof CompatibilityPart ? ((workbenchPart = ((CompatibilityPart)packageExplorerPart.getObject()).getPart()) instanceof IPackagesViewPart ? (IPackagesViewPart)workbenchPart : null) : (packageExplorerPart.getObject() instanceof IPackagesViewPart ? (IPackagesViewPart)packageExplorerPart.getObject() : null));
        if (packagesViewPart != null) {
            return packagesViewPart.getTreeViewer();
        }
        return null;
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin) {
        if (plugin == null || !plugin.isInitialized() || plugin.isStopping()) {
            return false;
        }
        IRemoteSelectionProvider selectionProvider = (IRemoteSelectionProvider)plugin.getSoftwareSystemProvider().getInstallation().getExtension(IRemoteSelectionProvider.class);
        return selectionProvider.isServerRunning() && selectionProvider.hasRemoteSelection();
    }
}

