/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler.refactoring;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.ide.eclipse.b.b;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.E;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.t;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.refactoringsview.RefactoringsView;
import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

abstract class RefactoringHandler<T extends RefactoringDefinition>
extends CommandHandler {
    protected RefactoringHandler() {
    }

    protected abstract Class<T> getRefactoringDefinitionClass();

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean a(t workbenchView, List<Element> currentSelection) {
                RefactoringsView refactoringsView;
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'showInContextMenu' must not be null");
                }
                if (!$assertionsDisabled && currentSelection == null) {
                    throw new AssertionError((Object)"Parameter 'currentSelection' of method 'showInContextMenu' must not be null");
                }
                if (workbenchView instanceof RefactoringsView && (refactoringsView = (RefactoringsView)workbenchView).getSelectedViewComponentId() == RefactoringsView.ViewComponent.REFACTORINGS) {
                    return RefactoringHandler.getSingleSelection(RefactoringHandler.this.getRefactoringDefinitionClass(), currentSelection, (boolean)false) != null;
                }
                return false;
            }
        };
    }

    @CanExecute
    public final boolean canExecute(@Optional ISonargraphEclipsePlugin plugin, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") E activeSelection) {
        RefactoringDefinition refactoring;
        if (plugin == null) {
            return false;
        }
        if (!this.isAvailable()) {
            return false;
        }
        if (activeSelection != null && plugin.isInitialized() && plugin.getSoftwareSystemProvider().hasSoftwareSystem() && (refactoring = (RefactoringDefinition)RefactoringHandler.getSingleSelection(this.getRefactoringDefinitionClass(), (List)activeSelection.b(), (boolean)false)) != null && refactoring.getStatus().isApplicable()) {
            IIssueProvider provider = (IIssueProvider)plugin.getSoftwareSystemProvider().getSoftwareSystem().getExtension(IIssueProvider.class);
            return !provider.getRelevantNamedElements(refactoring).isEmpty();
        }
        return false;
    }

    protected abstract void performExecute(b var1, List<NamedElement> var2, T var3);

    @Execute
    public final void execute(ISonargraphEclipsePlugin plugin, @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") E activeSelection) {
        assert (plugin != null) : "Parameter 'plugin' of method 'execute' must not be null";
        assert (activeSelection != null) : "Parameter 'activeSelection' of method 'execute' must not be null";
        assert (plugin.isInitialized()) : "Plugin not initialized";
        assert (plugin.getSoftwareSystemProvider().hasSoftwareSystem()) : "No system available";
        if (b.a()) {
            UserInterfaceAdapter.b().b("Build Jobs Running", "Sonargraph refactoring cannot be executed while build jobs are running/pending.");
            return;
        }
        RefactoringDefinition refactoring = (RefactoringDefinition)RefactoringHandler.getSingleSelection(this.getRefactoringDefinitionClass(), (List)activeSelection.b(), (boolean)false);
        assert (refactoring != null) : "'refactoring' of method 'execute' must not be null";
        assert (refactoring.getStatus().isApplicable()) : "Refactoring not applicable";
        IIssueProvider provider = (IIssueProvider)plugin.getSoftwareSystemProvider().getSoftwareSystem().getExtension(IIssueProvider.class);
        List relevant = provider.getRelevantNamedElements(refactoring);
        assert (relevant != null && !relevant.isEmpty()) : "'relevant' of method 'execute' must not be empty";
        this.performExecute(new b(plugin), relevant, refactoring);
    }
}

