/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.virtualmodel;

import com.hello2morrow.foundation.file.TFileBasedXmlElementAttributesExtractor;
import com.hello2morrow.foundation.text.IntBasedHash;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.model.analysis.DynamicIssueType;
import com.hello2morrow.sonargraph.core.model.analysis.ThresholdIssueType;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureCheckIssueId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureDeprecationIssueId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IssueType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyWildcardPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.LineBasedContextSimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementFullyQualifiedNamePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementWildcardPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.ParserDependencyEndpointPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.SimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.plugin.IPluginProvider;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.FixDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ToDoDefinition;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueId;
import com.hello2morrow.sonargraph.core.model.script.ScriptProviderId;
import com.hello2morrow.sonargraph.core.model.system.IPersistableVirtualModel;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.system.PersistenceCause;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.AbstractVirtualModelIO;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.VirtualModelPersistenceCause;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdDeleteResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdDependencyPattern;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdDependencyPatternType;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdDependencyScriptIssueType;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdElementPattern;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdElementPatternType;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdElementScriptIssueType;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdFixResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdIgnoreResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdIssueType;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdMatching;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdMoveRenameResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdMoveResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdRenameResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdResolutions;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdToDoResolution;
import com.hello2morrow.sonargraph.core.persistence.virtualmodel.XsdVirtualModel;
import com.hello2morrow.sonargraph.integration.access.foundation.a;
import com.hello2morrow.sonargraph.integration.access.foundation.e;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VirtualModelReader
extends AbstractVirtualModelIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVirtualModelIO.class);
    private static final Pattern NEW_ARCHITECTURE_VIOLATION_DESCRIPTOR_PATTERN = Pattern.compile(String.valueOf(ArchitectureViolationIssueId.INSTANCE.getStandardName()) + ":\\./.*\\.arc");
    private final Map<String, ScriptProviderId> m_identifyingPathToScriptProviderId = new THashMap();
    private final IPluginProvider m_pluginProvider;

    VirtualModelReader(Version productVersion, a aggregatingClassLoader, IPluginProvider pluginProvider, XmlPersistenceContext persistenceContext) {
        super(productVersion, aggregatingClassLoader, persistenceContext);
        assert (pluginProvider != null) : "Parameter 'pluginProvider' of method 'VirtualModelReader' must not be null";
        this.m_pluginProvider = pluginProvider;
    }

    OperationResult load(TFile virtualModelFile, IPersistableVirtualModel model) {
        assert (virtualModelFile != null) : "Parameter 'virtualModelFile' of method 'load' must not be null";
        assert (model != null) : "Parameter 'creator' of method 'load' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load virtual model from '" + virtualModelFile.getName() + "'");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileInputStream inputStream = new TFileInputStream((File)virtualModelFile);){
                OperationResultWithOutcome<XsdVirtualModel> loadResult = this.internLoadFromStream((InputStream)inputStream, model);
                if (loadResult.isFailure()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed to process file '" + virtualModelFile.getAbsolutePath() + "'.", new Object[0]);
                    Map attributes = TFileBasedXmlElementAttributesExtractor.process((TFile)virtualModelFile, (String)"virtualModel");
                    if (attributes == null) {
                        result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Not an XML file '" + virtualModelFile.getAbsolutePath() + "'.", new Object[0]);
                    } else {
                        String versionAsString = (String)attributes.get("version");
                        if (versionAsString == null || versionAsString.isEmpty()) {
                            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "No 'version' info found in XML file '" + virtualModelFile.getAbsolutePath() + "'.", new Object[0]);
                        } else {
                            Version versionFromFile = Version.create((String)versionAsString);
                            if (versionFromFile == null) {
                                result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Version from attribute 'version' has unsupported format '" + versionAsString + "'.", new Object[0]);
                            } else if (versionFromFile.isAfter(this.getProductVersion())) {
                                result.addError((OperationResult.IMessageCause)ValidationEventHandlerImpl.ValidationMessageCauses.VERSION_MISMATCH, "Update of Sonargraph needed. The virtual model was last saved with version '" + versionFromFile + "', installation has version '" + this.getProductVersion() + "'!", new Object[0]);
                            }
                        }
                    }
                }
                result.addMessagesFrom(loadResult);
                result.setOutcome((Object)((XsdVirtualModel)loadResult.getOutcome()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, (Throwable)ex, "Failed to load configuration from file '" + virtualModelFile.getNormalizedAbsolutePath() + "'", new Object[0]);
            return result;
        }
        if (result.isFailure()) {
            return result;
        }
        if (result.getOutcome() == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "No data found for virtual model in file '" + virtualModelFile.getNormalizedAbsolutePath() + "'", new Object[0]);
            return result;
        }
        this.createPojo(model, (XsdVirtualModel)result.getOutcome(), (OperationResult)result);
        return result;
    }

    OperationResult load(InputStream inputStream, IPersistableVirtualModel model) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadFromStream' must not be null";
        assert (model != null) : "Parameter 'model' of method 'load' must not be null";
        OperationResultWithOutcome<XsdVirtualModel> result = this.internLoadFromStream(inputStream, model);
        if (result.isSuccess()) {
            this.createPojo(model, (XsdVirtualModel)result.getOutcome(), (OperationResult)result);
        }
        return result;
    }

    private OperationResultWithOutcome<XsdVirtualModel> internLoadFromStream(InputStream inputStream, IPersistableVirtualModel model) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadFromStream' must not be null";
        assert (model != null) : "Parameter 'creator' of method 'internLoadFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading model '" + model.getIdentifyingPath() + "' from stream");
        JaxbAdapter<JAXBElement<XsdVirtualModel>> jaxbAdapter = this.createJaxbAadpter();
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl((OperationResult)result);
        JAXBElement xsdVirtualModel = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)eventHandler);
        if (result.isFailure()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Virtual model loaded from stream is corrupt", new Object[0]);
            return result;
        }
        result.setOutcome((Object)((XsdVirtualModel)xsdVirtualModel.getValue()));
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void createPojo(IPersistableVirtualModel model, XsdVirtualModel xsdVirtualModel, OperationResult result) {
        assert (model != null) : "Parameter 'model' of method 'createPojo' must not be null";
        assert (xsdVirtualModel != null) : "Parameter 'xsdVirtualModel' of method 'createPojo' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createPojo' must not be null";
        String versionFromPersistenceAsString = xsdVirtualModel.getVersion();
        Version versionFromPersistence = Version.create((String)versionFromPersistenceAsString);
        if (versionFromPersistence == null) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.VERSION_NOT_VALID, "Version read from persistence: '" + versionFromPersistenceAsString + "'", new Object[0]);
            return;
        }
        String versionBeforeMigrationString = xsdVirtualModel.getVersionBeforeMigration();
        if (versionBeforeMigrationString != null) {
            Version versionBeforeMigration = Version.create((String)versionBeforeMigrationString);
            if (versionBeforeMigration == null) {
                result.addError((OperationResult.IMessageCause)PersistenceCause.VERSION_NOT_VALID, "Version (previousVersion) read from persistence: '" + versionFromPersistenceAsString + "'", new Object[0]);
                return;
            }
            model.setVersion(versionBeforeMigration);
        } else {
            model.setVersion(versionFromPersistence);
        }
        String basedOn = xsdVirtualModel.getBasedOn();
        if (basedOn != null && !basedOn.isEmpty()) {
            model.setBasedOnPersistableVirtualModel(basedOn);
        }
        model.setDescription(xsdVirtualModel.getDescription());
        XsdResolutions resolutions = xsdVirtualModel.getResolutions();
        if (resolutions != null) {
            block10: for (XsdResolution xsdResolution : resolutions.getIgnoreOrFixOrTodo()) {
                Resolution resolution = this.createResolution(model.getNamedElement(), xsdResolution, result);
                assert (resolution != null) : "Unsupported resolution type '" + xsdResolution.getClass().getName() + "'";
                XsdIssueType xsdIssueType = xsdResolution.getType();
                String issueTypeClass = xsdIssueType.getClazz();
                String issueTypeNamePotentiallyMigrated = xsdIssueType.getName();
                List<XsdElementPattern> xsdElementPatterns = xsdResolution.getElementPattern();
                if (xsdIssueType instanceof XsdElementScriptIssueType || xsdIssueType instanceof XsdDependencyScriptIssueType) {
                    this.addOldScriptIssueType(resolution, xsdIssueType, result);
                } else {
                    String issueTypeName = xsdIssueType.getName();
                    String issueTypeDescriptor = xsdIssueType.getDescriptor();
                    switch (issueTypeClass) {
                        case "Architecture": {
                            if (this.addArchitectureCheckIssueType(resolution, issueTypeName, issueTypeDescriptor, result)) break;
                            continue block10;
                        }
                        case "Script": {
                            if (this.addScriptIssueType(resolution, issueTypeName, issueTypeDescriptor, result)) break;
                            continue block10;
                        }
                        case "Plugin": {
                            if (this.addPluginIssueType(model, resolution, issueTypeName, issueTypeDescriptor, result)) break;
                            continue block10;
                        }
                        default: {
                            issueTypeNamePotentiallyMigrated = this.migrateIfNecessary(versionFromPersistence, issueTypeName, xsdElementPatterns);
                            if (!this.addEnumBasedIssueType(resolution, issueTypeClass, issueTypeNamePotentiallyMigrated, issueTypeDescriptor, result)) continue block10;
                        }
                    }
                }
                String identifyingPath = model.getIdentifyingPath();
                for (XsdElementPattern nextXsdElementPattern : xsdElementPatterns) {
                    String string = nextXsdElementPattern.getValue();
                    if (string == null || string.isEmpty()) {
                        result.addError((OperationResult.IMessageCause)PersistenceCause.PATTERN_NOT_VALID, "Pattern is empty.", new Object[0]);
                        continue;
                    }
                    String string2 = string.replace(identifyingPath, "Result");
                    NamedElementIssuePattern nextNamedElementIssuePattern = this.createNamedElementIssuePattern(versionFromPersistence, resolution, issueTypeClass, issueTypeNamePotentiallyMigrated, string2, nextXsdElementPattern, result);
                    if (nextNamedElementIssuePattern == null) continue;
                    resolution.addChild(nextNamedElementIssuePattern);
                }
                for (XsdDependencyPattern xsdDependency : xsdResolution.getDependencyPattern()) {
                    void var19_24;
                    XsdDependencyPatternType type = xsdDependency.getType();
                    String fromPattern = xsdDependency.getFrom();
                    String toPattern = xsdDependency.getTo();
                    if (fromPattern == null || fromPattern.isEmpty()) {
                        result.addError((OperationResult.IMessageCause)PersistenceCause.PATTERN_NOT_VALID, "From pattern is empty.", new Object[0]);
                        continue;
                    }
                    if (toPattern == null || toPattern.isEmpty()) {
                        result.addError((OperationResult.IMessageCause)PersistenceCause.PATTERN_NOT_VALID, "To pattern is empty.", new Object[0]);
                        continue;
                    }
                    if (type == null || type == XsdDependencyPatternType.WILDCARD) {
                        DependencyWildcardPattern dependencyWildcardPattern = new DependencyWildcardPattern(resolution, fromPattern, toPattern);
                    } else {
                        assert (type == XsdDependencyPatternType.PARSER_DEPENDENCY_ENDPOINT) : "Unexpected type: " + (Object)((Object)type);
                        ParserDependencyEndpointPattern parserDependencyEndpointPattern = new ParserDependencyEndpointPattern(resolution, fromPattern, toPattern);
                    }
                    resolution.addChild((NamedElement)var19_24);
                }
                this.addMatchingInfoToPojo(xsdResolution, resolution);
                model.getNamedElement().addChild(resolution);
            }
        }
    }

    private String migrateIfNecessary(Version versionFromPersistence, String issueTypeName, List<XsdElementPattern> xsdElementPatterns) {
        assert (versionFromPersistence != null) : "Parameter 'versionFromPersistence' of method 'migrateIfNecessary' must not be null";
        assert (issueTypeName != null) : "Parameter 'issueTypeName' of method 'migrateIfNecessary' must not be null";
        assert (xsdElementPatterns != null) : "Parameter 'xsdElementPatterns' of method 'migrateIfNecessary' must not be null";
        Version version_8_7_0 = Version.create((int)8, (int)7, (int)0, (int)0);
        if (this.getProductVersion().isAtLeast(version_8_7_0) && versionFromPersistence.isBefore(version_8_7_0) && "CycleGroup".equals(issueTypeName) && !xsdElementPatterns.isEmpty()) {
            String pattern = xsdElementPatterns.get(0).getValue();
            String moduleCyclesSystem = "Analyzers:ModuleCyclesSystem:./Modifiable.vm";
            if (pattern.indexOf("Analyzers:ModuleCyclesSystem:./Modifiable.vm") != -1) {
                return "ModuleCycleGroup";
            }
            String componentCyclesSystem = "Analyzers:ComponentCyclesSystem:./Modifiable.vm";
            String componentCyclesModule = "Analyzers:ComponentCyclesModule:./Modifiable.vm";
            if (pattern.indexOf("Analyzers:ComponentCyclesSystem:./Modifiable.vm") != -1 || pattern.indexOf("Analyzers:ComponentCyclesModule:./Modifiable.vm") != -1) {
                return "ComponentCycleGroup";
            }
            String directoryCyclesSystem = "Analyzers:DirectoryCyclesSystem:./Modifiable.vm";
            String directoryCyclesModule = "Analyzers:DirectoryCyclesModule:./Modifiable.vm";
            if (pattern.indexOf("Analyzers:DirectoryCyclesSystem:./Modifiable.vm") != -1 || pattern.indexOf("Analyzers:DirectoryCyclesModule:./Modifiable.vm") != -1) {
                return "DirectoryCycleGroup";
            }
            return "NamespaceCycleGroup";
        }
        return issueTypeName;
    }

    private void addMatchingInfoToPojo(XsdResolution xsdResolution, Resolution resolution) {
        String xsdInfo;
        assert (xsdResolution != null) : "Parameter 'xsdResolution' of method 'addMatchingInfoToPojo' must not be null";
        assert (resolution != null) : "Parameter 'resolution' of method 'addMatchingInfoToPojo' must not be null";
        XsdMatching xsdMatching = xsdResolution.getMatching();
        if (xsdMatching != null && (xsdInfo = xsdMatching.getInfo()) != null && !xsdInfo.isEmpty()) {
            Matching matchingInfo = resolution.getUniqueChild(Matching.class);
            if (matchingInfo == null) {
                matchingInfo = new Matching(resolution, xsdInfo);
                resolution.addChild(matchingInfo);
            } else {
                matchingInfo.setInformation(xsdInfo);
            }
            List<XsdElementPattern> xsdElementPatterns = xsdMatching.getElementPattern();
            for (XsdElementPattern nextXsdElementPattern : xsdElementPatterns) {
                XsdElementPatternType nextXsdElementPatternType = nextXsdElementPattern.getType();
                if (nextXsdElementPatternType == null || nextXsdElementPatternType != XsdElementPatternType.FULLY_QUALIFIED_NAME) continue;
                String pattern = nextXsdElementPattern.getValue();
                String hash = nextXsdElementPattern.getHash();
                if (pattern == null || pattern.isEmpty()) break;
                if (hash != null && !hash.isEmpty()) {
                    matchingInfo.addElementFqName(pattern, IntBasedHash.decode((String)hash));
                    continue;
                }
                matchingInfo.addElementFqName(pattern);
            }
        }
    }

    private NamedElementIssuePattern createNamedElementIssuePattern(Version versionFromPersistence, Resolution resolution, String issueTypeClass, String issueTypeName, String pattern, XsdElementPattern xsdElementPattern, OperationResult result) {
        assert (versionFromPersistence != null) : "Parameter 'versionFromPersistence' of method 'createNamedElementIssuePattern' must not be null";
        assert (resolution != null) : "Parameter 'resolution' of method 'createNamedElementIssuePattern' must not be null";
        assert (issueTypeClass != null && issueTypeClass.length() > 0) : "Parameter 'issueTypeClass' of method 'createNamedElementIssuePattern' must not be empty";
        assert (issueTypeName != null && issueTypeName.length() > 0) : "Parameter 'issueTypeName' of method 'createNamedElementIssuePattern' must not be empty";
        assert (xsdElementPattern != null) : "Parameter 'xsdElementPattern' of method 'createNamedElementIssuePattern' must not be null";
        XsdElementPatternType type = xsdElementPattern.getType();
        if (type == null || type == XsdElementPatternType.WILDCARD) {
            return new NamedElementWildcardPattern(resolution, pattern);
        }
        if (CoreIssueId.class.getName().equals(issueTypeClass)) {
            if (CoreIssueId.DUPLICATE_CODE_BLOCK.getStandardName().equals(issueTypeName)) {
                return new SimilarityMatchPattern(resolution, pattern);
            }
            if (CoreIssueId.COMPONENT_CYCLE_GROUP.getStandardName().equals(issueTypeName) || CoreIssueId.NAMESPACE_CYCLE_GROUP.getStandardName().equals(issueTypeName) || CoreIssueId.DIRECTORY_CYCLE_GROUP.getStandardName().equals(issueTypeName) || CoreIssueId.MODULE_CYCLE_GROUP.getStandardName().equals(issueTypeName)) {
                return new SimilarityMatchPattern(resolution, pattern);
            }
        }
        if (xsdElementPattern.getHash() != null) {
            String hash = xsdElementPattern.getHash();
            LineBasedContextSimilarityMatchPattern.DataFromPattern data = this.createDataFromHash(hash);
            if (data == null) {
                result.addError((OperationResult.IMessageCause)PersistenceCause.PATTERN_NOT_VALID, "Hash '" + hash + "' has invalid format!", new Object[0]);
                return null;
            }
            String[] patternParts = pattern.split(NamedElement.DESCRIPTOR_NAME_PARTS_SEPARATOR);
            assert (patternParts.length > 1) : "Unexpected format of pattern: " + pattern;
            String encodedFqName = patternParts[0];
            String decodedFqName = LineBasedContextSimilarityMatchPattern.decodeOriginalFqName(encodedFqName);
            String realPattern = String.valueOf(decodedFqName) + pattern.substring(encodedFqName.length());
            return new LineBasedContextSimilarityMatchPattern(resolution, realPattern, data);
        }
        return new NamedElementFullyQualifiedNamePattern(resolution, pattern);
    }

    private LineBasedContextSimilarityMatchPattern.DataFromPattern createDataFromHash(String hash) {
        IntBasedHash postfixHashs;
        assert (hash != null) : "Parameter 'hash' of method 'DataFromPattern' must not be null";
        String[] parts = hash.split(NamedElement.DESCRIPTOR_NAME_PARTS_SEPARATOR);
        if (parts.length != 5) {
            return null;
        }
        String sourceFileOriginalFqName = LineBasedContextSimilarityMatchPattern.decodeOriginalFqName(parts[0]);
        String line = e.g((String)parts[1]);
        int lineNumber = Integer.parseInt(parts[2]);
        IntBasedHash prefixHashs = IntBasedHash.decode((String)parts[3]);
        if (prefixHashs == null) {
            LOGGER.error("Failed to create prefix hashs from '{}'", (Object)parts[3]);
            prefixHashs = new IntBasedHash(new int[0]);
        }
        if ((postfixHashs = IntBasedHash.decode((String)parts[4])) == null) {
            LOGGER.error("Failed to create postfix hashs from '{}'", (Object)parts[4]);
            postfixHashs = new IntBasedHash(new int[0]);
        }
        return new LineBasedContextSimilarityMatchPattern.DataFromPattern(sourceFileOriginalFqName, line, lineNumber, prefixHashs, postfixHashs);
    }

    private Resolution createResolution(NamedElement model, XsdResolution xsdResolution, OperationResult result) {
        assert (model != null) : "Parameter 'model' of method 'createResolution' must not be null";
        assert (xsdResolution != null) : "Parameter 'xsdResolution' of method 'createResolution' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createResolution' must not be null";
        if (xsdResolution instanceof XsdIgnoreResolution) {
            return new IgnoreDefinition(model, xsdResolution.getDate().toGregorianCalendar().getTime(), xsdResolution.getDescription());
        }
        if (xsdResolution instanceof XsdFixResolution) {
            XsdFixResolution xsdFixResolution = (XsdFixResolution)xsdResolution;
            return new FixDefinition(model, xsdFixResolution.getDate().toGregorianCalendar().getTime(), xsdFixResolution.getAssignedTo(), xsdFixResolution.getDescription(), Priority.fromStandardName(xsdFixResolution.getPriority().value()));
        }
        if (xsdResolution instanceof XsdToDoResolution) {
            XsdToDoResolution xsdToDoResolution = (XsdToDoResolution)xsdResolution;
            return new ToDoDefinition(model, xsdToDoResolution.getDate().toGregorianCalendar().getTime(), xsdToDoResolution.getAssignedTo(), xsdToDoResolution.getDescription(), Priority.fromStandardName(xsdToDoResolution.getPriority().value()));
        }
        if (xsdResolution instanceof XsdDeleteResolution) {
            XsdDeleteResolution xsdDeleteResolution = (XsdDeleteResolution)xsdResolution;
            Boolean includeRecursiveElementChildren = xsdDeleteResolution.isIncludeRecursiveElementChildren();
            return new DeleteRefactoringDefinition(model, xsdDeleteResolution.getDate().toGregorianCalendar().getTime(), xsdDeleteResolution.getAssignedTo(), xsdDeleteResolution.getDescription(), Priority.fromStandardName(xsdDeleteResolution.getPriority().value()), includeRecursiveElementChildren != null ? includeRecursiveElementChildren : false);
        }
        if (xsdResolution instanceof XsdMoveRenameResolution) {
            XsdMoveRenameResolution xsdMoveRenameResolution = (XsdMoveRenameResolution)xsdResolution;
            return new MoveRenameRefactoringDefinition(model, xsdMoveRenameResolution.getDate().toGregorianCalendar().getTime(), xsdMoveRenameResolution.getAssignedTo(), xsdMoveRenameResolution.getDescription(), Priority.fromStandardName(xsdMoveRenameResolution.getPriority().value()), xsdMoveRenameResolution.getLanguage(), MoveRenameRefactoringElementType.fromStandardName(xsdMoveRenameResolution.getElementType().value()), xsdMoveRenameResolution.getTargetRootDirectory(), xsdMoveRenameResolution.getMoveToParentName(), xsdMoveRenameResolution.getNewName());
        }
        if (xsdResolution instanceof XsdMoveResolution) {
            XsdMoveResolution xsdMoveResolution = (XsdMoveResolution)xsdResolution;
            return new MoveRefactoringDefinition(model, xsdMoveResolution.getDate().toGregorianCalendar().getTime(), xsdMoveResolution.getAssignedTo(), xsdMoveResolution.getDescription(), Priority.fromStandardName(xsdMoveResolution.getPriority().value()), xsdMoveResolution.getLanguage(), MoveRenameRefactoringElementType.fromStandardName(xsdMoveResolution.getElementType().value()), xsdMoveResolution.getTargetRootDirectory(), xsdMoveResolution.getMoveToParentName());
        }
        if (xsdResolution instanceof XsdRenameResolution) {
            XsdRenameResolution xsdRenameResolution = (XsdRenameResolution)xsdResolution;
            return new RenameRefactoringDefinition(model, xsdRenameResolution.getDate().toGregorianCalendar().getTime(), xsdRenameResolution.getAssignedTo(), xsdRenameResolution.getDescription(), Priority.fromStandardName(xsdRenameResolution.getPriority().value()), xsdRenameResolution.getLanguage(), MoveRenameRefactoringElementType.fromStandardName(xsdRenameResolution.getElementType().value()), xsdRenameResolution.getNewName());
        }
        return null;
    }

    private boolean addArchitectureCheckIssueType(Resolution resolution, String issueTypeName, final String issueTypeDescriptor, OperationResult result) {
        assert (resolution != null) : "Parameter 'resolution' of method 'addArchitectureCheckIssueType' must not be null";
        assert (issueTypeName != null && issueTypeName.length() > 0) : "Parameter 'issueTypeName' of method 'addArchitectureCheckIssueType' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'addArchitectureCheckIssueType' must not be null";
        if (issueTypeDescriptor == null || issueTypeDescriptor.isEmpty()) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Issue type name '" + issueTypeName + "' must have a descriptor", new Object[0]);
            return false;
        }
        ArchitectureCheckIssueId issueId = null;
        String key = null;
        if (ArchitectureViolationIssueId.INSTANCE.getStandardName().equals(issueTypeName)) {
            issueId = ArchitectureViolationIssueId.INSTANCE;
            Matcher matcher = NEW_ARCHITECTURE_VIOLATION_DESCRIPTOR_PATTERN.matcher(issueTypeDescriptor);
            key = matcher.matches() ? issueTypeDescriptor : DynamicIssueType.createKey(issueId, new IProviderId(){

                public String getStandardName() {
                    return issueTypeDescriptor;
                }

                public String getPresentationName() {
                    return issueTypeDescriptor;
                }

                @Override
                public boolean isDynamic() {
                    return true;
                }
            });
        } else if (ArchitectureDeprecationIssueId.INSTANCE.getStandardName().equals(issueTypeName)) {
            issueId = ArchitectureDeprecationIssueId.INSTANCE;
            key = issueTypeDescriptor;
        }
        if (issueId == null || key == null) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.UNRESOLVABLE_ISSUE, "Issue type name '" + issueTypeName + "' unknown", new Object[0]);
            return false;
        }
        resolution.addChild(new DynamicIssueType(resolution, issueId, key));
        return true;
    }

    private boolean addPluginIssueType(IPersistableVirtualModel model, Resolution resolution, String name, String descriptor, OperationResult result) {
        assert (model != null) : "Parameter 'model' of method 'addPluginIssueType' must not be null";
        assert (resolution != null) : "Parameter 'resolution' of method 'addPluginIssueType' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addPluginIssueType' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'addPluginIssueType' must not be null";
        if (descriptor == null || descriptor.isEmpty()) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Issue type class 'Plugin' must have a descriptor", new Object[0]);
            return false;
        }
        List descriptorParts = StringUtility.splitAndTrim((String)descriptor, (String)ENTRY_SEPARATOR);
        if (descriptorParts.size() != 2 && descriptorParts.size() != 3) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Issue type class 'Plugin' must have a descriptor of syntax 'IssueId:PluginId'", new Object[0]);
            return false;
        }
        String issueIdFromDecriptor = (String)descriptorParts.get(0);
        String pluginIdFromDescriptor = (String)descriptorParts.get(1);
        if (pluginIdFromDescriptor.isEmpty() || issueIdFromDecriptor.isEmpty()) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Issue type class 'Plugin' must have a descriptor of syntax 'IssueId:PluginId'", new Object[0]);
            return false;
        }
        IIssueId pluginIssueId = this.m_pluginProvider.getIssueId(pluginIdFromDescriptor, issueIdFromDecriptor);
        if (pluginIssueId == null) {
            result.addWarning((OperationResult.IMessageCause)VirtualModelPersistenceCause.PLUGIN_ISSUE_ID_NOT_FOUND, "'" + model.getIdentifyingPath() + "'", new Object[0]);
            return false;
        }
        resolution.addChild(new DynamicIssueType(resolution, pluginIssueId, descriptor));
        return true;
    }

    private boolean addScriptIssueType(Resolution resolution, String name, String descriptor, OperationResult result) {
        assert (resolution != null) : "Parameter 'resolution' of method 'addScriptIssueType' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addScriptIssueType' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'addScriptIssueType' must not be null";
        if (descriptor == null || descriptor.isEmpty()) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Issue type class 'Script' must have a descriptor", new Object[0]);
            return false;
        }
        int pos = descriptor.indexOf(ENTRY_SEPARATOR);
        if (pos == -1) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Issue type class 'Script' must have a descriptor of syntax 'IdentifyingPath:Severity'", new Object[0]);
            return false;
        }
        String identifyingPathFromDescriptor = descriptor.substring(0, pos);
        String severityFromDecriptor = descriptor.substring(pos + 1);
        if (identifyingPathFromDescriptor.isEmpty() || severityFromDecriptor.isEmpty()) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Issue type class 'Script' must have a descriptor of syntax 'IdentifyingPath:Severity'", new Object[0]);
            return false;
        }
        try {
            Severity severity = Severity.fromStandardName(severityFromDecriptor);
            ScriptProviderId providerId = this.m_identifyingPathToScriptProviderId.get(identifyingPathFromDescriptor);
            if (providerId == null) {
                providerId = new ScriptProviderId(identifyingPathFromDescriptor);
                this.m_identifyingPathToScriptProviderId.put(identifyingPathFromDescriptor, providerId);
            }
            ScriptIssueId issueId = new ScriptIssueId(name, severity, providerId);
            resolution.addChild(new DynamicIssueType(resolution, issueId, DynamicIssueType.createKey(issueId, providerId)));
        }
        catch (IllegalArgumentException e2) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Issue type class 'Script' must have a descriptor of syntax 'IdentifyingPath:Severity' where 'Severity' is one of 'Error', 'Warning', 'Info'", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean addOldScriptIssueType(Resolution resolution, XsdIssueType xsdIssueType, OperationResult result) {
        block6: {
            try {
                if (!(xsdIssueType instanceof XsdElementScriptIssueType)) break block6;
                XsdElementScriptIssueType elementIssueType = (XsdElementScriptIssueType)xsdIssueType;
                Severity severity = Severity.fromStandardName(elementIssueType.getSeverity());
                String scriptPath = elementIssueType.getScript();
                if (!this.addScriptIssueType(resolution, xsdIssueType.getName(), String.valueOf(scriptPath) + ENTRY_SEPARATOR + severity.getStandardName(), result)) {
                    return false;
                }
            }
            catch (IllegalArgumentException e2) {
                result.addError((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Issue type class 'Script' must have a descriptor of syntax 'IdentifyingPath:Severity' where 'Severity' is one of 'Error', 'Warning', 'Info'", new Object[0]);
                return false;
            }
        }
        assert (xsdIssueType != null && xsdIssueType instanceof XsdDependencyScriptIssueType) : "Unexpected class in method 'addOldSCriptIssueType': " + xsdIssueType;
        XsdDependencyScriptIssueType dependencyIssueType = (XsdDependencyScriptIssueType)xsdIssueType;
        Severity severity = Severity.fromStandardName(dependencyIssueType.getSeverity());
        String scriptPath = dependencyIssueType.getScript();
        if (!this.addScriptIssueType(resolution, xsdIssueType.getName(), String.valueOf(scriptPath) + ENTRY_SEPARATOR + severity.getStandardName(), result)) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addEnumBasedIssueType(Resolution resolution, String enumClass, String constant, String descriptor, OperationResult result) {
        assert (resolution != null) : "Parameter 'resolution' of method 'handleEnum' must not be null";
        if (!$assertionsDisabled) {
            if (enumClass == null) throw new AssertionError((Object)"Parameter 'enumClass' of method 'handleEnum' must not be empty");
            if (enumClass.length() <= 0) {
                throw new AssertionError((Object)"Parameter 'enumClass' of method 'handleEnum' must not be empty");
            }
        }
        if (!$assertionsDisabled) {
            if (constant == null) throw new AssertionError((Object)"Parameter 'constant' of method 'handleEnum' must not be empty");
            if (constant.length() <= 0) {
                throw new AssertionError((Object)"Parameter 'constant' of method 'handleEnum' must not be empty");
            }
        }
        assert (result != null) : "Parameter 'result' of method 'handleEnum' must not be null";
        try {
            Class issueEnum = this.getAggregatingClassLoader().loadClass(enumClass);
            Object enumConstant = Enum.valueOf(issueEnum, StringUtility.convertStandardNameToConstantName((String)constant));
            if (!(enumConstant instanceof IIssueId)) {
                result.addError((OperationResult.IMessageCause)PersistenceCause.ISSUE_CLASS_NOT_SUPPORTED, "Ignoring '" + enumConstant.getClass().getName() + "', it is not a valid issue id", new Object[0]);
                return false;
            }
            IIssueId issueId = (IIssueId)enumConstant;
            if (!issueId.isResolvable() && (resolution instanceof FixDefinition || resolution instanceof IgnoreDefinition)) {
                result.addWarning((OperationResult.IMessageCause)PersistenceCause.UNRESOLVABLE_ISSUE, "Ignoring '" + issueId.getStandardName() + "', it is not resolvable with a fix/ignore resolution", new Object[0]);
                return false;
            }
            if (issueId != CoreIssueId.THRESHOLD_VIOLATION) {
                resolution.addChild(new IssueType(resolution, issueId, descriptor));
                return true;
            }
            if (descriptor != null && !descriptor.isEmpty()) {
                resolution.addChild(new ThresholdIssueType(resolution, issueId, descriptor));
                return true;
            }
            result.addWarning((OperationResult.IMessageCause)PersistenceCause.DESCRIPTOR_INVALID, "Ignoring '" + issueId.getStandardName() + "', it must have a descriptor", new Object[0]);
            return false;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalArgumentException ex) {
            result.addWarning((OperationResult.IMessageCause)PersistenceCause.ISSUE_CLASS_NOT_SUPPORTED, "Ignoring '" + enumClass + "." + constant + "', the specified enum class/constant cannot be found", new Object[0]);
            return false;
        }
    }
}

