/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system.settings;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.plugin.BooleanEntry;
import com.hello2morrow.sonargraph.core.persistence.plugin.ConfigurationEntry;
import com.hello2morrow.sonargraph.core.persistence.plugin.FloatEntry;
import com.hello2morrow.sonargraph.core.persistence.plugin.IntEntry;
import com.hello2morrow.sonargraph.core.persistence.plugin.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.plugin.StringEntry;
import com.hello2morrow.sonargraph.core.persistence.plugin.XsdPluginConfiguration;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import com.hello2morrow.sonargraph.plugin.SonargraphBooleanPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphFloatPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphIntPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;

public final class PluginConfigurationPersistence {
    private static final String XSD_NAMESPACE = "com.hello2morrow.sonargraph.core.persistence.plugin";
    private static final String ROOT_ELEMENT = "pluginConfiguration";
    private static final String SCHEMA_URL = String.valueOf("com.hello2morrow.sonargraph.core.persistence.plugin".replace('.', '/')) + "/" + "pluginConfiguration";
    private final Version m_version;

    public static boolean isValidRootElement(String rootElement) {
        assert (rootElement != null && rootElement.length() > 0) : "Parameter 'rootElement' of method 'isValidRootElement' must not be empty";
        return ROOT_ELEMENT.equals(rootElement);
    }

    public PluginConfigurationPersistence(Version version) {
        assert (version != null) : "Parameter 'version' of method 'PluginConfigurationPersistence' must not be null";
        this.m_version = version;
    }

    private static void loadValues(String pluginId, String identifyingPath, XsdPluginConfiguration xsdPluginConfiguration, Map<String, SonargraphPluginAttribute> attributes, OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> result) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'loadValues' must not be empty";
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'loadValues' must not be empty";
        assert (xsdPluginConfiguration != null) : "Parameter 'pluginConfiguration' of method 'loadValues' must not be null";
        assert (attributes != null) : "Parameter 'attributes' of method 'loadValues' must not be null";
        assert (result != null) : "Parameter 'result' of method 'loadValues' must not be null";
        String xsdPluginId = xsdPluginConfiguration.getPluginId();
        if (!pluginId.equals(xsdPluginId)) {
            result.addError((OperationResult.IMessageCause)PluginConfigurationPersistenceCause.PLUGIN_ID_DOES_NOT_MATCH, "'" + pluginId + "' does not match '" + xsdPluginId + "' in '" + identifyingPath + "'", new Object[0]);
            return;
        }
        THashMap values = new THashMap();
        for (ConfigurationEntry entry : xsdPluginConfiguration.getIntEntryOrFloatEntryOrStringEntry()) {
            String entryName = entry.getName();
            if (entryName.isEmpty()) {
                result.addWarning((OperationResult.IMessageCause)PluginConfigurationPersistenceCause.EMPTY_ATTRIBUTE_NAME, "Ignoring empty attribute in '" + identifyingPath + "'", new Object[0]);
                continue;
            }
            SonargraphPluginAttribute nextAttributeDefinition = attributes.get(entryName);
            if (nextAttributeDefinition == null) {
                result.addWarning((OperationResult.IMessageCause)PluginConfigurationPersistenceCause.UKNOWN_ATTRIBUTE, "Ignoring unknown attribute '" + entryName + "' in '" + identifyingPath + "'", new Object[0]);
                continue;
            }
            if (entry instanceof BooleanEntry) {
                if (nextAttributeDefinition instanceof SonargraphBooleanPluginAttribute) {
                    values.put(nextAttributeDefinition, ((BooleanEntry)entry).isValue());
                    continue;
                }
                result.addWarning((OperationResult.IMessageCause)PluginConfigurationPersistenceCause.UKNOWN_ATTRIBUTE, "Ignoring attribute '" + entryName + "' with wrong type in '" + identifyingPath + "'", new Object[0]);
                continue;
            }
            if (entry instanceof IntEntry) {
                if (nextAttributeDefinition instanceof SonargraphIntPluginAttribute) {
                    values.put(nextAttributeDefinition, ((IntEntry)entry).getValue());
                    continue;
                }
                result.addWarning((OperationResult.IMessageCause)PluginConfigurationPersistenceCause.UKNOWN_ATTRIBUTE, "Ignoring attribute '" + entryName + "' with wrong type in '" + identifyingPath + "'", new Object[0]);
                continue;
            }
            if (entry instanceof FloatEntry) {
                if (nextAttributeDefinition instanceof SonargraphFloatPluginAttribute) {
                    values.put(nextAttributeDefinition, Float.valueOf(((FloatEntry)entry).getValue()));
                    continue;
                }
                result.addWarning((OperationResult.IMessageCause)PluginConfigurationPersistenceCause.UKNOWN_ATTRIBUTE, "Ignoring attribute '" + entryName + "' with wrong type in '" + identifyingPath + "'", new Object[0]);
                continue;
            }
            assert (entry != null && entry instanceof StringEntry) : "Unexpected class in method 'loadValues': " + entry;
            if (nextAttributeDefinition instanceof SonargraphStringPluginAttribute) {
                values.put(nextAttributeDefinition, ((StringEntry)entry).getValue());
                continue;
            }
            result.addWarning((OperationResult.IMessageCause)PluginConfigurationPersistenceCause.UKNOWN_ATTRIBUTE, "Ignoring attribute '" + entryName + "' with wrong type in '" + identifyingPath + "'", new Object[0]);
        }
        result.setOutcome((Object)values);
    }

    private static JaxbAdapter<JAXBElement<XsdPluginConfiguration>> createJaxbAdapter() {
        XmlPersistenceContext persistenceContext = new XmlPersistenceContext(XSD_NAMESPACE, CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
        ClassLoader classLoader = ObjectFactory.class.getClassLoader();
        return JaxbAccess.createJaxbAdapter(classLoader, persistenceContext);
    }

    private static OperationResultWithOutcome<XsdPluginConfiguration> internLoadFromStream(InputStream inputStream, String identifyingPath) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadFromStream' must not be null";
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'internLoadFromStream' must not be empty";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading model '" + identifyingPath + "' from stream");
        JaxbAdapter<JAXBElement<XsdPluginConfiguration>> jaxbAdapter = PluginConfigurationPersistence.createJaxbAdapter();
        String sourceInfo = "PluginConfiguration '" + identifyingPath + "'";
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl((OperationResult)result, sourceInfo);
        JAXBElement xsdPluginConfiguration = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)eventHandler);
        if (result.isSuccess()) {
            result.setOutcome((Object)((XsdPluginConfiguration)xsdPluginConfiguration.getValue()));
        }
        return result;
    }

    public OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> load(TFile file, String identifyingPath, String pluginId, Map<String, SonargraphPluginAttribute> attributes) {
        assert (file != null) : "Parameter 'file' of method 'load' must not be null";
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'load' must not be empty";
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'load' must not be empty";
        assert (attributes != null) : "Parameter 'attributes' of method 'load' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load plugin configuration from '" + file.getName() + "'");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TFileInputStream inputStream = new TFileInputStream((File)file);){
                OperationResultWithOutcome<XsdPluginConfiguration> loadResult = PluginConfigurationPersistence.internLoadFromStream((InputStream)inputStream, identifyingPath);
                result.addMessagesFrom(loadResult);
                result.setOutcome((Object)((XsdPluginConfiguration)loadResult.getOutcome()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, (Throwable)ex, "Failed to load plugin configuration from file '" + file.getNormalizedAbsolutePath() + "'", new Object[0]);
        }
        OperationResultWithOutcome loadValuesResult = new OperationResultWithOutcome("Load plugin configuration from '" + file.getName() + "'");
        loadValuesResult.addMessagesFrom((OperationResult)result);
        if (result.isSuccess()) {
            PluginConfigurationPersistence.loadValues(pluginId, identifyingPath, (XsdPluginConfiguration)result.getOutcome(), attributes, (OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>>)loadValuesResult);
        }
        return loadValuesResult;
    }

    public OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>> load(InputStream inputStream, String identifyingPath, String pluginId, Map<String, SonargraphPluginAttribute> attributes) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadFromStream' must not be null";
        OperationResultWithOutcome<XsdPluginConfiguration> result = PluginConfigurationPersistence.internLoadFromStream(inputStream, identifyingPath);
        OperationResultWithOutcome loadValuesResult = new OperationResultWithOutcome("Load plugin configuration from '" + identifyingPath + "'");
        loadValuesResult.addMessagesFrom(result);
        if (result.isSuccess()) {
            PluginConfigurationPersistence.loadValues(pluginId, identifyingPath, (XsdPluginConfiguration)result.getOutcome(), attributes, (OperationResultWithOutcome<Map<SonargraphPluginAttribute, Object>>)loadValuesResult);
        }
        return loadValuesResult;
    }

    public void save(String pluginId, Map<String, SonargraphPluginAttribute> attributes, OutputStream outputStream, OperationResult result) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'save' must not be empty";
        assert (attributes != null) : "Parameter 'attributes' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        JAXBElement<XsdPluginConfiguration> xsdElement = this.createXsdPluginConfiguration(pluginId, attributes);
        try {
            PluginConfigurationPersistence.createJaxbAdapter().save(xsdElement, outputStream);
        }
        catch (IOException ioe) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ioe);
        }
    }

    public OperationResult save(TFile file, String pluginId, Map<String, SonargraphPluginAttribute> attributes) {
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'save' must not be empty";
        assert (attributes != null) : "Parameter 'attributes' of method 'save' must not be null";
        TFile modelsDir = file.getParentFile();
        if (!modelsDir.exists() || !modelsDir.isDirectory()) {
            modelsDir.mkdir();
        }
        JAXBElement<XsdPluginConfiguration> xsdElement = this.createXsdPluginConfiguration(pluginId, attributes);
        OperationResult result = new OperationResult("Persist pluginConfiguration '" + pluginId + "'");
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (TFileOutputStream outputStream = new TFileOutputStream((File)file);){
                PluginConfigurationPersistence.createJaxbAdapter().save(xsdElement, (OutputStream)outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex, "Failed to save pluginConfiguration file '" + file.getNormalizedAbsolutePath() + "'", new Object[0]);
        }
        return result;
    }

    private JAXBElement<XsdPluginConfiguration> createXsdPluginConfiguration(String pluginId, Map<String, SonargraphPluginAttribute> attributes) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'createXsdPluginConfiguration' must not be empty";
        assert (attributes != null) : "Parameter 'attributes' of method 'createXsdPluginConfiguration' must not be null";
        ObjectFactory objectFactory = new ObjectFactory();
        XsdPluginConfiguration xsdPluginConfiguration = objectFactory.createXsdPluginConfiguration();
        JAXBElement<XsdPluginConfiguration> xsdElement = objectFactory.createPluginConfiguration(xsdPluginConfiguration);
        xsdPluginConfiguration.setVersion(this.m_version.toString());
        xsdPluginConfiguration.setPluginId(pluginId);
        List<ConfigurationEntry> entries = xsdPluginConfiguration.getIntEntryOrFloatEntryOrStringEntry();
        for (SonargraphPluginAttribute nextAttribute : attributes.values()) {
            ConfigurationEntry entry;
            if (nextAttribute instanceof SonargraphBooleanPluginAttribute) {
                entry = objectFactory.createBooleanEntry();
                entry.setName(nextAttribute.getName());
                ((BooleanEntry)entry).setValue(((SonargraphBooleanPluginAttribute)nextAttribute).getValue());
                entries.add(entry);
                continue;
            }
            if (nextAttribute instanceof SonargraphIntPluginAttribute) {
                entry = objectFactory.createIntEntry();
                entry.setName(nextAttribute.getName());
                ((IntEntry)entry).setValue(((SonargraphIntPluginAttribute)nextAttribute).getValue());
                entries.add(entry);
                continue;
            }
            if (nextAttribute instanceof SonargraphFloatPluginAttribute) {
                entry = objectFactory.createFloatEntry();
                entry.setName(nextAttribute.getName());
                ((FloatEntry)entry).setValue(((SonargraphFloatPluginAttribute)nextAttribute).getValue().floatValue());
                entries.add(entry);
                continue;
            }
            assert (nextAttribute instanceof SonargraphStringPluginAttribute) : "Unexpected class in method 'createXsdPluginConfiguration': " + nextAttribute;
            entry = objectFactory.createStringEntry();
            entry.setName(nextAttribute.getName());
            ((StringEntry)entry).setValue(((SonargraphStringPluginAttribute)nextAttribute).getValue());
            entries.add(entry);
        }
        return xsdElement;
    }

    public static enum PluginConfigurationPersistenceCause implements OperationResult.IMessageCause
    {
        PLUGIN_ID_DOES_NOT_MATCH,
        UKNOWN_ATTRIBUTE,
        EMPTY_ATTRIBUTE_NAME,
        WRONG_ATTRIBUTE_TYPE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

