/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system.settings;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.persistence.analyzer.BooleanEntry;
import com.hello2morrow.sonargraph.core.persistence.analyzer.ConfigurationEntry;
import com.hello2morrow.sonargraph.core.persistence.analyzer.FloatEntry;
import com.hello2morrow.sonargraph.core.persistence.analyzer.IntEntry;
import com.hello2morrow.sonargraph.core.persistence.analyzer.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.analyzer.StandardEnumerationEntry;
import com.hello2morrow.sonargraph.core.persistence.analyzer.StringEntry;
import com.hello2morrow.sonargraph.core.persistence.analyzer.XsdAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;

public final class AnalyzerConfigurationPersistence {
    private static final String XSD_NAMESPACE = "com.hello2morrow.sonargraph.core.persistence.analyzer";
    private static final String ROOT_ELEMENT = "analyzerConfiguration";
    private static final String SCHEMA_URL = String.valueOf("com.hello2morrow.sonargraph.core.persistence.analyzer".replace('.', '/')) + "/" + "analyzerConfiguration";
    private final AnalyzerConfigurationFile m_configurationFile;

    public static boolean isValidRootElement(String rootElement) {
        assert (rootElement != null && rootElement.length() > 0) : "Parameter 'rootElement' of method 'isValidRootElement' must not be empty";
        return ROOT_ELEMENT.equals(rootElement);
    }

    public AnalyzerConfigurationPersistence(AnalyzerConfigurationFile configurationFile) {
        assert (configurationFile != null) : "Parameter 'configurationFile' of method 'AnalyzerConfigurationPersistence' must not be null";
        this.m_configurationFile = configurationFile;
    }

    private static void convertXmlToPojo(AnalyzerConfiguration configuration, XsdAnalyzerConfiguration analyzerConfiguration, OperationResult result) {
        assert (configuration != null) : "Parameter 'configuration' of method 'convertXmlToPojo' must not be null";
        assert (analyzerConfiguration != null) : "Parameter 'analyzerConfiguration' of method 'convertXmlToPojo' must not be null";
        assert (result != null) : "Parameter 'result' of method 'convertXmlToPojo' must not be null";
        String analyzerStandardName = analyzerConfiguration.getAnalyzer();
        if (!configuration.getAnalyzerId().getStandardName().equals(analyzerStandardName)) {
            result.addError((OperationResult.IMessageCause)AnalyzerConfigurationPersistenceCause.ANALYZER_DOES_NOT_MATCH, "'" + configuration.getAnalyzerId().getStandardName() + "' does not match the one from persistence: " + analyzerStandardName, new Object[0]);
            return;
        }
        for (ConfigurationEntry entry : analyzerConfiguration.getIntEntryOrFloatEntryOrStringEntry()) {
            String entryName = entry.getName();
            if (entryName.isEmpty()) {
                result.addError((OperationResult.IMessageCause)AnalyzerConfigurationPersistenceCause.EMPTY_NAME, "Unable to load configuration for '" + configuration.getAnalyzerId() + "'", new Object[0]);
                return;
            }
            if (entry instanceof IntEntry) {
                configuration.setValue(entryName, ((IntEntry)entry).getValue());
                continue;
            }
            if (entry instanceof FloatEntry) {
                configuration.setValue(entryName, Float.valueOf(((FloatEntry)entry).getValue()));
                continue;
            }
            if (entry instanceof BooleanEntry) {
                configuration.setValue(entryName, ((BooleanEntry)entry).isValue());
                continue;
            }
            if (entry instanceof StringEntry) {
                configuration.setValue(entryName, ((StringEntry)entry).getValue());
                continue;
            }
            if (entry instanceof StandardEnumerationEntry) {
                Class<?> theEnum;
                String clazz;
                StandardEnumerationEntry enumEntry;
                block19: {
                    enumEntry = (StandardEnumerationEntry)entry;
                    clazz = enumEntry.getClazz();
                    theEnum = null;
                    try {
                        theEnum = Class.forName(clazz);
                    }
                    catch (ClassCastException | ClassNotFoundException ex) {
                        if ($assertionsDisabled) break block19;
                        throw new AssertionError((Object)("Corrupt configuration, expected class name of enum implementing IStandardEnumeration, got " + clazz));
                    }
                }
                assert (theEnum != null && theEnum.isEnum());
                assert (IStandardEnumeration.class.isAssignableFrom(theEnum));
                IStandardEnumeration standardEnumConstant = null;
                IStandardEnumeration[] iStandardEnumerationArray = (IStandardEnumeration[])theEnum.getEnumConstants();
                int n2 = iStandardEnumerationArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IStandardEnumeration next = iStandardEnumerationArray[n3];
                    if (next.getStandardName().equals(enumEntry.getValue())) {
                        standardEnumConstant = next;
                        break;
                    }
                    ++n3;
                }
                assert (standardEnumConstant != null) : "Wrong enum value " + enumEntry.getValue() + " for class " + clazz;
                configuration.setValue(entryName, standardEnumConstant);
                continue;
            }
            assert (false) : "ConfigurationEntry is of unsupported type '" + entry.getClass().getCanonicalName() + "'";
        }
    }

    private static JaxbAdapter<JAXBElement<XsdAnalyzerConfiguration>> createJaxbAdapter() {
        XmlPersistenceContext persistenceContext = new XmlPersistenceContext(XSD_NAMESPACE, CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
        ClassLoader classLoader = ObjectFactory.class.getClassLoader();
        return JaxbAccess.createJaxbAdapter(classLoader, persistenceContext);
    }

    private static XsdAnalyzerConfiguration internLoadConfigurationFromStream(InputStream inputStream, OperationResult result) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'internLoadConfigurationFromStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'internLoadConfigurationFromStream' must not be null";
        JaxbAdapter<JAXBElement<XsdAnalyzerConfiguration>> jaxbAdapter = AnalyzerConfigurationPersistence.createJaxbAdapter();
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl(result);
        JAXBElement xsdElement = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)eventHandler);
        if (result.isFailure()) {
            return null;
        }
        return (XsdAnalyzerConfiguration)xsdElement.getValue();
    }

    public OperationResult load(AnalyzerConfiguration configuration, TFile contentFile) {
        OperationResult result;
        block14: {
            assert (configuration != null) : "Parameter 'configuration' of method 'load' must not be null";
            assert (contentFile != null) : "Parameter 'source' of method 'load' must not be null";
            result = new OperationResult("Loading analyzer configuration '" + this.m_configurationFile.getAnalyzerId().getPresentationName() + "' from: " + contentFile.getAbsolutePath());
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (TFileInputStream inputStream = new TFileInputStream((File)contentFile);){
                    XsdAnalyzerConfiguration xsdAnalyzerConfiguration = AnalyzerConfigurationPersistence.internLoadConfigurationFromStream((InputStream)inputStream, result);
                    if (result.isSuccess()) {
                        AnalyzerConfigurationPersistence.convertXmlToPojo(configuration, xsdAnalyzerConfiguration, result);
                        break block14;
                    }
                    OperationResult result2 = new OperationResult("Loading analyzer configuration '" + this.m_configurationFile.getAnalyzerId().getPresentationName() + "' from: " + contentFile.getAbsolutePath());
                    result2.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed to process analyzer configuration '" + this.m_configurationFile.getAnalyzerId().getPresentationName() + "' from '" + contentFile.getName() + "'", new Object[0]);
                    result2.addMessagesFrom(result);
                    return result2;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, (Throwable)ex);
            }
        }
        return result;
    }

    public OperationResult load(AnalyzerConfiguration configuration, InputStream inputStream) {
        OperationResult result = new OperationResult("Loading analyzer configuration '" + this.m_configurationFile.getAnalyzerId().getPresentationName() + "' from: " + this.m_configurationFile.getFile().getAbsolutePath());
        XsdAnalyzerConfiguration xsdAnalyzerConfiguration = AnalyzerConfigurationPersistence.internLoadConfigurationFromStream(inputStream, result);
        if (result.isSuccess()) {
            AnalyzerConfigurationPersistence.convertXmlToPojo(configuration, xsdAnalyzerConfiguration, result);
        }
        return result;
    }

    public static OperationResult save(Version version, AnalyzerConfiguration configuration, TFile file, String fileId) {
        assert (version != null) : "Parameter 'version' of method 'persist' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'persist' must not be null";
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        assert (fileId != null && !fileId.isEmpty()) : "Parameter 'fileId' of method 'save' must not be empty";
        OperationResult result = new OperationResult("Persisting analyzer configuration '" + configuration.getAnalyzerId() + "'");
        if (!file.exists()) {
            try {
                TFile parentDirectory = file.getParentFile();
                if (!parentDirectory.exists()) {
                    parentDirectory.mkdirs();
                }
                file.createNewFile();
            }
            catch (IOException ex1) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_FILE, (Throwable)ex1, "Failed to create configuration file '" + file.getAbsolutePath() + "'", new Object[0]);
            }
        }
        if (result.isSuccess()) {
            JAXBElement<XsdAnalyzerConfiguration> xsdElement = AnalyzerConfigurationPersistence.convertPojoToXml(version, configuration, fileId);
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (TFileOutputStream outputStream = new TFileOutputStream((File)file);){
                    AnalyzerConfigurationPersistence.createJaxbAdapter().save(xsdElement, (OutputStream)outputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex, "Failed to save configuration to file '" + file.getAbsolutePath() + "'", new Object[0]);
            }
        }
        return result;
    }

    public OperationResult save(Version version, AnalyzerConfiguration configuration) {
        assert (version != null) : "Parameter 'version' of method 'save' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'save' must not be null";
        return AnalyzerConfigurationPersistence.save(version, configuration, this.m_configurationFile.getFile(), this.m_configurationFile.getFileId());
    }

    public void save(Version version, AnalyzerConfiguration configuration, OutputStream outputStream, OperationResult result) {
        assert (version != null) : "Parameter 'version' of method 'save' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        try {
            JAXBElement<XsdAnalyzerConfiguration> xsdElement = AnalyzerConfigurationPersistence.convertPojoToXml(version, configuration, this.m_configurationFile.getFileId());
            AnalyzerConfigurationPersistence.createJaxbAdapter().save(xsdElement, outputStream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    private static JAXBElement<XsdAnalyzerConfiguration> convertPojoToXml(Version version, AnalyzerConfiguration configuration, String fileId) {
        assert (version != null) : "Parameter 'version' of method 'convertPojoToXml' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'convertPojoToXml' must not be null";
        assert (fileId != null && fileId.length() > 0) : "Parameter 'fileId' of method 'convertPojoToXml' must not be empty";
        ObjectFactory objectFactory = new ObjectFactory();
        XsdAnalyzerConfiguration xsdAnalyzerConfiguration = objectFactory.createXsdAnalyzerConfiguration();
        JAXBElement<XsdAnalyzerConfiguration> xsdElement = objectFactory.createAnalyzerConfiguration(xsdAnalyzerConfiguration);
        xsdAnalyzerConfiguration.setVersion(version.toString());
        xsdAnalyzerConfiguration.setAnalyzer(configuration.getAnalyzerId().getStandardName());
        List<ConfigurationEntry> entries = xsdAnalyzerConfiguration.getIntEntryOrFloatEntryOrStringEntry();
        Map<String, Object> valueMap = configuration.getValueMapForPersistence();
        ArrayList<String> names = new ArrayList<String>(valueMap.keySet());
        Collections.sort(names);
        for (String name : names) {
            ConfigurationEntry entry;
            Object value = valueMap.get(name);
            assert (value != null) : "value for configuration entry must not be null";
            if (value.getClass() == Integer.class) {
                entry = objectFactory.createIntEntry();
                entry.setName(name);
                ((IntEntry)entry).setValue((Integer)value);
                entries.add(entry);
                continue;
            }
            if (value.getClass() == Float.class) {
                entry = objectFactory.createFloatEntry();
                entry.setName(name);
                ((FloatEntry)entry).setValue(((Float)value).floatValue());
                entries.add(entry);
                continue;
            }
            if (value.getClass() == Boolean.class) {
                entry = objectFactory.createBooleanEntry();
                entry.setName(name);
                ((BooleanEntry)entry).setValue((Boolean)value);
                entries.add(entry);
                continue;
            }
            if (value.getClass() == String.class) {
                entry = objectFactory.createStringEntry();
                entry.setName(name);
                ((StringEntry)entry).setValue((String)value);
                entries.add(entry);
                continue;
            }
            if (value instanceof IStandardEnumeration) {
                entry = objectFactory.createStandardEnumerationEntry();
                entry.setName(name);
                ((StandardEnumerationEntry)entry).setValue(((IStandardEnumeration)value).getStandardName());
                ((StandardEnumerationEntry)entry).setClazz(value.getClass().getName());
                entries.add(entry);
                continue;
            }
            assert (false) : "Unsupported type: '" + value.getClass() + "'";
        }
        return xsdElement;
    }

    public static enum AnalyzerConfigurationPersistenceCause implements OperationResult.IMessageCause
    {
        ANALYZER_DOES_NOT_MATCH,
        EMPTY_NAME;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

