/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.IssueFilter;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemCreator;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.system.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.system.PersistenceCause;
import com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.system.XmlAdditionalInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModule;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModuleDependency;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractSystemExtension;
import com.hello2morrow.sonargraph.core.persistence.system.XsdMetaDataEntry;
import com.hello2morrow.sonargraph.core.persistence.system.XsdRootPath;
import com.hello2morrow.sonargraph.integration.access.foundation.a;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlSystemPersistenceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlSystemPersistenceProvider.class);
    private final XmlPersistenceContext m_persistenceContext;
    private final Version m_version;
    private final Map<String, XmlAdditionalInfoProvider> m_infoProviders;
    private final ISoftwareSystemCreator m_systemProvider;

    public XmlSystemPersistenceProvider(Version version, List<IAdditionalFileInfoProvider> infoProviders, ISoftwareSystemCreator systemProvider) {
        assert (version != null) : "Parameter 'version' of method 'XmlSystemPersistenceProvider' must not be null";
        assert (infoProviders != null) : "Parameter 'infoProviders' of method 'XmlPersistenceProvider' must not be null";
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'XmlPersistenceProvider' must not be null";
        this.m_version = version;
        this.m_systemProvider = systemProvider;
        this.m_infoProviders = new HashMap<String, XmlAdditionalInfoProvider>(infoProviders.size());
        this.m_persistenceContext = new XmlPersistenceContext(XmlAdditionalInfoProvider.CORE_PERSISTENT_CONTEXT);
        for (IAdditionalFileInfoProvider provider : infoProviders) {
            assert (provider instanceof XmlAdditionalInfoProvider) : "persistence provider must be of type '" + XmlAdditionalInfoProvider.class.getName();
            XmlAdditionalInfoProvider xmlProvider = (XmlAdditionalInfoProvider)provider;
            this.m_infoProviders.put(provider.getLanguage().getStandardName(), xmlProvider);
            this.m_persistenceContext.add(xmlProvider.getPersistentContext());
        }
    }

    public boolean canLoadSnapshot() {
        return this.m_infoProviders.values().stream().allMatch(ip -> ip.canLoadSnapshot());
    }

    public boolean systemCanBeLoaded() {
        return this.m_infoProviders.values().stream().allMatch(ip -> ip.systemCanBeLoaded());
    }

    public boolean systemWasMigratedAndNeedsSave() {
        return this.m_infoProviders.values().stream().anyMatch(ip -> ip.systemWasMigratedAndNeedsSave());
    }

    public OperationResultWithOutcome<com.hello2morrow.sonargraph.core.model.system.SoftwareSystem> load(TFile systemFile, String systemName, a classLoader, Properties systemProperties, boolean isTemporary) {
        assert (systemFile != null) : "Parameter 'systemFile' of method 'load' must not be null";
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'load' must not be empty";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'load' must not be null";
        assert (systemProperties != null) : "Parameter 'systemProperties' of method 'load' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load Software System from file '" + systemFile.getName() + "'");
        if (!systemFile.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "File '" + systemFile.getAbsolutePath() + "' does not exist", new Object[0]);
            return result;
        }
        JaxbAdapter m_adapter = JaxbAccess.createJaxbAdapter(classLoader, this.m_persistenceContext);
        ValidationEventHandlerImpl validationHandler = new ValidationEventHandlerImpl((OperationResult)result);
        SoftwareSystem systemXml = null;
        try {
            Throwable throwable = null;
            Object var11_14 = null;
            try (TFileInputStream from = new TFileInputStream((File)systemFile);){
                systemXml = (SoftwareSystem)m_adapter.load((InputStream)from, (ValidationEventHandler)validationHandler);
                if (result.isFailure()) {
                    return result;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "File '" + systemFile.getAbsolutePath() + "' does not exist", new Object[0]);
            return result;
        }
        catch (IOException ex) {
            LOGGER.error("Failed to close inputstream of file '{}'", (Object)systemFile.getAbsolutePath());
        }
        this.createSoftwareSystem(systemFile, systemName, (OperationResultWithOutcome<com.hello2morrow.sonargraph.core.model.system.SoftwareSystem>)result, systemXml, systemProperties, isTemporary);
        return result;
    }

    private void createSoftwareSystem(TFile systemFile, String systemName, OperationResultWithOutcome<com.hello2morrow.sonargraph.core.model.system.SoftwareSystem> result, SoftwareSystem systemXml, Properties systemProperties, boolean isTemporary) {
        assert (systemXml != null) : "XML System object must not be null!";
        assert (systemProperties != null) : "Parameter 'systemProperties' of method 'createSoftwareSystem' must not be null";
        com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem = this.initCoreSoftwareSystem(this.m_systemProvider, systemXml, systemFile, systemName, systemProperties, isTemporary, result);
        if (softwareSystem != null) {
            result.setOutcome((Object)softwareSystem);
            int i2 = 0;
            while (i2 < systemXml.getSystemExtension().size()) {
                XsdAbstractSystemExtension extension = systemXml.getSystemExtension().get(i2);
                String language = extension.getLanguage();
                if (!this.m_infoProviders.containsKey(language)) {
                    result.addError((OperationResult.IMessageCause)PersistenceCause.LANGUAGE_NOT_SUPPORTED, "Language '" + language + "' of extension[" + i2 + "] is not supported.", new Object[0]);
                } else {
                    this.m_infoProviders.get(language).getSystemDetailsFromXml(softwareSystem, extension, (OperationResult)result);
                }
                ++i2;
            }
            HashMap<XsdAbstractModule, Module> xmlToModuleMap = new HashMap<XsdAbstractModule, Module>();
            for (XsdAbstractModule moduleXml : systemXml.getModule()) {
                String language = moduleXml.getLanguage();
                if (language == null || language.equals("")) {
                    result.addError((OperationResult.IMessageCause)PersistenceCause.LANGUAGE_NOT_DEFINED, "No language defined for module '" + moduleXml.getName() + "'", new Object[0]);
                    continue;
                }
                if (!this.m_infoProviders.containsKey(language)) {
                    result.addError((OperationResult.IMessageCause)PersistenceCause.LANGUAGE_NOT_SUPPORTED, "Language '" + language + "' of module '" + moduleXml.getName() + "' is not supported", new Object[0]);
                    continue;
                }
                Module.IModuleType moduleType = this.m_infoProviders.get(language).getModuleType(moduleXml.getClass());
                assert (moduleType != null) : "moduleType must not be null";
                OperationResultWithOutcome<Module> createModuleResult = this.m_systemProvider.createModule(softwareSystem, language, moduleType.getStandardName(), moduleXml.getId(), moduleXml.getName(), moduleXml.getDescription());
                if (createModuleResult.isFailure()) {
                    result.addMessagesFrom(createModuleResult);
                    continue;
                }
                Module module = (Module)createModuleResult.getOutcome();
                assert (module != null) : "Module must not be null!";
                xmlToModuleMap.put(moduleXml, module);
                if (module.hasIssues(new IIssueId[0])) {
                    result.addWarning((OperationResult.IMessageCause)PersistenceCause.ISSUES_CREATING_MODULE, "Creation of module '" + module.getName() + "' has led to issues.", new Object[0]);
                }
                for (XsdRootPath nextRootPath : moduleXml.getRootPath()) {
                    RootDirectoryPath nextRootDirectoryPath = this.m_infoProviders.get(language).getRootDirectoryPathFromXml(nextRootPath, softwareSystem, module);
                    if (module.getUniqueChild(new NameFilter(nextRootPath.getName()), nextRootDirectoryPath.getClass()) != null) {
                        result.addWarning((OperationResult.IMessageCause)PersistenceCause.DUPLICATE_ROOT_DIRECTORY, "Ignored duplicate root directory '" + nextRootDirectoryPath.getName() + "' for module '" + moduleXml.getName() + "'", new Object[0]);
                        continue;
                    }
                    module.addChild(nextRootDirectoryPath);
                }
                this.m_infoProviders.get(language).getModuleDetailsFromXml(this.m_systemProvider.getInstallation(), softwareSystem, module, moduleXml, (OperationResult)result);
            }
            for (XsdAbstractModule moduleXml : systemXml.getModule()) {
                Module module = (Module)xmlToModuleMap.get(moduleXml);
                if (module == null) continue;
                for (XsdAbstractModuleDependency nextXsdDependency : moduleXml.getDependsOn()) {
                    String language = module.getLanguage().getStandardName();
                    XmlAdditionalInfoProvider infoProvider = this.m_infoProviders.get(language);
                    if (!infoProvider.canCreateWorkspaceDependencies()) continue;
                    WorkspaceDependency.IWorkspaceDependencyType workspaceDependencyType = infoProvider.getWorkspaceDependencyType(nextXsdDependency.getClass());
                    if (workspaceDependencyType == null) {
                        result.addError((OperationResult.IMessageCause)PersistenceCause.DEPENDENCY_TYPE_NOT_SUPPORTED, "No dependency type registered for JAXB class " + nextXsdDependency.getClass().getCanonicalName(), new Object[0]);
                        continue;
                    }
                    String id = nextXsdDependency.getId();
                    String name = nextXsdDependency.getName();
                    if (name == null || name.length() == 0) {
                        name = id;
                    }
                    WorkspaceDependency.AdditionalDependencyData dependencyData = infoProvider.getAdditionalDependencyData(nextXsdDependency, workspaceDependencyType);
                    OperationResultWithOutcome<WorkspaceDependency> dependencyResult = this.m_systemProvider.createWorkspaceDependency(softwareSystem, language, moduleXml.getId(), id, name, workspaceDependencyType.getStandardName(), dependencyData);
                    if (dependencyResult.isFailure()) {
                        result.addMessagesFrom(dependencyResult);
                        continue;
                    }
                    WorkspaceDependency dependency = (WorkspaceDependency)dependencyResult.getOutcome();
                    assert (dependency != null) : "created workspace dependency must not be null";
                    module.addOutgoingWorkspaceDependency(dependency);
                }
            }
            for (XmlAdditionalInfoProvider infoProvider : this.m_infoProviders.values()) {
                infoProvider.cleanup();
            }
        }
    }

    private void initFilter(Filter filter, List<String> includes, List<String> excludes, OperationResultWithOutcome<com.hello2morrow.sonargraph.core.model.system.SoftwareSystem> result) {
        String notValid;
        for (String nextInclude : includes) {
            if (filter.getFirstChild(new NameFilter(nextInclude), WildcardPatternInclude.class) != null) {
                result.addWarning((OperationResult.IMessageCause)PersistenceCause.DUPLICATE_INCLUDE, "Ignored component filter include pattern '" + nextInclude + "'", new Object[0]);
                continue;
            }
            notValid = WildcardPattern.isValid(nextInclude);
            if (notValid == null) {
                filter.addChild(new WildcardPatternInclude(filter, nextInclude));
                continue;
            }
            result.addError((OperationResult.IMessageCause)PersistenceCause.PATTERN_NOT_VALID, "Component filter include pattern '" + nextInclude + "' is invalid: " + notValid, new Object[0]);
        }
        for (String nextExclude : excludes) {
            if (filter.getFirstChild(new NameFilter(nextExclude), WildcardPatternExclude.class) != null) {
                result.addWarning((OperationResult.IMessageCause)PersistenceCause.DUPLICATE_EXCLUDE, "Ignored component filter exclude pattern '" + nextExclude + "'", new Object[0]);
                continue;
            }
            notValid = WildcardPattern.isValid(nextExclude);
            if (notValid == null) {
                filter.addChild(new WildcardPatternExclude(filter, nextExclude));
                continue;
            }
            result.addError((OperationResult.IMessageCause)PersistenceCause.PATTERN_NOT_VALID, "Component filter exclude pattern '" + nextExclude + "' is invalid: " + notValid, new Object[0]);
        }
    }

    private com.hello2morrow.sonargraph.core.model.system.SoftwareSystem initCoreSoftwareSystem(ISoftwareSystemCreator systemProvider, SoftwareSystem systemXml, TFile systemFile, String systemName, Properties systemProperties, boolean isTemporary, OperationResultWithOutcome<com.hello2morrow.sonargraph.core.model.system.SoftwareSystem> result) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'initCoreSoftwareSystem' must not be null";
        assert (systemXml != null) : "Parameter 'systemXml' of method 'initCoreSoftwareSystem' must not be null";
        assert (systemProperties != null) : "Parameter 'systemProperties' of method 'initCoreSoftwareSystem' must not be null";
        String id = systemXml.getId();
        if (id == null || id.length() == 0) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.ID_NOT_VALID, "Id not valid for system: " + id, new Object[0]);
            return null;
        }
        com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem = systemProvider.createSoftwareSystem(systemName, id, systemFile, systemProperties, isTemporary);
        String description = systemXml.getDescription();
        if (description != null && description.length() > 0) {
            softwareSystem.setDescription(description);
        }
        for (XsdMetaDataEntry mde : systemXml.getMetaData()) {
            String nextKey = mde.getKey();
            boolean matchFound = false;
            ISoftwareSystem.KnownMetaDataKeys[] knownMetaDataKeysArray = ISoftwareSystem.KnownMetaDataKeys.values();
            int n2 = knownMetaDataKeysArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ISoftwareSystem.KnownMetaDataKeys nextMetaDateKey = knownMetaDataKeysArray[n3];
                if (nextMetaDateKey.name().equalsIgnoreCase(nextKey)) {
                    softwareSystem.setMetaData(nextMetaDateKey.name(), mde.getValue());
                    matchFound = true;
                    break;
                }
                ++n3;
            }
            if (matchFound) continue;
            result.addWarning((OperationResult.IMessageCause)PersistenceCause.UNKNOWN_META_DATA_KEY, "'" + nextKey + "' is not a known meta data key.", new Object[0]);
        }
        ProductionCodeFilter componentFilter = softwareSystem.getUniqueExistingChild(Workspace.class).getProductionCodeFilter();
        this.initFilter(componentFilter, systemXml.getInclude(), systemXml.getExclude(), result);
        IssueFilter issueFilter = softwareSystem.getUniqueExistingChild(Workspace.class).getIssueFilter();
        this.initFilter(issueFilter, systemXml.getIssueFilterInclude(), systemXml.getIssueFilterExclude(), result);
        WorkspaceFilter workspaceFilter = softwareSystem.getUniqueExistingChild(Workspace.class).getWorkspaceFilter();
        this.initFilter(workspaceFilter, systemXml.getWorkspaceFilterInclude(), systemXml.getWorkspaceFilterExclude(), result);
        return softwareSystem;
    }

    private void persistFilter(Filter filter, List<String> includes, List<String> excludes) {
        for (WildcardPatternInclude nextInclude : filter.getChildren(WildcardPatternInclude.class)) {
            includes.add(nextInclude.getName());
        }
        for (WildcardPatternExclude nextExclude : filter.getChildren(WildcardPatternExclude.class)) {
            excludes.add(nextExclude.getName());
        }
    }

    private SoftwareSystem createSystemXml(com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem, ClassLoader classLoader) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'save' must not be null";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'save' must not be null";
        ObjectFactory xmlFactory = new ObjectFactory();
        SoftwareSystem systemXml = xmlFactory.createSoftwareSystem();
        systemXml.setId(softwareSystem.getId());
        systemXml.setVersion(this.m_version.toString());
        systemXml.setDescription(softwareSystem.getDescription());
        for (Map.Entry<String, String> entry : softwareSystem.getMetaData().entrySet()) {
            XsdMetaDataEntry mde = xmlFactory.createXsdMetaDataEntry();
            mde.setKey(StringUtility.convertConstantNameToStandardName((String)entry.getKey()));
            mde.setValue(entry.getValue());
            systemXml.getMetaData().add(mde);
        }
        ProductionCodeFilter componentFilter = softwareSystem.getUniqueExistingChild(Workspace.class).getProductionCodeFilter();
        this.persistFilter(componentFilter, systemXml.getInclude(), systemXml.getExclude());
        IssueFilter issueFilter = softwareSystem.getUniqueExistingChild(Workspace.class).getIssueFilter();
        this.persistFilter(issueFilter, systemXml.getIssueFilterInclude(), systemXml.getIssueFilterExclude());
        WorkspaceFilter workspaceFilter = softwareSystem.getUniqueExistingChild(Workspace.class).getWorkspaceFilter();
        this.persistFilter(workspaceFilter, systemXml.getWorkspaceFilterInclude(), systemXml.getWorkspaceFilterExclude());
        for (XmlAdditionalInfoProvider infoProvider : this.m_infoProviders.values()) {
            infoProvider.addSystemDetailsToXml(softwareSystem, systemXml);
        }
        for (Module nextModule : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
            if (nextModule.isAutomatic()) continue;
            String language = nextModule.getType().getLanguage().getStandardName();
            XmlAdditionalInfoProvider infoProvider = this.m_infoProviders.get(language);
            assert (infoProvider != null) : "InfoProvider must not be null for language '" + nextModule.getType().getLanguage() + "'";
            XsdAbstractModule xmlModule = infoProvider.createXmlModule(nextModule.getType());
            xmlModule.setLanguage(language);
            xmlModule.setName(nextModule.getName());
            xmlModule.setId(nextModule.getId());
            xmlModule.setDescription(nextModule.getDescription());
            for (WorkspaceDependency nextDep : nextModule.getOutgoingWorkspaceDependencies()) {
                XsdAbstractModuleDependency nextXmlModuleDependency = infoProvider.createWorkspaceDependency(nextModule, nextDep);
                if (nextXmlModuleDependency == null) continue;
                nextXmlModuleDependency.setId(nextDep.getToId());
                if (nextDep.getTo() != null) {
                    assert (nextDep.getTo() instanceof NamedElement) : "workspace dependency endpoint must be of type NamedElement";
                    nextXmlModuleDependency.setName(((NamedElement)((Object)nextDep.getTo())).getShortName());
                } else {
                    nextXmlModuleDependency.setName(nextDep.getToName());
                }
                infoProvider.addInfoToXmlWorkspaceDependency(nextDep, nextXmlModuleDependency);
                xmlModule.getDependsOn().add(nextXmlModuleDependency);
            }
            for (RootDirectoryPath nextRootDirectoryPath : nextModule.getRelevantRootDirectoryPaths()) {
                infoProvider.addRootDirectoryPathToXml(xmlModule, nextModule, nextRootDirectoryPath);
            }
            infoProvider.addModuleDetailsToXml(softwareSystem, nextModule, systemXml, xmlModule);
            systemXml.getModule().add(xmlModule);
        }
        for (XmlAdditionalInfoProvider infoProvider : this.m_infoProviders.values()) {
            infoProvider.cleanup();
        }
        return systemXml;
    }

    public OperationResult save(com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem, a classLoader) {
        SoftwareSystem systemXml = this.createSystemXml(softwareSystem, (ClassLoader)classLoader);
        JaxbAdapter adapter = JaxbAccess.createJaxbAdapter(classLoader, this.m_persistenceContext);
        TFile file = softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile().getFile();
        OperationResult result = new OperationResult("Save software system");
        try {
            JaxbAccess.save(adapter, systemXml, file);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex, "Failed to save software system to file '" + file.getNormalizedAbsolutePath() + "'", new Object[0]);
        }
        return result;
    }

    public void writeToStream(com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem, a classLoader, OutputStream outStream) throws IOException {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'writeToStream' must not be null";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'writeToStream' must not be null";
        assert (outStream != null) : "Parameter 'outStream' of method 'writeToStream' must not be null";
        SoftwareSystem systemXml = this.createSystemXml(softwareSystem, (ClassLoader)classLoader);
        JaxbAdapter adapter = JaxbAccess.createJaxbAdapter(classLoader, this.m_persistenceContext);
        adapter.save((Object)systemXml, outStream);
    }

    public OperationResultWithOutcome<com.hello2morrow.sonargraph.core.model.system.SoftwareSystem> readFromStream(com.hello2morrow.sonargraph.core.model.system.SoftwareSystem softwareSystem, InputStream inputStream, String filePath) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'replaceFromStream' must not be null";
        assert (inputStream != null) : "Parameter 'inputStream' of method 'replaceFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load Software System from stream");
        JaxbAdapter m_adapter = JaxbAccess.createJaxbAdapter(softwareSystem.getClassLoader(), this.m_persistenceContext);
        ValidationEventHandlerImpl validationHandler = new ValidationEventHandlerImpl((OperationResult)result);
        SoftwareSystem systemXml = null;
        systemXml = (SoftwareSystem)m_adapter.load(inputStream, (ValidationEventHandler)validationHandler);
        this.createSoftwareSystem(new TFile(filePath), softwareSystem.getName(), (OperationResultWithOutcome<com.hello2morrow.sonargraph.core.model.system.SoftwareSystem>)result, systemXml, new Properties(), softwareSystem.getMode().isTemporary());
        return result;
    }
}

