/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.system.PersistenceCause;
import com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.system.XmlAdditionalInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModule;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModuleDependency;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractSystemExtension;
import com.hello2morrow.sonargraph.integration.access.foundation.a;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlDynamicSystemInfoPersistenceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlDynamicSystemInfoPersistenceProvider.class);
    private final Map<String, XmlAdditionalInfoProvider> m_infoProviders;
    private final XmlPersistenceContext m_persistenceContext;

    public XmlDynamicSystemInfoPersistenceProvider(Version version, List<IAdditionalFileInfoProvider> infoProviders) {
        assert (version != null) : "Parameter 'version' of method 'XmlSystemPersistenceProvider' must not be null";
        assert (infoProviders != null) : "Parameter 'infoProviders' of method 'XmlPersistenceProvider' must not be null";
        this.m_infoProviders = new HashMap<String, XmlAdditionalInfoProvider>(infoProviders.size());
        this.m_persistenceContext = new XmlPersistenceContext(XmlAdditionalInfoProvider.CORE_PERSISTENT_CONTEXT);
        for (IAdditionalFileInfoProvider provider : infoProviders) {
            assert (provider instanceof XmlAdditionalInfoProvider) : "persistence provider must be of type '" + XmlAdditionalInfoProvider.class.getName();
            XmlAdditionalInfoProvider xmlProvider = (XmlAdditionalInfoProvider)provider;
            this.m_infoProviders.put(provider.getLanguage().getStandardName(), xmlProvider);
            this.m_persistenceContext.add(xmlProvider.getPersistentContext());
        }
    }

    public OperationResultWithOutcome<DynamicSystemInfo> load(TFile systemFile, String systemName, a classLoader) {
        assert (systemFile != null) : "Parameter 'systemFile' of method 'load' must not be null";
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'load' must not be empty";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'load' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load Workspace of Software System from file '" + systemFile.getName() + "'");
        if (!systemFile.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "File '" + systemFile.getAbsolutePath() + "' does not exist", new Object[0]);
            return result;
        }
        JaxbAdapter m_adapter = JaxbAccess.createJaxbAdapter(classLoader, this.m_persistenceContext);
        ValidationEventHandlerImpl validationHandler = new ValidationEventHandlerImpl((OperationResult)result);
        SoftwareSystem systemXml = null;
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (TFileInputStream from = new TFileInputStream((File)systemFile);){
                systemXml = (SoftwareSystem)m_adapter.load((InputStream)from, (ValidationEventHandler)validationHandler);
                if (result.isFailure()) {
                    return result;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "File '" + systemFile.getAbsolutePath() + "' does not exist", new Object[0]);
            return result;
        }
        catch (IOException ex) {
            LOGGER.error("Failed to close inputstream of file '{}'", (Object)systemFile.getAbsolutePath());
        }
        this.createSoftwareSystem(systemFile, systemName, (OperationResultWithOutcome<DynamicSystemInfo>)result, systemXml);
        return result;
    }

    private void createSoftwareSystem(TFile systemFile, String systemName, OperationResultWithOutcome<DynamicSystemInfo> result, SoftwareSystem systemXml) {
        assert (systemXml != null) : "XML System object must not be null!";
        DynamicSystemInfo systemInfo = new DynamicSystemInfo(systemXml.getId(), systemName, systemXml.getDescription());
        result.setOutcome((Object)systemInfo);
        int i2 = 0;
        while (i2 < systemXml.getSystemExtension().size()) {
            XsdAbstractSystemExtension extension = systemXml.getSystemExtension().get(i2);
            String language = extension.getLanguage();
            if (!this.m_infoProviders.containsKey(language)) {
                result.addError((OperationResult.IMessageCause)PersistenceCause.LANGUAGE_NOT_SUPPORTED, "Language '" + language + "' of extension[" + i2 + "] is not supported.", new Object[0]);
            }
            ++i2;
        }
        HashMap<String, ModuleInfo> idToModuleMap = new HashMap<String, ModuleInfo>();
        for (XsdAbstractModule nextModuleXml : systemXml.getModule()) {
            String language = nextModuleXml.getLanguage();
            if (language == null || language.equals("")) {
                result.addError((OperationResult.IMessageCause)PersistenceCause.LANGUAGE_NOT_DEFINED, "No language defined for module '" + nextModuleXml.getName() + "'", new Object[0]);
                continue;
            }
            if (!this.m_infoProviders.containsKey(language)) {
                result.addError((OperationResult.IMessageCause)PersistenceCause.LANGUAGE_NOT_SUPPORTED, "Language '" + language + "' of module '" + nextModuleXml.getName() + "' is not supported", new Object[0]);
                continue;
            }
            Module.IModuleType moduleType = this.m_infoProviders.get(language).getModuleType(nextModuleXml.getClass());
            assert (moduleType != null) : "moduleType must not be null";
            ModuleInfo module = new ModuleInfo(nextModuleXml.getId(), nextModuleXml.getName(), nextModuleXml.getDescription(), language, moduleType.getStandardName());
            assert (module != null) : "Module must not be null!";
            this.m_infoProviders.get(language).getModuleDetailsFromXml(systemFile.getParentFile().getParentFile(), module, nextModuleXml);
            systemInfo.addModule(module);
            idToModuleMap.put(module.getId(), module);
        }
        for (XmlAdditionalInfoProvider infoProvider : this.m_infoProviders.values()) {
            infoProvider.cleanup();
        }
        for (XsdAbstractModule nextModuleXml : systemXml.getModule()) {
            ModuleInfo from = (ModuleInfo)idToModuleMap.get(nextModuleXml.getId());
            for (XsdAbstractModuleDependency nextXsdDependency : nextModuleXml.getDependsOn()) {
                WorkspaceDependency.IWorkspaceDependencyType workspaceDependencyType = this.m_infoProviders.get(nextModuleXml.getLanguage()).getWorkspaceDependencyType(nextXsdDependency.getClass());
                if (workspaceDependencyType == null) {
                    result.addError((OperationResult.IMessageCause)PersistenceCause.DEPENDENCY_TYPE_NOT_SUPPORTED, "No dependency type registered for JAXB class " + nextXsdDependency.getClass().getCanonicalName(), new Object[0]);
                    continue;
                }
                String id = nextXsdDependency.getId();
                String name = nextXsdDependency.getName();
                if (name == null || name.length() == 0) {
                    name = id;
                }
                ModuleInfo to = (ModuleInfo)idToModuleMap.get(id);
                assert (to != null) : "Module with id '" + id + "' has not been loaded";
                from.addDependsOn(to);
            }
        }
    }
}

