/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfiles;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.workspaceprofile.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.workspaceprofile.XsdWorkspaceProfile;
import com.hello2morrow.sonargraph.core.persistence.workspaceprofile.XsdWorkspaceProfileFilter;
import com.hello2morrow.sonargraph.core.persistence.workspaceprofile.XsdWorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.persistence.workspaceprofile.XsdWorkspaceProfilePatterns;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;

public final class WorkspaceProfilePersistence {
    private static final String SCHEMA_URL = "com/hello2morrow/sonargraph/core/persistence/workspaceprofile/workspaceProfile";
    private static final String XSD_PACKAGE_NAME = "com.hello2morrow.sonargraph.core.persistence.workspaceprofile";
    private final Version m_version;
    private final SoftwareSystem m_softwareSystem;
    private final WorkspaceProfiles m_workspaceProfiles;
    private final Files m_files;
    private final XmlPersistenceContext m_persistenceContext;

    public WorkspaceProfilePersistence(Version version, SoftwareSystem softwareSystem) {
        assert (version != null) : "Parameter 'version' of method 'WorkspaceProfilePersistence' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'WorkspaceProfilePersistence' must not be null";
        this.m_version = version;
        this.m_softwareSystem = softwareSystem;
        this.m_files = this.m_softwareSystem.getUniqueChild(Files.class);
        this.m_workspaceProfiles = this.m_files.getSystemDirectory().getUniqueExistingChild(WorkspaceProfiles.class);
        this.m_persistenceContext = new XmlPersistenceContext(XSD_PACKAGE_NAME, CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
    }

    private JaxbAdapter<JAXBElement<XsdWorkspaceProfile>> createJaxbAdapter() {
        ClassLoader classLoader = ObjectFactory.class.getClassLoader();
        return JaxbAccess.createJaxbAdapter(classLoader, this.m_persistenceContext);
    }

    public OperationResultWithOutcome<WorkspaceProfile> load(InputStream inputStream, WorkspaceProfile profile) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'load' must not be null";
        assert (profile != null) : "Parameter 'profile' of method 'load' must not be null";
        OperationResultWithOutcome loadResult = new OperationResultWithOutcome("Loading workspace profile '" + profile.getName() + "' from stream");
        JaxbAdapter<JAXBElement<XsdWorkspaceProfile>> jaxbAdapter = this.createJaxbAdapter();
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl((OperationResult)loadResult);
        JAXBElement xsdWorkspaceProfile = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)eventHandler);
        loadResult.setOutcome((Object)this.convertProfileXmlToPojo(profile, (XsdWorkspaceProfile)xsdWorkspaceProfile.getValue(), null));
        return loadResult;
    }

    public OperationResultWithOutcome<WorkspaceProfile> load(WorkspaceProfile profile, TFile file) {
        assert (file != null) : "Parameter 'file' of method 'load' must not be null";
        OperationResultWithOutcome loadResult = new OperationResultWithOutcome("Loading workspace profile '" + file.getAbsolutePath() + "'");
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (TFileInputStream inputStream = new TFileInputStream((File)file);){
                JaxbAdapter<JAXBElement<XsdWorkspaceProfile>> jaxbAdapter = this.createJaxbAdapter();
                OperationResult readResult = new OperationResult("Read workspace profile");
                ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl(readResult);
                JAXBElement xsdWorkspaceProfile = (JAXBElement)jaxbAdapter.load((InputStream)inputStream, (ValidationEventHandler)eventHandler);
                if (readResult.isSuccess()) {
                    loadResult.setOutcome((Object)this.convertProfileXmlToPojo(profile, (XsdWorkspaceProfile)xsdWorkspaceProfile.getValue(), file));
                } else {
                    StringBuilder builder = new StringBuilder("Workspace profile '");
                    builder.append(file.getAbsolutePath()).append("'.");
                    for (String next : readResult.getMessagesAsStringList()) {
                        builder.append(StringUtility.LINE_SEPARATOR).append(next);
                    }
                    loadResult.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, builder.toString(), new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            loadResult.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Workspace profile not found at '" + file.getAbsolutePath() + "'", new Object[]{ex});
        }
        catch (IOException ex) {
            loadResult.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex, "Workspace profile could not be loaded from '" + file.getAbsolutePath() + "'", new Object[0]);
        }
        return loadResult;
    }

    public OperationResult save(WorkspaceProfile profile) {
        Object workspaceDirectories;
        assert (profile != null) : "Parameter 'profile' of method 'save' must not be null";
        OperationResult saveResult = new OperationResult("Saving workspace profile");
        TFile parentFile = profile.getFile().getParentFile();
        if (!parentFile.exists()) {
            workspaceDirectories = new TFile((File)parentFile);
            try {
                workspaceDirectories.mkdir(true);
            }
            catch (IOException ex) {
                saveResult.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, (Throwable)ex);
                return saveResult;
            }
        }
        try {
            workspaceDirectories = null;
            Object var5_9 = null;
            try (TFileOutputStream outputStream = new TFileOutputStream((File)profile.getFile());){
                this.save((OutputStream)outputStream, profile, saveResult);
            }
            catch (Throwable throwable) {
                if (workspaceDirectories == null) {
                    workspaceDirectories = throwable;
                } else if (workspaceDirectories != throwable) {
                    ((Throwable)workspaceDirectories).addSuppressed(throwable);
                }
                throw workspaceDirectories;
            }
        }
        catch (FileNotFoundException ex) {
            saveResult.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "WorkspaceProfile not found at '" + profile.getFile().getAbsolutePath() + "'", new Object[]{ex});
        }
        catch (IOException ex) {
            saveResult.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex);
        }
        return saveResult;
    }

    public void save(OutputStream outputStream, WorkspaceProfile profile, OperationResult result) {
        try {
            this.createJaxbAdapter().save(this.convertPojoToXml(profile), outputStream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex);
        }
    }

    private JAXBElement<XsdWorkspaceProfile> convertPojoToXml(WorkspaceProfile profile) {
        assert (profile != null) : "Parameter 'profile' of method 'convertPojoToXml' must not be null";
        ObjectFactory objectFactory = new ObjectFactory();
        XsdWorkspaceProfile xsdProfile = objectFactory.createXsdWorkspaceProfile();
        xsdProfile.setId(profile.getFileId());
        xsdProfile.setVersion(this.m_version.toString());
        String description = profile.getDescription();
        if (description != null && description.trim().length() > 0) {
            xsdProfile.setDescription(description);
        }
        XsdWorkspaceProfilePatterns xsdPatterns = objectFactory.createXsdWorkspaceProfilePatterns();
        xsdProfile.setPatterns(xsdPatterns);
        for (IWorkspaceProfilePattern iWorkspaceProfilePattern : profile.getChildren(WorkspaceProfilePattern.class)) {
            XsdWorkspaceProfilePattern xsdPattern = objectFactory.createXsdWorkspaceProfilePattern();
            xsdPattern.setModuleMatcher(iWorkspaceProfilePattern.getModuleMatcher());
            xsdPattern.setRootPathMatcher(iWorkspaceProfilePattern.getRootPathMatcher());
            xsdPattern.setReplace(iWorkspaceProfilePattern.getRootPathReplacement());
            xsdPatterns.getPattern().add(xsdPattern);
        }
        ProductionCodeFilter productionCodeFilter = profile.getUniqueExistingChild(ProductionCodeFilter.class);
        xsdProfile.setOverrideWorkspaceFilter(profile.overrideWorkspaceFilter());
        if (!profile.overrideWorkspaceFilter()) {
            return objectFactory.createWorkspaceProfile(xsdProfile);
        }
        XsdWorkspaceProfileFilter xsdFilter = objectFactory.createXsdWorkspaceProfileFilter();
        xsdProfile.setFilters(xsdFilter);
        for (WildcardPatternInclude nextInclude : productionCodeFilter.getChildren(WildcardPatternInclude.class)) {
            xsdFilter.getInclude().add(nextInclude.getName());
        }
        for (WildcardPatternExclude nextExclude : productionCodeFilter.getChildren(WildcardPatternExclude.class)) {
            xsdFilter.getExclude().add(nextExclude.getName());
        }
        return objectFactory.createWorkspaceProfile(xsdProfile);
    }

    private WorkspaceProfile convertProfileXmlToPojo(WorkspaceProfile updateProfile, XsdWorkspaceProfile xsdWorkspaceProfile, TFile profileFile) {
        WorkspaceProfile profile;
        assert (xsdWorkspaceProfile != null) : "Parameter 'xsdWorkspaceProfile' of method 'convertProfileXmlToPojo' must not be null";
        if (xsdWorkspaceProfile.getPatterns() != null) {
            if (updateProfile == null) {
                profile = new WorkspaceProfile((NamedElement)this.m_workspaceProfiles, profileFile, this.m_files);
            } else {
                profile = updateProfile;
                updateProfile.removeChildren(new Class[0]);
            }
            for (XsdWorkspaceProfilePattern xsdPattern : xsdWorkspaceProfile.getPatterns().getPattern()) {
                WorkspaceProfilePattern pattern = new WorkspaceProfilePattern(profile, xsdPattern.getModuleMatcher(), xsdPattern.getRootPathMatcher(), xsdPattern.getReplace());
                profile.addChild(pattern);
            }
        } else {
            String identifier = updateProfile == null ? profileFile.getAbsolutePath() : updateProfile.getAbsolutePath();
            assert (false) : "No moduleRefs or patterns found for workspace profile '" + identifier + "'";
            return null;
        }
        String description = xsdWorkspaceProfile.getDescription();
        if (description != null) {
            profile.setDescription(description);
        }
        profile.setOverrideWorkspaceFilter(xsdWorkspaceProfile.isOverrideWorkspaceFilter());
        ProductionCodeFilter filters = new ProductionCodeFilter(profile);
        profile.addChild(filters);
        if (!profile.overrideWorkspaceFilter() || xsdWorkspaceProfile.getFilters() == null) {
            return profile;
        }
        for (String nextInclude : xsdWorkspaceProfile.getFilters().getInclude()) {
            WildcardPatternInclude include = new WildcardPatternInclude(filters, nextInclude);
            filters.addChild(include);
        }
        for (String nextExclude : xsdWorkspaceProfile.getFilters().getExclude()) {
            WildcardPatternExclude exclude = new WildcardPatternExclude(filters, nextExclude);
            filters.addChild(exclude);
        }
        return profile;
    }
}

