/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.snapshot;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;

public final class SnapshotBaseDirectory
extends NamedElement
implements IBaseDirectory {
    private final TFile m_baseDir;

    public SnapshotBaseDirectory(NamedElement parent, TFile baseDir) {
        super(parent);
        assert (baseDir != null) : "Parameter 'baseDir' of method 'AttachSnapshotBaseDir' must not be null";
        this.m_baseDir = baseDir;
    }

    @Override
    public TFile getDirectoryFile() {
        return this.m_baseDir;
    }

    static String convertPathIfNecessary(String path) {
        assert (path != null) : "Parameter 'path' of method 'convertPathIfNecessary' must not be null";
        return path.replace("..", "up");
    }

    @Override
    public TFile createFile(String relativePath) {
        assert (relativePath != null && relativePath.length() > 0) : "Parameter 'relativePath' of method 'createFile' must not be empty";
        assert (FileUtility.isRelativePath((String)relativePath)) : "Not a relative path: " + relativePath;
        TFile created = new TFile((File)this.getDirectoryFile(), SnapshotBaseDirectory.convertPathIfNecessary(relativePath)).getNormalizedAbsoluteFile();
        return created;
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public String getShortName() {
        int pos = this.getDirectoryFile().getAbsolutePath().lastIndexOf(47);
        if (pos != -1) {
            return this.getDirectoryFile().getAbsolutePath().substring(pos + 1);
        }
        return this.getDirectoryFile().getAbsolutePath();
    }
}

