/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.snapshot;

import com.hello2morrow.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RetrievableFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetrievableFactory.class);
    private final Class<? extends ISnapshotReader.IRetrievable> m_class;
    private final Constructor<? extends ISnapshotReader.IRetrievable> m_constructor;

    RetrievableFactory(String className, ClassLoader loader, Class<?> ... arguments) throws ClassNotFoundException {
        Constructor<?> ctor;
        Class<?> clazz;
        block7: {
            assert (className != null && className.length() > 0) : "Parameter 'className' of method 'DependencyFactory' must not be empty";
            assert (loader != null) : "Parameter 'loader' of method 'DependencyFactory' must not be null";
            clazz = null;
            ctor = null;
            try {
                clazz = loader.loadClass(className);
                assert (clazz != null);
                if (arguments != null && arguments.length > 0) {
                    ctor = clazz.getConstructor(arguments);
                    assert (ctor != null);
                }
            }
            catch (NoSuchMethodException | SecurityException e2) {
                LOGGER.error("Unable to initialize factory of class " + className, (Object)ExceptionUtility.collectFirstAndLast((Throwable)e2));
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)ExceptionUtility.collectFirstAndLast((Throwable)e2));
            }
        }
        this.m_class = clazz;
        this.m_constructor = ctor;
    }

    ISnapshotReader.IRetrievable create(Object ... arguments) {
        block7: {
            if (arguments != null && arguments.length > 0) {
                assert (this.m_constructor != null);
                try {
                    return this.m_constructor.newInstance(arguments);
                }
                catch (Exception e2) {
                    LOGGER.error("Unable to create " + this.m_class.getName(), (Object)ExceptionUtility.collectFirstAndLast((Throwable)e2));
                    assert (false) : ExceptionUtility.collectFirstAndLast((Throwable)e2);
                    break block7;
                }
            }
            try {
                return this.m_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e3) {
                LOGGER.error("Unable to create " + this.m_class.getName(), (Object)ExceptionUtility.collectFirstAndLast((Throwable)e3));
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)ExceptionUtility.collectFirstAndLast((Throwable)e3));
            }
        }
        return null;
    }
}

