/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.snapshot;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.persistence.snapshot.INamedElementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NamedElementFactory
implements INamedElementFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedElementFactory.class);
    private Class<NamedElement> m_class;
    private Constructor<NamedElement> m_constructor;

    NamedElementFactory(String className, ClassLoader loader) throws ClassNotFoundException {
        assert (className != null && className.length() > 0) : "Parameter 'className' of method 'Factory' must not be empty";
        assert (loader != null) : "Parameter 'loader' of method 'Factory' must not be null";
        try {
            this.m_class = loader.loadClass(className);
            this.m_constructor = this.m_class.getConstructor(NamedElement.class);
        }
        catch (NoSuchMethodException e2) {
            this.m_constructor = null;
        }
    }

    @Override
    public NamedElement create(NamedElement parent) {
        assert (this.m_constructor != null) : "No matching constructor for class " + this.m_class.getName();
        try {
            return this.m_constructor.newInstance(parent);
        }
        catch (InstantiationException e2) {
            LOGGER.error("Cannot instantiate object from factory", (Throwable)e2);
        }
        catch (IllegalAccessException e3) {
            LOGGER.error("Cannot access constructor from factory", (Throwable)e3);
        }
        catch (InvocationTargetException e4) {
            LOGGER.error("Exception in factory constructor", (Throwable)e4);
        }
        assert (false);
        return null;
    }

    @Override
    public NamedElement create() {
        try {
            return this.m_class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
            LOGGER.error("Cannot instantiate object from factory", (Throwable)e2);
            assert (false);
            return null;
        }
    }
}

