/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.report;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.text.IntBasedHash;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.foundation.utilities.XmlUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.analysis.DynamicIssueType;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureDeprecationIssueId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueId;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.IIssueWithLineContext;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.IssueType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyWildcardPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.LineBasedContextSimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementFullyQualifiedNamePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementWildcardPattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.ParserDependencyEndpointPattern;
import com.hello2morrow.sonargraph.core.model.filter.IssueFilter;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginExternal;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.report.MetricValueComparator;
import com.hello2morrow.sonargraph.core.model.resolution.FixDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.ToDoDefinition;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueId;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PhysicalInfo;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.LanguageBasedExternal;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.report.AbstractExportMetaDataXmlAccess;
import com.hello2morrow.sonargraph.core.persistence.report.MarshallListener;
import com.hello2morrow.sonargraph.core.persistence.report.QualityGateXmlReportWriter;
import com.hello2morrow.sonargraph.core.persistence.report.ReportCancelledException;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlAccess;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlIdGenerator;
import com.hello2morrow.sonargraph.integration.access.persistence.report.ObjectFactory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdAnalyzer;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdAnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdBooleanEntry;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdCycleElement;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdCycleGroupAnalyzerConfiguration;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdCycleGroupContainer;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdCycleIssue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDeleteRefactoring;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDependencyIssue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDependencyIssues;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDependencyPatternType;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDuplicateBlockIssue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDuplicateCodeConfiguration;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElement;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementIssues;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementKind;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementKinds;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementPattern;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementPatternType;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElements;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExecutionPhase;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExportMetaData;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExternal;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExternalModuleScopeElements;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExternalSystemScopeElements;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdFeature;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdFeatures;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdFilter;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdFloatEntry;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIgnore;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIntEntry;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueCategory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssues;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdLineBasedIssue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdLogicalNamespace;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdLogicalProgrammingElement;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMap;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMapEntry;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMatching;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricFloatValue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricId;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricIntValue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricLevel;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricLevelContainer;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricLevelValues;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricThreshold;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricThresholdViolationIssue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricThresholds;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricValue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdModule;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdModuleElements;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdModuleMetricValues;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMoveRefactoring;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMoveRenameRefactoring;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdNamedElement;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdPhysicalRecursiveElement;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdPlugin;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdPluginConfiguration;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdPluginExternal;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdProgrammingElement;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdRenameRefactoring;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdResolution;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdResolutions;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdRootDirectory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdSimpleElementIssue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdSoftwareSystemReport;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdSourceFile;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdStringEntry;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdSystemDiffConfiguration;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdSystemElements;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdSystemFile;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdSystemMetricValues;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdToDo;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdWildcardPattern;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdWorkspace;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.IPluginModelContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphBooleanPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphFloatPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphIntPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportXmlWriter
extends AbstractExportMetaDataXmlAccess<JAXBElement<XsdSoftwareSystemReport>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportXmlWriter.class);
    private final Map<IAnalyzerId, Object> m_analyzerMap = new TreeMap<IAnalyzerId, Object>(Comparator.comparing(IStandardEnumeration::getStandardName));
    private final XmlIdGenerator m_idGenerator = new XmlIdGenerator();
    private final ObjectFactory m_objectFactory = new ObjectFactory();
    private final Map<Language, ILanguageProvider> m_languageToLanguageProvider = new HashMap<Language, ILanguageProvider>();
    private final Map<Object, XsdNamedElement> m_namedElementToXsdNamedElement = new HashMap<Object, XsdNamedElement>();
    private final Map<SonargraphPlugin, XsdPlugin> m_pluginToXsdPlugin = new HashMap<SonargraphPlugin, XsdPlugin>();
    private final Map<Module, XsdModule> m_moduleToXsdModule = new LinkedHashMap<Module, XsdModule>();
    private final Map<PhysicalInfo, XsdSourceFile> m_physicalInfoToXsdSourceFile = new HashMap<PhysicalInfo, XsdSourceFile>();
    private final Set<PhysicalRecursiveElement> m_physicalRecursiveElementsNeedingOriginals = new HashSet<PhysicalRecursiveElement>();
    private final Map<String, XsdRootDirectory> m_fqNameToXsdRootDirectory = new HashMap<String, XsdRootDirectory>();
    private final Map<String, XsdElementKind> m_elementStandardNameToXsdElementKind = new HashMap<String, XsdElementKind>();
    private final Map<Issue, XsdIssue> m_issueToXsdIssue = new HashMap<Issue, XsdIssue>();
    private final Map<IMetricThreshold, XsdMetricThreshold> m_metricThresholdToXsdMetricThreshold = new HashMap<IMetricThreshold, XsdMetricThreshold>();
    private final Map<String, XsdIssueCategory> m_nameToIssueCategory = new HashMap<String, XsdIssueCategory>();
    private final Map<String, XsdMetricLevel> m_nameToMetricLevel = new HashMap<String, XsdMetricLevel>();
    private final Map<String, XsdMetricId> m_nameToMetricId = new HashMap<String, XsdMetricId>();
    private final Version m_version;
    private final IReport m_report;
    private int m_createdXsdElements;

    public ReportXmlWriter(Version version, IReport report) {
        assert (version != null) : "Parameter 'version' of method 'ScriptPersistence' must not be null";
        assert (report != null) : "Parameter 'report' of method 'ReportPersistence' must not be null";
        this.m_version = version;
        this.m_report = report;
    }

    public void storeReportToFile(IWorkerContext workerContext, TFile targetFile, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'save' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        JAXBElement<XsdSoftwareSystemReport> xmlReport = this.createXmlReport(workerContext, result);
        try {
            workerContext.setNumberOfSteps(1);
            JaxbAdapter jaxbAdapter = XmlAccess.createReportJaxbAdapter();
            jaxbAdapter.setMarshalListener((Marshaller.Listener)new MarshallListener(workerContext, this.m_createdXsdElements));
            JaxbAccess.save(jaxbAdapter, xmlReport, targetFile);
            workerContext.endStep();
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
        catch (ReportCancelledException ex) {
            LOGGER.debug("Report generation has been cancelled");
        }
    }

    private JAXBElement<XsdSoftwareSystemReport> createXmlReport(IWorkerContext workerContext, OperationResult result) {
        Map<External, Set<NamedElement>> map;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createXmlReport' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createXmlReport' must not be null";
        for (Language language : this.m_report.getSoftwareSystem().getUsedLanguages()) {
            this.m_languageToLanguageProvider.put(language, this.m_report.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class).getLanguageProvider(language));
        }
        XsdSoftwareSystemReport xsdReport = this.m_objectFactory.createXsdSoftwareSystemReport();
        ++this.m_createdXsdElements;
        JAXBElement xsdReportRoot = this.m_objectFactory.createReport(xsdReport);
        ++this.m_createdXsdElements;
        xsdReport.setId(this.m_idGenerator.getNextId());
        xsdReport.setName(this.m_report.getSoftwareSystem().getName());
        xsdReport.setSystemDescription(this.m_report.getSoftwareSystem().getDescription());
        xsdReport.setDescription(this.m_report.getSoftwareSystem().getDescription());
        Map<String, String> metaData = this.m_report.getSoftwareSystem().getMetaData();
        if (!metaData.isEmpty()) {
            XsdMap map2 = this.m_objectFactory.createXsdMap();
            for (Map.Entry<String, String> entry : metaData.entrySet()) {
                XsdMapEntry xsdMapEntry = this.m_objectFactory.createXsdMapEntry();
                xsdMapEntry.setKey(entry.getKey());
                xsdMapEntry.setValue(entry.getValue());
                map2.getEntry().add(xsdMapEntry);
            }
            xsdReport.setSystemMetaData(map2);
        }
        xsdReport.setVersion(this.m_version.toString());
        xsdReport.setTimestamp(XmlUtility.createDateTimeObject((long)this.m_report.getTimestamp()));
        xsdReport.setSystemId(this.m_report.getSoftwareSystem().getId());
        xsdReport.setSystemPath(this.m_report.getSystemDirectoryPath());
        xsdReport.setCurrentVirtualModel(this.m_report.getCurrentVirtualModel());
        xsdReport.setAnalyzerExecutionLevel(this.determineExecutionLevel(this.m_report.getAnalyzerExecutionLevel()));
        xsdReport.setReportContextInfo(this.m_report.getReportContextInfo() != null ? this.m_report.getReportContextInfo() : "");
        if (this.m_report.getQualityModelPath() != null && this.m_report.getQualityModelPath().trim().length() > 0) {
            xsdReport.setQualityModel(this.m_report.getQualityModelPath());
        }
        if (this.m_report.getActiveProfile() != null && this.m_report.getActiveProfile().trim().length() > 0) {
            xsdReport.setWorkspaceProfile(this.m_report.getActiveProfile());
        }
        this.addFeaturesToXml(xsdReport);
        this.addPluginsToXml(xsdReport);
        this.addAnalyzersToXml(xsdReport);
        this.addDuplicateCodeConfigurationToXml(xsdReport);
        this.addScriptRunnerConfigurationToXml(xsdReport);
        this.addArchitectureCheckConfigurationToXml(xsdReport);
        this.addCycleGroupAnalyzerConfigurationToXml(xsdReport);
        this.addPluginConfigurationToXml(xsdReport);
        this.addCheckedArchitecturesToXml(xsdReport);
        this.addCheckedQualityGatesToXml(xsdReport);
        this.addBaselineToXml(xsdReport);
        XsdExportMetaData xsdExportMetaData = this.m_objectFactory.createXsdExportMetaData();
        ++this.m_createdXsdElements;
        xsdReport.setMetaData(xsdExportMetaData);
        this.addExportDataToXml(xsdExportMetaData);
        this.addMetricThresholds(xsdReport);
        this.createWorkspace(xsdReport);
        XsdSystemElements xsdSystemElements = this.m_objectFactory.createXsdSystemElements();
        ++this.m_createdXsdElements;
        xsdSystemElements.setRef((Object)xsdReport);
        xsdReport.setSystemElements(xsdSystemElements);
        for (Map.Entry<Module, Set<NamedElement>> entry : this.m_report.getModuleElements().entrySet()) {
            if (workerContext.hasBeenCanceled()) {
                return xsdReportRoot;
            }
            Module nextModule = entry.getKey();
            XsdModuleElements nextXsdModuleElements = this.m_objectFactory.createXsdModuleElements();
            ++this.m_createdXsdElements;
            XsdModule nextXsdModule = this.m_moduleToXsdModule.get(nextModule);
            nextXsdModuleElements.setRef((Object)nextXsdModule);
            xsdReport.getModuleElements().add(nextXsdModuleElements);
            HashSet<NamedElement> namedElements = new HashSet<NamedElement>((Collection)entry.getValue());
            this.addElements(workerContext, namedElements, (XsdElements)nextXsdModuleElements);
            nextXsdModule.setKind((Object)this.m_elementStandardNameToXsdElementKind.get(nextModule.getStandardPresentationKind()));
        }
        for (PhysicalRecursiveElement physicalRecursiveElement : this.m_physicalRecursiveElementsNeedingOriginals) {
            if (workerContext.hasBeenCanceled()) {
                return xsdReportRoot;
            }
            Language nextLanguage = physicalRecursiveElement.getLanguage();
            ILanguageProvider nextLanguageProvider = this.m_languageToLanguageProvider.get(nextLanguage);
            assert (nextLanguageProvider != null) : "Parameter 'nextLanguageProvider' of method 'createXmlReport' must not be null";
            PhysicalInfo nextPhysicalInfo = nextLanguageProvider.getPhysicalInfo(physicalRecursiveElement);
            if (nextPhysicalInfo != null) {
                RootDirectoryPath nextRootDirectoryPath = nextPhysicalInfo.getRootDirectoryPath();
                XsdPhysicalRecursiveElement nextOriginalXsdPhysicalRecursiveElement = this.createOriginalPhysicalRecursiveElement(nextRootDirectoryPath, physicalRecursiveElement, nextPhysicalInfo);
                XsdNamedElement nextXsdNamedElement = this.m_namedElementToXsdNamedElement.get(physicalRecursiveElement);
                assert (nextXsdNamedElement != null && nextXsdNamedElement instanceof XsdPhysicalRecursiveElement) : "Unexpected class in method 'createXmlReport': " + nextXsdNamedElement;
                XsdPhysicalRecursiveElement xsdPhysicalRecursiveElement = (XsdPhysicalRecursiveElement)nextXsdNamedElement;
                xsdPhysicalRecursiveElement.setOriginalLocation((Object)nextOriginalXsdPhysicalRecursiveElement);
                xsdPhysicalRecursiveElement.setOriginalFqName(physicalRecursiveElement.getOriginalFullyQualifiedName());
                continue;
            }
            LOGGER.warn("Physical recursive element needs original but no physical info available: " + physicalRecursiveElement.getFullyQualifiedName());
        }
        Map<External, Set<NamedElement>> map3 = this.m_report.getExternalSystemScopeElements();
        if (!map3.isEmpty()) {
            for (Map.Entry entry : map3.entrySet()) {
                External external = (External)entry.getKey();
                XsdExternalSystemScopeElements xsdExternalSystemScopeElements = this.m_objectFactory.createXsdExternalSystemScopeElements();
                ++this.m_createdXsdElements;
                XsdNamedElement xsdNamedElement = this.m_namedElementToXsdNamedElement.get(external);
                assert (xsdNamedElement != null) : "xsdExternal must not be null for External '" + external + "'";
                xsdExternalSystemScopeElements.setRef((Object)xsdNamedElement);
                xsdReport.getExternalSystemScopeElements().add(xsdExternalSystemScopeElements);
                this.addElements(workerContext, (Set)entry.getValue(), (XsdElements)xsdExternalSystemScopeElements);
            }
        }
        if (!(map = this.m_report.getExternalModuleScopeElements()).isEmpty()) {
            for (Map.Entry<External, Set<NamedElement>> nextEntry : map.entrySet()) {
                External external = nextEntry.getKey();
                XsdExternalModuleScopeElements xsdExternalModuleScopeElements = this.m_objectFactory.createXsdExternalModuleScopeElements();
                ++this.m_createdXsdElements;
                XsdNamedElement xsdExternal = this.m_namedElementToXsdNamedElement.get(external);
                assert (xsdExternal != null && xsdExternal instanceof XsdExternal) : "Unexpected class in method 'createXmlReport': " + xsdExternal;
                XsdExternal nextExternal = (XsdExternal)xsdExternal;
                xsdExternalModuleScopeElements.setRef((Object)nextExternal);
                xsdReport.getExternalModuleScopeElements().add(xsdExternalModuleScopeElements);
                this.addElements(workerContext, nextEntry.getValue(), (XsdElements)xsdExternalModuleScopeElements);
            }
        }
        this.addElements(workerContext, this.m_report.getSystemElements(), (XsdElements)xsdSystemElements);
        if (workerContext.hasBeenCanceled()) {
            return xsdReportRoot;
        }
        XsdElementKinds xsdElementKinds = this.m_objectFactory.createXsdElementKinds();
        ++this.m_createdXsdElements;
        xsdReport.setElementKinds(xsdElementKinds);
        xsdElementKinds.getElementKind().addAll(this.m_elementStandardNameToXsdElementKind.values());
        this.addMetricValuesToXml(workerContext, xsdReport, this.m_nameToMetricId);
        if (workerContext.hasBeenCanceled()) {
            return xsdReportRoot;
        }
        if (this.m_report.getTotalNumberOfIssues() > 0) {
            this.addIssuesToXml(workerContext, xsdReport);
        }
        if (workerContext.hasBeenCanceled()) {
            return xsdReportRoot;
        }
        if (this.m_report.getNumberOfResolutions() > 0) {
            this.addResolutionsToXml(workerContext, xsdReport);
        }
        return xsdReportRoot;
    }

    private XsdAnalyzerExecutionLevel determineExecutionLevel(AnalyzerExecutionLevel level) {
        assert (level != null) : "Parameter 'level' of method 'determineExecutionLevel' must not be null";
        switch (level) {
            case MINIMAL: {
                return XsdAnalyzerExecutionLevel.MINIMAL;
            }
            case BASIC: {
                return XsdAnalyzerExecutionLevel.BASIC;
            }
            case ADVANCED: {
                return XsdAnalyzerExecutionLevel.ADVANCED;
            }
            case FULL: {
                return XsdAnalyzerExecutionLevel.FULL;
            }
        }
        assert (false) : "Unsupported AnalyzerExecutionLevel '" + (Object)((Object)level) + "'";
        return null;
    }

    private void addFeaturesToXml(XsdSoftwareSystemReport xsdReport) {
        XsdFeature xsdFeature;
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addFeaturesToXml' must not be null";
        XsdFeatures xsdFeatures = this.m_objectFactory.createXsdFeatures();
        ++this.m_createdXsdElements;
        xsdReport.setFeatures(xsdFeatures);
        for (SonargraphFeature feature : this.m_report.getAvailableFeatures()) {
            xsdFeature = this.m_objectFactory.createXsdFeature();
            ++this.m_createdXsdElements;
            xsdFeature.setName(feature.getStandardName());
            xsdFeature.setPresentationName(feature.getPresentationName());
            xsdFeature.setLicensed(Boolean.valueOf(true));
            xsdFeatures.getFeature().add(xsdFeature);
        }
        for (SonargraphFeature feature : this.m_report.getUnavailableFeatures()) {
            xsdFeature = this.m_objectFactory.createXsdFeature();
            ++this.m_createdXsdElements;
            xsdFeature.setName(feature.getStandardName());
            xsdFeature.setPresentationName(feature.getPresentationName());
            xsdFeature.setLicensed(Boolean.valueOf(false));
            xsdFeatures.getFeature().add(xsdFeature);
        }
    }

    private void addDuplicateCodeConfigurationToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addDuplicateCodeConfigurationToXml' must not be null";
        List<String> entries = this.m_report.getDuplicateCodeConfigurationEntries();
        if (!entries.isEmpty()) {
            XsdDuplicateCodeConfiguration xsdDuplicateCodeConfiguration = this.m_objectFactory.createXsdDuplicateCodeConfiguration();
            ++this.m_createdXsdElements;
            xsdReport.setDuplicateCodeConfiguration(xsdDuplicateCodeConfiguration);
            for (String nextEntry : entries) {
                xsdDuplicateCodeConfiguration.getEntry().add(nextEntry);
            }
        }
    }

    private void addScriptRunnerConfigurationToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addScriptRunnerConfigurationToXml' must not be null";
        List<String> entries = this.m_report.getScriptRunnerConfigurationEntries();
        if (!entries.isEmpty()) {
            XsdScriptRunnerConfiguration xsdScriptRunnerConfiguration = this.m_objectFactory.createXsdScriptRunnerConfiguration();
            ++this.m_createdXsdElements;
            xsdReport.setScriptRunnerConfiguration(xsdScriptRunnerConfiguration);
            for (String next : entries) {
                xsdScriptRunnerConfiguration.getEntry().add(next);
            }
        }
    }

    private void addArchitectureCheckConfigurationToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addArchitectureCheckConfigurationToXml' must not be null";
        List<String> entries = this.m_report.getArchitectureCheckConfigurationEntries();
        if (!entries.isEmpty()) {
            XsdArchitectureCheckConfiguration xsdArchitectureCheckConfiguration = this.m_objectFactory.createXsdArchitectureCheckConfiguration();
            ++this.m_createdXsdElements;
            xsdReport.setArchitectureCheckConfiguration(xsdArchitectureCheckConfiguration);
            for (String next : entries) {
                xsdArchitectureCheckConfiguration.getEntry().add(next);
            }
        }
    }

    private void addBaselineToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addBaselineToXml' must not be null";
        if (this.m_report.getBaseline() != null) {
            XsdSystemDiffConfiguration xsdSystemDiff = this.m_objectFactory.createXsdSystemDiffConfiguration();
            ++this.m_createdXsdElements;
            xsdSystemDiff.setPath(this.m_report.getBaseline().trim());
            xsdReport.setSystemDiffConfiguration(xsdSystemDiff);
        }
    }

    private void addCheckedQualityGatesToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addCheckedQualityGatesToXml' must not be null";
        QualityGateXmlReportWriter qualityGateWriter = new QualityGateXmlReportWriter(this.m_objectFactory, this.m_idGenerator, this.m_namedElementToXsdNamedElement, this.m_elementStandardNameToXsdElementKind);
        this.m_createdXsdElements += qualityGateWriter.writeElementsToXml(this.m_report, xsdReport);
    }

    private void addCycleGroupAnalyzerConfigurationToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addCycleGroupAnalyzerConfigurationToXml' must not be null";
        for (CycleAnalyzerConfiguration next : this.m_report.getCycleGroupAnalyzerConfigurations()) {
            XsdCycleGroupAnalyzerConfiguration xsdCycleGroupAnalyzerConfig = this.m_objectFactory.createXsdCycleGroupAnalyzerConfiguration();
            ++this.m_createdXsdElements;
            Object xsdAnalyzer = this.m_analyzerMap.get(next.getAnalyzerId());
            assert (xsdAnalyzer != null) : "Missing analyzer '" + next.getAnalyzerId() + "'";
            xsdCycleGroupAnalyzerConfig.setName(next.getAnalyzerId().getStandardName());
            xsdCycleGroupAnalyzerConfig.setAnalyzer(xsdAnalyzer);
            xsdReport.getCycleGroupAnalyzerConfiguration().add(xsdCycleGroupAnalyzerConfig);
            for (Map.Entry<String, Object> nextConfig : next.getValueMap().entrySet()) {
                assert (nextConfig.getValue() != null) : "value of configuration entry '" + nextConfig.getKey() + "' must not be null";
                if (nextConfig.getValue() instanceof String) {
                    XsdStringEntry xsdStringEntry = this.m_objectFactory.createXsdStringEntry();
                    ++this.m_createdXsdElements;
                    xsdStringEntry.setName(nextConfig.getKey());
                    xsdStringEntry.setValue((String)nextConfig.getValue());
                    xsdCycleGroupAnalyzerConfig.getStringEntry().add(xsdStringEntry);
                    continue;
                }
                if (nextConfig.getValue() instanceof Integer) {
                    XsdIntEntry xsdIntEntry = this.m_objectFactory.createXsdIntEntry();
                    ++this.m_createdXsdElements;
                    xsdIntEntry.setName(nextConfig.getKey());
                    xsdIntEntry.setValue(Integer.valueOf((Integer)nextConfig.getValue()));
                    xsdCycleGroupAnalyzerConfig.getIntEntry().add(xsdIntEntry);
                    continue;
                }
                assert (false) : "Analyzer configuration entry '" + nextConfig.getKey() + "' has unsupported value type '" + nextConfig.getValue().getClass().getCanonicalName() + "'";
            }
        }
    }

    private void addPluginConfigurationToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addPluginConfigurationToXml' must not be null";
        for (Map.Entry<SonargraphPlugin, Pair<PluginConfigurationFile, List<Pair<SonargraphPluginAttribute, String>>>> next : this.m_report.getPluginConfigurations().entrySet()) {
            XsdPluginConfiguration xsdPluginConfiguration = this.m_objectFactory.createXsdPluginConfiguration();
            ++this.m_createdXsdElements;
            XsdPlugin xsdPlugin = this.m_pluginToXsdPlugin.get(next.getKey());
            assert (xsdPlugin != null) : "Missing plugin '" + next.getKey() + "'";
            PluginConfigurationFile pluginConfiguration = (PluginConfigurationFile)next.getValue().getFirst();
            xsdPluginConfiguration.setId(this.m_idGenerator.getNextId());
            xsdPluginConfiguration.setPlugin((Object)xsdPlugin);
            xsdPluginConfiguration.setName(pluginConfiguration.getName());
            xsdPluginConfiguration.setPresentationName(pluginConfiguration.getPresentationName(false));
            List pluginConfigurationAttributes = (List)next.getValue().getSecond();
            for (Pair nextAttributeAndValue : pluginConfigurationAttributes) {
                SonargraphPluginAttribute definition = (SonargraphPluginAttribute)nextAttributeAndValue.getFirst();
                if (definition instanceof SonargraphStringPluginAttribute) {
                    XsdStringEntry xsdStringEntry = this.m_objectFactory.createXsdStringEntry();
                    xsdStringEntry.setName(definition.getName());
                    xsdStringEntry.setValue(((String)nextAttributeAndValue.getSecond()).toString());
                    xsdPluginConfiguration.getStringEntry().add(xsdStringEntry);
                } else if (definition instanceof SonargraphIntPluginAttribute) {
                    XsdIntEntry xsdIntEntry = this.m_objectFactory.createXsdIntEntry();
                    xsdIntEntry.setName(definition.getName());
                    xsdIntEntry.setValue(Integer.valueOf(Integer.parseInt((String)nextAttributeAndValue.getSecond())));
                    xsdPluginConfiguration.getIntEntry().add(xsdIntEntry);
                } else if (definition instanceof SonargraphFloatPluginAttribute) {
                    XsdFloatEntry xsdFloatEntry = this.m_objectFactory.createXsdFloatEntry();
                    xsdFloatEntry.setName(definition.getName());
                    xsdFloatEntry.setValue(Float.valueOf(Float.parseFloat((String)nextAttributeAndValue.getSecond())));
                    xsdPluginConfiguration.getFloatEntry().add(xsdFloatEntry);
                } else {
                    assert (definition != null && definition instanceof SonargraphBooleanPluginAttribute) : "Unexpected class in method 'addPluginConfigurationEntriesDiff': " + definition;
                    XsdBooleanEntry xsdBooleanEntry = this.m_objectFactory.createXsdBooleanEntry();
                    xsdBooleanEntry.setName(definition.getName());
                    xsdBooleanEntry.setValue(Boolean.valueOf(Boolean.parseBoolean((String)nextAttributeAndValue.getSecond())));
                    xsdPluginConfiguration.getBooleanEntry().add(xsdBooleanEntry);
                }
                ++this.m_createdXsdElements;
            }
            xsdReport.getPluginConfiguration().add(xsdPluginConfiguration);
        }
    }

    private void createWorkspace(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'createModules' must not be null";
        XsdWorkspace xsdWorkspace = this.m_objectFactory.createXsdWorkspace();
        ++this.m_createdXsdElements;
        xsdReport.setWorkspace(xsdWorkspace);
        this.addWorkspaceFiltersToXml(xsdWorkspace);
        for (Module nextModule : this.m_report.getModules()) {
            XsdModule nextXsdModule = this.m_objectFactory.createXsdModule();
            ++this.m_createdXsdElements;
            this.addStandardNamedElementAttributes(nextModule, (XsdNamedElement)nextXsdModule, false);
            nextXsdModule.setDescription(nextModule.getDescription());
            nextXsdModule.setLanguage(nextModule.getLanguage().getStandardName());
            nextXsdModule.setModuleId(nextModule.getId());
            xsdWorkspace.getModule().add(nextXsdModule);
            this.m_moduleToXsdModule.put(nextModule, nextXsdModule);
            this.m_namedElementToXsdNamedElement.put(nextModule, (XsdNamedElement)nextXsdModule);
            for (RootDirectoryPath nextRootDirectoryPath : nextModule.getChildren(RootDirectoryPath.class)) {
                XsdRootDirectory nextXsdRootDirectoryPath = this.m_objectFactory.createXsdRootDirectory();
                ++this.m_createdXsdElements;
                this.addStandardNamedElementAttributes(nextRootDirectoryPath, (XsdNamedElement)nextXsdRootDirectoryPath, false);
                nextXsdModule.getRootDirectory().add(nextXsdRootDirectoryPath);
                this.m_namedElementToXsdNamedElement.put(nextRootDirectoryPath, (XsdNamedElement)nextXsdRootDirectoryPath);
                this.m_fqNameToXsdRootDirectory.put(nextRootDirectoryPath.getFullyQualifiedName(), nextXsdRootDirectoryPath);
            }
        }
        for (External nextExternal : this.m_report.getExternal()) {
            XsdExternal nextXsdExternal;
            if (nextExternal instanceof LanguageBasedExternal) {
                nextXsdExternal = this.m_objectFactory.createXsdExternal();
                ++this.m_createdXsdElements;
                this.addStandardNamedElementAttributes(nextExternal, (XsdNamedElement)nextXsdExternal, false);
                Language nextLanguage = nextExternal.getLanguage();
                nextXsdExternal.setLanguage(nextLanguage.getStandardName());
                nextXsdExternal.setDescription(nextExternal.getDescription());
                xsdWorkspace.getExternal().add(nextXsdExternal);
                this.m_namedElementToXsdNamedElement.put(nextExternal, (XsdNamedElement)nextXsdExternal);
                for (RootDirectoryPath nextRootDirectoryPath : nextExternal.getChildrenRecursively(RootDirectoryPath.class, NamespaceFragment.class)) {
                    XsdRootDirectory nextXsdRootDirectoryPath = this.m_objectFactory.createXsdRootDirectory();
                    ++this.m_createdXsdElements;
                    this.addStandardNamedElementAttributes(nextRootDirectoryPath, (XsdNamedElement)nextXsdRootDirectoryPath, false);
                    nextXsdExternal.getRootDirectory().add(nextXsdRootDirectoryPath);
                    this.m_namedElementToXsdNamedElement.put(nextRootDirectoryPath, (XsdNamedElement)nextXsdRootDirectoryPath);
                    this.m_fqNameToXsdRootDirectory.put(nextRootDirectoryPath.getFullyQualifiedName(), nextXsdRootDirectoryPath);
                }
                continue;
            }
            if (!(nextExternal instanceof PluginExternal)) continue;
            nextXsdExternal = this.m_objectFactory.createXsdPluginExternal();
            ++this.m_createdXsdElements;
            this.addStandardNamedElementAttributes(nextExternal, (XsdNamedElement)nextXsdExternal, false);
            nextXsdExternal.setDescription(nextExternal.getDescription());
            xsdWorkspace.getPluginExternal().add(nextXsdExternal);
            this.m_namedElementToXsdNamedElement.put(nextExternal, (XsdNamedElement)nextXsdExternal);
        }
    }

    private void addWorkspaceFiltersToXml(XsdWorkspace xsdWorkspace) {
        XsdWildcardPattern xsdExclude;
        XsdWildcardPattern xsdInclude;
        XsdFilter xsdWorkspaceFilter = this.m_objectFactory.createXsdFilter();
        ++this.m_createdXsdElements;
        xsdWorkspace.setWorkspaceFilter(xsdWorkspaceFilter);
        WorkspaceFilter workspaceFilter = this.m_report.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getWorkspaceFilter();
        xsdWorkspaceFilter.setDescription(workspaceFilter.getDescription());
        xsdWorkspaceFilter.setInformation(workspaceFilter.getInformation());
        xsdWorkspaceFilter.setNumberOfExcludedElements(Integer.valueOf(workspaceFilter.getExcludedFile().size()));
        for (WildcardPattern wildcardPattern : workspaceFilter.getChildren(WildcardPatternInclude.class)) {
            xsdInclude = this.createXsdWildcardPattern(wildcardPattern);
            xsdWorkspaceFilter.getInclude().add(xsdInclude);
        }
        for (WildcardPattern wildcardPattern : workspaceFilter.getChildren(WildcardPatternExclude.class)) {
            xsdExclude = this.createXsdWildcardPattern(wildcardPattern);
            xsdWorkspaceFilter.getExclude().add(xsdExclude);
        }
        XsdFilter xsdProductionCodeFilter = this.m_objectFactory.createXsdFilter();
        ++this.m_createdXsdElements;
        xsdWorkspace.setProductionCodeFilter(xsdProductionCodeFilter);
        ProductionCodeFilter productionCodeFilter = this.m_report.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getProductionCodeFilter();
        xsdProductionCodeFilter.setDescription(productionCodeFilter.getDescription());
        xsdProductionCodeFilter.setInformation(productionCodeFilter.getInformation());
        xsdProductionCodeFilter.setNumberOfIncludedElements(Integer.valueOf(productionCodeFilter.getNumberOfIncludedComponents()));
        xsdProductionCodeFilter.setNumberOfExcludedElements(Integer.valueOf(productionCodeFilter.getNumberOfExcludedComponents()));
        for (WildcardPattern wildcardPattern : productionCodeFilter.getChildren(WildcardPatternInclude.class)) {
            xsdInclude = this.createXsdWildcardPattern(wildcardPattern);
            xsdProductionCodeFilter.getInclude().add(xsdInclude);
        }
        for (WildcardPattern wildcardPattern : productionCodeFilter.getChildren(WildcardPatternExclude.class)) {
            xsdExclude = this.createXsdWildcardPattern(wildcardPattern);
            xsdProductionCodeFilter.getExclude().add(xsdExclude);
        }
        XsdFilter xsdIssueFilter = this.m_objectFactory.createXsdFilter();
        ++this.m_createdXsdElements;
        xsdWorkspace.setIssueFilter(xsdIssueFilter);
        IssueFilter issueFilter = this.m_report.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getIssueFilter();
        xsdIssueFilter.setDescription(issueFilter.getDescription());
        xsdIssueFilter.setInformation(issueFilter.getInformation());
        xsdIssueFilter.setNumberOfIncludedElements(Integer.valueOf(issueFilter.getNumberOfIncludedComponents()));
        xsdIssueFilter.setNumberOfExcludedElements(Integer.valueOf(issueFilter.getNumberOfExcludedComponents()));
        for (WildcardPattern wildcardPattern : issueFilter.getChildren(WildcardPatternInclude.class)) {
            xsdInclude = this.createXsdWildcardPattern(wildcardPattern);
            xsdIssueFilter.getInclude().add(xsdInclude);
        }
        for (WildcardPattern wildcardPattern : issueFilter.getChildren(WildcardPatternExclude.class)) {
            xsdExclude = this.createXsdWildcardPattern(wildcardPattern);
            xsdIssueFilter.getExclude().add(xsdExclude);
        }
    }

    private XsdWildcardPattern createXsdWildcardPattern(WildcardPattern wildcardPattern) {
        XsdWildcardPattern xsdPattern = this.m_objectFactory.createXsdWildcardPattern();
        ++this.m_createdXsdElements;
        this.addStandardNamedElementAttributes(wildcardPattern, (XsdNamedElement)xsdPattern, true);
        xsdPattern.setNumberOfMatches(Integer.valueOf(wildcardPattern.getNumberOfMatchedElements()));
        return xsdPattern;
    }

    private void addResolutionsToXml(IWorkerContext context, XsdSoftwareSystemReport xsdReport) {
        XsdResolutions xsdResolutions = this.m_objectFactory.createXsdResolutions();
        ++this.m_createdXsdElements;
        xsdResolutions.setNumberOfResolutions(this.m_report.getNumberOfResolutions());
        xsdReport.setResolutions(xsdResolutions);
        List ignores = this.m_report.getResolutions().stream().filter(r2 -> r2 instanceof IgnoreDefinition).collect(Collectors.toList());
        for (Resolution ignore : ignores) {
            if (context.hasBeenCanceled()) {
                return;
            }
            XsdIgnore xsdResolution = this.m_objectFactory.createXsdIgnore();
            ++this.m_createdXsdElements;
            this.addResolutionStandardProperties((XsdResolution)xsdResolution, context, ignore);
            xsdResolutions.getResolution().add(xsdResolution);
        }
        List tasks = this.m_report.getResolutions().stream().filter(r2 -> r2 instanceof ToDoDefinition || r2 instanceof FixDefinition).map(r2 -> (TaskDefinition)r2).collect(Collectors.toList());
        for (TaskDefinition task : tasks) {
            if (context.hasBeenCanceled()) {
                return;
            }
            XsdToDo xsdResolution = task instanceof ToDoDefinition ? this.m_objectFactory.createXsdToDo() : this.m_objectFactory.createXsdFixMe();
            ++this.m_createdXsdElements;
            this.addResolutionStandardProperties((XsdResolution)xsdResolution, context, task);
            xsdResolutions.getResolution().add(xsdResolution);
        }
        List refactorings = this.m_report.getResolutions().stream().filter(r2 -> r2 instanceof RefactoringDefinition).map(r2 -> (RefactoringDefinition)r2).collect(Collectors.toList());
        for (RefactoringDefinition refactoring : refactorings) {
            XsdDeleteRefactoring xsdRefactoring;
            if (context.hasBeenCanceled()) {
                return;
            }
            if (refactoring instanceof DeleteRefactoringDefinition) {
                xsdRefactoring = this.m_objectFactory.createXsdDeleteRefactoring();
            } else if (refactoring instanceof RenameRefactoringDefinition) {
                xsdRefactoring = this.m_objectFactory.createXsdRenameRefactoring();
            } else if (refactoring instanceof MoveRenameRefactoringDefinition) {
                xsdRefactoring = this.m_objectFactory.createXsdMoveRenameRefactoring();
            } else if (refactoring instanceof MoveRefactoringDefinition) {
                xsdRefactoring = this.m_objectFactory.createXsdMoveRefactoring();
            } else {
                assert (false) : "Unsupported refactoring: " + refactoring;
                xsdRefactoring = null;
            }
            ++this.m_createdXsdElements;
            this.addResolutionStandardProperties((XsdResolution)xsdRefactoring, context, refactoring);
            xsdRefactoring.setStatus(refactoring.getStatus().getStandardName());
            xsdRefactoring.setNumberOfPotentiallyDoneElements(refactoring.getNumberOfPotentiallyDoneElements());
            if (refactoring instanceof DeleteRefactoringDefinition) {
                int affectedParserDependencies = ((DeleteRefactoringDefinition)refactoring).getNumberOfAffectedParserDependencies();
                if (affectedParserDependencies != -1) {
                    xsdRefactoring.setAffectedParserDependencyCount(affectedParserDependencies);
                }
            } else if (refactoring instanceof RenameRefactoringDefinition) {
                XsdRenameRefactoring xsdRenameRefactoring = (XsdRenameRefactoring)xsdRefactoring;
                RenameRefactoringDefinition renameRefactoring = (RenameRefactoringDefinition)refactoring;
                xsdRenameRefactoring.setNewName(renameRefactoring.getNewName());
                xsdRenameRefactoring.setElementKind(renameRefactoring.getRefactoringElementType().getStandardName());
            } else if (refactoring instanceof MoveRefactoringDefinition) {
                MoveRefactoringDefinition move = (MoveRefactoringDefinition)refactoring;
                XsdMoveRefactoring xsdMove = (XsdMoveRefactoring)xsdRefactoring;
                xsdMove.setTargetRootDirectoryFqName(move.getTargetRootDirectoryFqName());
                xsdMove.setMoveToParentName(move.getMoveToParentName());
                xsdMove.setElementKind(move.getRefactoringElementType().getStandardName());
            }
            if (refactoring instanceof MoveRenameRefactoringDefinition) {
                MoveRenameRefactoringDefinition moveRename = (MoveRenameRefactoringDefinition)refactoring;
                XsdMoveRenameRefactoring xsdMoveRename = (XsdMoveRenameRefactoring)xsdRefactoring;
                xsdMoveRename.setNewName(moveRename.getNewName());
            }
            xsdResolutions.getResolution().add(xsdRefactoring);
        }
    }

    private void addResolutionStandardProperties(XsdResolution xsdResolution, IWorkerContext context, Resolution resolution) {
        XsdElementPattern xsdPattern;
        assert (context != null) : "Parameter 'context' of method 'addResolutionStandardProperties' must not be null";
        assert (xsdResolution != null) : "Parameter 'xsdResolution' of method 'addResolutionStandardProperties' must not be null";
        assert (resolution != null) : "Parameter 'resolution' of method 'addResolutionStandardProperties' must not be null";
        xsdResolution.setFqName(resolution.getFullyQualifiedName());
        xsdResolution.setType(resolution.getPresentationKind());
        xsdResolution.setPrio(resolution.getPriority().getPresentationName());
        xsdResolution.setInformation(resolution.getInformation());
        for (IIssue issueAccessor : resolution.getAssociatedIssues()) {
            assert (issueAccessor instanceof Issue) : "Unexpected class '" + issueAccessor.getClass().getName() + "'";
            Issue issue = (Issue)issueAccessor;
            if (!issue.isValid()) {
                LOGGER.error("Ignoring invalid associated issue '{}' for resolution '{}'", (Object)issue, (Object)resolution);
                continue;
            }
            XsdIssue mappedXsdIssue = this.m_issueToXsdIssue.get(issue);
            assert (mappedXsdIssue != null) : "No issue found for resolution '" + resolution.getDebugInfo() + "'";
            xsdResolution.getIssueIds().add(mappedXsdIssue);
        }
        xsdResolution.setDescription(resolution.getDescription());
        xsdResolution.setAssignee(resolution.getAssignee());
        xsdResolution.setDate(XmlUtility.createDateTimeObject((long)resolution.getDate().getTime()));
        if (LOGGER.isDebugEnabled()) {
            xsdResolution.setDebugInfo(xsdResolution.getDebugInfo());
        }
        xsdResolution.setTask(Boolean.valueOf(resolution instanceof TaskDefinition));
        xsdResolution.setApplicable(Boolean.valueOf(resolution.getMatchingElementsCount() > 0));
        xsdResolution.setMatchingElementsCount(Integer.valueOf(resolution.getMatchingElementsCount()));
        xsdResolution.setRefactoring(Boolean.valueOf(resolution instanceof RefactoringDefinition));
        Matching matchingInfo = resolution.getUniqueChild(Matching.class);
        if (matchingInfo != null) {
            XsdMatching xsdMatching = this.m_objectFactory.createXsdMatching();
            ++this.m_createdXsdElements;
            xsdMatching.setInfo(matchingInfo.getInformation());
            for (Pair pair : matchingInfo.getElementFqNamesAndHashs()) {
                XsdElementPattern xsdElementPattern = this.m_objectFactory.createXsdElementPattern();
                xsdElementPattern.setType(XsdElementPatternType.FULLY_QUALIFIED_NAME);
                xsdElementPattern.setValue((String)pair.getFirst());
                if (pair.getSecond() != null) {
                    xsdElementPattern.setHash(IntBasedHash.encode((IntBasedHash)((IntBasedHash)pair.getSecond())));
                }
                xsdMatching.getElementPattern().add(xsdElementPattern);
            }
            xsdResolution.setMatching(xsdMatching);
        }
        for (NamedElementWildcardPattern namedElementWildcardPattern : resolution.getChildren(NamedElementWildcardPattern.class)) {
            xsdPattern = this.m_objectFactory.createXsdElementPattern();
            xsdPattern.setType(XsdElementPatternType.WILDCARD);
            xsdPattern.setValue(namedElementWildcardPattern.getPattern());
            xsdResolution.getElementPattern().add(xsdPattern);
        }
        for (NamedElementFullyQualifiedNamePattern namedElementFullyQualifiedNamePattern : resolution.getChildren(NamedElementFullyQualifiedNamePattern.class)) {
            xsdPattern = this.m_objectFactory.createXsdElementPattern();
            xsdPattern.setType(XsdElementPatternType.FULLY_QUALIFIED_NAME);
            xsdPattern.setValue(namedElementFullyQualifiedNamePattern.getPattern());
            xsdResolution.getElementPattern().add(xsdPattern);
        }
        for (DependencyWildcardPattern dependencyWildcardPattern : resolution.getChildren(DependencyWildcardPattern.class)) {
            xsdPattern = this.m_objectFactory.createXsdDependencyPattern();
            xsdPattern.setType(XsdDependencyPatternType.WILDCARD);
            xsdPattern.setFrom(dependencyWildcardPattern.getFromPattern());
            xsdPattern.setTo(dependencyWildcardPattern.getToPattern());
            xsdResolution.getDependencyPattern().add(xsdPattern);
        }
        for (ParserDependencyEndpointPattern parserDependencyEndpointPattern : resolution.getChildren(ParserDependencyEndpointPattern.class)) {
            xsdPattern = this.m_objectFactory.createXsdDependencyPattern();
            xsdPattern.setType(XsdDependencyPatternType.PARSER_DEPENDENCY_ENDPOINT);
            xsdPattern.setFrom(parserDependencyEndpointPattern.getFromPattern());
            xsdPattern.setTo(parserDependencyEndpointPattern.getToPattern());
            xsdResolution.getDependencyPattern().add(xsdPattern);
        }
        IssueType issueType = resolution.getUniqueExistingChild(IssueType.class);
        xsdResolution.setDescriptor(ReportXmlWriter.createIssueDescriptor(issueType));
    }

    public static String createIssueDescriptor(IssueType issueType) {
        String descriptor;
        assert (issueType != null) : "Parameter 'issueType' of method 'createDescriptor' must not be null";
        if (issueType instanceof DynamicIssueType) {
            DynamicIssueType dynamicIssueType = (DynamicIssueType)issueType;
            if (issueType.getIssueId().getClass().equals(ScriptIssueId.class)) {
                descriptor = String.valueOf(dynamicIssueType.getIssueProviderIdStandardName()) + Element.DESCRIPTOR_NAME_PARTS_SEPARATOR + issueType.getIssueId().getSupportedSeverities().get(0).getStandardName();
            } else if (issueType.getIssueId().getClass().equals(PluginIssueId.class)) {
                PluginIssueId pluginIssueId = (PluginIssueId)issueType.getIssueId();
                descriptor = String.valueOf(pluginIssueId.getProvider().getStandardName()) + Element.DESCRIPTOR_NAME_PARTS_SEPARATOR + pluginIssueId.getStandardName();
            } else if (issueType.getIssueId().getClass().equals(ArchitectureViolationIssueId.class)) {
                descriptor = dynamicIssueType.getKey();
            } else if (issueType.getIssueId().getClass().equals(ArchitectureDeprecationIssueId.class)) {
                descriptor = dynamicIssueType.getKey();
            } else {
                assert (false) : "Unhandled dynamic issue issueType: " + dynamicIssueType;
                descriptor = "";
            }
        } else {
            descriptor = !issueType.getKey().equals(issueType.getIssueId().getStandardName()) ? issueType.getKey() : "";
        }
        return descriptor;
    }

    public static String createDeprecatedIssueDescriptor(IssueType issueType) {
        String descriptor;
        assert (issueType != null) : "Parameter 'issueType' of method 'createDeprecatedIssueDescriptor' must not be null";
        if (issueType instanceof DynamicIssueType) {
            DynamicIssueType dynamicIssueType = (DynamicIssueType)issueType;
            if (issueType.getIssueId().getClass().equals(ScriptIssueId.class)) {
                descriptor = String.valueOf(dynamicIssueType.getIssueProviderIdStandardName()) + Element.DESCRIPTOR_NAME_PARTS_SEPARATOR + issueType.getIssueId().getSupportedSeverities().get(0).getStandardName();
            } else if (issueType.getIssueId().getClass().equals(PluginIssueId.class)) {
                PluginIssueId pluginIssueId = (PluginIssueId)issueType.getIssueId();
                descriptor = String.valueOf(pluginIssueId.getProvider().getStandardName()) + Element.DESCRIPTOR_NAME_PARTS_SEPARATOR + pluginIssueId.getStandardName() + Element.DESCRIPTOR_NAME_PARTS_SEPARATOR + pluginIssueId.getSupportedSeverities().get(0).getStandardName();
            } else if (issueType.getIssueId().getClass().equals(ArchitectureViolationIssueId.class)) {
                descriptor = dynamicIssueType.getIssueProviderIdStandardName();
            } else {
                assert (false) : "Unhandled dynamic issue issueType: " + dynamicIssueType;
                descriptor = "";
            }
        } else {
            descriptor = !issueType.getKey().equals(issueType.getIssueId().getStandardName()) ? issueType.getKey() : "";
        }
        return descriptor;
    }

    private void addAnalyzersToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addAnalyzersToXml' must not be null";
        xsdReport.setAnalyzers(this.m_objectFactory.createXsdAnalyzers());
        ++this.m_createdXsdElements;
        this.m_report.getLicensedAnalyzers().stream().forEach(id -> this.addAnalyzerToMap((IAnalyzerId)id, true));
        this.m_report.getUnlicensedAnalyzers().stream().forEach(id -> this.addAnalyzerToMap((IAnalyzerId)id, false));
        List xsdAnalyzerNode = xsdReport.getAnalyzers().getAnalyzer();
        this.m_analyzerMap.values().forEach(analyzer -> {
            boolean bl2 = xsdAnalyzerNode.add((XsdAnalyzer)analyzer);
        });
    }

    private void addAnalyzerToMap(IAnalyzerId analyzerId, boolean isLicensed) {
        XsdAnalyzer xsdAnalyzer = this.m_objectFactory.createXsdAnalyzer();
        ++this.m_createdXsdElements;
        xsdAnalyzer.setId(this.m_idGenerator.getNextId());
        xsdAnalyzer.setName(analyzerId.getStandardName());
        xsdAnalyzer.setPresentationName(analyzerId.getPresentationName());
        xsdAnalyzer.setDescription(analyzerId.getDescription());
        xsdAnalyzer.setLicensed(Boolean.valueOf(isLicensed));
        xsdAnalyzer.setExecutionLevel(this.determineExecutionLevel(analyzerId.getExecutionLevel()));
        Set<Language> usedLanguages = this.m_report.getSoftwareSystem().getUsedLanguages();
        boolean matchesUsedLanguages = analyzerId.getLanguage() == null || usedLanguages.contains(analyzerId.getLanguage());
        boolean matchesExecutionLevel = analyzerId.getExecutionLevel().matchesOrIsLowerThan(this.m_report.getAnalyzerExecutionLevel());
        xsdAnalyzer.setExecuted(Boolean.valueOf(matchesUsedLanguages && matchesExecutionLevel));
        this.m_analyzerMap.put(analyzerId, xsdAnalyzer);
    }

    private void addCheckedArchitecturesToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addArchitectureToXml' must not be null";
        for (StrictPair<ArchitectureFile, String> next : this.m_report.getCheckedArchitectureFiles()) {
            ArchitectureFile file = (ArchitectureFile)next.getFirst();
            String hash = (String)next.getSecond();
            XsdSystemFile xsdFile = this.m_objectFactory.createXsdSystemFile();
            ++this.m_createdXsdElements;
            xsdFile.setPath(file.getIdentifyingPath());
            xsdFile.setType(file.getFileType().getStandardName());
            xsdFile.setLastModified(XmlUtility.createDateTimeObject((long)file.getTimestamp()));
            xsdFile.setHash(hash);
            xsdReport.getSystemFile().add(xsdFile);
        }
    }

    private void addPluginsToXml(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addPluginsToxml' must not be null";
        xsdReport.setPlugins(this.m_objectFactory.createXsdPlugins());
        ++this.m_createdXsdElements;
        boolean isLicensed = this.m_report.getAvailableFeatures().contains((Object)SonargraphFeature.PLUGINS);
        for (Pair<SonargraphPlugin, IAnalyzerId> next : this.m_report.getAnalyzerPlugins()) {
            SonargraphPlugin plugin2 = (SonargraphPlugin)next.getFirst();
            boolean isExecuted = next.getSecond() == null ? false : ((IAnalyzerId)next.getSecond()).getExecutionLevel().matchesOrIsLowerThan(this.m_report.getAnalyzerExecutionLevel()) && isLicensed;
            this.addPluginToXml(xsdReport, plugin2, isLicensed, isExecuted);
            if (next.getSecond() == null) continue;
            this.addAnalyzerToMap((IAnalyzerId)next.getSecond(), isLicensed);
        }
        this.m_report.getModelPlugins().forEach(plugin -> this.addPluginToXml(xsdReport, (SonargraphPlugin)plugin, isLicensed, plugin.isEnabled()));
    }

    private void addPluginToXml(XsdSoftwareSystemReport xsdReport, SonargraphPlugin plugin, boolean licensed, boolean enabled) {
        XsdPlugin xsdPlugin = this.m_objectFactory.createXsdPlugin();
        ++this.m_createdXsdElements;
        xsdPlugin.setId(this.m_idGenerator.getNextId());
        xsdPlugin.setName(plugin.getId());
        xsdPlugin.setPresentationName(plugin.getPresentationName());
        xsdPlugin.setDescription(plugin.getDescription());
        xsdPlugin.setVendor(plugin.getVendor());
        xsdPlugin.setVersion(plugin.getVersion());
        xsdPlugin.setEnabled(Boolean.valueOf(plugin.isEnabled()));
        xsdPlugin.setLicensed(Boolean.valueOf(licensed));
        IPluginAnalyzerContributor analyzerContributor = plugin.getAnalyzerContributor();
        IPluginModelContributor modelContributor = plugin.getModelContributor();
        if (analyzerContributor != null) {
            xsdPlugin.getSupportedExecutionPhase().add(XsdExecutionPhase.ANALYZER);
        }
        if (modelContributor != null) {
            xsdPlugin.getSupportedExecutionPhase().add(XsdExecutionPhase.MODEL);
        }
        if (enabled) {
            if (analyzerContributor != null) {
                xsdPlugin.getActiveExecutionPhase().add(XsdExecutionPhase.ANALYZER);
            }
            if (modelContributor != null) {
                xsdPlugin.getActiveExecutionPhase().add(XsdExecutionPhase.MODEL);
            }
        }
        this.m_pluginToXsdPlugin.put(plugin, xsdPlugin);
        xsdReport.getPlugins().getPlugin().add(xsdPlugin);
    }

    private void addMetricThresholds(XsdSoftwareSystemReport xsdReport) {
        assert (xsdReport != null) : "Parameter 'xsdReport' of method 'addMetricThresholds' must not be null";
        List<IMetricThreshold> thresholds = this.m_report.getThresholds();
        if (thresholds.isEmpty()) {
            return;
        }
        XsdMetricThresholds xsdThresholds = this.m_objectFactory.createXsdMetricThresholds();
        ++this.m_createdXsdElements;
        xsdReport.setMetricThresholds(xsdThresholds);
        for (IMetricThreshold next : thresholds) {
            XsdMetricThreshold xsdThreshold = this.m_objectFactory.createXsdMetricThreshold();
            ++this.m_createdXsdElements;
            xsdThreshold.setId(this.m_idGenerator.getNextId());
            IMetricDescriptor metricDescriptor = next.getMetricDescriptor();
            XsdMetricId nextMetricId = this.m_nameToMetricId.get(metricDescriptor.getMetricId().getStandardName());
            assert (nextMetricId != null) : "'nextMetricId' of method 'addMetricThresholds' must not be null for: " + metricDescriptor.getMetricId().getStandardName();
            xsdThreshold.setMetricId((Object)nextMetricId);
            XsdMetricLevel nextMetricLevel = this.m_nameToMetricLevel.get(metricDescriptor.getLevel().getStandardName());
            assert (nextMetricLevel != null) : "'nextMetricLevel' of method 'addMetricThresholds' must not be null for: " + metricDescriptor.getLevel().getStandardName();
            xsdThreshold.setMetricLevel((Object)nextMetricLevel);
            xsdThreshold.setSeverity(next.getSeverity().getStandardName());
            double nextLowerThreshold = next.getLowerThreshold().doubleValue();
            xsdThreshold.setLowerThreshold(new BigDecimal(nextLowerThreshold));
            double nextUpperThreshold = next.getUpperThreshold().doubleValue();
            xsdThreshold.setUpperThreshold(new BigDecimal(nextUpperThreshold));
            xsdThresholds.getThreshold().add(xsdThreshold);
            if (LOGGER.isDebugEnabled()) {
                xsdThreshold.setDebugInfo(next.getInformation());
            }
            this.m_metricThresholdToXsdMetricThreshold.put(next, xsdThreshold);
        }
    }

    private void addMetricValuesToXml(IWorkerContext context, XsdSoftwareSystemReport xsdReport, Map<String, XsdMetricId> metricMap) {
        XsdSystemMetricValues xsdSystemMetricValues = this.m_objectFactory.createXsdSystemMetricValues();
        ++this.m_createdXsdElements;
        xsdSystemMetricValues.setElementRef((Object)xsdReport);
        xsdReport.setSystemMetricValues(xsdSystemMetricValues);
        HashMap<IMetricDescriptor, IMetricValue> systemLevelMetrics = new HashMap<IMetricDescriptor, IMetricValue>();
        for (Map.Entry<IMetricCategory, Map<IMetricDescriptor, IMetricValue>> entry : this.m_report.getSystemLevelMetrics().entrySet()) {
            systemLevelMetrics.putAll(entry.getValue());
        }
        this.addSystemLevelMetrics(context, xsdSystemMetricValues, metricMap, CoreMetricLevel.SYSTEM, systemLevelMetrics);
        this.addLevelMetricsToXml(context, metricMap, (XsdMetricLevelContainer)xsdSystemMetricValues, this.m_report.getSystemElementMetrics());
        for (Map.Entry<Object, Map<Object, Object>> entry : this.m_report.getModuleMetrics().entrySet()) {
            if (context.hasBeenCanceled()) {
                return;
            }
            context.working("Adding metric values for module", false);
            Module module = (Module)entry.getKey();
            XsdModuleMetricValues xsdModule = this.m_objectFactory.createXsdModuleMetricValues();
            ++this.m_createdXsdElements;
            xsdModule.setElementRef((Object)this.m_namedElementToXsdNamedElement.get(module));
            xsdReport.getModuleMetricValues().add(xsdModule);
            Map<Object, Object> moduleLevelMetrics = entry.getValue();
            this.addLevelMetricsToXml(context, metricMap, (XsdMetricLevelContainer)xsdModule, moduleLevelMetrics);
        }
    }

    private XsdProgrammingElement getOrCreateXsdProgrammingElement(ProgrammingElement programmingElement) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'getOrCreateXsdNamedElement' must not be null";
        XsdElement xsdElement = (XsdElement)this.m_namedElementToXsdNamedElement.get(programmingElement);
        if (xsdElement != null) {
            assert (xsdElement instanceof XsdProgrammingElement) : "Not an XsdProgrammingElement " + xsdElement.getClass().getName();
            return (XsdProgrammingElement)xsdElement;
        }
        XsdProgrammingElement xsdProgrammingElement = this.m_objectFactory.createXsdProgrammingElement();
        ++this.m_createdXsdElements;
        this.addStandardNamedElementAttributes(programmingElement, (XsdNamedElement)xsdProgrammingElement, false);
        this.m_namedElementToXsdNamedElement.put(programmingElement, (XsdNamedElement)xsdProgrammingElement);
        RootDirectoryPath rootDirectoryPath = programmingElement.getParent(RootDirectoryPath.class, new Class[0]);
        if (rootDirectoryPath != null) {
            Pair<FilePath, PhysicalInfo> sourceFileInfo;
            XsdRootDirectory xsdRootDirectory = this.m_fqNameToXsdRootDirectory.get(rootDirectoryPath.getFullyQualifiedName());
            assert (xsdRootDirectory != null) : "Parameter 'xsdRootDirectory' of method 'getOrCreateXsdProgrammingElement' must not be null";
            int line = programmingElement.getLineNumber();
            if (line != -1) {
                xsdProgrammingElement.setLine(Integer.valueOf(line));
            }
            if ((sourceFileInfo = this.getSourceFileInfo(programmingElement)) != null) {
                this.connectSourceFile(programmingElement, (XsdNamedElement)xsdProgrammingElement, (FilePath)sourceFileInfo.getFirst(), (PhysicalInfo)sourceFileInfo.getSecond());
            }
            xsdRootDirectory.getProgrammingElement().add(xsdProgrammingElement);
        } else {
            External external = programmingElement.getParent(External.class, new Class[0]);
            XsdNamedElement xsdNamedElement = this.m_namedElementToXsdNamedElement.get(external);
            assert (xsdNamedElement != null) : "xsdNamedElement must not be null for External '" + external + "'";
            if (xsdNamedElement instanceof XsdExternal) {
                XsdExternal xsdExternal = (XsdExternal)xsdNamedElement;
                xsdExternal.getProgrammingElement().add(xsdProgrammingElement);
            } else if (xsdNamedElement instanceof XsdPluginExternal) {
                XsdPluginExternal xsdPluginExternal = (XsdPluginExternal)xsdNamedElement;
                xsdPluginExternal.getProgrammingElement().add(xsdProgrammingElement);
            }
        }
        return xsdProgrammingElement;
    }

    private void addElements(IWorkerContext workerContext, Set<NamedElement> elementSet, XsdElements xsdElements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'addElements' must not be null";
        assert (elementSet != null) : "Parameter 'elementSet' of method 'addElements' must not be null";
        assert (xsdElements != null) : "Parameter 'xsdElements' of method 'addElements' must not be null";
        List sorted = elementSet.stream().sorted(Comparator.comparing(NamedElement::getFullyQualifiedName)).collect(Collectors.toList());
        for (NamedElement nextElement : sorted) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.working("Adding element", false);
            this.addElement(xsdElements, nextElement);
        }
    }

    private boolean physicallyAffectedByRefactoring(NamedElement element) {
        String originalFqName;
        assert (element != null) : "Parameter 'element' of method 'physicallyAffectedByRefactoring' must not be null";
        String fqName = element.getFullyQualifiedName();
        return !fqName.equals(originalFqName = element.getOriginalFullyQualifiedName());
    }

    private XsdLogicalNamespace getOrCreateXsdLogicalNamespace(XsdElements xsdElements, LogicalNamespace logicalNamespace) {
        assert (xsdElements != null) : "Parameter 'xsdElements' of method 'getOrCreateXsdLogicalNamespace' must not be null";
        assert (logicalNamespace != null) : "Parameter 'logicalNamespace' of method 'getOrCreateXsdLogicalNamespace' must not be null";
        XsdLogicalNamespace xsdNamedElement = this.m_objectFactory.createXsdLogicalNamespace();
        ++this.m_createdXsdElements;
        this.addStandardNamedElementAttributes(logicalNamespace, (XsdNamedElement)xsdNamedElement, false);
        for (LogicalNamespace.ISourceNamespace nextSourceNamespace : logicalNamespace.getRepresentativeSourceNamespaces()) {
            NamedElement nextSourceNamespaceAsNamedElement = nextSourceNamespace.getNamedElement();
            if (!(nextSourceNamespaceAsNamedElement instanceof PhysicalRecursiveElement)) continue;
            XsdPhysicalRecursiveElement nextXsdPhysicalRecursiveElement = this.getOrCreateXsdPhysicalRecursiveElement((PhysicalRecursiveElement)nextSourceNamespaceAsNamedElement);
            xsdNamedElement.getDerivedFrom().add(nextXsdPhysicalRecursiveElement);
        }
        this.m_namedElementToXsdNamedElement.put(logicalNamespace, (XsdNamedElement)xsdNamedElement);
        xsdElements.getLogicalNamespace().add(xsdNamedElement);
        return xsdNamedElement;
    }

    private XsdLogicalProgrammingElement getOrCreateXsdLogicalProgrammingElement(XsdElements xsdElements, LogicalProgrammingElement logicalProgrammingElement) {
        assert (xsdElements != null) : "Parameter 'xsdElements' of method 'getOrCreateXsdLogicalProgrammingElement' must not be null";
        assert (logicalProgrammingElement != null) : "Parameter 'logicalProgrammingElement' of method 'getOrCreateXsdLogicalProgrammingElement' must not be null";
        XsdLogicalProgrammingElement xsdNamedElement = this.m_objectFactory.createXsdLogicalProgrammingElement();
        ++this.m_createdXsdElements;
        this.addStandardNamedElementAttributes(logicalProgrammingElement, (XsdNamedElement)xsdNamedElement, false);
        for (ProgrammingElement programmingElement : logicalProgrammingElement.getLogicalGroup()) {
            xsdNamedElement.getDerivedFrom().add(this.getOrCreateXsdProgrammingElement(programmingElement));
        }
        this.m_namedElementToXsdNamedElement.put(logicalProgrammingElement, (XsdNamedElement)xsdNamedElement);
        xsdElements.getLogicalProgrammingElement().add(xsdNamedElement);
        return xsdNamedElement;
    }

    private Pair<FilePath, PhysicalInfo> getSourceFileInfo(NamedElement element) {
        ILanguageProvider languageProvider;
        FilePath sourceFile;
        assert (element != null) : "Parameter 'element' of method 'getSourceFileInfo' must not be null";
        Language language = element.getLanguage();
        if (language != null && (sourceFile = (languageProvider = this.m_languageToLanguageProvider.get(language)).getSourceFile(element)) != null) {
            PhysicalInfo physicalInfo = null;
            if (this.physicallyAffectedByRefactoring(element)) {
                physicalInfo = languageProvider.getPhysicalInfo(element);
            }
            return new Pair((Object)sourceFile, (Object)physicalInfo);
        }
        return null;
    }

    private void connectSourceFile(NamedElement element, XsdNamedElement xsdNamedElement, FilePath sourceFile, PhysicalInfo physicalInfo) {
        assert (element != null) : "Parameter 'element' of method 'connectSourceFile' must not be null";
        assert (xsdNamedElement != null) : "Parameter 'xsdNamedElement' of method 'connectSourceFile' must not be null";
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'connectSourceFile' must not be null";
        XsdSourceFile xsdOriginalSource = physicalInfo != null ? this.getOrCreateOriginalXsdSourceFile(sourceFile, physicalInfo) : null;
        RootDirectoryPath root = sourceFile.getParent(RootDirectoryPath.class, new Class[0]);
        assert (root != null) : "'root' of method 'connectSourceFile' must not be null";
        XsdSourceFile xsdSource = this.getOrCreateXsdSourceFile(root, sourceFile);
        if (xsdOriginalSource != null) {
            xsdSource.setOriginalLocation((Object)xsdOriginalSource);
        }
        xsdNamedElement.setSource((Object)xsdSource);
        String originalFqName = element.getOriginalFullyQualifiedName();
        if (!element.getFullyQualifiedName().equals(originalFqName)) {
            xsdNamedElement.setOriginalFqName(originalFqName);
        }
    }

    private XsdNamedElement addElement(XsdElements xsdElements, NamedElement element) {
        assert (xsdElements != null) : "Parameter 'xsdElements' of method 'addElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addElement' must not be null";
        XsdElement xsdElement = (XsdElement)this.m_namedElementToXsdNamedElement.get(element);
        if (xsdElement != null) {
            assert (xsdElement instanceof XsdNamedElement) : "Not an XsdNamedElement " + xsdElement.getClass().getName();
            return (XsdNamedElement)xsdElement;
        }
        if (element instanceof PhysicalRecursiveElement) {
            return this.getOrCreateXsdPhysicalRecursiveElement((PhysicalRecursiveElement)element);
        }
        if (element instanceof ProgrammingElement) {
            return this.getOrCreateXsdProgrammingElement((ProgrammingElement)element);
        }
        if (element instanceof LogicalNamespace) {
            return this.getOrCreateXsdLogicalNamespace(xsdElements, (LogicalNamespace)element);
        }
        if (element instanceof LogicalProgrammingElement) {
            return this.getOrCreateXsdLogicalProgrammingElement(xsdElements, (LogicalProgrammingElement)element);
        }
        Pair<FilePath, PhysicalInfo> info = this.getSourceFileInfo(element);
        if (info != null) {
            FilePath sourceFile = (FilePath)info.getFirst();
            assert (sourceFile != null) : "'sourceFile' of method 'addElement' must not be null";
            if (element == sourceFile || element.getFullyQualifiedName().equals(sourceFile.getFullyQualifiedName())) {
                PhysicalInfo physicalInfo = (PhysicalInfo)info.getSecond();
                XsdSourceFile xsdOriginalSourceFile = physicalInfo != null ? this.getOrCreateOriginalXsdSourceFile(sourceFile, physicalInfo) : null;
                RootDirectoryPath root = sourceFile.getParent(RootDirectoryPath.class, new Class[0]);
                assert (root != null) : "Parameter 'root' of method 'addElement' must not be null";
                XsdSourceFile xsdSource = this.getOrCreateXsdSourceFile(root, sourceFile);
                if (xsdOriginalSourceFile != null) {
                    xsdSource.setOriginalLocation((Object)xsdOriginalSourceFile);
                }
                return xsdSource;
            }
        }
        XsdNamedElement xsdNamedElement = this.m_objectFactory.createXsdNamedElement();
        ++this.m_createdXsdElements;
        this.addStandardNamedElementAttributes(element, xsdNamedElement, false);
        if (info != null) {
            this.connectSourceFile(element, xsdNamedElement, (FilePath)info.getFirst(), (PhysicalInfo)info.getSecond());
        }
        this.m_namedElementToXsdNamedElement.put(element, xsdNamedElement);
        xsdElements.getElement().add(xsdNamedElement);
        return xsdNamedElement;
    }

    private XsdSourceFile getOrCreateOriginalXsdSourceFile(FilePath source, PhysicalInfo physicalInfo) {
        assert (source != null) : "Parameter 'source' of method 'getOrCreateOriginalXsdSourceFile' must not be null";
        assert (physicalInfo != null) : "Parameter 'physicalInfo' of method 'getOrCreateOriginalXsdSourceFile' must not be null";
        XsdSourceFile xsdSourceFile = this.m_physicalInfoToXsdSourceFile.get(physicalInfo);
        if (xsdSourceFile == null) {
            XsdNamedElement xsdSourceFile2 = this.m_namedElementToXsdNamedElement.get(source);
            if (xsdSourceFile2 != null) {
                LOGGER.debug("Source file has already been created {} for {}. This might happen for class files.", (Object)source, (Object)physicalInfo);
                return (XsdSourceFile)xsdSourceFile2;
            }
            xsdSourceFile = this.m_objectFactory.createXsdSourceFile();
            ++this.m_createdXsdElements;
            String directoryPathFqName = physicalInfo.getRootDirectoryPath().getFullyQualifiedName();
            XsdRootDirectory xsdRootDirectory = this.m_fqNameToXsdRootDirectory.get(directoryPathFqName);
            assert (xsdRootDirectory != null) : "Parameter 'xsdRootDirectory' of method 'getOrCreateOriginalXsdSourceFile' must not be null";
            xsdSourceFile.setLocationOnly(Boolean.valueOf(true));
            this.addStandardNamedElementAttributes(source, (XsdNamedElement)xsdSourceFile, true);
            xsdRootDirectory.getSourceElement().add(xsdSourceFile);
            this.m_physicalInfoToXsdSourceFile.put(physicalInfo, xsdSourceFile);
        }
        return xsdSourceFile;
    }

    private XsdPhysicalRecursiveElement createOriginalPhysicalRecursiveElement(RootDirectoryPath rootDirectoryPath, PhysicalRecursiveElement forPhysicalRecursiveElement, PhysicalInfo physicalInfo) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'createOriginalPhysicalRecursiveElement' must not be null";
        assert (forPhysicalRecursiveElement != null) : "Parameter 'physicalRecursiveElement' of method 'createOriginalPhysicalRecursiveElement' must not be null";
        assert (physicalInfo != null) : "Parameter 'physicalInfo' of method 'createOriginalPhysicalRecursiveElement' must not be null";
        String directoryPathFqName = rootDirectoryPath.getFullyQualifiedName();
        if (!this.m_namedElementToXsdNamedElement.containsKey(rootDirectoryPath) || !this.m_fqNameToXsdRootDirectory.containsKey(directoryPathFqName)) {
            LOGGER.warn("RootDirectory '" + rootDirectoryPath + "' not added in workspace processing!");
            return null;
        }
        XsdElement xsdElementRoot = (XsdElement)this.m_fqNameToXsdRootDirectory.get(directoryPathFqName);
        assert (xsdElementRoot != null && xsdElementRoot instanceof XsdRootDirectory) : "Unexpected class in method 'getOrCreateSourceFileForElement': " + xsdElementRoot;
        XsdRootDirectory xsdRootDirectory = (XsdRootDirectory)xsdElementRoot;
        XsdPhysicalRecursiveElement xsdPhysicalRecursiveElement = this.m_objectFactory.createXsdPhysicalRecursiveElement();
        ++this.m_createdXsdElements;
        xsdPhysicalRecursiveElement.setRelativeDirectoryPath(physicalInfo.getRelativePath());
        xsdPhysicalRecursiveElement.setLocationOnly(Boolean.valueOf(true));
        this.addStandardNamedElementAttributes(forPhysicalRecursiveElement, (XsdNamedElement)xsdPhysicalRecursiveElement, true);
        xsdRootDirectory.getPhysicalRecursiveElement().add(xsdPhysicalRecursiveElement);
        return xsdPhysicalRecursiveElement;
    }

    private XsdPhysicalRecursiveElement getOrCreateXsdPhysicalRecursiveElement(PhysicalRecursiveElement physicalRecursiveElement) {
        XsdPhysicalRecursiveElement xsdPhysicalRecursiveElement;
        assert (physicalRecursiveElement != null) : "Parameter 'physicalRecursiveElement' of method 'getOrCreateXsdPhysicalRecursiveElement' must not be null";
        XsdNamedElement xsdNamedElement = this.m_namedElementToXsdNamedElement.get(physicalRecursiveElement);
        if (xsdNamedElement != null) {
            assert (xsdNamedElement != null && xsdNamedElement instanceof XsdPhysicalRecursiveElement) : "Unexpected class in method 'getOrCreateXsdPhysicalRecursiveElement': " + xsdNamedElement;
            return (XsdPhysicalRecursiveElement)xsdNamedElement;
        }
        RootDirectoryPath rootDirectoryPath = physicalRecursiveElement.getParent(RootDirectoryPath.class, new Class[0]);
        if (rootDirectoryPath != null) {
            String directoryPathFqName = rootDirectoryPath.getFullyQualifiedName();
            if (!this.m_namedElementToXsdNamedElement.containsKey(rootDirectoryPath) || !this.m_fqNameToXsdRootDirectory.containsKey(directoryPathFqName)) {
                LOGGER.warn("RootDirectory '" + rootDirectoryPath + "' not added in workspace processing!");
                return null;
            }
            XsdElement xsdParent = (XsdElement)this.m_fqNameToXsdRootDirectory.get(directoryPathFqName);
            assert (xsdParent != null && xsdParent instanceof XsdRootDirectory) : "Unexpected class in method 'getOrCreateXsdPhysicalRecursiveElement': " + xsdParent;
            XsdRootDirectory xsdRootDirectory = (XsdRootDirectory)xsdParent;
            xsdPhysicalRecursiveElement = this.m_objectFactory.createXsdPhysicalRecursiveElement();
            ++this.m_createdXsdElements;
            String relDirectoryPath = physicalRecursiveElement.getRelativeDirectoryPath();
            if (relDirectoryPath != null) {
                xsdPhysicalRecursiveElement.setRelativeDirectoryPath(relDirectoryPath);
                if (this.physicallyAffectedByRefactoring(physicalRecursiveElement)) {
                    this.m_physicalRecursiveElementsNeedingOriginals.add(physicalRecursiveElement);
                }
            } else {
                Pair<FilePath, PhysicalInfo> info;
                SourceFile sourceFile = physicalRecursiveElement.getParent(SourceFile.class, new Class[0]);
                if (sourceFile != null && (info = this.getSourceFileInfo(sourceFile)) != null) {
                    this.connectSourceFile(physicalRecursiveElement, (XsdNamedElement)xsdPhysicalRecursiveElement, (FilePath)info.getFirst(), (PhysicalInfo)info.getSecond());
                }
            }
            xsdRootDirectory.getPhysicalRecursiveElement().add(xsdPhysicalRecursiveElement);
        } else {
            xsdPhysicalRecursiveElement = this.m_objectFactory.createXsdPhysicalRecursiveElement();
            ++this.m_createdXsdElements;
            External external = physicalRecursiveElement.getParent(External.class, new Class[0]);
            XsdNamedElement xsdExternal = this.m_namedElementToXsdNamedElement.get(external);
            assert (xsdExternal != null && xsdExternal instanceof XsdExternal) : "Unexpected class in method 'getOrCreateXsdPhysicalRecursiveElement': " + xsdExternal;
            XsdExternal nextXsdExternal = (XsdExternal)xsdExternal;
            nextXsdExternal.getPhysicalRecursiveElement().add(xsdPhysicalRecursiveElement);
        }
        this.addStandardNamedElementAttributes(physicalRecursiveElement, (XsdNamedElement)xsdPhysicalRecursiveElement, false);
        this.m_namedElementToXsdNamedElement.put(physicalRecursiveElement, (XsdNamedElement)xsdPhysicalRecursiveElement);
        return xsdPhysicalRecursiveElement;
    }

    private XsdSourceFile getOrCreateXsdSourceFile(RootDirectoryPath rootDirectoryPath, FilePath sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getOrCreateXsdSourceFile' must not be null";
        XsdNamedElement xsdNamedElement = this.m_namedElementToXsdNamedElement.get(sourceFile);
        if (xsdNamedElement != null) {
            assert (xsdNamedElement instanceof XsdSourceFile) : "Unexpected class in method 'getOrCreateXsdSourceFile': " + xsdNamedElement;
            return (XsdSourceFile)xsdNamedElement;
        }
        String directoryPathFqName = rootDirectoryPath.getFullyQualifiedName();
        XsdRootDirectory xsdRootDirectory = this.m_fqNameToXsdRootDirectory.get(directoryPathFqName);
        XsdSourceFile xsdSourceFile = this.m_objectFactory.createXsdSourceFile();
        ++this.m_createdXsdElements;
        this.addStandardNamedElementAttributes(sourceFile, (XsdNamedElement)xsdSourceFile, false);
        xsdRootDirectory.getSourceElement().add(xsdSourceFile);
        this.m_namedElementToXsdNamedElement.put(sourceFile, (XsdNamedElement)xsdSourceFile);
        return xsdSourceFile;
    }

    private void addStandardNamedElementAttributes(NamedElement element, XsdNamedElement xsdElement, boolean isOriginal) {
        assert (element != null) : "Parameter 'element' of method 'addStandardNamedElementAttributes' must not be null";
        assert (xsdElement != null) : "Parameter 'xsdElement' of method 'addStandardNamedElementAttributes' must not be null";
        xsdElement.setId(this.m_idGenerator.getNextId());
        xsdElement.setName(isOriginal ? element.getOriginal().getFullyQualifiedNamePart() : element.getFullyQualifiedNamePart());
        xsdElement.setFqName(isOriginal ? element.getOriginalFullyQualifiedName() : element.getFullyQualifiedName());
        xsdElement.setPresentationName(isOriginal ? element.getOriginalPresentationName(false) : element.getPresentationName(false));
        xsdElement.setKind((Object)this.getOrCreateElementKind(element));
        if (!isOriginal) {
            String originalFqName = element.getOriginalFullyQualifiedName();
            if (!element.getFullyQualifiedName().equals(originalFqName)) {
                xsdElement.setOriginalFqName(originalFqName);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            xsdElement.setDebugInfo(element.getDebugInfo());
        }
    }

    private XsdElementKind getOrCreateElementKind(NamedElement nextElement) {
        XsdElementKind xsdElementKind;
        if (!this.m_elementStandardNameToXsdElementKind.containsKey(nextElement.getStandardPresentationKind())) {
            xsdElementKind = this.m_objectFactory.createXsdElementKind();
            ++this.m_createdXsdElements;
            xsdElementKind.setId(this.m_idGenerator.getNextId());
            xsdElementKind.setStandardKind(nextElement.getStandardPresentationKind());
            xsdElementKind.setPresentationKind(nextElement.getPresentationKind());
            if (!xsdElementKind.getStandardKind().equals(nextElement.getImageResourceName())) {
                xsdElementKind.setImageResourceName(nextElement.getImageResourceName());
            }
            this.m_elementStandardNameToXsdElementKind.put(nextElement.getStandardPresentationKind(), xsdElementKind);
        } else {
            xsdElementKind = this.m_elementStandardNameToXsdElementKind.get(nextElement.getStandardPresentationKind());
        }
        return xsdElementKind;
    }

    private void addExportDataToXml(XsdExportMetaData xsdExportData) {
        assert (xsdExportData != null) : "Parameter 'xsdExportData' of method 'createMetricMap' must not be null";
        this.createXmlExportMetaData(this.m_idGenerator, this.m_objectFactory, this.m_report.getMetricIdsAsMap(), this.m_report.getIssueCategories(), this.m_report.getIssueProviderIds(), this.m_report.getIssueIds(), xsdExportData);
        for (XsdMetricLevel next : xsdExportData.getMetricLevels().getLevel()) {
            this.m_nameToMetricLevel.put(next.getName(), next);
        }
        for (XsdMetricLevel next : xsdExportData.getMetricIds().getMetricId()) {
            this.m_nameToMetricId.put(next.getName(), (XsdMetricId)next);
        }
        for (XsdMetricLevel next : xsdExportData.getIssueCategories().getCategory()) {
            this.m_nameToIssueCategory.put(next.getName(), (XsdIssueCategory)next);
        }
    }

    private void addSystemLevelMetrics(IWorkerContext context, XsdSystemMetricValues xsdSystem, Map<String, XsdMetricId> metricMap, CoreMetricLevel systemMetricLevel, Map<IMetricDescriptor, IMetricValue> systemLevelMetrics) {
        XsdMetricLevelValues xsdMetricLevelValues = this.m_objectFactory.createXsdMetricLevelValues();
        ++this.m_createdXsdElements;
        XsdMetricLevel xsdSystemMetricLevel = this.m_nameToMetricLevel.get(systemMetricLevel.getStandardName());
        if (xsdSystemMetricLevel != null) {
            xsdMetricLevelValues.setLevelRef((Object)xsdSystemMetricLevel);
            xsdSystem.getLevelValues().add(xsdMetricLevelValues);
            for (Map.Entry<IMetricDescriptor, IMetricValue> next : systemLevelMetrics.entrySet()) {
                NamedElement associatedElement;
                if (context.hasBeenCanceled()) {
                    return;
                }
                IMetricDescriptor descriptor = next.getKey();
                XsdMetricValue xsdMetricValue = this.m_objectFactory.createXsdMetricValue();
                ++this.m_createdXsdElements;
                XsdMetricId xsdMetricId = metricMap.get(descriptor.getMetricId().getStandardName());
                assert (xsdMetricId != null) : "Missing metricId for " + descriptor.getMetricId().getStandardName();
                xsdMetricValue.setRef((Object)xsdMetricId);
                xsdMetricLevelValues.getMetric().add(xsdMetricValue);
                if (LOGGER.isDebugEnabled()) {
                    xsdMetricValue.setDebugInfo(descriptor.getMetricId().getPresentationName());
                }
                if (!(associatedElement = next.getValue().getAssociatedElement()).isValid()) continue;
                this.addMetricValue(associatedElement, next.getValue(), descriptor, xsdMetricValue);
            }
        }
    }

    private void addLevelMetricsToXml(IWorkerContext context, Map<String, XsdMetricId> metricMap, XsdMetricLevelContainer xsdMetricLevelContainer, Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>> levelMetrics) {
        for (Map.Entry<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>> nextLevel : levelMetrics.entrySet()) {
            XsdMetricLevelValues xsdLevelValues = this.m_objectFactory.createXsdMetricLevelValues();
            ++this.m_createdXsdElements;
            XsdMetricLevel xsdMetricLevel = this.m_nameToMetricLevel.get(nextLevel.getKey().getStandardName());
            assert (xsdMetricLevel != null) : "MetricLevel '" + nextLevel.getKey().getPresentationName() + "' has not been added";
            xsdLevelValues.setLevelRef((Object)xsdMetricLevel);
            xsdMetricLevelContainer.getLevelValues().add(xsdLevelValues);
            context.working("Adding metric values for level", false);
            for (Map.Entry<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>> nextCategory : nextLevel.getValue().entrySet()) {
                for (Map.Entry<IMetricDescriptor, List<IMetricValue>> nextDescriptor : nextCategory.getValue().entrySet()) {
                    if (context.hasBeenCanceled()) {
                        return;
                    }
                    IMetricDescriptor descriptor = nextDescriptor.getKey();
                    XsdMetricValue xsdMetricValue = this.m_objectFactory.createXsdMetricValue();
                    ++this.m_createdXsdElements;
                    XsdMetricId metricId = metricMap.get(descriptor.getMetricId().getStandardName());
                    assert (metricId != null) : "Missing metric for " + descriptor.getMetricId().getStandardName();
                    xsdMetricValue.setRef((Object)metricId);
                    xsdLevelValues.getMetric().add(xsdMetricValue);
                    if (LOGGER.isDebugEnabled()) {
                        xsdMetricValue.setDebugInfo(descriptor.getMetricId().getPresentationName());
                    }
                    MetricValueComparator comparator = new MetricValueComparator();
                    List sortedValues = nextDescriptor.getValue().stream().filter(v2 -> v2.getValue() != null).sorted(comparator).collect(Collectors.toList());
                    for (IMetricValue nextValue : sortedValues) {
                        if (context.hasBeenCanceled()) {
                            return;
                        }
                        NamedElement associatedElement = nextValue.getAssociatedElement();
                        if (!associatedElement.isValid()) continue;
                        this.addMetricValue(associatedElement, nextValue, descriptor, xsdMetricValue);
                    }
                }
            }
        }
    }

    private void addMetricValue(NamedElement associatedElement, IMetricValue value, IMetricDescriptor descriptor, XsdMetricValue xsdMetricValue) {
        assert (associatedElement != null) : "Parameter 'associatedElement' of method 'addMetricValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'addMetricValue' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'addMetricValue' must not be null";
        assert (xsdMetricValue != null) : "Parameter 'xsdMetricValue' of method 'addMetricValue' must not be null";
        if (descriptor.isFloat()) {
            XsdMetricFloatValue xsdValue = this.m_objectFactory.createXsdMetricFloatValue();
            ++this.m_createdXsdElements;
            XsdElement ref = (XsdElement)this.m_namedElementToXsdNamedElement.get(associatedElement);
            assert (ref != null) : "no element found for " + associatedElement.getDebugInfo();
            xsdValue.setRef((Object)ref);
            if (LOGGER.isDebugEnabled()) {
                xsdValue.setDebugInfo(associatedElement.getFullyQualifiedName());
            }
            xsdValue.setValue(NumberUtility.round((float)value.getValue().floatValue()));
            xsdMetricValue.getFloat().add(xsdValue);
        } else {
            XsdMetricIntValue xsdValue = this.m_objectFactory.createXsdMetricIntValue();
            ++this.m_createdXsdElements;
            XsdElement ref = (XsdElement)this.m_namedElementToXsdNamedElement.get(associatedElement);
            assert (ref != null) : "no element found for " + associatedElement.getDebugInfo();
            xsdValue.setRef((Object)ref);
            if (LOGGER.isDebugEnabled()) {
                xsdValue.setDebugInfo(associatedElement.getFullyQualifiedName());
            }
            xsdValue.setValue(value.getValue().intValue());
            xsdMetricValue.getInt().add(xsdValue);
        }
    }

    private void addPositionInfo(Issue issue, XsdIssue xsdIssue) {
        int column;
        assert (issue != null) : "Parameter 'issue' of method 'addPositionInfo' must not be null";
        assert (xsdIssue != null) : "Parameter 'xsdIssue' of method 'addPositionInfo' must not be null";
        int lineNumber = issue.getLineNumber();
        if (lineNumber != -1) {
            xsdIssue.setLine(Integer.valueOf(lineNumber));
        }
        if ((column = issue.getColumn()) != -1) {
            xsdIssue.setColumn(Integer.valueOf(column));
        }
    }

    private void addIssuesToXml(IWorkerContext context, XsdSoftwareSystemReport xsdReport) {
        List<DependencyIssue> dependencyIssues;
        assert (context != null) : "Parameter 'context' of method 'addIssuesToXml' must not be null";
        assert (xsdReport != null) : "Parameter 'result' of method 'createIssues' must not be null";
        XsdIssues xsdIssues = this.m_objectFactory.createXsdIssues();
        ++this.m_createdXsdElements;
        xsdIssues.setModelName(this.m_report.getSoftwareSystem().getCurrentModel().getName());
        xsdIssues.setNumberOfIssues(this.m_report.getTotalNumberOfIssues());
        xsdIssues.setNumberOfUnresolvedIssues(this.m_report.getUnresolvedIssues().size());
        xsdReport.setIssues(xsdIssues);
        List<NamedElementIssue> namedElementIssues = this.m_report.getNamedElementIssues();
        Map<IAnalyzerId, List<CycleGroupIssue>> cycleIssuesMap = this.m_report.getCycleIssues();
        List<DuplicateCodeBlockIssue> duplicateIssues = this.m_report.getDuplicateIssues();
        int numberOfThresholdViolations = this.m_report.getNumberOfThresholdViolations();
        if (namedElementIssues.size() > 0 || cycleIssuesMap.size() > 0 || duplicateIssues.size() > 0 || numberOfThresholdViolations > 0) {
            XsdSimpleElementIssue xsdIssue;
            XsdElementIssues xsdElementIssues = this.m_objectFactory.createXsdElementIssues();
            ++this.m_createdXsdElements;
            xsdIssues.setElementIssues(xsdElementIssues);
            for (NamedElementIssue namedElementIssue : namedElementIssues) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                context.working("Adding element issues", false);
                if (namedElementIssue instanceof IIssueWithLineContext) {
                    XsdLineBasedIssue xsdLineBasedIssue = this.m_objectFactory.createXsdLineBasedIssue();
                    ++this.m_createdXsdElements;
                    XsdElementPattern xsdPattern = this.m_objectFactory.createXsdElementPattern();
                    ++this.m_createdXsdElements;
                    xsdPattern.setType(XsdElementPatternType.FULLY_QUALIFIED_NAME);
                    xsdPattern.setValue(LineBasedContextSimilarityMatchPattern.createPatternForPersistence((IIssueWithLineContext)((Object)namedElementIssue)));
                    xsdPattern.setHash(LineBasedContextSimilarityMatchPattern.createHash((IIssueWithLineContext)((Object)namedElementIssue)));
                    xsdLineBasedIssue.setPattern(xsdPattern);
                    xsdIssue = xsdLineBasedIssue;
                } else {
                    xsdIssue = this.m_objectFactory.createXsdSimpleElementIssue();
                    ++this.m_createdXsdElements;
                }
                this.addAttributesToSimpleElementIssue(namedElementIssue, xsdIssue);
                xsdElementIssues.getIssue().add(xsdIssue);
                this.m_issueToXsdIssue.put(namedElementIssue, (XsdIssue)xsdIssue);
            }
            for (DuplicateCodeBlockIssue duplicateCodeBlockIssue : duplicateIssues) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                context.working("Adding duplicate code block issues", false);
                xsdIssue = this.addDuplicateCodeBlockIssueToXml(context, duplicateCodeBlockIssue, xsdElementIssues);
                this.m_issueToXsdIssue.put(duplicateCodeBlockIssue, (XsdIssue)xsdIssue);
            }
            for (Map.Entry entry : cycleIssuesMap.entrySet()) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                context.working("Adding cycle group issues", false);
                XsdCycleGroupContainer xsdCycleGroupContainer = this.m_objectFactory.createXsdCycleGroupContainer();
                ++this.m_createdXsdElements;
                IAnalyzerId analyzer = (IAnalyzerId)entry.getKey();
                xsdCycleGroupContainer.setAnalyzerRef(this.m_analyzerMap.get(analyzer));
                xsdElementIssues.getCycleGroups().add(xsdCycleGroupContainer);
                List sorted = ((List)entry.getValue()).stream().sorted((o1, o2) -> {
                    CycleGroup c1 = (CycleGroup)o1.getAffectedElement();
                    CycleGroup c2 = (CycleGroup)o2.getAffectedElement();
                    int size1 = c1.getNumberOfCyclicElements();
                    int size2 = c2.getNumberOfCyclicElements();
                    return Integer.compare(size2, size1);
                }).collect(Collectors.toList());
                for (CycleGroupIssue next : sorted) {
                    if (context.hasBeenCanceled()) {
                        return;
                    }
                    XsdCycleIssue xsdCycleIssue = this.m_objectFactory.createXsdCycleIssue();
                    ++this.m_createdXsdElements;
                    CycleGroup cycle = (CycleGroup)next.getAffectedElement();
                    if (!(cycle instanceof AnalyzerCycleGroup)) continue;
                    AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)cycle;
                    xsdCycleIssue.setId(this.m_idGenerator.getNextId());
                    xsdCycleIssue.setProvider((Object)this.getIssueProviderMap().get(next.getProvider()));
                    xsdCycleIssue.setName(cycleGroup.getName());
                    xsdCycleIssue.setFqName(cycleGroup.getFullyQualifiedName());
                    xsdCycleIssue.setDescription(cycleGroup.getDescription());
                    xsdCycleIssue.setType((Object)this.getIssueTypeMap().get(next.getId()));
                    xsdCycleIssue.setNumberOfCyclicElements(cycleGroup.getNumberOfCyclicElements());
                    xsdCycleIssue.setStructuralDebtIndex(Integer.valueOf(cycleGroup.getStructuralDebtIndex()));
                    xsdCycleIssue.setComponentDependenciesToRemove(Integer.valueOf(cycleGroup.getComponentDependenciesToRemove()));
                    xsdCycleIssue.setParserDependenciesToRemove(Integer.valueOf(cycleGroup.getParserDependenciesToRemove()));
                    xsdCycleIssue.setScope((Object)this.m_namedElementToXsdNamedElement.get(cycleGroup.getScope()));
                    xsdCycleIssue.setSeverity(cycleGroup.isCritical() ? Severity.ERROR.getStandardName() : Severity.WARNING.getStandardName());
                    xsdCycleGroupContainer.getCycleGroup().add(xsdCycleIssue);
                    List sortedElements = cycleGroup.getCyclicNamedElements().stream().sorted(Comparator.comparing(NamedElement::getFullyQualifiedName)).collect(Collectors.toList());
                    for (NamedElement element : sortedElements) {
                        if (context.hasBeenCanceled()) {
                            return;
                        }
                        XsdCycleElement xsdElement = this.m_objectFactory.createXsdCycleElement();
                        ++this.m_createdXsdElements;
                        XsdNamedElement xsdCycle = this.m_namedElementToXsdNamedElement.get(element);
                        assert (xsdCycle != null) : "'xsdCycle' must not be null. Cycle: " + element.getFullyQualifiedName();
                        xsdElement.setRef((Object)xsdCycle);
                        if (LOGGER.isDebugEnabled()) {
                            xsdElement.setDebugInfo(element.getFullyQualifiedName());
                        }
                        xsdCycleIssue.getElement().add(xsdElement);
                    }
                    this.m_issueToXsdIssue.put(next, (XsdIssue)xsdCycleIssue);
                }
            }
        }
        if ((dependencyIssues = this.m_report.getDependencyIssues()).size() > 0) {
            XsdDependencyIssues xsdDependencyIssues = this.m_objectFactory.createXsdDependencyIssues();
            ++this.m_createdXsdElements;
            xsdIssues.setDepencencyIssues(xsdDependencyIssues);
            for (DependencyIssue next : dependencyIssues) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                context.working("Adding dependency issues", false);
                XsdDependencyIssue xsdIssue = this.m_objectFactory.createXsdDependencyIssue();
                ++this.m_createdXsdElements;
                xsdIssue.setId(this.m_idGenerator.getNextId());
                this.addIssueAttributes(next, (XsdIssue)xsdIssue);
                Dependency dependency = next.getAffectedElement();
                xsdIssue.setFrom((Object)this.m_namedElementToXsdNamedElement.get(dependency.getUnderlyingFrom()));
                xsdIssue.setTo((Object)this.m_namedElementToXsdNamedElement.get(dependency.getUnderlyingTo()));
                this.addPositionInfo(next, (XsdIssue)xsdIssue);
                if (LOGGER.isDebugEnabled()) {
                    xsdIssue.setDebugInfo(String.valueOf(next.getId().getStandardName()) + ": " + dependency.toString());
                }
                xsdDependencyIssues.getIssue().add(xsdIssue);
                this.m_issueToXsdIssue.put(next, (XsdIssue)xsdIssue);
            }
        }
        if (numberOfThresholdViolations > 0) {
            context.working("Adding threshold issues", false);
            for (Map.Entry entry : this.m_report.getThresholdViolationIssues().entrySet()) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                XsdMetricThreshold xsdThreshold = this.m_metricThresholdToXsdMetricThreshold.get(entry.getKey());
                assert (xsdThreshold != null) : "Threshold '" + ((IMetricThreshold)entry.getKey()).getInformation() + "' has not been added";
                for (ThresholdViolationIssue next : (List)entry.getValue()) {
                    XsdMetricThresholdViolationIssue xsdIssue = this.m_objectFactory.createXsdMetricThresholdViolationIssue();
                    ++this.m_createdXsdElements;
                    this.addAttributesToSimpleElementIssue(next, (XsdSimpleElementIssue)xsdIssue);
                    xsdIssue.setMetricValue(new BigDecimal(next.getValue().doubleValue()));
                    xsdIssue.setThresholdRef((Object)xsdThreshold);
                    xsdIssues.getElementIssues().getThresholdViolation().add(xsdIssue);
                    this.m_issueToXsdIssue.put(next, (XsdIssue)xsdIssue);
                }
            }
        }
    }

    private XsdSimpleElementIssue addAttributesToSimpleElementIssue(NamedElementIssue issue, XsdSimpleElementIssue xsdIssue) {
        xsdIssue.setId(this.m_idGenerator.getNextId());
        this.addIssueAttributes(issue, (XsdIssue)xsdIssue);
        NamedElement namedElement = issue.getAffectedElement();
        XsdNamedElement affectedElement = this.m_namedElementToXsdNamedElement.get(namedElement);
        assert (affectedElement != null) : "affectedElement must have been added. Issue: " + namedElement.getFullyQualifiedName();
        xsdIssue.setAffectedElement((Object)affectedElement);
        if (LOGGER.isDebugEnabled()) {
            xsdIssue.setDebugInfo(String.valueOf(issue.getName()) + ", " + namedElement.getPresentationName(false));
        }
        this.addPositionInfo(issue, (XsdIssue)xsdIssue);
        if (issue instanceof IIssueWithLineContext) {
            IIssueWithLineContext lineContextIssue = (IIssueWithLineContext)((Object)issue);
            String pattern = LineBasedContextSimilarityMatchPattern.createPatternForPersistence(lineContextIssue);
            String hash = LineBasedContextSimilarityMatchPattern.createHash(lineContextIssue);
            XsdElementPattern xsdElementPattern = this.m_objectFactory.createXsdElementPattern();
            xsdElementPattern.setType(XsdElementPatternType.FULLY_QUALIFIED_NAME);
            xsdElementPattern.setValue(pattern);
            xsdElementPattern.setHash(hash);
        }
        return xsdIssue;
    }

    private XsdIssue addDuplicateCodeBlockIssueToXml(IWorkerContext context, DuplicateCodeBlockIssue issue, XsdElementIssues xsdElementIssues) {
        assert (context != null) : "Parameter 'context' of method 'addDuplicateCodeBlockIssueToXml' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'createDuplicateCodeBlockIssue' must not be null";
        assert (xsdElementIssues != null) : "Parameter 'xsdElementIssues' of method 'createDuplicateCodeBlockIssue' must not be null";
        XsdDuplicateBlockIssue xsdIssue = this.m_objectFactory.createXsdDuplicateBlockIssue();
        ++this.m_createdXsdElements;
        xsdElementIssues.getDuplicate().add(xsdIssue);
        DuplicateCodeBlock block = (DuplicateCodeBlock)issue.getAffectedElement();
        xsdIssue.setId(this.m_idGenerator.getNextId());
        xsdIssue.setFqName(block.getFullyQualifiedName());
        this.addIssueAttributes(issue, (XsdIssue)xsdIssue);
        xsdIssue.setName(block.getName());
        xsdIssue.setBlockSize(block.getBlockSize());
        xsdIssue.setNumberOfOccurrences(block.getTotalNumberOfOccurrences());
        for (DuplicateCodeBlockOccurrence occurrence : block.getChildren(DuplicateCodeBlockOccurrence.class)) {
            if (context.hasBeenCanceled()) {
                return xsdIssue;
            }
            XsdDuplicateCodeBlockOccurrence xsdOccurrence = this.m_objectFactory.createXsdDuplicateCodeBlockOccurrence();
            ++this.m_createdXsdElements;
            xsdOccurrence.setSource((Object)this.m_namedElementToXsdNamedElement.get(occurrence.getSourceFile()));
            xsdOccurrence.setBlockSize(Integer.valueOf(occurrence.getBlockSize()));
            xsdOccurrence.setStartLine(Integer.valueOf(occurrence.getBlockBegin()));
            xsdOccurrence.setEndLine(Integer.valueOf(occurrence.getBlockEnd()));
            xsdOccurrence.setTolerance(Integer.valueOf(occurrence.getToleranceAsInt()));
            xsdOccurrence.setHash(IntBasedHash.encode((IntBasedHash)occurrence.getHashRepresentation()));
            if (LOGGER.isDebugEnabled()) {
                xsdOccurrence.setDebugInfo(occurrence.getSourceFile().getPresentationName(false));
            }
            xsdIssue.getOccurrence().add(xsdOccurrence);
        }
        return xsdIssue;
    }

    private void addIssueAttributes(Issue issue, XsdIssue xsdIssue) {
        String description;
        assert (issue != null) : "Parameter 'issue' of method 'addIssueAttributes' must not be null";
        assert (xsdIssue != null) : "Parameter 'xsdIssue' of method 'addIssueAttributes' must not be null";
        xsdIssue.setType((Object)this.getIssueTypeMap().get(issue.getId()));
        xsdIssue.setProvider((Object)this.getIssueProviderMap().get(issue.getProvider()));
        if (issue.getId().getSupportedSeverities().size() > 1) {
            xsdIssue.setSeverity(issue.getSeverity().getStandardName());
        }
        if (!(description = issue.getDescription()).trim().isEmpty()) {
            xsdIssue.setDescription(description);
        }
        if (LOGGER.isDebugEnabled()) {
            xsdIssue.setDebugInfo(issue.getPresentationName(false));
        }
    }
}

