/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.report;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactClass;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableFilter;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import java.util.Collection;

public final class ArchitectureFileSerializer {
    public String serialize(ArchitectureFile file) {
        assert (file != null) : "Parameter 'file' of method 'serialize' must not be null";
        StringBuilder content = new StringBuilder();
        for (Artifact next : file.getArtifacts()) {
            ArchitectureElementVisitor visitor = new ArchitectureElementVisitor(content);
            next.accept(visitor);
        }
        return content.toString();
    }

    private static class ArchitectureElementVisitor
    extends NamedElementVisitor
    implements ArchitectureElement.IVisitor,
    ArtifactClass.IVisitor {
        private final StringBuilder m_builder;

        public ArchitectureElementVisitor(StringBuilder builder) {
            assert (builder != null) : "Parameter 'builder' of method 'ArchitectureElementVisitor' must not be null";
            this.m_builder = builder;
        }

        @Override
        public void visitChildrenOf(NamedElement element) {
            if (element instanceof IArchitectureAssignmentElement) {
                return;
            }
            super.visitChildrenOf(element);
        }

        @Override
        public void visitArchitectureElement(ArchitectureElement element) {
            this.append(element);
            for (IAssignableFilter include : element.getIncludeFilters()) {
                this.handleFilter(include, true);
            }
            for (IAssignableFilter exclude : element.getExcludeFilters()) {
                this.handleFilter(exclude, false);
            }
            if (element instanceof Connector) {
                Connector connector = (Connector)element;
                Collection<Interface> connectedInterfaces = connector.getConnectedInterfaces();
                if (!connectedInterfaces.isEmpty()) {
                    this.m_builder.append("ConnectedTo:");
                }
                for (Interface connected : connectedInterfaces) {
                    this.m_builder.append(connected.getParent().getShortName()).append('.').append(connected.getShortName()).append(':');
                }
                if (!connectedInterfaces.isEmpty()) {
                    this.m_builder.append(';');
                }
            }
            this.visitChildrenOf(element);
        }

        private void handleFilter(IAssignableFilter filter, boolean isInclude) {
            assert (filter != null && filter instanceof NamedElement) : "Unexpected class in method 'handleFilter': " + filter;
            if (isInclude) {
                this.m_builder.append("IncludeFilter:");
            } else {
                this.m_builder.append("ExcludeFilter:");
            }
            this.m_builder.append(((NamedElement)((Object)filter)).getShortName()).append(';');
        }

        @Override
        public void visitArtifactClass(ArtifactClass element) {
            this.append(element);
            this.visitChildrenOf(element);
        }

        private void append(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'append' must not be null";
            this.m_builder.append(element.getClass().getSimpleName()).append(':');
            this.m_builder.append(element.getShortName()).append(';');
        }
    }
}

