/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.report;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.path.DynamicProviderId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueId;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlIdGenerator;
import com.hello2morrow.sonargraph.integration.access.persistence.report.ObjectFactory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExportMetaData;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueCategory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueProvider;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueType;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricCategory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricId;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricLevel;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public abstract class AbstractExportMetaDataXmlAccess<T> {
    private Map<IssueCategory, XsdIssueCategory> m_issueCategoryMap;
    private Map<IProviderId, XsdIssueProvider> m_issueProviderMap;
    private Map<IIssueId, XsdIssueType> m_issueTypeMap;

    protected AbstractExportMetaDataXmlAccess() {
    }

    protected final Map<IssueCategory, XsdIssueCategory> getIssueCategoryMap() {
        return this.m_issueCategoryMap;
    }

    protected final Map<IProviderId, XsdIssueProvider> getIssueProviderMap() {
        return this.m_issueProviderMap;
    }

    protected final Map<IIssueId, XsdIssueType> getIssueTypeMap() {
        return this.m_issueTypeMap;
    }

    protected final void createXmlExportMetaData(XmlIdGenerator idGenerator, ObjectFactory objectFactory, Map<IMetricId, List<IMetricLevel>> metricIds, Collection<IssueCategory> issueCategories, Collection<IProviderId> issueProviders, Collection<IIssueId> issueTypes, XsdExportMetaData xsdExport) {
        assert (idGenerator != null) : "Parameter 'idGenerator' of method 'createXmlExportMetaData' must not be null";
        assert (objectFactory != null) : "Parameter 'objectFactory' of method 'createXmlExportMetaData' must not be null";
        assert (metricIds != null) : "Parameter 'metricIds' of method 'createXmlExportMetaData' must not be null";
        assert (issueCategories != null) : "Parameter 'issueCategories' of method 'createXmlExportMetaData' must not be null";
        assert (issueProviders != null) : "Parameter 'issueProviders' of method 'createXmlExportMetaData' must not be null";
        assert (issueTypes != null) : "Parameter 'issueTypes' of method 'createXmlExportMetaData' must not be null";
        assert (xsdExport != null) : "Parameter 'xsdExport' of method 'createXmlExportMetaData' must not be null";
        xsdExport.setIssueCategories(objectFactory.createXsdIssueCategories());
        xsdExport.setIssueProviders(objectFactory.createXsdIssueProviders());
        xsdExport.setIssueTypes(objectFactory.createXsdIssueTypes());
        xsdExport.setMetricCategories(objectFactory.createXsdMetricCategories());
        xsdExport.setMetricProviders(objectFactory.createXsdMetricProviders());
        xsdExport.setMetricLevels(objectFactory.createXsdMetricLevels());
        xsdExport.setMetricIds(objectFactory.createXsdMetricIds());
        this.m_issueCategoryMap = this.processIssueCategories(idGenerator, objectFactory, issueCategories);
        xsdExport.getIssueCategories().getCategory().addAll(this.m_issueCategoryMap.values());
        this.m_issueProviderMap = this.processIssueProviders(idGenerator, objectFactory, issueProviders);
        xsdExport.getIssueProviders().getIssueProvider().addAll(this.m_issueProviderMap.values());
        this.m_issueTypeMap = this.processIssueTypes(idGenerator, objectFactory, issueTypes, this.m_issueProviderMap, this.m_issueCategoryMap);
        xsdExport.getIssueTypes().getIssueType().addAll(this.m_issueTypeMap.values());
        TreeMap<IMetricLevel, XsdMetricLevel> metricLevelToXsdMetricLevelMap = new TreeMap<IMetricLevel, XsdMetricLevel>(new IMetricLevel.MetricLevelComparator());
        TreeMap<String, XsdMetricCategory> standardNameToXsdCategoryMap = new TreeMap<String, XsdMetricCategory>();
        TreeMap<String, XsdMetricProvider> standardNameToXsdProviderMap = new TreeMap<String, XsdMetricProvider>(new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                boolean name1WithPath = name1.startsWith("./");
                boolean name2WithPath = name2.startsWith("./");
                if (name1WithPath && !name2WithPath) {
                    return 1;
                }
                if (!name1WithPath && name2WithPath) {
                    return -1;
                }
                return name1.compareTo(name2);
            }
        });
        for (Map.Entry<IMetricId, List<IMetricLevel>> next : metricIds.entrySet()) {
            Optional<Number> worstValue;
            XsdMetricProvider xsdProvider;
            XsdMetricId xsdMetric = objectFactory.createXsdMetricId();
            xsdMetric.setId(idGenerator.getNextId());
            IMetricId metricId = next.getKey();
            xsdMetric.setName(metricId.getStandardName());
            xsdMetric.setPresentationName(metricId.getPresentationName());
            xsdMetric.setDescription(metricId.getDescription());
            xsdMetric.setIsFloat(metricId.isFloat());
            for (IMetricCategory category : metricId.getCategories()) {
                XsdMetricCategory xsdCategory;
                if (standardNameToXsdCategoryMap.containsKey(category.getStandardName())) {
                    xsdCategory = (XsdMetricCategory)standardNameToXsdCategoryMap.get(category.getStandardName());
                } else {
                    xsdCategory = objectFactory.createXsdMetricCategory();
                    xsdCategory.setId(idGenerator.getNextId());
                    xsdCategory.setName(category.getStandardName());
                    xsdCategory.setPresentationName(category.getPresentationName());
                    xsdCategory.setOrderNumber(category.getOrderNumber());
                    standardNameToXsdCategoryMap.put(category.getStandardName(), xsdCategory);
                }
                xsdMetric.getCategories().add(xsdCategory);
            }
            for (IMetricLevel level : next.getValue()) {
                XsdMetricLevel xsdLevel = this.getOrCreateMetricLevel(level, metricLevelToXsdMetricLevelMap, idGenerator, objectFactory);
                xsdMetric.getLevels().add(xsdLevel);
            }
            IProviderId provider = metricId.getProvider();
            String providerName = provider.getStandardName();
            if (standardNameToXsdProviderMap.containsKey(providerName)) {
                xsdProvider = (XsdMetricProvider)standardNameToXsdProviderMap.get(providerName);
            } else {
                xsdProvider = objectFactory.createXsdMetricProvider();
                xsdProvider.setId(idGenerator.getNextId());
                xsdProvider.setName(providerName);
                xsdProvider.setPresentationName(provider.getPresentationName());
                standardNameToXsdProviderMap.put(providerName, xsdProvider);
            }
            xsdMetric.setProvider((Object)xsdProvider);
            Optional<Number> bestValue = metricId.getBestValue();
            if (bestValue.isPresent()) {
                xsdMetric.setBestValue(Double.valueOf(bestValue.get().doubleValue()));
            }
            if ((worstValue = metricId.getWorstValue()).isPresent()) {
                xsdMetric.setWorstValue(Double.valueOf(worstValue.get().doubleValue()));
            }
            IMetricId.IMetricRange range = metricId.getRange();
            xsdMetric.setMinValue(Double.valueOf(range.getMinValue()));
            xsdMetric.setMaxValue(Double.valueOf(range.getMaxValue()));
            xsdMetric.setDirection(metricId.getSorting().getStandardName());
            xsdExport.getMetricIds().getMetricId().add(xsdMetric);
        }
        xsdExport.getMetricLevels().getLevel().addAll(metricLevelToXsdMetricLevelMap.values());
        TreeSet<XsdMetricCategory> metricCategories = new TreeSet<XsdMetricCategory>(new Comparator<XsdMetricCategory>(){

            @Override
            public int compare(XsdMetricCategory c1, XsdMetricCategory c2) {
                int compareOrderNumber = Integer.valueOf(c1.getOrderNumber()).compareTo(c2.getOrderNumber());
                if (compareOrderNumber != 0) {
                    return compareOrderNumber;
                }
                return c1.getName().compareTo(c2.getName());
            }
        });
        metricCategories.addAll(standardNameToXsdCategoryMap.values());
        for (XsdMetricCategory nextCategory : metricCategories) {
            xsdExport.getMetricCategories().getCategory().add(nextCategory);
        }
        for (XsdMetricProvider nextProvider : standardNameToXsdProviderMap.values()) {
            xsdExport.getMetricProviders().getProvider().add(nextProvider);
        }
    }

    private Map<IProviderId, XsdIssueProvider> processIssueProviders(XmlIdGenerator idGenerator, ObjectFactory objectFactory, Collection<IProviderId> issueProviders) {
        assert (idGenerator != null) : "Parameter 'idGenerator' of method 'processIssueProviders' must not be null";
        assert (objectFactory != null) : "Parameter 'objectFactory' of method 'processIssueProviders' must not be null";
        assert (issueProviders != null) : "Parameter 'issueProviders' of method 'processIssueProviders' must not be null";
        LinkedHashMap<IProviderId, XsdIssueProvider> issueProviderMap = new LinkedHashMap<IProviderId, XsdIssueProvider>();
        List sortedProviders = issueProviders.stream().sorted(new Comparator<IProviderId>(){

            @Override
            public int compare(IProviderId id1, IProviderId id2) {
                return id1.getStandardName().compareTo(id2.getStandardName());
            }
        }).collect(Collectors.toList());
        for (IProviderId issueProviderId : sortedProviders) {
            XsdIssueProvider xsdIssueProvider = objectFactory.createXsdIssueProvider();
            xsdIssueProvider.setId(idGenerator.getNextId());
            issueProviderMap.put(issueProviderId, xsdIssueProvider);
            xsdIssueProvider.setName(issueProviderId.getStandardName());
            xsdIssueProvider.setPresentationName(issueProviderId.getPresentationName());
        }
        return issueProviderMap;
    }

    private Map<IssueCategory, XsdIssueCategory> processIssueCategories(XmlIdGenerator idGenerator, ObjectFactory objectFactory, Collection<IssueCategory> issueCategories) {
        assert (idGenerator != null) : "Parameter 'idGenerator' of method 'processIssueCategories' must not be null";
        assert (objectFactory != null) : "Parameter 'objectFactory' of method 'processIssueCategories' must not be null";
        assert (issueCategories != null && !issueCategories.isEmpty()) : "Parameter 'issueCategories' of method 'processIssueCategories' must not be empty";
        LinkedHashMap<IssueCategory, XsdIssueCategory> issueCategoryToXsdMap = new LinkedHashMap<IssueCategory, XsdIssueCategory>();
        Collection sortedCategories = issueCategories.stream().sorted(new Comparator<IssueCategory>(){

            @Override
            public int compare(IssueCategory cat1, IssueCategory cat2) {
                return cat1.getStandardName().compareTo(cat2.getStandardName());
            }
        }).collect(Collectors.toList());
        for (IssueCategory category : sortedCategories) {
            XsdIssueCategory xsdCategory = objectFactory.createXsdIssueCategory();
            xsdCategory.setId(idGenerator.getNextId());
            xsdCategory.setName(category.getStandardName());
            xsdCategory.setPresentationName(category.getPresentationName());
            issueCategoryToXsdMap.put(category, xsdCategory);
        }
        return issueCategoryToXsdMap;
    }

    private Map<IIssueId, XsdIssueType> processIssueTypes(XmlIdGenerator idGenerator, ObjectFactory objectFactory, Collection<IIssueId> issueTypes, Map<IProviderId, XsdIssueProvider> issueProviderToXsdMap, Map<IssueCategory, XsdIssueCategory> issueCategoryToXsdMap) {
        assert (idGenerator != null) : "Parameter 'idGenerator' of method 'processIssueTypes' must not be null";
        assert (objectFactory != null) : "Parameter 'objectFactory' of method 'processIssueTypes' must not be null";
        assert (issueTypes != null) : "Parameter 'issueTypes' of method 'processIssueTypes' must not be null";
        assert (issueProviderToXsdMap != null) : "Parameter 'issueProviderToXsdMap' of method 'processIssueTypes' must not be null";
        assert (issueCategoryToXsdMap != null && !issueCategoryToXsdMap.isEmpty()) : "Parameter 'issueCategoryToXsdMap' of method 'processIssueTypes' must not be empty";
        LinkedHashMap<IIssueId, XsdIssueType> issueTypeMap = new LinkedHashMap<IIssueId, XsdIssueType>();
        Collection sortedIssueIds = issueTypes.stream().sorted(new Comparator<IIssueId>(){

            @Override
            public int compare(IIssueId id1, IIssueId id2) {
                int compareCategory = id1.getCategory().getStandardName().compareTo(id2.getCategory().getStandardName());
                if (compareCategory != 0) {
                    return compareCategory;
                }
                int compareSeverity = id1.getSupportedSeverities().get(0).ordinal() - id2.getSupportedSeverities().get(0).ordinal();
                if (compareSeverity != 0) {
                    return compareSeverity;
                }
                return id1.getStandardName().compareTo(id2.getStandardName());
            }
        }).collect(Collectors.toList());
        for (IIssueId issueId : sortedIssueIds) {
            XsdIssueProvider provider;
            DynamicProviderId providerId;
            XsdIssueType xsdIssueType = objectFactory.createXsdIssueType();
            xsdIssueType.setId(idGenerator.getNextId());
            issueTypeMap.put(issueId, xsdIssueType);
            xsdIssueType.setName(issueId.getStandardName());
            xsdIssueType.setPresentationName(issueId.getPresentationName());
            xsdIssueType.setSeverity(issueId.getSupportedSeverities().stream().map(s2 -> s2.getStandardName()).collect(Collectors.joining(", ")));
            XsdIssueCategory xsdIssueCategory = issueCategoryToXsdMap.get((Object)issueId.getCategory());
            assert (xsdIssueCategory != null) : "No issueCategory '" + issueId.getCategory().getStandardName() + "' has been added";
            xsdIssueType.setCategory((Object)xsdIssueCategory);
            if (issueId instanceof ScriptIssueId) {
                providerId = ((ScriptIssueId)issueId).getProvider();
                provider = issueProviderToXsdMap.get(providerId);
                xsdIssueType.setProvider((Object)provider);
                continue;
            }
            if (!(issueId instanceof PluginIssueId)) continue;
            providerId = ((PluginIssueId)issueId).getProvider();
            provider = issueProviderToXsdMap.get(providerId);
            xsdIssueType.setProvider((Object)provider);
        }
        return issueTypeMap;
    }

    private XsdMetricLevel getOrCreateMetricLevel(IMetricLevel level, Map<IMetricLevel, XsdMetricLevel> levelMap, XmlIdGenerator idGenerator, ObjectFactory objectFactory) {
        assert (level != null) : "Parameter 'level' of method 'getOrCreateMetricLevel' must not be null";
        assert (levelMap != null) : "Parameter 'levelMap' of method 'getOrCreateMetricLevel' must not be null";
        assert (idGenerator != null) : "Parameter 'idGenerator' of method 'getOrCreateMetricLevel' must not be null";
        if (levelMap.containsKey(level)) {
            return levelMap.get(level);
        }
        XsdMetricLevel xsdMetricLevel = objectFactory.createXsdMetricLevel();
        xsdMetricLevel.setId(idGenerator.getNextId());
        xsdMetricLevel.setName(level.getStandardName());
        xsdMetricLevel.setPresentationName(level.getPresentationName());
        xsdMetricLevel.setOrderNumber(level.getOrderNumber());
        levelMap.put(level, xsdMetricLevel);
        return xsdMetricLevel;
    }
}

