/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.remote;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteConfiguration;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationPersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationPersistence.class);
    private static final String STANDALONE_SERVER_ENABLED = "standalone.server.enabled";
    private static final String STANDALONE_SERVER_PORT = "standalone.server.port";
    private static final String IDE_SERVER_ENABLED = "ide.server.enabled";
    private static final String IDE_SERVER_PORT = "ide.server.port";
    private final TFile m_propsFile;
    private final SonargraphProduct m_product;

    public ConfigurationPersistence(TFile propsFile, SonargraphProduct product) {
        assert (propsFile != null) : "Parameter 'propsFile' of method 'PropertyReader' must not be null";
        assert (product != null) : "Parameter 'product' of method 'PropertyReader' must not be null";
        this.m_propsFile = propsFile;
        this.m_product = product;
    }

    public RemoteConfiguration load(int defaultServerPort, int defaultRemotePort, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'load' must not be null";
        int serverPort = defaultServerPort;
        int remotePort = defaultRemotePort;
        boolean isEnabled = false;
        boolean isRemoteEnabled = false;
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (TFileInputStream in = new TFileInputStream((File)this.m_propsFile);){
                Properties props = new Properties();
                props.load((InputStream)in);
                switch (this.m_product) {
                    case SONARGRAPH: {
                        isEnabled = Boolean.parseBoolean(props.getProperty(STANDALONE_SERVER_ENABLED, Boolean.FALSE.toString()));
                        serverPort = this.getIntProperty(props, STANDALONE_SERVER_PORT, defaultServerPort);
                        remotePort = this.getIntProperty(props, IDE_SERVER_PORT, defaultRemotePort);
                        isRemoteEnabled = Boolean.parseBoolean(props.getProperty(IDE_SERVER_ENABLED, Boolean.FALSE.toString()));
                        break;
                    }
                    case SONARGRAPH_BUILD: {
                        break;
                    }
                    case SONARGRAPH_ECLIPSE: 
                    case SONARGRAPH_INTELLI_J: {
                        isEnabled = Boolean.parseBoolean(props.getProperty(IDE_SERVER_ENABLED, Boolean.FALSE.toString()));
                        serverPort = this.getIntProperty(props, IDE_SERVER_PORT, defaultServerPort);
                        remotePort = this.getIntProperty(props, STANDALONE_SERVER_PORT, defaultRemotePort);
                        isRemoteEnabled = Boolean.parseBoolean(props.getProperty(STANDALONE_SERVER_ENABLED, Boolean.FALSE.toString()));
                        break;
                    }
                    default: {
                        assert (false) : "Unspported product: " + this.m_product.getPresentationName();
                        break;
                    }
                }
                return new RemoteConfiguration(isEnabled, serverPort, isRemoteEnabled, remotePort);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, "Failed to read configuration for remote selection", new Object[]{e2});
            return new RemoteConfiguration(isEnabled, serverPort, isRemoteEnabled, defaultRemotePort);
        }
    }

    private int getIntProperty(Properties props, String property, int defaultValue) {
        int value;
        String stringValue = props.getProperty(property);
        if (stringValue != null) {
            try {
                value = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException ex) {
                LOGGER.error("");
                value = defaultValue;
            }
        } else {
            value = defaultValue;
        }
        return value;
    }

    public OperationResult save(RemoteConfiguration configuration) {
        String isIdeEnabled;
        String idePort;
        String isStandaloneEnabled;
        String standalonePort;
        assert (configuration != null) : "Parameter 'configuration' of method 'save' must not be null";
        OperationResult result = new OperationResult("Persisting remote configuration");
        switch (this.m_product) {
            case SONARGRAPH: {
                standalonePort = Integer.toString(configuration.getServerPort());
                isStandaloneEnabled = Boolean.toString(configuration.isEnabled());
                idePort = Integer.toString(configuration.getRemotePort());
                isIdeEnabled = Boolean.toString(configuration.isRemoteEnabled());
                break;
            }
            case SONARGRAPH_BUILD: {
                return result;
            }
            case SONARGRAPH_ECLIPSE: 
            case SONARGRAPH_INTELLI_J: {
                idePort = Integer.toString(configuration.getServerPort());
                isIdeEnabled = Boolean.toString(configuration.isEnabled());
                standalonePort = Integer.toString(configuration.getRemotePort());
                isStandaloneEnabled = Boolean.toString(configuration.isRemoteEnabled());
                break;
            }
            default: {
                assert (false) : "Unspported product: " + this.m_product.getPresentationName();
                return result;
            }
        }
        Properties props = new Properties();
        props.put(STANDALONE_SERVER_ENABLED, isStandaloneEnabled);
        props.put(STANDALONE_SERVER_PORT, standalonePort);
        props.put(IDE_SERVER_ENABLED, isIdeEnabled);
        props.put(IDE_SERVER_PORT, idePort);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (TFileOutputStream out = new TFileOutputStream((File)this.m_propsFile);){
                props.store((OutputStream)out, "Properties for communication between Sonargraph Architect and IDE Plugin.");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_WRITE_FILE, "Failed to write properties for remote interaction.", new Object[0]);
        }
        return result;
    }
}

